/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import com.parse.ParseTextUtils;
import com.parse.PointerEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

class ParseRESTQueryCommand
extends ParseRESTCommand {
    public static <T extends ParseObject> ParseRESTQueryCommand findCommand(ParseQuery.State<T> state, String sessionToken) {
        String httpPath = String.format("classes/%s", state.className());
        Map<String, String> parameters = ParseRESTQueryCommand.constructParameters(state.order(), state.constraints(), state.selectedKeys(), state.includes(), state.limit(), state.skip(), state.extraOptions(), state.isTracingEnabled(), false);
        return new ParseRESTQueryCommand(httpPath, ParseRequest.Method.GET, parameters, sessionToken);
    }

    public static <T extends ParseObject> ParseRESTQueryCommand countCommand(ParseQuery.State<T> state, String sessionToken) {
        String httpPath = String.format("classes/%s", state.className());
        Map<String, String> parameters = ParseRESTQueryCommand.constructParameters(state.order(), state.constraints(), state.selectedKeys(), state.includes(), state.limit(), state.skip(), state.extraOptions(), state.isTracingEnabled(), true);
        return new ParseRESTQueryCommand(httpPath, ParseRequest.Method.GET, parameters, sessionToken);
    }

    private static Map<String, String> constructParameters(List<String> order, Map<String, ?> conditions, Set<String> selectedKeys, Set<String> includedKeys, int limit, int skip, Map<String, ?> extraOptions, boolean tracingEnabled, boolean count) {
        PointerEncoder encoder = PointerEncoder.get();
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (!order.isEmpty()) {
            parameters.put("order", ParseTextUtils.join(",", order));
        }
        if (!conditions.isEmpty()) {
            JSONObject encodedConditions = (JSONObject)encoder.encode(conditions);
            parameters.put("where", encodedConditions.toString());
        }
        if (selectedKeys != null) {
            parameters.put("keys", ParseTextUtils.join(",", selectedKeys));
        }
        if (!includedKeys.isEmpty()) {
            parameters.put("include", ParseTextUtils.join(",", includedKeys));
        }
        if (count) {
            parameters.put("count", Integer.toString(1));
        } else {
            if (limit >= 0) {
                parameters.put("limit", Integer.toString(limit));
            }
            if (skip > 0) {
                parameters.put("skip", Integer.toString(skip));
            }
        }
        for (Map.Entry<String, ?> entry : extraOptions.entrySet()) {
            JSONObject encodedExtraOptions = (JSONObject)encoder.encode(entry.getValue());
            parameters.put(entry.getKey(), encodedExtraOptions.toString());
        }
        if (tracingEnabled) {
            parameters.put("trace", Integer.toString(1));
        }
        return parameters;
    }

    private ParseRESTQueryCommand(String httpPath, ParseRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }
}

