/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.GetDataCallback;
import com.parse.Parse;
import com.parse.ParseCallback1;
import com.parse.ParseCorePlugins;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseExecutors;
import com.parse.ParseFileController;
import com.parse.ParseFileUtils;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;
import com.parse.ProgressCallback;
import com.parse.SaveCallback;
import com.parse.TaskQueue;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseFile {
    static final int MAX_FILE_SIZE = 0xA00000;
    private State state;
    byte[] data;
    final TaskQueue taskQueue = new TaskQueue();
    private Set<Task.TaskCompletionSource> currentTasks = Collections.synchronizedSet(new HashSet());

    static ParseFileController getFileController() {
        return ParseCorePlugins.getInstance().getFileController();
    }

    private static ProgressCallback progressCallbackOnMainThread(final ProgressCallback progressCallback) {
        if (progressCallback == null) {
            return null;
        }
        return new ProgressCallback(){

            @Override
            public void done(final Integer percentDone) {
                Task.call((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        progressCallback.done(percentDone);
                        return null;
                    }
                }, (Executor)ParseExecutors.main());
            }
        };
    }

    public ParseFile(String name, byte[] data, String contentType) {
        this(new State.Builder().name(name).mimeType(contentType).build());
        if (data.length > 0xA00000) {
            throw new IllegalArgumentException(String.format("ParseFile must be less than %d bytes", 0xA00000));
        }
        this.data = data;
    }

    public ParseFile(byte[] data) {
        this(null, data, null);
    }

    public ParseFile(String name, byte[] data) {
        this(name, data, null);
    }

    public ParseFile(byte[] data, String contentType) {
        this(null, data, contentType);
    }

    ParseFile(State state) {
        this.state = state;
    }

    State getState() {
        return this.state;
    }

    public String getName() {
        return this.state.name();
    }

    public boolean isDirty() {
        return this.state.url() == null;
    }

    public boolean isDataAvailable() {
        return this.data != null || ParseFile.getFileController().isDataAvailable(this.state) || this.isPinnedDataAvailable();
    }

    public String getUrl() {
        return this.state.url();
    }

    static File getFilesDir() {
        return Parse.getParseFilesDir("files");
    }

    private String getFilename() {
        return this.state.name();
    }

    File getCacheFile() {
        return ParseFile.getFileController().getCacheFile(this.state);
    }

    File getFilesFile() {
        String filename = this.getFilename();
        return filename != null ? new File(ParseFile.getFilesDir(), filename) : null;
    }

    boolean isPinned() {
        File file = this.getFilesFile();
        return file != null && file.exists();
    }

    private boolean isPinnedDataAvailable() {
        return this.getFilesFile().exists();
    }

    void pin() throws ParseException {
        this.setPinned(true);
    }

    void unpin() throws ParseException {
        this.setPinned(false);
    }

    Task<Void> pinInBackground() {
        return this.setPinnedInBackground(true);
    }

    Task<Void> unpinInBackground() {
        return this.setPinnedInBackground(false);
    }

    void pinInBackground(ParseCallback1<ParseException> callback) {
        this.setPinnedInBackground(true, callback);
    }

    void unpinInBackground(ParseCallback1<ParseException> callback) {
        this.setPinnedInBackground(false, callback);
    }

    private void setPinned(boolean pinned) throws ParseException {
        ParseTaskUtils.wait(this.setPinnedInBackground(pinned));
    }

    private void setPinnedInBackground(boolean pinned, ParseCallback1<ParseException> callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.setPinnedInBackground(pinned), callback);
    }

    private Task<Void> setPinnedInBackground(final boolean pinned) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return task;
            }
        }).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                File dest;
                File src;
                if (ParseFile.this.state.url() == null) {
                    throw new IllegalStateException("Unable to pin file before saving");
                }
                if (pinned && ParseFile.this.isPinned() || !pinned && !ParseFile.this.isPinned()) {
                    return null;
                }
                if (pinned) {
                    src = ParseFile.this.getCacheFile();
                    dest = ParseFile.this.getFilesFile();
                } else {
                    src = ParseFile.this.getFilesFile();
                    dest = ParseFile.this.getCacheFile();
                }
                if (dest.exists()) {
                    ParseFileUtils.deleteQuietly(dest);
                }
                if (pinned && ParseFile.this.data != null) {
                    ParseFileUtils.writeByteArrayToFile(dest, ParseFile.this.data);
                    if (src.exists()) {
                        ParseFileUtils.deleteQuietly(src);
                    }
                    return null;
                }
                if (src == null || !src.exists()) {
                    throw new IllegalStateException("Unable to pin file before retrieving");
                }
                ParseFileUtils.moveFile(src, dest);
                return null;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    public void save() throws ParseException {
        ParseTaskUtils.wait(this.saveInBackground());
    }

    private Task<Void> saveAsync(final String sessionToken, final ProgressCallback uploadProgressCallback, Task<Void> toAwait, final Task<Void> cancellationToken) {
        if (!this.isDirty()) {
            return Task.forResult(null);
        }
        if (cancellationToken != null && cancellationToken.isCancelled()) {
            return Task.cancelled();
        }
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                if (!ParseFile.this.isDirty()) {
                    return Task.forResult(null);
                }
                if (cancellationToken != null && cancellationToken.isCancelled()) {
                    return Task.cancelled();
                }
                return ParseFile.getFileController().saveAsync(ParseFile.this.state, ParseFile.this.data, sessionToken, ParseFile.progressCallbackOnMainThread(uploadProgressCallback), (Task<Void>)cancellationToken).onSuccessTask((Continuation)new Continuation<State, Task<Void>>(){

                    public Task<Void> then(Task<State> task) throws Exception {
                        ParseFile.this.state = (State)task.getResult();
                        return task.makeVoid();
                    }
                });
            }
        });
    }

    public Task<Void> saveInBackground(final ProgressCallback uploadProgressCallback) {
        final Task.TaskCompletionSource cts = Task.create();
        this.currentTasks.add(cts);
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return ParseFile.this.saveAsync(sessionToken, uploadProgressCallback, (Task<Void>)cts.getTask());
            }
        }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                cts.trySetResult(null);
                ParseFile.this.currentTasks.remove(cts);
                return task;
            }
        });
    }

    Task<Void> saveAsync(final String sessionToken, final ProgressCallback uploadProgressCallback, final Task<Void> cancellationToken) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return ParseFile.this.saveAsync(sessionToken, uploadProgressCallback, (Task<Void>)toAwait, (Task<Void>)cancellationToken);
            }
        });
    }

    public Task<Void> saveInBackground() {
        return this.saveInBackground((ProgressCallback)null);
    }

    public void saveInBackground(SaveCallback saveCallback, ProgressCallback progressCallback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.saveInBackground(progressCallback), saveCallback);
    }

    public void saveInBackground(SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.saveInBackground(), callback);
    }

    public byte[] getData() throws ParseException {
        return ParseTaskUtils.wait(this.getDataInBackground());
    }

    private Task<byte[]> getDataAsync(final ProgressCallback progressCallback, Task<Void> toAwait, final Task<Void> cancellationToken) {
        if (this.data != null) {
            return Task.forResult((Object)this.data);
        }
        if (cancellationToken != null && cancellationToken.isCancelled()) {
            return Task.cancelled();
        }
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<byte[]>>(){

            public Task<byte[]> then(Task<Void> task) throws Exception {
                if (ParseFile.this.data != null) {
                    return Task.forResult((Object)ParseFile.this.data);
                }
                if (cancellationToken != null && cancellationToken.isCancelled()) {
                    return Task.cancelled();
                }
                return ParseFile.getFileController().fetchAsync(ParseFile.this.state, null, ParseFile.progressCallbackOnMainThread(progressCallback), (Task<Void>)cancellationToken).onSuccess((Continuation)new Continuation<File, byte[]>(){

                    public byte[] then(Task<File> task) throws Exception {
                        File file = (File)task.getResult();
                        try {
                            ParseFile.this.data = ParseFileUtils.readFileToByteArray(file);
                            return ParseFile.this.data;
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                });
            }
        });
    }

    public Task<byte[]> getDataInBackground(final ProgressCallback progressCallback) {
        final Task.TaskCompletionSource cts = Task.create();
        this.currentTasks.add(cts);
        return this.taskQueue.enqueue(new Continuation<Void, Task<byte[]>>(){

            public Task<byte[]> then(Task<Void> toAwait) throws Exception {
                return ParseFile.this.getDataAsync(progressCallback, (Task<Void>)toAwait, (Task<Void>)cts.getTask());
            }
        }).continueWithTask((Continuation)new Continuation<byte[], Task<byte[]>>(){

            public Task<byte[]> then(Task<byte[]> task) throws Exception {
                cts.trySetResult(null);
                ParseFile.this.currentTasks.remove(cts);
                return task;
            }
        });
    }

    public Task<byte[]> getDataInBackground() {
        return this.getDataInBackground((ProgressCallback)null);
    }

    public void getDataInBackground(GetDataCallback dataCallback, ProgressCallback progressCallback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.getDataInBackground(progressCallback), dataCallback);
    }

    public void getDataInBackground(GetDataCallback dataCallback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.getDataInBackground(), dataCallback);
    }

    public void cancel() {
        HashSet<Task.TaskCompletionSource> tasks = new HashSet<Task.TaskCompletionSource>(this.currentTasks);
        for (Task.TaskCompletionSource tcs : tasks) {
            tcs.trySetCancelled();
        }
        this.currentTasks.removeAll(tasks);
    }

    ParseFile(JSONObject json, ParseDecoder decoder) {
        this(new State.Builder().name(json.optString("name")).url(json.optString("url")).build());
    }

    JSONObject encode() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("__type", (Object)"File");
        json.put("name", (Object)this.getName());
        String url = this.getUrl();
        if (url == null) {
            throw new IllegalStateException("Unable to encode an unsaved ParseFile.");
        }
        json.put("url", (Object)this.getUrl());
        return json;
    }

    static class State {
        private final String name;
        private final String contentType;
        private final String url;

        private State(Builder builder) {
            this.name = builder.name != null ? builder.name : "file";
            this.contentType = builder.mimeType;
            this.url = builder.url;
        }

        public String name() {
            return this.name;
        }

        public String mimeType() {
            return this.contentType;
        }

        public String url() {
            return this.url;
        }

        static class Builder {
            private String name;
            private String mimeType;
            private String url;

            public Builder() {
            }

            public Builder(State state) {
                this.name = state.name();
                this.mimeType = state.mimeType();
                this.url = state.url();
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder mimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public State build() {
                return new State(this);
            }
        }
    }
}

