/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.net.http.AndroidHttpClient;
import com.parse.ParseHttpBody;
import com.parse.ParseHttpClient;
import com.parse.ParseHttpRequest;
import com.parse.ParseHttpResponse;
import com.parse.ParseRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

class ParseApacheHttpClient
extends ParseHttpClient<HttpUriRequest, HttpResponse> {
    private DefaultHttpClient apacheClient;

    public ParseApacheHttpClient(int socketOperationTimeout, SSLSessionCache sslSessionCache) {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)socketOperationTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)socketOperationTimeout);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLCertificateSocketFactory.getHttpSocketFactory((int)socketOperationTimeout, (SSLSessionCache)sslSessionCache), 443));
        String maxConnectionsStr = System.getProperty("http.maxConnections");
        if (maxConnectionsStr != null) {
            int maxConnections = Integer.parseInt(maxConnectionsStr);
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(maxConnections));
            ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)maxConnections);
        }
        String host = System.getProperty("http.proxyHost");
        String portString = System.getProperty("http.proxyPort");
        if (host != null && host.length() != 0 && portString != null && portString.length() != 0) {
            int port = Integer.parseInt(portString);
            HttpHost proxy = new HttpHost(host, port, "http");
            params.setParameter("http.route.default-proxy", (Object)proxy);
        }
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        this.apacheClient = new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)params);
    }

    @Override
    ParseHttpResponse executeInternal(ParseHttpRequest parseRequest) throws IOException {
        HttpUriRequest apacheRequest = this.getRequest(parseRequest);
        ParseApacheHttpClient.setParseRequestCancelRunnable(parseRequest, apacheRequest);
        HttpResponse apacheResponse = this.apacheClient.execute(apacheRequest);
        return this.getResponse(apacheResponse);
    }

    @Override
    ParseHttpResponse getResponse(HttpResponse apacheResponse) throws IOException {
        if (apacheResponse == null) {
            throw new IllegalArgumentException("HttpResponse passed to getResponse should not be null.");
        }
        int statusCode = apacheResponse.getStatusLine().getStatusCode();
        InputStream content = AndroidHttpClient.getUngzippedContent((HttpEntity)apacheResponse.getEntity());
        int totalSize = -1;
        Header[] contentLengthHeader = apacheResponse.getHeaders("Content-Length");
        if (contentLengthHeader.length > 0) {
            totalSize = Integer.parseInt(contentLengthHeader[0].getValue());
        }
        String reasonPhrase = apacheResponse.getStatusLine().getReasonPhrase();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : apacheResponse.getAllHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        String contentType = null;
        HttpEntity entity = apacheResponse.getEntity();
        if (entity != null && entity.getContentType() != null) {
            contentType = entity.getContentType().getValue();
        }
        return ((ParseHttpResponse.Builder)((ParseHttpResponse.Builder)((ParseHttpResponse.Builder)((ParseHttpResponse.Builder)((ParseHttpResponse.Builder)((ParseHttpResponse.Builder)new ParseHttpResponse.Builder().setStatusCode(statusCode)).setContent(content)).setTotalSize(totalSize)).setReasonPhase(reasonPhrase)).setHeaders(headers)).setContentType(contentType)).build();
    }

    @Override
    HttpUriRequest getRequest(ParseHttpRequest parseRequest) throws IOException {
        HttpGet apacheRequest;
        if (parseRequest == null) {
            throw new IllegalArgumentException("ParseHttpRequest passed to getApacheRequest should not be null.");
        }
        ParseRequest.Method method = parseRequest.getMethod();
        String url = parseRequest.getUrl();
        switch (method) {
            case GET: {
                apacheRequest = new HttpGet(url);
                break;
            }
            case DELETE: {
                apacheRequest = new HttpDelete(url);
                break;
            }
            case POST: {
                apacheRequest = new HttpPost(url);
                break;
            }
            case PUT: {
                apacheRequest = new HttpPut(url);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported http method " + method.toString());
            }
        }
        for (Map.Entry<String, String> entry : parseRequest.getAllHeaders().entrySet()) {
            apacheRequest.setHeader(entry.getKey(), entry.getValue());
        }
        AndroidHttpClient.modifyRequestToAcceptGzipResponse((HttpRequest)apacheRequest);
        ParseHttpBody body = parseRequest.getBody();
        switch (method) {
            case POST: {
                ((HttpPost)apacheRequest).setEntity((HttpEntity)new ParseApacheHttpEntity(body));
                break;
            }
            case PUT: {
                ((HttpPut)apacheRequest).setEntity((HttpEntity)new ParseApacheHttpEntity(body));
                break;
            }
        }
        return apacheRequest;
    }

    private static void setParseRequestCancelRunnable(ParseHttpRequest parseRequest, final HttpUriRequest apacheRequest) {
        parseRequest.setCancelRunnable(new Runnable(){

            @Override
            public void run() {
                apacheRequest.abort();
            }
        });
    }

    private static class ParseApacheHttpEntity
    extends InputStreamEntity {
        private ParseHttpBody parseBody;

        public ParseApacheHttpEntity(ParseHttpBody parseBody) {
            super(parseBody.getContent(), (long)parseBody.getContentLength());
            super.setContentType(parseBody.getContentType());
            this.parseBody = parseBody;
        }

        public void writeTo(OutputStream out) throws IOException {
            this.parseBody.writeTo(out);
        }
    }
}

