/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ParseACL;
import com.parse.ParseDateFormat;
import com.parse.ParseDecoder;
import com.parse.ParseEncoder;
import com.parse.ParseFieldOperation;
import com.parse.ParseHttpClient;
import com.parse.ParseObject;
import com.parse.ParseObjectController;
import com.parse.ParseOperationSet;
import com.parse.ParseRESTObjectBatchCommand;
import com.parse.ParseRESTObjectCommand;
import com.parse.PointerEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

class NetworkObjectController
implements ParseObjectController {
    private static final String KEY_OBJECT_ID = "objectId";
    private static final String KEY_CLASS_NAME = "className";
    private static final String KEY_ACL = "ACL";
    private static final String KEY_CREATED_AT = "createdAt";
    private static final String KEY_UPDATED_AT = "updatedAt";
    private ParseHttpClient client;

    public NetworkObjectController(ParseHttpClient client) {
        this.client = client;
    }

    @Override
    public Task<ParseObject.State> fetchAsync(final ParseObject.State state, String sessionToken, final ParseDecoder decoder) {
        ParseRESTObjectCommand command = ParseRESTObjectCommand.getObjectCommand(state.objectId(), state.className(), sessionToken);
        command.enableRetrying();
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, ParseObject.State>(){

            public ParseObject.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return NetworkObjectController.this.stateFromJSON(state, result, decoder, true);
            }
        });
    }

    @Override
    public Task<ParseObject.State> saveAsync(final ParseObject.State state, ParseOperationSet operations, String sessionToken, final ParseDecoder decoder) {
        JSONObject objectJSON = this.stateToJSONObject(state, operations, PointerEncoder.get());
        ParseRESTObjectCommand command = ParseRESTObjectCommand.saveObjectCommand(state, objectJSON, sessionToken);
        command.enableRetrying();
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, ParseObject.State>(){

            public ParseObject.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return NetworkObjectController.this.stateFromJSON(state, result, decoder, false);
            }
        });
    }

    @Override
    public List<Task<ParseObject.State>> saveAllAsync(List<ParseObject.State> states, List<ParseOperationSet> operationsList, String sessionToken, List<ParseDecoder> decoders) {
        int batchSize = states.size();
        ArrayList<ParseRESTObjectCommand> commands = new ArrayList<ParseRESTObjectCommand>(batchSize);
        PointerEncoder encoder = PointerEncoder.get();
        for (int i = 0; i < batchSize; ++i) {
            ParseObject.State state = states.get(i);
            ParseOperationSet operations = operationsList.get(i);
            JSONObject objectJSON = this.stateToJSONObject(state, operations, encoder);
            ParseRESTObjectCommand command = ParseRESTObjectCommand.saveObjectCommand(state, objectJSON, sessionToken);
            commands.add(command);
        }
        List<Task<JSONObject>> batchTasks = ParseRESTObjectBatchCommand.executeBatch(this.client, commands, sessionToken);
        ArrayList<Task<ParseObject.State>> tasks = new ArrayList<Task<ParseObject.State>>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            final ParseObject.State state = states.get(i);
            final ParseDecoder decoder = decoders.get(i);
            tasks.add((Task<ParseObject.State>)batchTasks.get(i).onSuccess((Continuation)new Continuation<JSONObject, ParseObject.State>(){

                public ParseObject.State then(Task<JSONObject> task) throws Exception {
                    JSONObject result = (JSONObject)task.getResult();
                    return NetworkObjectController.this.stateFromJSON(state, result, decoder, false);
                }
            }));
        }
        return tasks;
    }

    @Override
    public Task<Void> deleteAsync(ParseObject.State state, String sessionToken) {
        ParseRESTObjectCommand command = ParseRESTObjectCommand.deleteObjectCommand(state, sessionToken);
        command.enableRetrying();
        return command.executeAsync(this.client).makeVoid();
    }

    @Override
    public List<Task<Void>> deleteAllAsync(List<ParseObject.State> states, String sessionToken) {
        int batchSize = states.size();
        ArrayList<ParseRESTObjectCommand> commands = new ArrayList<ParseRESTObjectCommand>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            ParseObject.State state = states.get(i);
            ParseRESTObjectCommand command = ParseRESTObjectCommand.deleteObjectCommand(state, sessionToken);
            command.enableRetrying();
            commands.add(command);
        }
        List<Task<JSONObject>> batchTasks = ParseRESTObjectBatchCommand.executeBatch(this.client, commands, sessionToken);
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            tasks.add((Task<Void>)batchTasks.get(i).makeVoid());
        }
        return tasks;
    }

    <T extends ParseObject.State> JSONObject stateToJSONObject(T state, ParseOperationSet operations, ParseEncoder objectEncoder) {
        JSONObject objectJSON = new JSONObject();
        try {
            for (String key : operations.keySet()) {
                ParseFieldOperation operation = (ParseFieldOperation)operations.get(key);
                objectJSON.put(key, objectEncoder.encode(operation));
            }
            if (state.objectId() != null) {
                objectJSON.put(KEY_OBJECT_ID, (Object)state.objectId());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize object to JSON");
        }
        return objectJSON;
    }

    @Override
    public <T extends ParseObject.State> T stateFromJSON(T original, JSONObject json, ParseDecoder decoder, boolean completeData) {
        try {
            Object builder = ((ParseObject.State.Init)original.newBuilder()).clear();
            ((ParseObject.State.Init)builder).isComplete(completeData);
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key.equals("__type") || key.equals(KEY_CLASS_NAME)) continue;
                if (key.equals(KEY_OBJECT_ID)) {
                    String newObjectId = json.getString(key);
                    ((ParseObject.State.Init)builder).objectId(newObjectId);
                    continue;
                }
                if (key.equals(KEY_CREATED_AT)) {
                    ((ParseObject.State.Init)builder).createdAt(ParseDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                if (key.equals(KEY_UPDATED_AT)) {
                    ((ParseObject.State.Init)builder).updatedAt(ParseDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                if (key.equals(KEY_ACL)) {
                    ParseACL acl = ParseACL.createACLFromJSONObject(json.getJSONObject(key), decoder);
                    ((ParseObject.State.Init)builder).put(KEY_ACL, acl);
                    continue;
                }
                Object value = json.get(key);
                Object decodedObject = decoder.decode(value);
                ((ParseObject.State.Init)builder).put(key, decodedObject);
            }
            return (T)((ParseObject.State.Init)builder).build();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

