/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Bundle;
import com.parse.GcmBroadcastReceiver;
import com.parse.PLog;
import com.parse.Parse;
import com.parse.ParseBroadcastReceiver;
import com.parse.PushService;
import com.parse.PushType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class ManifestInfo {
    private static final String TAG = "com.parse.ManifestInfo";
    private static final int NUMBER_OF_PUSH_INTENTS = 3;
    private static final Object lock = new Object();
    private static long lastModified = -1L;
    static int versionCode = -1;
    static String versionName = null;
    private static int iconId = 0;
    private static String displayName = null;
    private static PushType pushType;
    private static Boolean pushUsesBroadcastReceivers;

    ManifestInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified() {
        Object object = lock;
        synchronized (object) {
            if (lastModified == -1L) {
                File apkPath = new File(ManifestInfo.getApplicationInfo().sourceDir);
                lastModified = apkPath.lastModified();
            }
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVersionCode() {
        Object object = lock;
        synchronized (object) {
            if (versionCode == -1) {
                try {
                    versionCode = ManifestInfo.getPackageManager().getPackageInfo((String)ManifestInfo.getContext().getPackageName(), (int)0).versionCode;
                }
                catch (PackageManager.NameNotFoundException e) {
                    PLog.e(TAG, "Couldn't find info about own package", e);
                }
            }
        }
        return versionCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersionName() {
        Object object = lock;
        synchronized (object) {
            if (versionName == null) {
                try {
                    versionName = ManifestInfo.getPackageManager().getPackageInfo((String)ManifestInfo.getContext().getPackageName(), (int)0).versionName;
                }
                catch (PackageManager.NameNotFoundException e) {
                    PLog.e(TAG, "Couldn't find info about own package", e);
                }
            }
        }
        return versionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDisplayName(Context context) {
        Object object = lock;
        synchronized (object) {
            if (displayName == null) {
                ApplicationInfo appInfo = context.getApplicationInfo();
                displayName = context.getPackageManager().getApplicationLabel(appInfo).toString();
            }
        }
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIconId() {
        Object object = lock;
        synchronized (object) {
            if (iconId == 0) {
                iconId = ManifestInfo.getApplicationInfo().icon;
            }
        }
        return iconId;
    }

    static boolean hasIntentReceiver(String action) {
        return !ManifestInfo.getIntentReceivers(action).isEmpty();
    }

    static List<ResolveInfo> getIntentReceivers(String ... actions) {
        Context context = ManifestInfo.getContext();
        String packageName = context.getPackageName();
        ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>();
        for (String action : actions) {
            list.addAll(context.getPackageManager().queryBroadcastReceivers(new Intent(action), 32));
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            String receiverPackageName = ((ResolveInfo)list.get((int)i)).activityInfo.packageName;
            if (receiverPackageName.equals(packageName)) continue;
            list.remove(i);
        }
        return list;
    }

    public static void setPushUsesBroadcastReceivers(boolean value) {
        pushUsesBroadcastReceivers = value;
    }

    static boolean getPushUsesBroadcastReceivers() {
        if (pushUsesBroadcastReceivers != null) {
            return pushUsesBroadcastReceivers;
        }
        int intentsRegistered = 0;
        if (ManifestInfo.hasIntentReceiver("com.parse.push.intent.RECEIVE")) {
            ++intentsRegistered;
        }
        if (ManifestInfo.hasIntentReceiver("com.parse.push.intent.OPEN")) {
            ++intentsRegistered;
        }
        if (ManifestInfo.hasIntentReceiver("com.parse.push.intent.DELETE")) {
            ++intentsRegistered;
        }
        if (intentsRegistered != 0 && intentsRegistered != 3) {
            throw new SecurityException("The Parse Push BroadcastReceiver must implement a filter for all of com.parse.push.intent.RECEIVE, com.parse.push.intent.OPEN, and com.parse.push.intent.DELETE");
        }
        pushUsesBroadcastReceivers = intentsRegistered == 3;
        return pushUsesBroadcastReceivers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setPushType(PushType newPushType) {
        Object object = lock;
        synchronized (object) {
            pushType = newPushType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PushType getPushType() {
        Object object = lock;
        synchronized (object) {
            if (pushType == null) {
                boolean deviceSupportsGcm = ManifestInfo.deviceSupportsGcm();
                boolean hasAnyGcmSpecificDeclaration = ManifestInfo.hasAnyGcmSpecificDeclaration();
                ManifestCheckResult gcmSupportLevel = ManifestInfo.gcmSupportLevel();
                ManifestCheckResult ppnsSupportLevel = ManifestInfo.ppnsSupportLevel();
                pushType = deviceSupportsGcm && gcmSupportLevel != ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS ? PushType.GCM : ((!hasAnyGcmSpecificDeclaration || !deviceSupportsGcm) && ppnsSupportLevel != ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS ? PushType.PPNS : PushType.NONE);
                if (Parse.getLogLevel() <= 5) {
                    if (pushType == PushType.GCM && gcmSupportLevel == ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS) {
                        PLog.w(TAG, "Using GCM for push, but the app manifest is missing some optional declarations that should be added for maximum reliability. Please " + ManifestInfo.getGcmManifestMessage());
                    } else if (pushType == PushType.PPNS && ppnsSupportLevel == ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS) {
                        PLog.w(TAG, "Using PPNS for push, but the app manifest is missing some optional declarations that should be added for maximum reliability. Please " + ManifestInfo.getPpnsManifestMessage());
                    }
                }
                if (Parse.getLogLevel() <= 6 && pushType == PushType.NONE && hasAnyGcmSpecificDeclaration) {
                    if (!deviceSupportsGcm) {
                        PLog.e(TAG, "Cannot use GCM for push on this device because Google Play Services is not installed. Install Google Play Service from the Play Store, or enable PPNS as a fallback push service. To enable PPNS as a fallback push service on devices without Google Play support, please " + ManifestInfo.getPpnsManifestMessage());
                    }
                    if (gcmSupportLevel != ManifestCheckResult.HAS_ALL_DECLARATIONS) {
                        PLog.e(TAG, "Cannot use GCM for push because the app manifest is missing some required declarations. Please " + ManifestInfo.getGcmManifestMessage());
                    }
                }
                if (Parse.getLogLevel() <= 2) {
                    PLog.v(TAG, "Using " + (Object)((Object)pushType) + " for push.");
                }
            }
        }
        return pushType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNonePushTypeLogMessage() {
        Object object = lock;
        synchronized (object) {
            if (pushType == PushType.NONE) {
                return "Push is not configured for this app because the app manifest is missing required declarations. Please add the following declarations to your app manifest to support either GCM or PPNS for push (or both). To enable GCM support, please " + ManifestInfo.getGcmManifestMessage() + "To enable PPNS support, please " + ManifestInfo.getPpnsManifestMessage();
            }
            return "";
        }
    }

    private static Context getContext() {
        return Parse.getApplicationContext();
    }

    private static PackageManager getPackageManager() {
        return ManifestInfo.getContext().getPackageManager();
    }

    private static ApplicationInfo getApplicationInfo() {
        return ManifestInfo.getContext().getApplicationInfo();
    }

    private static ApplicationInfo getApplicationInfo(Context context, int flags) {
        try {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public static Bundle getApplicationMetadata(Context context) {
        ApplicationInfo info = ManifestInfo.getApplicationInfo(context, 128);
        if (info != null) {
            return info.metaData;
        }
        return null;
    }

    private static PackageInfo getPackageInfo(String name) {
        PackageInfo info = null;
        try {
            info = ManifestInfo.getPackageManager().getPackageInfo(name, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info;
    }

    private static ServiceInfo getServiceInfo(Class<? extends Service> clazz) {
        ServiceInfo info = null;
        try {
            info = ManifestInfo.getPackageManager().getServiceInfo(new ComponentName(ManifestInfo.getContext(), clazz), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info;
    }

    private static ActivityInfo getReceiverInfo(Class<? extends BroadcastReceiver> clazz) {
        ActivityInfo info = null;
        try {
            info = ManifestInfo.getPackageManager().getReceiverInfo(new ComponentName(ManifestInfo.getContext(), clazz), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info;
    }

    private static boolean hasPermissions(String ... permissions) {
        for (String permission : permissions) {
            if (ManifestInfo.getPackageManager().checkPermission(permission, ManifestInfo.getContext().getPackageName()) == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean checkResolveInfo(Class<? extends BroadcastReceiver> clazz, List<ResolveInfo> infoList) {
        for (ResolveInfo info : infoList) {
            if (info.activityInfo == null || !clazz.getCanonicalName().equals(info.activityInfo.name)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkReceiver(Class<? extends BroadcastReceiver> clazz, String permission, Intent[] intents) {
        ActivityInfo receiver = ManifestInfo.getReceiverInfo(clazz);
        if (receiver == null) {
            return false;
        }
        if (permission != null && !permission.equals(receiver.permission)) {
            return false;
        }
        for (Intent intent : intents) {
            List receivers = ManifestInfo.getPackageManager().queryBroadcastReceivers(intent, 0);
            if (receivers.isEmpty()) {
                return false;
            }
            if (ManifestInfo.checkResolveInfo(clazz, receivers)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAnyGcmSpecificDeclaration() {
        return ManifestInfo.hasPermissions("com.google.android.c2dm.permission.RECEIVE") || ManifestInfo.hasPermissions(ManifestInfo.getContext().getPackageName() + ".permission.C2D_MESSAGE") || ManifestInfo.getReceiverInfo(GcmBroadcastReceiver.class) != null;
    }

    private static boolean deviceSupportsGcm() {
        return Build.VERSION.SDK_INT >= 8 && ManifestInfo.getPackageInfo("com.google.android.gsf") != null;
    }

    private static ManifestCheckResult gcmSupportLevel() {
        Context context = ManifestInfo.getContext();
        if (ManifestInfo.getServiceInfo(PushService.class) == null) {
            return ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
        }
        String[] requiredPermissions = new String[]{"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK", "android.permission.GET_ACCOUNTS", "com.google.android.c2dm.permission.RECEIVE", context.getPackageName() + ".permission.C2D_MESSAGE"};
        if (!ManifestInfo.hasPermissions(requiredPermissions)) {
            return ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
        }
        String packageName = context.getPackageName();
        String rcvrPermission = "com.google.android.c2dm.permission.SEND";
        Intent[] intents = new Intent[]{new Intent("com.google.android.c2dm.intent.RECEIVE").setPackage(packageName).addCategory(packageName), new Intent("com.google.android.c2dm.intent.REGISTRATION").setPackage(packageName).addCategory(packageName)};
        if (!ManifestInfo.checkReceiver(GcmBroadcastReceiver.class, rcvrPermission, intents)) {
            return ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
        }
        String[] optionalPermissions = new String[]{"android.permission.VIBRATE"};
        if (!ManifestInfo.hasPermissions(optionalPermissions)) {
            return ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS;
        }
        return ManifestCheckResult.HAS_ALL_DECLARATIONS;
    }

    private static ManifestCheckResult ppnsSupportLevel() {
        if (ManifestInfo.getServiceInfo(PushService.class) == null) {
            return ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
        }
        String[] optionalPermissions = new String[]{"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.VIBRATE", "android.permission.WAKE_LOCK", "android.permission.RECEIVE_BOOT_COMPLETED"};
        if (!ManifestInfo.hasPermissions(optionalPermissions)) {
            return ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS;
        }
        String packageName = ManifestInfo.getContext().getPackageName();
        Intent[] intents = new Intent[]{new Intent("android.intent.action.BOOT_COMPLETED").setPackage(packageName), new Intent("android.intent.action.USER_PRESENT").setPackage(packageName)};
        if (!ManifestInfo.checkReceiver(ParseBroadcastReceiver.class, null, intents)) {
            return ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS;
        }
        return ManifestCheckResult.HAS_ALL_DECLARATIONS;
    }

    private static String getGcmManifestMessage() {
        String packageName = ManifestInfo.getContext().getPackageName();
        String gcmPackagePermission = packageName + ".permission.C2D_MESSAGE";
        return "make sure that these permissions are declared as children of the root <manifest> element:\n\n<uses-permission android:name=\"android.permission.INTERNET\" />\n<uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />\n<uses-permission android:name=\"android.permission.VIBRATE\" />\n<uses-permission android:name=\"android.permission.WAKE_LOCK\" />\n<uses-permission android:name=\"android.permission.GET_ACCOUNTS\" />\n<uses-permission android:name=\"com.google.android.c2dm.permission.RECEIVE\" />\n<permission android:name=\"" + gcmPackagePermission + "\" " + "android:protectionLevel=\"signature\" />\n" + "<uses-permission android:name=\"" + gcmPackagePermission + "\" />\n" + "\n" + "Also, please make sure that these services and broadcast receivers are declared as " + "children of the <application> element:\n" + "\n" + "<service android:name=\"com.parse.PushService\" />\n" + "<receiver android:name=\"com.parse.GcmBroadcastReceiver\" " + "android:permission=\"com.google.android.c2dm.permission.SEND\">\n" + "  <intent-filter>\n" + "    <action android:name=\"com.google.android.c2dm.intent.RECEIVE\" />\n" + "    <action android:name=\"com.google.android.c2dm.intent.REGISTRATION\" />\n" + "    <category android:name=\"" + packageName + "\" />\n" + "  </intent-filter>\n" + "</receiver>\n";
    }

    private static String getPpnsManifestMessage() {
        return "make sure that these permissions are declared as children of the root <manifest> element:\n\n<uses-permission android:name=\"android.permission.INTERNET\" />\n<uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />\n<uses-permission android:name=\"android.permission.RECEIVE_BOOT_COMPLETED\" />\n<uses-permission android:name=\"android.permission.VIBRATE\" />\n<uses-permission android:name=\"android.permission.WAKE_LOCK\" />\n\nAlso, please make sure that these services and broadcast receivers are declared as children of the <application> element:\n\n<service android:name=\"com.parse.PushService\" />\n<receiver android:name=\"com.parse.ParseBroadcastReceiver\">\n  <intent-filter>\n    <action android:name=\"android.intent.action.BOOT_COMPLETED\" />\n    <action android:name=\"android.intent.action.USER_PRESENT\" />\n  </intent-filter>\n</receiver>\n";
    }

    static {
        pushUsesBroadcastReceivers = null;
    }

    static enum ManifestCheckResult {
        HAS_ALL_DECLARATIONS,
        MISSING_OPTIONAL_DECLARATIONS,
        MISSING_REQUIRED_DECLARATIONS;

    }
}

