/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Looper;
import android.os.SystemClock;
import bolts.Continuation;
import bolts.Task;
import com.parse.ConnectivityNotifier;
import com.parse.PLog;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseIOUtils;
import com.parse.ParseWakeLock;
import com.parse.PushRouter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

class PushConnection {
    private static final String TAG = "com.parse.PushConnection";
    private static final int CONNECT_TIMEOUT_MS = 40000;
    static long KEEP_ALIVE_INTERVAL = 900000L;
    static long KEEP_ALIVE_ACK_INTERVAL = 60000L;
    static boolean ENABLE_QUICK_ACK_CHECK = true;
    static boolean ENABLE_RETRY_DELAY = true;
    private static final long MIN_RETRY_DELAY_MS = 15000L;
    private static final long MAX_RETRY_DELAY_MS = 300000L;
    private static final double RETRY_MULT_FACTOR_MIN = 1.5;
    private static final double RETRY_MULT_FACTOR_MAX = 2.0;
    private final Service service;
    private final String host;
    private final int port;
    private final ExecutorService executor;
    private final EventSet eventSet;
    private final AtomicLong lastReadTime;
    private static List<StateTransitionListener> stateTransitionListeners;

    public PushConnection(Service service, String host, int port) {
        this.service = service;
        this.host = host;
        this.port = port;
        this.executor = Executors.newSingleThreadExecutor();
        this.eventSet = new EventSet();
        this.lastReadTime = new AtomicLong();
        WaitStartState nextState = new WaitStartState();
        PushConnection.dispatchOnStateChange(this, null, nextState);
        this.executor.execute(nextState);
    }

    public synchronized void start() {
        this.eventSet.signalEvent(Event.START);
    }

    public synchronized void stop() {
        this.eventSet.signalEvent(Event.STOP);
    }

    private static boolean writeLine(Socket socket, String string) {
        boolean sent = false;
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            throw new Error("Wrote to push socket on main thread.");
        }
        try {
            OutputStream stream = socket.getOutputStream();
            stream.write((string + "\n").getBytes("UTF-8"));
            stream.flush();
            sent = true;
        }
        catch (IOException e) {
            PLog.v(TAG, "PushConnection write failed: " + string + " due to exception: " + e);
        }
        return sent;
    }

    private static void closeSocket(Socket socket) {
        try {
            if (!(socket instanceof SSLSocket)) {
                socket.shutdownInput();
            }
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerStateTransitionListener(StateTransitionListener listener) {
        Class<PushConnection> clazz = PushConnection.class;
        synchronized (PushConnection.class) {
            if (stateTransitionListeners == null) {
                stateTransitionListeners = new ArrayList<StateTransitionListener>();
            }
            if (!stateTransitionListeners.contains(listener)) {
                stateTransitionListeners.add(listener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterStateTransitionListener(StateTransitionListener listener) {
        Class<PushConnection> clazz = PushConnection.class;
        synchronized (PushConnection.class) {
            if (stateTransitionListeners == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            stateTransitionListeners.remove(listener);
            if (stateTransitionListeners.size() == 0) {
                stateTransitionListeners = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispatchOnStateChange(PushConnection connection, State from, State to) {
        Class<PushConnection> clazz = PushConnection.class;
        synchronized (PushConnection.class) {
            if (stateTransitionListeners != null) {
                for (StateTransitionListener listener : stateTransitionListeners) {
                    listener.onStateChange(connection, from, to);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static class EventSet {
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private final HashSet<Event> signaledEvents = new HashSet();

        private EventSet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signalEvent(Event event) {
            this.lock.lock();
            try {
                this.signaledEvents.add(event);
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEvents(Event ... eventsToRemove) {
            this.lock.lock();
            try {
                for (Event e : eventsToRemove) {
                    this.signaledEvents.remove((Object)e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public Set<Event> await(Event ... eventsToAwait) {
            return this.timedAwait(Long.MAX_VALUE, eventsToAwait);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Event> timedAwait(long timeoutMs, Event ... eventsToAwait) {
            HashSet<Event> e;
            block8: {
                e = Collections.EMPTY_SET;
                HashSet<Event> toAwait = new HashSet<Event>(Arrays.asList(eventsToAwait));
                long startMs = SystemClock.elapsedRealtime();
                boolean awaitForever = timeoutMs == Long.MAX_VALUE;
                this.lock.lock();
                while (true) {
                    long delta;
                    while (true) {
                        delta = SystemClock.elapsedRealtime() - startMs;
                        e = new HashSet<Event>(toAwait);
                        e.retainAll(this.signaledEvents);
                        this.signaledEvents.removeAll(toAwait);
                        if (e.size() != 0) break block8;
                        if (!awaitForever && delta >= timeoutMs) {
                            break block8;
                        }
                        if (!awaitForever) break;
                        this.condition.awaitUninterruptibly();
                    }
                    try {
                        this.condition.await(timeoutMs - delta, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException exception) {
                        break block8;
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            return e;
        }
    }

    private class ReaderThread
    extends Thread {
        private final Socket socket;
        private boolean stopped;

        public ReaderThread(Socket socket) {
            this.socket = socket;
            this.stopped = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream is = null;
            BufferedReader reader = null;
            try {
                is = this.socket.getInputStream();
                if (is != null) {
                    reader = new BufferedReader(new InputStreamReader(is));
                    this.runReaderLoop(reader);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                ParseIOUtils.closeQuietly(reader);
                ParseIOUtils.closeQuietly(is);
            }
            ReaderThread readerThread = this;
            synchronized (readerThread) {
                if (!this.stopped) {
                    PushConnection.this.eventSet.signalEvent(Event.READ_ERROR);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runReaderLoop(BufferedReader reader) {
            while (true) {
                String line = null;
                try {
                    line = reader.readLine();
                    PushConnection.this.lastReadTime.set(SystemClock.elapsedRealtime());
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (line == null) break;
                JSONTokener tokener = new JSONTokener(line);
                JSONObject message = null;
                try {
                    message = new JSONObject(tokener);
                }
                catch (JSONException e) {
                    PLog.e(PushConnection.TAG, "bad json: " + line, e);
                }
                if (message != null) {
                    PushRouter.handlePpnsPushAsync(message);
                }
                ReaderThread readerThread = this;
                synchronized (readerThread) {
                    if (this.stopped) {
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopReading() {
            ReaderThread readerThread = this;
            synchronized (readerThread) {
                this.stopped = true;
            }
        }
    }

    private class KeepAliveMonitor {
        private final Socket socket;
        private final long interval;
        private BroadcastReceiver writeReceiver;
        private BroadcastReceiver readReceiver;
        private AlarmManager manager;
        private PendingIntent broadcast;
        private Task<Void> keepAliveTask;
        private boolean unregistered;

        public KeepAliveMonitor(Socket socket, long interval) {
            this.socket = socket;
            this.interval = interval;
        }

        public void register() {
            final Context appContext = Parse.getApplicationContext();
            String packageName = appContext.getPackageName();
            String readAction = "com.parse.PushConnection.readKeepAlive";
            final Intent readIntent = new Intent("com.parse.PushConnection.readKeepAlive");
            readIntent.setPackage(packageName);
            readIntent.addCategory(packageName);
            String writeAction = "com.parse.PushConnection.writeKeepAlive";
            Intent writeIntent = new Intent("com.parse.PushConnection.writeKeepAlive");
            writeIntent.setPackage(packageName);
            writeIntent.addCategory(packageName);
            this.manager = (AlarmManager)appContext.getSystemService("alarm");
            PendingIntent oldReadBroadcast = PendingIntent.getBroadcast((Context)appContext, (int)0, (Intent)readIntent, (int)0);
            if (oldReadBroadcast != null) {
                this.manager.cancel(oldReadBroadcast);
                oldReadBroadcast.cancel();
            } else {
                PLog.e(PushConnection.TAG, "oldReadBroadcast was null");
            }
            this.broadcast = PendingIntent.getBroadcast((Context)appContext, (int)0, (Intent)writeIntent, (int)0);
            this.manager.cancel(this.broadcast);
            int alarmType = 2;
            long start = SystemClock.elapsedRealtime();
            this.manager.setInexactRepeating(alarmType, start, this.interval, this.broadcast);
            this.readReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    long delta = SystemClock.elapsedRealtime() - PushConnection.this.lastReadTime.get();
                    if (delta > KEEP_ALIVE_ACK_INTERVAL * 2L) {
                        PLog.v(PushConnection.TAG, "Keep alive failure: last read was " + delta + " ms ago.");
                        KeepAliveMonitor.this.signalKeepAliveFailure();
                    }
                }
            };
            this.writeReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    final ParseWakeLock wl = ParseWakeLock.acquireNewWakeLock((Context)PushConnection.this.service, 1, "push-keep-alive", 20000L);
                    if (KeepAliveMonitor.this.keepAliveTask == null) {
                        KeepAliveMonitor.this.keepAliveTask = Task.forResult(null).makeVoid();
                    }
                    KeepAliveMonitor.this.keepAliveTask = KeepAliveMonitor.this.keepAliveTask.continueWith((Continuation)new Continuation<Void, Void>(){

                        public Void then(Task<Void> task) {
                            if (!PushConnection.writeLine(KeepAliveMonitor.this.socket, "{}")) {
                                KeepAliveMonitor.this.signalKeepAliveFailure();
                            }
                            boolean quickAckCheckSucceeded = false;
                            if (ENABLE_QUICK_ACK_CHECK) {
                                long quickCheckDelta = 2500L;
                                try {
                                    Thread.sleep(quickCheckDelta);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                long delta = SystemClock.elapsedRealtime() - PushConnection.this.lastReadTime.get();
                                boolean bl = quickAckCheckSucceeded = delta <= 2L * quickCheckDelta;
                            }
                            if (!quickAckCheckSucceeded) {
                                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)appContext, (int)System.identityHashCode(this), (Intent)readIntent, (int)0x50000000);
                                KeepAliveMonitor.this.manager.set(2, SystemClock.elapsedRealtime() + KEEP_ALIVE_ACK_INTERVAL, pendingIntent);
                            } else {
                                PLog.v(PushConnection.TAG, "Keep alive ack was received quickly.");
                            }
                            wl.release();
                            return null;
                        }
                    }, (Executor)ParseCommand.NETWORK_EXECUTOR);
                }
            };
            IntentFilter readFilter = new IntentFilter("com.parse.PushConnection.readKeepAlive");
            readFilter.addCategory(packageName);
            appContext.registerReceiver(this.readReceiver, readFilter);
            IntentFilter writeFilter = new IntentFilter("com.parse.PushConnection.writeKeepAlive");
            writeFilter.addCategory(packageName);
            appContext.registerReceiver(this.writeReceiver, writeFilter);
        }

        private synchronized void signalKeepAliveFailure() {
            if (!this.unregistered) {
                PushConnection.this.eventSet.signalEvent(Event.KEEP_ALIVE_ERROR);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            Context context = Parse.getApplicationContext();
            context.unregisterReceiver(this.readReceiver);
            context.unregisterReceiver(this.writeReceiver);
            this.manager.cancel(this.broadcast);
            this.broadcast.cancel();
            KeepAliveMonitor keepAliveMonitor = this;
            synchronized (keepAliveMonitor) {
                this.unregistered = true;
            }
        }
    }

    private class ReachabilityMonitor {
        private ConnectivityNotifier.ConnectivityListener listener;
        private boolean unregistered;

        private ReachabilityMonitor() {
        }

        public void register() {
            this.listener = new ConnectivityNotifier.ConnectivityListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void networkConnectivityStatusChanged(Context context, Intent intent) {
                    ReachabilityMonitor reachabilityMonitor = ReachabilityMonitor.this;
                    synchronized (reachabilityMonitor) {
                        if (!ReachabilityMonitor.this.unregistered) {
                            PushConnection.this.eventSet.signalEvent(Event.CONNECTIVITY_CHANGED);
                        }
                    }
                }
            };
            ConnectivityNotifier.getNotifier((Context)PushConnection.this.service).addListener(this.listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            ConnectivityNotifier.getNotifier((Context)PushConnection.this.service).removeListener(this.listener);
            ReachabilityMonitor reachabilityMonitor = this;
            synchronized (reachabilityMonitor) {
                this.unregistered = true;
            }
        }
    }

    public class StoppedState
    extends State {
        @Override
        public State runState() {
            return null;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }
    }

    public class WaitRetryState
    extends State {
        private long delay;

        public WaitRetryState(long delay) {
            this.delay = delay;
        }

        public long getDelay() {
            return this.delay;
        }

        @Override
        public State runState() {
            Set<Event> e;
            PushConnection.this.eventSet.removeEvents(Event.START);
            long actualDelay = this.delay;
            if (!ENABLE_RETRY_DELAY) {
                actualDelay = 0L;
            }
            State nextState = (e = PushConnection.this.eventSet.timedAwait(actualDelay, Event.STOP, Event.START)).contains((Object)Event.STOP) ? new StoppedState() : (e.contains((Object)Event.START) ? new ConnectState(0L) : new ConnectState(this.delay));
            return nextState;
        }
    }

    public class ConnectedState
    extends State {
        private final Socket socket;

        public ConnectedState(Socket socket) {
            this.socket = socket;
        }

        @Override
        public State runState() {
            State nextState = null;
            ReachabilityMonitor reachabilityMonitor = new ReachabilityMonitor();
            KeepAliveMonitor keepAliveMonitor = new KeepAliveMonitor(this.socket, KEEP_ALIVE_INTERVAL);
            ReaderThread readerThread = new ReaderThread(this.socket);
            reachabilityMonitor.register();
            keepAliveMonitor.register();
            readerThread.start();
            while (nextState == null) {
                Set<Event> e = PushConnection.this.eventSet.await(Event.STOP, Event.CONNECTIVITY_CHANGED, Event.KEEP_ALIVE_ERROR, Event.READ_ERROR);
                if (e.contains((Object)Event.STOP)) {
                    nextState = new StoppedState();
                    continue;
                }
                if (!e.contains((Object)Event.READ_ERROR) && !e.contains((Object)Event.KEEP_ALIVE_ERROR) && !e.contains((Object)Event.CONNECTIVITY_CHANGED)) continue;
                nextState = new WaitRetryState(0L);
            }
            reachabilityMonitor.unregister();
            keepAliveMonitor.unregister();
            readerThread.stopReading();
            PushConnection.closeSocket(this.socket);
            PushConnection.this.eventSet.removeEvents(Event.CONNECTIVITY_CHANGED, Event.KEEP_ALIVE_ERROR, Event.READ_ERROR);
            return nextState;
        }
    }

    public class ConnectState
    extends State {
        private long lastDelay;

        public ConnectState(long lastDelay) {
            this.lastDelay = lastDelay;
        }

        @Override
        public State runState() {
            boolean connectedAndSentHandshake = false;
            Socket socket = null;
            Exception t = null;
            try {
                if (!"push.parse.com".equals(PushConnection.this.host)) {
                    socket = new Socket();
                } else {
                    SocketFactory sslSocketFactory = SSLSocketFactory.getDefault();
                    socket = sslSocketFactory.createSocket();
                }
                InetSocketAddress address = new InetSocketAddress(PushConnection.this.host, PushConnection.this.port);
                socket.connect(address, 40000);
                socket.setKeepAlive(true);
                socket.setTcpNoDelay(true);
                connectedAndSentHandshake = this.sendHandshake(socket);
            }
            catch (IOException e) {
                t = e;
            }
            catch (SecurityException e) {
                t = e;
            }
            if (t != null) {
                PLog.i(PushConnection.TAG, "Failed to connect to push server due to " + t);
            }
            if (!connectedAndSentHandshake) {
                PushConnection.closeSocket(socket);
                return new WaitRetryState(this.nextDelay());
            }
            return new ConnectedState(socket);
        }

        private boolean sendHandshake(Socket socket) {
            boolean success = false;
            Task<JSONObject> handshakeTask = PushRouter.getPushRequestJSONAsync();
            try {
                handshakeTask.waitForCompletion();
            }
            catch (InterruptedException e) {
                PLog.e(PushConnection.TAG, "Unexpected interruption when waiting for handshake to be sent", e);
            }
            JSONObject request = (JSONObject)handshakeTask.getResult();
            if (request != null) {
                success = PushConnection.writeLine(socket, request.toString());
            }
            return success;
        }

        private long nextDelay() {
            long delay = (long)((double)this.lastDelay * (1.5 + Math.random() * 0.5));
            delay = Math.min(Math.max(15000L, delay), 300000L);
            return delay;
        }
    }

    public class WaitStartState
    extends State {
        @Override
        public State runState() {
            State nextState = null;
            Set<Event> e = PushConnection.this.eventSet.await(Event.START, Event.STOP);
            if (e.contains((Object)Event.STOP)) {
                nextState = new StoppedState();
            } else if (e.contains((Object)Event.START)) {
                nextState = new ConnectState(0L);
            }
            return nextState;
        }
    }

    public abstract class State
    implements Runnable {
        @Override
        public void run() {
            State nextState = this.runState();
            PushConnection.dispatchOnStateChange(PushConnection.this, this, nextState);
            if (this.isTerminal()) {
                PLog.i(PushConnection.TAG, this + " finished and is the terminal state. Thread exiting.");
                PushConnection.this.executor.shutdown();
            } else if (nextState != null) {
                PLog.i(PushConnection.TAG, "PushConnection transitioning from " + this + " to " + nextState);
                PushConnection.this.executor.execute(nextState);
            } else {
                throw new NullPointerException(this + " tried to transition to null state.");
            }
        }

        public abstract State runState();

        public boolean isTerminal() {
            return false;
        }
    }

    private static enum Event {
        START,
        STOP,
        CONNECTIVITY_CHANGED,
        KEEP_ALIVE_ERROR,
        READ_ERROR;

    }

    public static interface StateTransitionListener {
        public void onStateChange(PushConnection var1, State var2, State var3);
    }
}

