/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.SSLSessionCache;
import com.parse.ParseHttpBody;
import com.parse.ParseHttpClient;
import com.parse.ParseHttpRequest;
import com.parse.ParseHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;

class ParseURLConnectionHttpClient
extends ParseHttpClient<HttpURLConnection, HttpURLConnection> {
    String userAgent;
    int socketOperationTimeout;
    SSLSessionCache sslSessionCache;

    public ParseURLConnectionHttpClient(String userAgent, int socketOperationTimeout, SSLSessionCache sslSessionCache) {
        this.userAgent = userAgent;
        this.socketOperationTimeout = socketOperationTimeout;
        this.sslSessionCache = sslSessionCache;
    }

    @Override
    public ParseHttpResponse execute(ParseHttpRequest parseRequest) throws IOException {
        HttpURLConnection connection = this.getRequest(parseRequest);
        ParseURLConnectionHttpClient.setParseRequestCancelRunnable(parseRequest, connection);
        return this.getResponse(connection);
    }

    @Override
    HttpURLConnection getRequest(ParseHttpRequest parseRequest) throws IOException {
        URL url = new URL(parseRequest.getUrl());
        Proxy proxy = null;
        String host = System.getProperty("http.proxyHost");
        String portString = System.getProperty("http.proxyPort");
        if (host != null && host.length() != 0 && portString != null && portString.length() != 0) {
            int port = Integer.parseInt(portString);
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        }
        HttpURLConnection connection = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(parseRequest.getMethod().toString());
        connection.setConnectTimeout(this.socketOperationTimeout);
        connection.setReadTimeout(this.socketOperationTimeout);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        for (Map.Entry<String, String> entry : parseRequest.getAllHeaders().entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        connection.setRequestProperty("User-Agent", this.userAgent);
        ParseHttpBody body = parseRequest.getBody();
        if (body != null) {
            connection.setRequestProperty("Content-Length", String.valueOf(body.getContentLength()));
            connection.setRequestProperty("Content-Type", body.getContentType());
            connection.setFixedLengthStreamingMode(body.getContentLength());
            connection.setDoOutput(true);
            body.writeTo(connection.getOutputStream());
        }
        return connection;
    }

    private static void setParseRequestCancelRunnable(ParseHttpRequest parseRequest, final HttpURLConnection connection) {
        parseRequest.setCancelRunnable(new Runnable(){

            @Override
            public void run() {
                connection.disconnect();
            }
        });
    }

    @Override
    ParseHttpResponse getResponse(HttpURLConnection connection) throws IOException {
        int statusCode = connection.getResponseCode();
        InputStream content = statusCode < 400 ? connection.getInputStream() : connection.getErrorStream();
        int totalSize = connection.getContentLength();
        String reasonPhrase = connection.getResponseMessage();
        return new ParseHttpResponse(statusCode, content, totalSize, reasonPhrase);
    }
}

