/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.SSLSessionCache;
import android.os.Build;
import bolts.Continuation;
import bolts.Task;
import com.parse.PLog;
import com.parse.ParseException;
import com.parse.ParseExecutors;
import com.parse.ParseHttpBody;
import com.parse.ParseHttpClient;
import com.parse.ParseHttpRequest;
import com.parse.ParseHttpResponse;
import com.parse.ProgressCallback;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.client.ClientProtocolException;

abstract class ParseRequest<Response, Result> {
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ParseRequest.NETWORK_EXECUTOR-thread-" + this.mCount.getAndIncrement());
        }
    };
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int MAX_POOL_SIZE = CPU_COUNT * 2 * 2 + 1;
    private static final long KEEP_ALIVE_TIME = 1L;
    private static final int MAX_QUEUE_SIZE = 128;
    static final ExecutorService NETWORK_EXECUTOR = ParseRequest.newThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), sThreadFactory);
    protected static final int DEFAULT_MAX_RETRIES = 4;
    static final long DEFAULT_INITIAL_RETRY_DELAY = 1000L;
    private static ParseHttpClient defaultClient = null;
    private static long defaultInitialRetryDelay = 1000L;
    private ParseHttpClient client;
    private ParseHttpRequest request;
    protected int maxRetries = 4;
    protected Method method;
    protected String url;
    private AtomicReference<Task.TaskCompletionSource> currentTask = new AtomicReference();

    private static ThreadPoolExecutor newThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, workQueue, threadFactory);
        if (Build.VERSION.SDK_INT >= 9) {
            executor.allowCoreThreadTimeOut(true);
        }
        return executor;
    }

    public static void setDefaultClient(ParseHttpClient client) {
        defaultClient = client;
    }

    public static ParseHttpClient getDefaultClient() {
        if (defaultClient == null) {
            throw new IllegalStateException("Can't send Parse HTTPS request before Parse.initialize()");
        }
        return defaultClient;
    }

    public static void setDefaultInitialRetryDelay(long delay) {
        defaultInitialRetryDelay = delay;
    }

    public static long getDefaultInitialRetryDelay() {
        return defaultInitialRetryDelay;
    }

    public static void initialize(Context context) {
        if (defaultClient == null) {
            String userAgent = ParseRequest.getUserAgent(context);
            SSLSessionCache sslSessionCache = new SSLSessionCache(context);
            int socketOperationTimeout = 10000;
            ParseHttpClient.setKeepAlive(true);
            ParseHttpClient.setMaxConnections(20);
            defaultClient = ParseHttpClient.createClient(socketOperationTimeout, userAgent, sslSessionCache);
        }
    }

    public ParseRequest(String url) {
        this(Method.GET, url);
    }

    public ParseRequest(Method method, String url) {
        this.client = defaultClient;
        this.method = method;
        this.url = url;
    }

    public void setClient(ParseHttpClient client) {
        this.client = client;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMaxRetries(int max) {
        this.maxRetries = max;
    }

    protected Task<Void> onPreExecute(Task<Void> task) {
        return task;
    }

    protected ParseHttpBody newBody(ProgressCallback uploadProgressCallback) {
        return null;
    }

    protected ParseHttpRequest newRequest(Method method, ProgressCallback uploadProgressCallback) throws ParseException {
        ParseHttpRequest.Builder requestBuilder = new ParseHttpRequest.Builder();
        requestBuilder.setUrl(this.url).setMethod(method);
        switch (method) {
            case GET: 
            case DELETE: {
                break;
            }
            case POST: 
            case PUT: {
                requestBuilder.setBody(this.newBody(uploadProgressCallback));
                break;
            }
            default: {
                throw new IllegalStateException("Invalid method " + (Object)((Object)method));
            }
        }
        return requestBuilder.build();
    }

    protected Task<Result> onPostExecute(Task<Response> task) throws ParseException {
        return task.cast();
    }

    private Task<Response> sendOneRequestAsync(final ProgressCallback downloadProgressCallback) {
        if (this.currentTask.get().getTask().isCancelled()) {
            return Task.cancelled();
        }
        return Task.forResult(null).onSuccessTask(new Continuation<Void, Task<Response>>(){

            public Task<Response> then(Task<Void> task) throws Exception {
                ParseHttpResponse response = ParseRequest.this.client.execute(ParseRequest.this.request);
                return ParseRequest.this.onResponse(response, downloadProgressCallback);
            }
        }, (Executor)NETWORK_EXECUTOR).continueWithTask(new Continuation<Response, Task<Response>>(){

            public Task<Response> then(Task<Response> task) throws Exception {
                if (task.isFaulted()) {
                    Exception error = task.getError();
                    if (error instanceof ClientProtocolException) {
                        return Task.forError((Exception)ParseRequest.this.newTemporaryException("bad protocol", error));
                    }
                    if (error instanceof IOException) {
                        return Task.forError((Exception)ParseRequest.this.newTemporaryException("i/o failure", error));
                    }
                }
                return task;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    protected abstract Task<Response> onResponse(ParseHttpResponse var1, ProgressCallback var2);

    public Task<Result> executeAsync() {
        return this.executeAsync(null, null);
    }

    public Task<Result> executeAsync(final ProgressCallback uploadProgressCallback, final ProgressCallback downloadProgressCallback) {
        final Task.TaskCompletionSource tcs = Task.create();
        this.currentTask.set(tcs);
        Task.forResult(null).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseRequest.this.onPreExecute(task);
            }
        }).onSuccessTask(new Continuation<Void, Task<Response>>(){

            public Task<Response> then(Task<Void> task) throws Exception {
                long delay = defaultInitialRetryDelay + (long)((double)defaultInitialRetryDelay * Math.random());
                if (ParseRequest.this.request == null) {
                    ParseRequest.this.request = ParseRequest.this.newRequest(ParseRequest.this.method, uploadProgressCallback);
                }
                return ParseRequest.this.executeAsync(0, delay, downloadProgressCallback);
            }
        }).onSuccessTask(new Continuation<Response, Task<Result>>(){

            public Task<Result> then(Task<Response> task) throws Exception {
                return ParseRequest.this.onPostExecute(task);
            }
        }).continueWithTask(new Continuation<Result, Task<Void>>(){

            public Task<Void> then(Task<Result> task) throws Exception {
                if (task.isCancelled()) {
                    tcs.trySetCancelled();
                } else if (task.isFaulted()) {
                    tcs.trySetError(task.getError());
                } else {
                    tcs.trySetResult(task.getResult());
                }
                return null;
            }
        });
        return tcs.getTask();
    }

    private Task<Response> executeAsync(final int attemptsMade, final long delay, final ProgressCallback downloadProgressCallback) {
        return this.sendOneRequestAsync(downloadProgressCallback).continueWithTask(new Continuation<Response, Task<Response>>(){

            public Task<Response> then(Task<Response> task) throws Exception {
                Exception e = task.getError();
                if (task.isFaulted() && e instanceof ParseException) {
                    if (((Task.TaskCompletionSource)ParseRequest.this.currentTask.get()).getTask().isCancelled()) {
                        return Task.cancelled();
                    }
                    if (e instanceof ParseRequestException && ((ParseRequestException)e).isPermanentFailure) {
                        return task;
                    }
                    if (attemptsMade < ParseRequest.this.maxRetries) {
                        PLog.i("com.parse.ParseRequest", "Request failed. Waiting " + delay + " milliseconds before attempt #" + (attemptsMade + 1));
                        final Task.TaskCompletionSource retryTask = Task.create();
                        ParseExecutors.scheduled().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ParseRequest.this.executeAsync(attemptsMade + 1, delay * 2L, downloadProgressCallback).continueWithTask(new Continuation<Response, Task<Void>>(){

                                    public Task<Void> then(Task<Response> task) throws Exception {
                                        if (task.isCancelled()) {
                                            retryTask.setCancelled();
                                        } else if (task.isFaulted()) {
                                            retryTask.setError(task.getError());
                                        } else {
                                            retryTask.setResult(task.getResult());
                                        }
                                        return null;
                                    }
                                });
                            }
                        }, delay, TimeUnit.MILLISECONDS);
                        return retryTask.getTask();
                    }
                    if (!ParseRequest.this.request.isCancelled()) {
                        PLog.i("com.parse.ParseRequest", "Request failed. Giving up.");
                    }
                }
                return task;
            }
        });
    }

    public void cancel() {
        Task.TaskCompletionSource curr = this.currentTask.get();
        if (curr != null) {
            curr.trySetCancelled();
        }
        if (this.request != null) {
            this.request.cancel();
        }
    }

    protected ParseException newPermanentException(int code, String message) {
        ParseRequestException e = new ParseRequestException(code, message);
        e.isPermanentFailure = true;
        return e;
    }

    protected ParseException newTemporaryException(int code, String message) {
        ParseRequestException e = new ParseRequestException(code, message);
        e.isPermanentFailure = false;
        return e;
    }

    protected ParseException newTemporaryException(String message, Throwable t) {
        ParseRequestException e = new ParseRequestException(100, message, t);
        e.isPermanentFailure = false;
        return e;
    }

    private static String getUserAgent(Context context) {
        String packageVersion = "unknown";
        try {
            String packageName = context.getPackageName();
            int versionCode = context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
            packageVersion = packageName + "/" + versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return "Parse Android SDK 1.9.2 (" + packageVersion + ") API Level " + Build.VERSION.SDK_INT;
    }

    private static class ParseRequestException
    extends ParseException {
        boolean isPermanentFailure = false;

        public ParseRequestException(int theCode, String theMessage) {
            super(theCode, theMessage);
        }

        public ParseRequestException(int theCode, String message, Throwable cause) {
            super(theCode, message, cause);
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;


        public static Method fromString(String string) {
            Method method = null;
            switch (string) {
                case "GET": {
                    method = GET;
                    break;
                }
                case "POST": {
                    method = POST;
                    break;
                }
                case "PUT": {
                    method = PUT;
                    break;
                }
                case "DELETE": {
                    method = DELETE;
                    break;
                }
            }
            return method;
        }

        public String toString() {
            String string = null;
            switch (this) {
                case GET: {
                    string = "GET";
                    break;
                }
                case POST: {
                    string = "POST";
                    break;
                }
                case PUT: {
                    string = "PUT";
                    break;
                }
                case DELETE: {
                    string = "DELETE";
                    break;
                }
            }
            return string;
        }
    }
}

