/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.ParseHttpRequest;
import com.parse.ParseHttpResponse;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import com.parse.ProgressCallback;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class ParseRESTUserCommand
extends ParseRESTCommand {
    private static final String HEADER_REVOCABLE_SESSION = "X-Parse-Revocable-Session";
    private static final String HEADER_TRUE = "1";
    private boolean isRevocableSessionEnabled;
    private int statusCode;

    public static ParseRESTUserCommand getCurrentUserCommand(String sessionToken) {
        return new ParseRESTUserCommand("users/me", ParseRequest.Method.GET, (Map)null, sessionToken);
    }

    public static ParseRESTUserCommand signUpUserCommand(JSONObject parameters, String sessionToken, boolean revocableSession) {
        return new ParseRESTUserCommand("classes/_User", ParseRequest.Method.POST, parameters, sessionToken, revocableSession);
    }

    public static ParseRESTUserCommand logInUserCommand(String username, String password, boolean revocableSession) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("username", username);
        parameters.put("password", password);
        return new ParseRESTUserCommand("login", ParseRequest.Method.GET, parameters, null, revocableSession);
    }

    public static ParseRESTUserCommand serviceLogInUserCommand(String authType, JSONObject authData, boolean revocableSession) throws JSONException {
        JSONObject authenticationData = new JSONObject();
        authenticationData.put(authType, (Object)authData);
        JSONObject parameters = new JSONObject();
        parameters.put("authData", (Object)authenticationData);
        return ParseRESTUserCommand.serviceLogInUserCommand(parameters, null, revocableSession);
    }

    public static ParseRESTUserCommand serviceLogInUserCommand(JSONObject parameters, String sessionToken, boolean revocableSession) {
        return new ParseRESTUserCommand("users", ParseRequest.Method.POST, parameters, sessionToken, revocableSession);
    }

    public static ParseRESTUserCommand resetUserPasswordCommand(String email) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("email", email);
        return new ParseRESTUserCommand("requestPasswordReset", ParseRequest.Method.POST, parameters, null);
    }

    public static ParseRESTUserCommand upgradeRevocableSessionCommand(String sessionToken) {
        return new ParseRESTUserCommand("upgradeToRevocableSession", ParseRequest.Method.POST, new JSONObject(), sessionToken);
    }

    public static ParseRESTUserCommand logOutUserCommand(String sessionToken) {
        return new ParseRESTUserCommand("logout", ParseRequest.Method.POST, new JSONObject(), sessionToken);
    }

    private ParseRESTUserCommand(String httpPath, ParseRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        this(httpPath, httpMethod, parameters, sessionToken, false);
    }

    private ParseRESTUserCommand(String httpPath, ParseRequest.Method httpMethod, JSONObject parameters, String sessionToken) {
        this(httpPath, httpMethod, parameters, sessionToken, false);
    }

    private ParseRESTUserCommand(String httpPath, ParseRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken, boolean isRevocableSessionEnabled) {
        super(httpPath, httpMethod, parameters, sessionToken);
        this.isRevocableSessionEnabled = isRevocableSessionEnabled;
    }

    private ParseRESTUserCommand(String httpPath, ParseRequest.Method httpMethod, JSONObject parameters, String sessionToken, boolean isRevocableSessionEnabled) {
        super(httpPath, httpMethod, parameters, sessionToken);
        this.isRevocableSessionEnabled = isRevocableSessionEnabled;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    protected void addAdditionalHeaders(ParseHttpRequest.Builder requestBuilder) {
        super.addAdditionalHeaders(requestBuilder);
        if (this.isRevocableSessionEnabled) {
            requestBuilder.addHeader(HEADER_REVOCABLE_SESSION, HEADER_TRUE);
        }
    }

    @Override
    protected Task<JSONObject> onResponse(ParseHttpResponse response, ProgressCallback progressCallback) {
        this.statusCode = response.getStatusCode();
        return super.onResponse(response, progressCallback);
    }
}

