/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseByteArrayHttpBody;
import com.parse.ParseCallback2;
import com.parse.ParseCountingByteArrayHttpBody;
import com.parse.ParseException;
import com.parse.ParseHttpBody;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import com.parse.ProgressCallback;
import java.util.Map;

class ParseRESTFileCommand
extends ParseRESTCommand {
    private byte[] data = null;
    private String contentType = null;

    public ParseRESTFileCommand(String httpPath, ParseRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    public static ParseRESTFileCommand uploadFileCommand(String fileName, byte[] data, String contentType, String sessionToken) {
        String httpPath = String.format("files/%s", fileName);
        ParseRESTFileCommand command = new ParseRESTFileCommand(httpPath, ParseRequest.Method.POST, null, sessionToken);
        command.data = data;
        command.contentType = contentType;
        return command;
    }

    @Override
    protected ParseHttpBody newBody(final ProgressCallback originalProgressCallback) {
        if (originalProgressCallback == null) {
            return new ParseByteArrayHttpBody(this.data, this.contentType);
        }
        ParseCallback2<Integer, ParseException> progressCallback = new ParseCallback2<Integer, ParseException>(){
            Integer maxProgressSoFar = 0;

            @Override
            public void done(Integer percentDone, ParseException e) {
                if (percentDone > this.maxProgressSoFar) {
                    this.maxProgressSoFar = percentDone;
                    originalProgressCallback.done(percentDone);
                }
            }
        };
        return new ParseCountingByteArrayHttpBody(this.data, this.contentType, progressCallback);
    }
}

