/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.CountCallback;
import com.parse.FindCallback;
import com.parse.GetCallback;
import com.parse.Parse;
import com.parse.ParseCallback2;
import com.parse.ParseDefaultQueryController;
import com.parse.ParseEncoder;
import com.parse.ParseException;
import com.parse.ParseGeoPoint;
import com.parse.ParseKeyValueCache;
import com.parse.ParseObject;
import com.parse.ParseQueryController;
import com.parse.ParseRESTQueryCommand;
import com.parse.ParseRelation;
import com.parse.ParseTaskUtils;
import com.parse.ParseTextUtils;
import com.parse.ParseUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseQuery<T extends ParseObject> {
    private static ParseQueryController controller;
    private final State.Builder<T> builder;
    private ParseUser user;
    private final Object lock = new Object();
    private boolean isRunning = false;
    private Task.TaskCompletionSource cts;

    private static ParseQueryController getQueryController() {
        if (controller == null) {
            controller = new ParseDefaultQueryController();
        }
        return controller;
    }

    static void setParseQueryQueryController(ParseQueryController controller) {
        ParseQuery.controller = controller;
    }

    public static <T extends ParseObject> ParseQuery<T> or(List<ParseQuery<T>> queries) {
        if (queries.isEmpty()) {
            throw new IllegalArgumentException("Can't take an or of an empty list of queries");
        }
        ArrayList builders = new ArrayList();
        for (ParseQuery<T> query : queries) {
            builders.add(query.getBuilder());
        }
        return new ParseQuery(State.Builder.or(builders));
    }

    public static <T extends ParseObject> ParseQuery<T> getQuery(Class<T> subclass) {
        return new ParseQuery<T>(subclass);
    }

    public static <T extends ParseObject> ParseQuery<T> getQuery(String className) {
        return new ParseQuery<T>(className);
    }

    @Deprecated
    public static ParseQuery<ParseUser> getUserQuery() {
        return ParseUser.getQuery();
    }

    private static void throwIfLDSEnabled() {
        ParseQuery.throwIfLDSEnabled(false);
    }

    private static void throwIfLDSDisabled() {
        ParseQuery.throwIfLDSEnabled(true);
    }

    private static void throwIfLDSEnabled(boolean enabled) {
        boolean ldsEnabled = Parse.isLocalDatastoreEnabled();
        if (enabled && !ldsEnabled) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Parse#enableLocalDatastore(Context)`.");
        }
        if (!enabled && ldsEnabled) {
            throw new IllegalStateException("Unsupported method when Local Datastore is enabled.");
        }
    }

    public ParseQuery(Class<T> subclass) {
        this(ParseObject.getClassName(subclass));
    }

    public ParseQuery(String theClassName) {
        this(new State.Builder(theClassName));
    }

    ParseQuery(State.Builder<T> builder) {
        this.builder = builder;
    }

    State.Builder<T> getBuilder() {
        return this.builder;
    }

    void setUser(ParseUser user) {
        this.user = user;
    }

    Task<ParseUser> getUserAsync(State<T> state) {
        if (state.ignoreACLs()) {
            return Task.forResult(null);
        }
        if (this.user != null) {
            return Task.forResult((Object)this.user);
        }
        return ParseUser.getCurrentUserAsync();
    }

    private void checkIfRunning() {
        this.checkIfRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfRunning(boolean grabLock) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning) {
                throw new RuntimeException("This query has an outstanding network connection. You have to wait until it's done.");
            }
            if (grabLock) {
                this.isRunning = true;
                this.cts = Task.create();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cts != null) {
                this.cts.trySetCancelled();
                this.cts = null;
            }
            this.isRunning = false;
        }
    }

    public List<T> find() throws ParseException {
        return ParseTaskUtils.wait(this.findInBackground());
    }

    public T getFirst() throws ParseException {
        return (T)((ParseObject)ParseTaskUtils.wait(this.getFirstInBackground()));
    }

    public ParseQuery<T> setCachePolicy(CachePolicy newCachePolicy) {
        this.checkIfRunning();
        this.builder.setCachePolicy(newCachePolicy);
        return this;
    }

    public CachePolicy getCachePolicy() {
        return this.builder.getCachePolicy();
    }

    ParseQuery<T> fromNetwork() {
        this.checkIfRunning();
        this.builder.fromNetwork();
        return this;
    }

    boolean isFromNetwork() {
        return this.builder.isFromNetwork();
    }

    public ParseQuery<T> fromLocalDatastore() {
        this.builder.fromLocalDatastore();
        return this;
    }

    public ParseQuery<T> fromPin() {
        this.checkIfRunning();
        this.builder.fromPin();
        return this;
    }

    public ParseQuery<T> fromPin(String name) {
        this.checkIfRunning();
        this.builder.fromPin(name);
        return this;
    }

    public ParseQuery<T> ignoreACLs() {
        this.checkIfRunning();
        this.builder.ignoreACLs();
        return this;
    }

    public ParseQuery<T> setMaxCacheAge(long maxAgeInMilliseconds) {
        this.checkIfRunning();
        this.builder.setMaxCacheAge(maxAgeInMilliseconds);
        return this;
    }

    public long getMaxCacheAge() {
        return this.builder.getMaxCacheAge();
    }

    private <TResult> Task<TResult> doWithRunningCheck(Callable<Task<TResult>> runnable) {
        Task task;
        this.checkIfRunning(true);
        try {
            task = runnable.call();
        }
        catch (Exception e) {
            task = Task.forError((Exception)e);
        }
        return task.continueWithTask(new Continuation<TResult, Task<TResult>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<TResult> then(Task<TResult> task) throws Exception {
                Object object = ParseQuery.this.lock;
                synchronized (object) {
                    ParseQuery.this.isRunning = false;
                    if (ParseQuery.this.cts != null) {
                        ParseQuery.this.cts.trySetResult(null);
                    }
                    ParseQuery.this.cts = null;
                }
                return task;
            }
        });
    }

    public Task<List<T>> findInBackground() {
        final State<T> state = this.builder.build();
        return this.doWithRunningCheck(new Callable<Task<List<T>>>(){

            @Override
            public Task<List<T>> call() throws Exception {
                return ParseQuery.this.getUserAsync(state).onSuccessTask(new Continuation<ParseUser, Task<List<T>>>(){

                    public Task<List<T>> then(Task<ParseUser> task) throws Exception {
                        ParseUser user = (ParseUser)task.getResult();
                        return ParseQuery.this.findAsync(state, user, (Task<Void>)ParseQuery.this.cts.getTask());
                    }
                });
            }
        });
    }

    public void findInBackground(final FindCallback<T> callback) {
        final State<T> state = this.builder.build();
        Task task = this.doWithRunningCheck(new Callable<Task<List<T>>>(){

            @Override
            public Task<List<T>> call() throws Exception {
                return ParseQuery.this.getUserAsync(state).onSuccessTask(new Continuation<ParseUser, Task<List<T>>>(){

                    public Task<List<T>> then(Task<ParseUser> task) throws Exception {
                        final ParseUser user = (ParseUser)task.getResult();
                        if (state.cachePolicy() != CachePolicy.CACHE_THEN_NETWORK || state.isFromLocalDatastore()) {
                            return ParseQuery.this.findAsync(state, user, (Task<Void>)ParseQuery.this.cts.getTask());
                        }
                        State cacheState = new State.Builder(state).setCachePolicy(CachePolicy.CACHE_ONLY).build();
                        final State networkState = new State.Builder(state).setCachePolicy(CachePolicy.NETWORK_ONLY).build();
                        Task findTask = ParseQuery.this.findAsync(cacheState, user, (Task<Void>)ParseQuery.this.cts.getTask());
                        findTask = ParseTaskUtils.callbackOnMainThreadAsync(findTask, callback);
                        return findTask.continueWithTask(new Continuation<List<T>, Task<List<T>>>(){

                            public Task<List<T>> then(Task<List<T>> task) throws Exception {
                                if (task.isCancelled()) {
                                    return task;
                                }
                                return ParseQuery.this.findAsync(networkState, user, (Task<Void>)ParseQuery.this.cts.getTask());
                            }
                        });
                    }
                });
            }
        });
        ParseTaskUtils.callbackOnMainThreadAsync(task, callback);
    }

    Task<List<T>> findAsync(State<T> state, ParseUser user, Task<Void> cancellationToken) {
        return ParseQuery.getQueryController().findAsync(state, user, cancellationToken);
    }

    public Task<T> getFirstInBackground() {
        final State<T> state = this.builder.setLimit(1).build();
        return this.doWithRunningCheck(new Callable<Task<T>>(){

            @Override
            public Task<T> call() throws Exception {
                return ParseQuery.this.getUserAsync(state).onSuccessTask(new Continuation<ParseUser, Task<T>>(){

                    public Task<T> then(Task<ParseUser> task) throws Exception {
                        ParseUser user = (ParseUser)task.getResult();
                        return ParseQuery.this.getFirstAsync(state, user, (Task<Void>)ParseQuery.this.cts.getTask());
                    }
                });
            }
        });
    }

    public void getFirstInBackground(final GetCallback<T> callback) {
        final State<T> state = this.builder.setLimit(1).build();
        Task task = this.doWithRunningCheck(new Callable<Task<T>>(){

            @Override
            public Task<T> call() throws Exception {
                return ParseQuery.this.getUserAsync(state).onSuccessTask(new Continuation<ParseUser, Task<T>>(){

                    public Task<T> then(Task<ParseUser> task) throws Exception {
                        final ParseUser user = (ParseUser)task.getResult();
                        if (state.cachePolicy() != CachePolicy.CACHE_THEN_NETWORK || state.isFromLocalDatastore()) {
                            return ParseQuery.this.getFirstAsync(state, user, (Task<Void>)ParseQuery.this.cts.getTask());
                        }
                        State cacheState = new State.Builder(state).setCachePolicy(CachePolicy.CACHE_ONLY).build();
                        final State networkState = new State.Builder(state).setCachePolicy(CachePolicy.NETWORK_ONLY).build();
                        Task findTask = ParseQuery.this.getFirstAsync(cacheState, user, (Task<Void>)ParseQuery.this.cts.getTask());
                        return ParseTaskUtils.callbackOnMainThreadAsync(findTask, callback).continueWithTask(new Continuation<T, Task<T>>(){

                            public Task<T> then(Task<T> task) throws Exception {
                                if (task.isCancelled()) {
                                    return task;
                                }
                                return ParseQuery.this.getFirstAsync(networkState, user, (Task<Void>)ParseQuery.this.cts.getTask());
                            }
                        });
                    }
                });
            }
        });
        ParseTaskUtils.callbackOnMainThreadAsync(task, callback);
    }

    private Task<T> getFirstAsync(State<T> state, ParseUser user, Task<Void> cancellationToken) {
        return ParseQuery.getQueryController().getFirstAsync(state, user, cancellationToken);
    }

    public int count() throws ParseException {
        return ParseTaskUtils.wait(this.countInBackground());
    }

    public Task<Integer> countInBackground() {
        final State<T> state = this.builder.build();
        return this.doWithRunningCheck(new Callable<Task<Integer>>(){

            @Override
            public Task<Integer> call() throws Exception {
                return ParseQuery.this.getUserAsync(state).onSuccessTask((Continuation)new Continuation<ParseUser, Task<Integer>>(){

                    public Task<Integer> then(Task<ParseUser> task) throws Exception {
                        ParseUser user = (ParseUser)task.getResult();
                        return ParseQuery.this.countAsync(state, user, (Task<Void>)ParseQuery.this.cts.getTask());
                    }
                });
            }
        });
    }

    public void countInBackground(final CountCallback callback) {
        final State<T> state = this.builder.build();
        final ParseCallback2<Integer, ParseException> c = callback != null ? new ParseCallback2<Integer, ParseException>(){

            @Override
            public void done(Integer integer, ParseException e) {
                callback.done(e == null ? integer : -1, e);
            }
        } : null;
        Task<Integer> task = this.doWithRunningCheck(new Callable<Task<Integer>>(){

            @Override
            public Task<Integer> call() throws Exception {
                return ParseQuery.this.getUserAsync(state).onSuccessTask((Continuation)new Continuation<ParseUser, Task<Integer>>(){

                    public Task<Integer> then(Task<ParseUser> task) throws Exception {
                        final ParseUser user = (ParseUser)task.getResult();
                        if (state.cachePolicy() != CachePolicy.CACHE_THEN_NETWORK || state.isFromLocalDatastore()) {
                            return ParseQuery.this.countAsync(state, user, (Task<Void>)ParseQuery.this.cts.getTask());
                        }
                        State cacheState = new State.Builder(state).setCachePolicy(CachePolicy.CACHE_ONLY).build();
                        final State networkState = new State.Builder(state).setCachePolicy(CachePolicy.NETWORK_ONLY).build();
                        Task countTask = ParseQuery.this.countAsync(cacheState, user, (Task<Void>)ParseQuery.this.cts.getTask());
                        return ParseTaskUtils.callbackOnMainThreadAsync(countTask, c).continueWithTask((Continuation)new Continuation<Integer, Task<Integer>>(){

                            public Task<Integer> then(Task<Integer> task) throws Exception {
                                if (task.isCancelled()) {
                                    return task;
                                }
                                return ParseQuery.this.countAsync(networkState, user, (Task<Void>)ParseQuery.this.cts.getTask());
                            }
                        });
                    }
                });
            }
        });
        ParseTaskUtils.callbackOnMainThreadAsync(task, c);
    }

    private Task<Integer> countAsync(State<T> state, ParseUser user, Task<Void> cancellationToken) {
        return ParseQuery.getQueryController().countAsync(state, user, cancellationToken);
    }

    public T get(String objectId) throws ParseException {
        return (T)((ParseObject)ParseTaskUtils.wait(this.getInBackground(objectId)));
    }

    public boolean hasCachedResult() {
        ParseQuery.throwIfLDSEnabled();
        State<T> state = this.builder.build();
        ParseUser user = null;
        try {
            user = ParseTaskUtils.wait(this.getUserAsync(state));
        }
        catch (ParseException e) {
            // empty catch block
        }
        String sessionToken = user != null ? user.getSessionToken() : null;
        String raw = ParseKeyValueCache.loadFromKeyValueCache(ParseRESTQueryCommand.findCommand(state, sessionToken).getCacheKey(), state.maxCacheAge());
        return raw != null;
    }

    public void clearCachedResult() {
        ParseQuery.throwIfLDSEnabled();
        State<T> state = this.builder.build();
        ParseUser user = null;
        try {
            user = ParseTaskUtils.wait(this.getUserAsync(state));
        }
        catch (ParseException e) {
            // empty catch block
        }
        String sessionToken = user != null ? user.getSessionToken() : null;
        ParseKeyValueCache.clearFromKeyValueCache(ParseRESTQueryCommand.findCommand(state, sessionToken).getCacheKey());
    }

    public static void clearAllCachedResults() {
        ParseQuery.throwIfLDSEnabled();
        ParseKeyValueCache.clearKeyValueCacheDir();
    }

    public Task<T> getInBackground(String objectId) {
        final State<T> state = this.builder.setSkip(-1).whereObjectIdEquals(objectId).build();
        return this.doWithRunningCheck(new Callable<Task<T>>(){

            @Override
            public Task<T> call() throws Exception {
                return ParseQuery.this.getUserAsync(state).continueWithTask(new Continuation<ParseUser, Task<T>>(){

                    public Task<T> then(Task<ParseUser> task) throws Exception {
                        ParseUser user = (ParseUser)task.getResult();
                        return ParseQuery.this.getFirstAsync(state, user, (Task<Void>)ParseQuery.this.cts.getTask());
                    }
                });
            }
        });
    }

    public void getInBackground(String objectId, final GetCallback<T> callback) {
        final State<T> state = this.builder.setSkip(-1).whereObjectIdEquals(objectId).build();
        Task task = this.doWithRunningCheck(new Callable<Task<T>>(){

            @Override
            public Task<T> call() throws Exception {
                return ParseQuery.this.getUserAsync(state).onSuccessTask(new Continuation<ParseUser, Task<T>>(){

                    public Task<T> then(Task<ParseUser> task) throws Exception {
                        final ParseUser user = (ParseUser)task.getResult();
                        if (state.cachePolicy() != CachePolicy.CACHE_THEN_NETWORK || state.isFromLocalDatastore()) {
                            return ParseQuery.this.getFirstAsync(state, user, (Task<Void>)ParseQuery.this.cts.getTask());
                        }
                        State cacheState = new State.Builder(state).setCachePolicy(CachePolicy.CACHE_ONLY).build();
                        final State networkState = new State.Builder(state).setCachePolicy(CachePolicy.NETWORK_ONLY).build();
                        Task getTask = ParseQuery.this.getFirstAsync(cacheState, user, (Task<Void>)ParseQuery.this.cts.getTask());
                        return ParseTaskUtils.callbackOnMainThreadAsync(getTask, callback).continueWithTask(new Continuation<T, Task<T>>(){

                            public Task<T> then(Task<T> task) throws Exception {
                                if (task.isCancelled()) {
                                    return task;
                                }
                                return ParseQuery.this.getFirstAsync(networkState, user, (Task<Void>)ParseQuery.this.cts.getTask());
                            }
                        });
                    }
                });
            }
        });
        ParseTaskUtils.callbackOnMainThreadAsync(task, callback);
    }

    public ParseQuery<T> whereEqualTo(String key, Object value) {
        this.checkIfRunning();
        this.builder.whereEqualTo(key, value);
        return this;
    }

    public ParseQuery<T> whereLessThan(String key, Object value) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$lt", value);
        return this;
    }

    public ParseQuery<T> whereNotEqualTo(String key, Object value) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$ne", value);
        return this;
    }

    public ParseQuery<T> whereGreaterThan(String key, Object value) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$gt", value);
        return this;
    }

    public ParseQuery<T> whereLessThanOrEqualTo(String key, Object value) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$lte", value);
        return this;
    }

    public ParseQuery<T> whereGreaterThanOrEqualTo(String key, Object value) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$gte", value);
        return this;
    }

    public ParseQuery<T> whereContainedIn(String key, Collection<? extends Object> values) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$in", values);
        return this;
    }

    public ParseQuery<T> whereContainsAll(String key, Collection<?> values) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$all", values);
        return this;
    }

    public ParseQuery<T> whereMatchesQuery(String key, ParseQuery<?> query) {
        this.checkIfRunning();
        this.builder.whereMatchesQuery(key, query.getBuilder());
        return this;
    }

    public ParseQuery<T> whereDoesNotMatchQuery(String key, ParseQuery<?> query) {
        this.checkIfRunning();
        this.builder.whereDoesNotMatchQuery(key, query.getBuilder());
        return this;
    }

    public ParseQuery<T> whereMatchesKeyInQuery(String key, String keyInQuery, ParseQuery<?> query) {
        this.checkIfRunning();
        this.builder.whereMatchesKeyInQuery(key, keyInQuery, query.getBuilder());
        return this;
    }

    public ParseQuery<T> whereDoesNotMatchKeyInQuery(String key, String keyInQuery, ParseQuery<?> query) {
        this.checkIfRunning();
        this.builder.whereDoesNotMatchKeyInQuery(key, keyInQuery, query.getBuilder());
        return this;
    }

    public ParseQuery<T> whereNotContainedIn(String key, Collection<? extends Object> values) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$nin", values);
        return this;
    }

    public ParseQuery<T> whereNear(String key, ParseGeoPoint point) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$nearSphere", point);
        return this;
    }

    public ParseQuery<T> whereWithinMiles(String key, ParseGeoPoint point, double maxDistance) {
        this.checkIfRunning();
        return this.whereWithinRadians(key, point, maxDistance / ParseGeoPoint.EARTH_MEAN_RADIUS_MILE);
    }

    public ParseQuery<T> whereWithinKilometers(String key, ParseGeoPoint point, double maxDistance) {
        this.checkIfRunning();
        return this.whereWithinRadians(key, point, maxDistance / ParseGeoPoint.EARTH_MEAN_RADIUS_KM);
    }

    public ParseQuery<T> whereWithinRadians(String key, ParseGeoPoint point, double maxDistance) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$nearSphere", point).addCondition(key, "$maxDistance", maxDistance);
        return this;
    }

    public ParseQuery<T> whereWithinGeoBox(String key, ParseGeoPoint southwest, ParseGeoPoint northeast) {
        this.checkIfRunning();
        ArrayList<ParseGeoPoint> array = new ArrayList<ParseGeoPoint>();
        array.add(southwest);
        array.add(northeast);
        HashMap<String, ArrayList<ParseGeoPoint>> dictionary = new HashMap<String, ArrayList<ParseGeoPoint>>();
        dictionary.put("$box", array);
        this.builder.addCondition(key, "$within", dictionary);
        return this;
    }

    public ParseQuery<T> whereMatches(String key, String regex) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$regex", regex);
        return this;
    }

    public ParseQuery<T> whereMatches(String key, String regex, String modifiers) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$regex", regex);
        if (modifiers.length() != 0) {
            this.builder.addCondition(key, "$options", modifiers);
        }
        return this;
    }

    public ParseQuery<T> whereContains(String key, String substring) {
        String regex = Pattern.quote(substring);
        this.whereMatches(key, regex);
        return this;
    }

    public ParseQuery<T> whereStartsWith(String key, String prefix) {
        String regex = "^" + Pattern.quote(prefix);
        this.whereMatches(key, regex);
        return this;
    }

    public ParseQuery<T> whereEndsWith(String key, String suffix) {
        String regex = Pattern.quote(suffix) + "$";
        this.whereMatches(key, regex);
        return this;
    }

    public ParseQuery<T> include(String key) {
        this.checkIfRunning();
        this.builder.include(key);
        return this;
    }

    public ParseQuery<T> selectKeys(Collection<String> keys) {
        this.checkIfRunning();
        this.builder.selectKeys(keys);
        return this;
    }

    public ParseQuery<T> whereExists(String key) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$exists", true);
        return this;
    }

    public ParseQuery<T> whereDoesNotExist(String key) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$exists", false);
        return this;
    }

    public ParseQuery<T> orderByAscending(String key) {
        this.checkIfRunning();
        this.builder.orderByAscending(key);
        return this;
    }

    public ParseQuery<T> addAscendingOrder(String key) {
        this.checkIfRunning();
        this.builder.addAscendingOrder(key);
        return this;
    }

    public ParseQuery<T> orderByDescending(String key) {
        this.checkIfRunning();
        this.builder.orderByDescending(key);
        return this;
    }

    public ParseQuery<T> addDescendingOrder(String key) {
        this.checkIfRunning();
        this.builder.addDescendingOrder(key);
        return this;
    }

    public ParseQuery<T> setLimit(int newLimit) {
        this.checkIfRunning();
        this.builder.setLimit(newLimit);
        return this;
    }

    public int getLimit() {
        return this.builder.getLimit();
    }

    public ParseQuery<T> setSkip(int newSkip) {
        this.checkIfRunning();
        this.builder.setSkip(newSkip);
        return this;
    }

    public int getSkip() {
        return this.builder.getSkip();
    }

    public String getClassName() {
        return this.builder.getClassName();
    }

    public ParseQuery<T> setTrace(boolean shouldTrace) {
        this.checkIfRunning();
        this.builder.setTracingEnabled(shouldTrace);
        return this;
    }

    static class State<T extends ParseObject> {
        private final String className;
        private final QueryConstraints where;
        private final Set<String> include;
        private final Set<String> selectedKeys;
        private final int limit;
        private final int skip;
        private final List<String> order;
        private final Map<String, Object> extraOptions;
        private final boolean trace;
        private final CachePolicy cachePolicy;
        private final long maxCacheAge;
        private final boolean isFromLocalDatastore;
        private final String pinName;
        private final boolean ignoreACLs;

        private State(Builder<T> builder) {
            this.className = ((Builder)builder).className;
            this.where = new QueryConstraints(((Builder)builder).where);
            this.include = Collections.unmodifiableSet(((Builder)builder).includes);
            this.selectedKeys = ((Builder)builder).selectedKeys != null ? Collections.unmodifiableSet(((Builder)builder).selectedKeys) : null;
            this.limit = ((Builder)builder).limit;
            this.skip = ((Builder)builder).skip;
            this.order = Collections.unmodifiableList(((Builder)builder).order);
            this.extraOptions = Collections.unmodifiableMap(((Builder)builder).extraOptions);
            this.trace = ((Builder)builder).trace;
            this.cachePolicy = ((Builder)builder).cachePolicy;
            this.maxCacheAge = ((Builder)builder).maxCacheAge;
            this.isFromLocalDatastore = ((Builder)builder).isFromLocalDatastore;
            this.pinName = ((Builder)builder).pinName;
            this.ignoreACLs = ((Builder)builder).ignoreACLs;
        }

        public String className() {
            return this.className;
        }

        public QueryConstraints constraints() {
            return this.where;
        }

        public Set<String> includes() {
            return this.include;
        }

        public Set<String> selectedKeys() {
            return this.selectedKeys;
        }

        public int limit() {
            return this.limit;
        }

        public int skip() {
            return this.skip;
        }

        public List<String> order() {
            return this.order;
        }

        public Map<String, Object> extraOptions() {
            return this.extraOptions;
        }

        public boolean isTracingEnabled() {
            return this.trace;
        }

        public CachePolicy cachePolicy() {
            return this.cachePolicy;
        }

        public long maxCacheAge() {
            return this.maxCacheAge;
        }

        public boolean isFromLocalDatastore() {
            return this.isFromLocalDatastore;
        }

        public String pinName() {
            return this.pinName;
        }

        public boolean ignoreACLs() {
            return this.ignoreACLs;
        }

        JSONObject toJSON(ParseEncoder encoder) {
            JSONObject params = new JSONObject();
            try {
                params.put("className", (Object)this.className);
                params.put("where", encoder.encode(this.where));
                if (this.limit >= 0) {
                    params.put("limit", this.limit);
                }
                if (this.skip > 0) {
                    params.put("skip", this.skip);
                }
                if (!this.order.isEmpty()) {
                    params.put("order", (Object)ParseTextUtils.join(",", this.order));
                }
                if (!this.include.isEmpty()) {
                    params.put("include", (Object)ParseTextUtils.join(",", this.include));
                }
                if (this.selectedKeys != null) {
                    params.put("fields", (Object)ParseTextUtils.join(",", this.selectedKeys));
                }
                if (this.trace) {
                    params.put("trace", 1);
                }
                for (String key : this.extraOptions.keySet()) {
                    params.put(key, encoder.encode(this.extraOptions.get(key)));
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return params;
        }

        public String toString() {
            return String.format(Locale.US, "%s[className=%s, where=%s, include=%s, selectedKeys=%s, limit=%s, skip=%s, order=%s, extraOptions=%s, cachePolicy=%s, maxCacheAge=%s, trace=%s]", new Object[]{this.getClass().getName(), this.className, this.where, this.include, this.selectedKeys, this.limit, this.skip, this.order, this.extraOptions, this.cachePolicy, this.maxCacheAge, this.trace});
        }

        static class Builder<T extends ParseObject> {
            private final String className;
            private final QueryConstraints where = new QueryConstraints();
            private final Set<String> includes = new HashSet<String>();
            private Set<String> selectedKeys;
            private int limit = -1;
            private int skip = 0;
            private List<String> order = new ArrayList<String>();
            private final Map<String, Object> extraOptions = new HashMap<String, Object>();
            private boolean trace;
            private CachePolicy cachePolicy = CachePolicy.IGNORE_CACHE;
            private long maxCacheAge = Long.MAX_VALUE;
            private boolean isFromLocalDatastore = false;
            private String pinName;
            private boolean ignoreACLs;

            public static <T extends ParseObject> Builder<T> or(List<Builder<T>> builders) {
                if (builders.isEmpty()) {
                    throw new IllegalArgumentException("Can't take an or of an empty list of queries");
                }
                String className = null;
                ArrayList<QueryConstraints> constraints = new ArrayList<QueryConstraints>();
                for (Builder<T> builder : builders) {
                    if (className != null && !builder.className.equals(className)) {
                        throw new IllegalArgumentException("All of the queries in an or query must be on the same class ");
                    }
                    if (builder.limit >= 0) {
                        throw new IllegalArgumentException("Cannot have limits in sub queries of an 'OR' query");
                    }
                    if (builder.skip > 0) {
                        throw new IllegalArgumentException("Cannot have skips in sub queries of an 'OR' query");
                    }
                    if (!builder.order.isEmpty()) {
                        throw new IllegalArgumentException("Cannot have an order in sub queries of an 'OR' query");
                    }
                    if (!builder.includes.isEmpty()) {
                        throw new IllegalArgumentException("Cannot have an include in sub queries of an 'OR' query");
                    }
                    if (builder.selectedKeys != null) {
                        throw new IllegalArgumentException("Cannot have an selectKeys in sub queries of an 'OR' query");
                    }
                    className = builder.className;
                    constraints.add(builder.where);
                }
                return super.whereSatifiesAnyOf(constraints);
            }

            public Builder(String className) {
                this.className = className;
            }

            public Builder(Class<T> subclass) {
                this(ParseObject.getClassName(subclass));
            }

            public Builder(State state) {
                this.className = state.className();
                this.where.putAll(state.constraints());
                this.includes.addAll(state.includes());
                this.selectedKeys = state.selectedKeys() != null ? new HashSet<String>(state.selectedKeys()) : null;
                this.limit = state.limit();
                this.skip = state.skip();
                this.order.addAll(state.order());
                this.extraOptions.putAll(state.extraOptions());
            }

            public String getClassName() {
                return this.className;
            }

            public Builder<T> whereEqualTo(String key, Object value) {
                this.where.put(key, value);
                return this;
            }

            public Builder<T> whereDoesNotMatchKeyInQuery(String key, String keyInQuery, Builder<?> builder) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put("key", keyInQuery);
                condition.put("query", builder);
                return this.addConditionInternal(key, "$dontSelect", Collections.unmodifiableMap(condition));
            }

            public Builder<T> whereMatchesKeyInQuery(String key, String keyInQuery, Builder<?> builder) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put("key", keyInQuery);
                condition.put("query", builder);
                return this.addConditionInternal(key, "$select", Collections.unmodifiableMap(condition));
            }

            public Builder<T> whereDoesNotMatchQuery(String key, Builder<?> builder) {
                return this.addConditionInternal(key, "$notInQuery", builder);
            }

            public Builder<T> whereMatchesQuery(String key, Builder<?> builder) {
                return this.addConditionInternal(key, "$inQuery", builder);
            }

            public Builder<T> addCondition(String key, String condition, Collection<? extends Object> value) {
                return this.addConditionInternal(key, condition, Collections.unmodifiableCollection(value));
            }

            public Builder<T> addCondition(String key, String condition, Object value) {
                return this.addConditionInternal(key, condition, value);
            }

            private Builder<T> addConditionInternal(String key, String condition, Object value) {
                Object existingValue;
                KeyConstraints whereValue = null;
                if (this.where.containsKey(key) && (existingValue = this.where.get(key)) instanceof KeyConstraints) {
                    whereValue = (KeyConstraints)existingValue;
                }
                if (whereValue == null) {
                    whereValue = new KeyConstraints();
                }
                whereValue.put(condition, value);
                this.where.put(key, whereValue);
                return this;
            }

            Builder<T> whereRelatedTo(ParseObject parent, String key) {
                this.where.put("$relatedTo", new RelationConstraint(key, parent));
                return this;
            }

            private Builder<T> whereSatifiesAnyOf(List<QueryConstraints> constraints) {
                this.where.put("$or", constraints);
                return this;
            }

            Builder<T> whereObjectIdEquals(String objectId) {
                this.where.clear();
                this.where.put("objectId", objectId);
                return this;
            }

            private Builder<T> setOrder(String key) {
                this.order.clear();
                this.order.add(key);
                return this;
            }

            private Builder<T> addOrder(String key) {
                this.order.add(key);
                return this;
            }

            public Builder<T> orderByAscending(String key) {
                return this.setOrder(key);
            }

            public Builder<T> addAscendingOrder(String key) {
                return this.addOrder(key);
            }

            public Builder<T> orderByDescending(String key) {
                return this.setOrder(String.format("-%s", key));
            }

            public Builder<T> addDescendingOrder(String key) {
                return this.addOrder(String.format("-%s", key));
            }

            public Builder<T> include(String key) {
                this.includes.add(key);
                return this;
            }

            public Builder<T> selectKeys(Collection<String> keys) {
                if (this.selectedKeys == null) {
                    this.selectedKeys = new HashSet<String>();
                }
                this.selectedKeys.addAll(keys);
                return this;
            }

            public int getLimit() {
                return this.limit;
            }

            public Builder<T> setLimit(int limit) {
                this.limit = limit;
                return this;
            }

            public int getSkip() {
                return this.skip;
            }

            public Builder<T> setSkip(int skip) {
                this.skip = skip;
                return this;
            }

            Builder<T> redirectClassNameForKey(String key) {
                this.extraOptions.put("redirectClassNameForKey", key);
                return this;
            }

            public Builder<T> setTracingEnabled(boolean trace) {
                this.trace = trace;
                return this;
            }

            public CachePolicy getCachePolicy() {
                ParseQuery.throwIfLDSEnabled();
                return this.cachePolicy;
            }

            public Builder<T> setCachePolicy(CachePolicy cachePolicy) {
                ParseQuery.throwIfLDSEnabled();
                this.cachePolicy = cachePolicy;
                return this;
            }

            public long getMaxCacheAge() {
                ParseQuery.throwIfLDSEnabled();
                return this.maxCacheAge;
            }

            public Builder<T> setMaxCacheAge(long maxCacheAge) {
                ParseQuery.throwIfLDSEnabled();
                this.maxCacheAge = maxCacheAge;
                return this;
            }

            public boolean isFromNetwork() {
                ParseQuery.throwIfLDSDisabled();
                return !this.isFromLocalDatastore;
            }

            public Builder<T> fromNetwork() {
                ParseQuery.throwIfLDSDisabled();
                this.isFromLocalDatastore = false;
                this.pinName = null;
                return this;
            }

            public Builder<T> fromLocalDatastore() {
                return this.fromPin(null);
            }

            public boolean isFromLocalDatstore() {
                return this.isFromLocalDatastore;
            }

            public Builder<T> fromPin() {
                return this.fromPin("_default");
            }

            public Builder<T> fromPin(String pinName) {
                ParseQuery.throwIfLDSDisabled();
                this.isFromLocalDatastore = true;
                this.pinName = pinName;
                return this;
            }

            public Builder<T> ignoreACLs() {
                ParseQuery.throwIfLDSDisabled();
                this.ignoreACLs = true;
                return this;
            }

            public State<T> build() {
                if (!this.isFromLocalDatastore && this.ignoreACLs) {
                    throw new IllegalStateException("`ignoreACLs` cannot be combined with network queries");
                }
                return new State(this);
            }
        }
    }

    public static enum CachePolicy {
        IGNORE_CACHE,
        CACHE_ONLY,
        NETWORK_ONLY,
        CACHE_ELSE_NETWORK,
        NETWORK_ELSE_CACHE,
        CACHE_THEN_NETWORK;

    }

    static class RelationConstraint {
        private String key;
        private ParseObject object;

        public RelationConstraint(String key, ParseObject object) {
            if (key == null || object == null) {
                throw new IllegalArgumentException("Arguments must not be null.");
            }
            this.key = key;
            this.object = object;
        }

        public String getKey() {
            return this.key;
        }

        public ParseObject getObject() {
            return this.object;
        }

        public ParseRelation<ParseObject> getRelation() {
            return this.object.getRelation(this.key);
        }

        public JSONObject encode(ParseEncoder objectEncoder) {
            JSONObject json = new JSONObject();
            try {
                json.put("key", (Object)this.key);
                json.put("object", (Object)objectEncoder.encodeRelatedObject(this.object));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return json;
        }
    }

    static class KeyConstraints
    extends HashMap<String, Object> {
        KeyConstraints() {
        }
    }

    static class QueryConstraints
    extends HashMap<String, Object> {
        public QueryConstraints() {
        }

        public QueryConstraints(Map<? extends String, ?> map) {
            super(map);
        }
    }
}

