/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.parse.ManifestInfo;
import com.parse.NotificationCompat;
import com.parse.PLog;
import com.parse.ParseAnalytics;
import com.parse.ParseNotificationManager;
import com.parse.TaskStackBuilderHelper;
import java.util.Locale;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

public class ParsePushBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = "com.parse.ParsePushReceiver";
    public static final String KEY_PUSH_CHANNEL = "com.parse.Channel";
    public static final String KEY_PUSH_DATA = "com.parse.Data";
    public static final String ACTION_PUSH_RECEIVE = "com.parse.push.intent.RECEIVE";
    public static final String ACTION_PUSH_OPEN = "com.parse.push.intent.OPEN";
    public static final String ACTION_PUSH_DELETE = "com.parse.push.intent.DELETE";
    public static final String PROPERTY_PUSH_ICON = "com.parse.push.notification_icon";
    protected static final int SMALL_NOTIFICATION_MAX_CHARACTER_LIMIT = 38;

    public void onReceive(Context context, Intent intent) {
        String intentAction;
        switch (intentAction = intent.getAction()) {
            case "com.parse.push.intent.RECEIVE": {
                this.onPushReceive(context, intent);
                break;
            }
            case "com.parse.push.intent.DELETE": {
                this.onPushDismiss(context, intent);
                break;
            }
            case "com.parse.push.intent.OPEN": {
                this.onPushOpen(context, intent);
            }
        }
    }

    protected void onPushReceive(Context context, Intent intent) {
        Notification notification;
        JSONObject pushData = null;
        try {
            pushData = new JSONObject(intent.getStringExtra(KEY_PUSH_DATA));
        }
        catch (JSONException e) {
            PLog.e(TAG, "Unexpected JSONException when receiving push data: ", e);
        }
        String action = null;
        if (pushData != null) {
            action = pushData.optString("action", null);
        }
        if (action != null) {
            Bundle extras = intent.getExtras();
            Intent broadcastIntent = new Intent();
            broadcastIntent.putExtras(extras);
            broadcastIntent.setAction(action);
            broadcastIntent.setPackage(context.getPackageName());
            context.sendBroadcast(broadcastIntent);
        }
        if ((notification = this.getNotification(context, intent)) != null) {
            ParseNotificationManager.getInstance().showNotification(context, notification);
        }
    }

    protected void onPushDismiss(Context context, Intent intent) {
    }

    protected void onPushOpen(Context context, Intent intent) {
        ParseAnalytics.trackAppOpenedInBackground(intent);
        String uriString = null;
        try {
            JSONObject pushData = new JSONObject(intent.getStringExtra(KEY_PUSH_DATA));
            uriString = pushData.optString("uri", null);
        }
        catch (JSONException e) {
            PLog.e(TAG, "Unexpected JSONException when receiving push data: ", e);
        }
        Class<? extends Activity> cls = this.getActivity(context, intent);
        Intent activityIntent = uriString != null ? new Intent("android.intent.action.VIEW", Uri.parse((String)uriString)) : new Intent(context, cls);
        activityIntent.putExtras(intent.getExtras());
        if (Build.VERSION.SDK_INT >= 16) {
            TaskStackBuilderHelper.startActivities(context, cls, activityIntent);
        } else {
            activityIntent.addFlags(0x10000000);
            activityIntent.addFlags(0x4000000);
            context.startActivity(activityIntent);
        }
    }

    protected Class<? extends Activity> getActivity(Context context, Intent intent) {
        String packageName = context.getPackageName();
        Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        if (launchIntent == null) {
            return null;
        }
        String className = launchIntent.getComponent().getClassName();
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return cls;
    }

    protected int getSmallIconId(Context context, Intent intent) {
        Bundle metaData = ManifestInfo.getApplicationMetadata(context);
        int explicitId = 0;
        if (metaData != null) {
            explicitId = metaData.getInt(PROPERTY_PUSH_ICON);
        }
        return explicitId != 0 ? explicitId : ManifestInfo.getIconId();
    }

    protected Bitmap getLargeIcon(Context context, Intent intent) {
        return null;
    }

    private JSONObject getPushData(Intent intent) {
        try {
            return new JSONObject(intent.getStringExtra(KEY_PUSH_DATA));
        }
        catch (JSONException e) {
            PLog.e(TAG, "Unexpected JSONException when receiving push data: ", e);
            return null;
        }
    }

    protected Notification getNotification(Context context, Intent intent) {
        JSONObject pushData = this.getPushData(intent);
        if (pushData == null || !pushData.has("alert") && !pushData.has("title")) {
            return null;
        }
        String title = pushData.optString("title", ManifestInfo.getDisplayName(context));
        String alert = pushData.optString("alert", "Notification received.");
        String tickerText = String.format(Locale.getDefault(), "%s: %s", title, alert);
        Bundle extras = intent.getExtras();
        Random random = new Random();
        int contentIntentRequestCode = random.nextInt();
        int deleteIntentRequestCode = random.nextInt();
        String packageName = context.getPackageName();
        Intent contentIntent = new Intent(ACTION_PUSH_OPEN);
        contentIntent.putExtras(extras);
        contentIntent.setPackage(packageName);
        Intent deleteIntent = new Intent(ACTION_PUSH_DELETE);
        deleteIntent.putExtras(extras);
        deleteIntent.setPackage(packageName);
        PendingIntent pContentIntent = PendingIntent.getBroadcast((Context)context, (int)contentIntentRequestCode, (Intent)contentIntent, (int)0x8000000);
        PendingIntent pDeleteIntent = PendingIntent.getBroadcast((Context)context, (int)deleteIntentRequestCode, (Intent)deleteIntent, (int)0x8000000);
        NotificationCompat.Builder parseBuilder = new NotificationCompat.Builder(context);
        parseBuilder.setContentTitle(title).setContentText(alert).setTicker(tickerText).setSmallIcon(this.getSmallIconId(context, intent)).setLargeIcon(this.getLargeIcon(context, intent)).setContentIntent(pContentIntent).setDeleteIntent(pDeleteIntent).setAutoCancel(true).setDefaults(-1);
        if (alert != null && alert.length() > 38) {
            parseBuilder.setStyle(new NotificationCompat.Builder.BigTextStyle().bigText(alert));
        }
        return parseBuilder.build();
    }
}

