/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import com.parse.ParseByteArrayHttpBody;
import com.parse.ParseHttpBody;
import com.parse.ParseHttpClient;
import com.parse.ParseHttpRequest;
import com.parse.ParseHttpResponse;
import com.parse.ParseRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import okio.BufferedSink;

class ParseOkHttpClient
extends ParseHttpClient<Request, Response> {
    private OkHttpClient okHttpClient;
    private String userAgent;

    public ParseOkHttpClient(String userAgent, int socketOperationTimeout, SSLSessionCache sslSessionCache) {
        this.userAgent = userAgent;
        this.okHttpClient = new OkHttpClient();
        this.okHttpClient.setConnectTimeout((long)socketOperationTimeout, TimeUnit.MILLISECONDS);
        this.okHttpClient.setReadTimeout((long)socketOperationTimeout, TimeUnit.MILLISECONDS);
        this.okHttpClient.setFollowRedirects(false);
        SSLSocketFactory sslSocketFactory = SSLCertificateSocketFactory.getDefault((int)socketOperationTimeout, (SSLSessionCache)sslSessionCache);
        this.okHttpClient.setSslSocketFactory(sslSocketFactory);
        String host = System.getProperty("http.proxyHost");
        String portString = System.getProperty("http.proxyPort");
        if (host != null && host.length() != 0 && portString != null && portString.length() != 0) {
            int port = Integer.parseInt(portString);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
            this.okHttpClient.setProxy(proxy);
        }
    }

    @Override
    public ParseHttpResponse execute(ParseHttpRequest parseRequest) throws IOException {
        Request okHttpRequest = this.getRequest(parseRequest);
        Call okHttpCall = this.okHttpClient.newCall(okHttpRequest);
        ParseOkHttpClient.setParseRequestCancelRunnable(parseRequest, okHttpCall);
        Response okHttpResponse = okHttpCall.execute();
        return this.getResponse(okHttpResponse);
    }

    private static void setParseRequestCancelRunnable(ParseHttpRequest parseRequest, final Call okHttpCall) {
        parseRequest.setCancelRunnable(new Runnable(){

            @Override
            public void run() {
                okHttpCall.cancel();
            }
        });
    }

    @Override
    ParseHttpResponse getResponse(Response okHttpResponse) throws IOException {
        int statusCode = okHttpResponse.code();
        InputStream content = okHttpResponse.body().byteStream();
        int totalSize = (int)okHttpResponse.body().contentLength();
        String reasonPhrase = okHttpResponse.message();
        return new ParseHttpResponse(statusCode, content, totalSize, reasonPhrase);
    }

    @Override
    Request getRequest(ParseHttpRequest parseRequest) throws IOException {
        Request.Builder okHttpRequestBuilder = new Request.Builder();
        ParseRequest.Method method = parseRequest.getMethod();
        switch (method) {
            case GET: {
                okHttpRequestBuilder.get();
                break;
            }
            case DELETE: {
                okHttpRequestBuilder.delete();
                break;
            }
            case POST: 
            case PUT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported http method " + method.toString());
            }
        }
        okHttpRequestBuilder.url(parseRequest.getUrl());
        Headers.Builder okHttpHeadersBuilder = new Headers.Builder();
        for (Map.Entry<String, String> entry : parseRequest.getAllHeaders().entrySet()) {
            okHttpHeadersBuilder.add(entry.getKey(), entry.getValue());
        }
        okHttpHeadersBuilder.add("User-Agent", this.userAgent);
        Headers okHttpHeaders = okHttpHeadersBuilder.build();
        okHttpRequestBuilder.headers(okHttpHeaders);
        ParseHttpBody parseBody = parseRequest.getBody();
        CountingOkHttpRequestBody okHttpRequestBody = null;
        if (parseBody instanceof ParseByteArrayHttpBody) {
            okHttpRequestBody = new CountingOkHttpRequestBody(parseBody);
        }
        switch (method) {
            case PUT: {
                okHttpRequestBuilder.put((RequestBody)okHttpRequestBody);
                break;
            }
            case POST: {
                okHttpRequestBuilder.post((RequestBody)okHttpRequestBody);
            }
        }
        return okHttpRequestBuilder.build();
    }

    private static class CountingOkHttpRequestBody
    extends RequestBody {
        private ParseHttpBody parseBody;

        public CountingOkHttpRequestBody(ParseHttpBody parseBody) {
            this.parseBody = parseBody;
        }

        public long contentLength() throws IOException {
            return this.parseBody.getContentLength();
        }

        public MediaType contentType() {
            return MediaType.parse((String)this.parseBody.getContentType());
        }

        public void writeTo(BufferedSink bufferedSink) throws IOException {
            this.parseBody.writeTo(bufferedSink.outputStream());
        }
    }
}

