/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Intent;
import bolts.Capture;
import bolts.Continuation;
import bolts.Task;
import com.parse.NoObjectsEncoder;
import com.parse.PLog;
import com.parse.Parse;
import com.parse.ParseRESTAnalyticsCommand;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;
import com.parse.SaveCallback;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseAnalytics {
    private static final String TAG = "com.parse.ParseAnalytics";
    private static final Map<String, Boolean> lruSeenPushes = new LinkedHashMap<String, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 10;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Void> trackAppOpenedInBackground(Intent intent) {
        Capture pushHash;
        block8: {
            String pushData = null;
            if (intent != null && intent.getExtras() != null) {
                pushData = intent.getExtras().getString("com.parse.Data");
            }
            pushHash = new Capture();
            if (pushData != null) {
                try {
                    JSONObject payload = new JSONObject(pushData);
                    String hash = payload.optString("push_hash");
                    if (hash.length() <= 0) break block8;
                    Map<String, Boolean> map = lruSeenPushes;
                    synchronized (map) {
                        if (lruSeenPushes.containsKey(hash)) {
                            return Task.forResult(null);
                        }
                        lruSeenPushes.put(hash, true);
                        pushHash.set((Object)hash);
                    }
                }
                catch (JSONException e) {
                    PLog.e(TAG, "Failed to parse push data: " + e.getMessage());
                }
            }
        }
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                ParseRESTAnalyticsCommand command = ParseRESTAnalyticsCommand.trackAppOpenedCommand((String)pushHash.get(), sessionToken);
                Task<Object> eventuallyTask = Parse.getEventuallyQueue().enqueueEventuallyAsync(command, null);
                return eventuallyTask.makeVoid();
            }
        });
    }

    @Deprecated
    public static void trackAppOpened(Intent intent) {
        ParseAnalytics.trackAppOpenedInBackground(intent);
    }

    public static void trackAppOpenedInBackground(Intent intent, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseAnalytics.trackAppOpenedInBackground(intent), callback);
    }

    @Deprecated
    public static void trackEvent(String name) {
        ParseAnalytics.trackEventInBackground(name);
    }

    public static void trackEventInBackground(String name, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseAnalytics.trackEventInBackground(name), callback);
    }

    @Deprecated
    public static void trackEvent(String name, Map<String, String> dimensions) {
        ParseAnalytics.trackEventInBackground(name, dimensions);
    }

    public static void trackEventInBackground(String name, Map<String, String> dimensions, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseAnalytics.trackEventInBackground(name, dimensions), callback);
    }

    public static Task<Void> trackEventInBackground(String name) {
        return ParseAnalytics.trackEventInBackground(name, (Map<String, String>)null);
    }

    public static Task<Void> trackEventInBackground(final String name, Map<String, String> dimensions) {
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeException("A name for the custom event must be provided.");
        }
        final JSONObject jsonDimensions = dimensions != null ? (JSONObject)NoObjectsEncoder.get().encode(dimensions) : null;
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                ParseRESTAnalyticsCommand command = ParseRESTAnalyticsCommand.trackEventCommand(name, jsonDimensions, sessionToken);
                Task<Object> eventuallyTask = Parse.getEventuallyQueue().enqueueEventuallyAsync(command, null);
                return eventuallyTask.makeVoid();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clear() {
        Map<String, Boolean> map = lruSeenPushes;
        synchronized (map) {
            lruSeenPushes.clear();
        }
    }
}

