/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import bolts.Continuation;
import bolts.Task;
import com.parse.GcmRegistrar;
import com.parse.ManifestInfo;
import com.parse.OfflineStore;
import com.parse.PLog;
import com.parse.ParseCommandCache;
import com.parse.ParseConfig;
import com.parse.ParseEventuallyQueue;
import com.parse.ParseFieldOperations;
import com.parse.ParseFileUtils;
import com.parse.ParseKeyValueCache;
import com.parse.ParseObject;
import com.parse.ParsePinningEventuallyQueue;
import com.parse.ParseRequest;
import com.parse.ParseUser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

public class Parse {
    private static final String PARSE_APPLICATION_ID = "com.parse.APPLICATION_ID";
    private static final String PARSE_CLIENT_KEY = "com.parse.CLIENT_KEY";
    static Context applicationContext;
    static String applicationId;
    static String clientKey;
    private static final Object MUTEX;
    static ParseEventuallyQueue eventuallyQueue;
    private static OfflineStore offlineStore;
    private static final Object MUTEX_CALLBACKS;
    private static Set<ParseCallbacks> callbacks;
    public static final int LOG_LEVEL_VERBOSE = 2;
    public static final int LOG_LEVEL_DEBUG = 3;
    public static final int LOG_LEVEL_INFO = 4;
    public static final int LOG_LEVEL_WARNING = 5;
    public static final int LOG_LEVEL_ERROR = 6;
    public static final int LOG_LEVEL_NONE = Integer.MAX_VALUE;

    private Parse() {
        throw new AssertionError();
    }

    public static void enableLocalDatastore(Context context) {
        if (Parse.isInitialized()) {
            throw new IllegalStateException("`Parse#enableLocalDatastore(Context)` must be invoked before `Parse#initialize(Context)`");
        }
        offlineStore = new OfflineStore(context);
    }

    static void disableLocalDatastore() {
        offlineStore = null;
    }

    static OfflineStore getLocalDatastore() {
        return offlineStore;
    }

    static void setLocalDatastore(OfflineStore offlineStore) {
        Parse.offlineStore = offlineStore;
    }

    static boolean isLocalDatastoreEnabled() {
        return offlineStore != null;
    }

    public static void initialize(Context context) {
        String clientKey;
        String applicationId;
        applicationContext = context.getApplicationContext();
        Bundle metaData = ManifestInfo.getApplicationMetadata(applicationContext);
        if (metaData != null) {
            applicationId = metaData.getString(PARSE_APPLICATION_ID);
            clientKey = metaData.getString(PARSE_CLIENT_KEY);
            if (applicationId == null) {
                throw new RuntimeException("ApplicationId not defined. You must provide ApplicationId in AndroidManifest.xml.\n<meta-data\n    android:name=\"com.parse.APPLICATION_ID\"\n    android:value=\"<Your Application Id>\" />");
            }
            if (clientKey == null) {
                throw new RuntimeException("ClientKey not defined. You must provide ClientKey in AndroidManifest.xml.\n<meta-data\n    android:name=\"com.parse.CLIENT_KEY\"\n    android:value=\"<Your Client Key>\" />");
            }
        } else {
            throw new RuntimeException("Can't get Application Metadata");
        }
        Parse.initialize(context, applicationId, clientKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Context context, String applicationId, String clientKey) {
        ParseRequest.initialize(context);
        ParseKeyValueCache.initialize(context);
        ParseObject.registerParseSubclasses();
        Parse.applicationId = applicationId;
        Parse.clientKey = clientKey;
        if (context != null) {
            applicationContext = context.getApplicationContext();
            Parse.checkCacheApplicationId();
            new Thread("Parse.initialize Disk Check & Starting Command Cache"){

                @Override
                public void run() {
                    Parse.getEventuallyQueue();
                }
            }.start();
        }
        ParseFieldOperations.registerDefaultDecoders();
        if (!Parse.allParsePushIntentReceiversInternal()) {
            throw new SecurityException("To prevent external tampering to your app's notifications, all receivers registered to handle the following actions must have their exported attributes set to false: com.parse.push.intent.RECEIVE, com.parse.push.intent.OPEN, com.parse.push.intent.DELETE");
        }
        GcmRegistrar.getInstance().updateAsync().continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseUser.getCurrentUserAsync().makeVoid();
            }
        }).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                ParseConfig.getCurrentConfig();
                return null;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
        Parse.dispatchOnParseInitialized();
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            callbacks = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroy() {
        ParseEventuallyQueue queue;
        Object object = MUTEX;
        synchronized (object) {
            queue = eventuallyQueue;
            eventuallyQueue = null;
        }
        if (queue != null) {
            queue.onDestroy();
        }
        object = MUTEX;
        synchronized (object) {
            applicationId = null;
            clientKey = null;
            applicationContext = null;
        }
    }

    private static boolean isInitialized() {
        return applicationId != null || clientKey != null;
    }

    static Context getApplicationContext() {
        Parse.checkContext();
        return applicationContext;
    }

    private static boolean allParsePushIntentReceiversInternal() {
        List<ResolveInfo> intentReceivers = ManifestInfo.getIntentReceivers("com.parse.push.intent.RECEIVE", "com.parse.push.intent.DELETE", "com.parse.push.intent.OPEN");
        for (ResolveInfo resolveInfo : intentReceivers) {
            if (!resolveInfo.activityInfo.exported) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    static File getParseDir() {
        Object object = MUTEX;
        synchronized (object) {
            Parse.checkContext();
            return applicationContext.getDir("Parse", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getParseCacheDir() {
        Object object = MUTEX;
        synchronized (object) {
            Parse.checkContext();
            File dir = new File(applicationContext.getCacheDir(), "com.parse");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getParseCacheDir(String subDir) {
        Object object = MUTEX;
        synchronized (object) {
            File dir = new File(Parse.getParseCacheDir(), subDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getParseFilesDir() {
        Object object = MUTEX;
        synchronized (object) {
            Parse.checkContext();
            File dir = new File(applicationContext.getFilesDir(), "com.parse");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getParseFilesDir(String subDir) {
        Object object = MUTEX;
        synchronized (object) {
            File dir = new File(Parse.getParseFilesDir(), subDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkCacheApplicationId() {
        Object object = MUTEX;
        synchronized (object) {
            if (applicationId != null) {
                File dir = Parse.getParseCacheDir();
                File applicationIdFile = new File(dir, "applicationId");
                if (applicationIdFile.exists()) {
                    boolean matches = false;
                    try {
                        RandomAccessFile f = new RandomAccessFile(applicationIdFile, "r");
                        byte[] bytes = new byte[(int)f.length()];
                        f.readFully(bytes);
                        f.close();
                        String diskApplicationId = new String(bytes, "UTF-8");
                        matches = diskApplicationId.equals(applicationId);
                    }
                    catch (FileNotFoundException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (!matches) {
                        try {
                            ParseFileUtils.deleteDirectory(dir);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                applicationIdFile = new File(dir, "applicationId");
                try {
                    FileOutputStream out = new FileOutputStream(applicationIdFile);
                    out.write(applicationId.getBytes("UTF-8"));
                    out.close();
                }
                catch (FileNotFoundException e) {
                }
                catch (UnsupportedEncodingException e) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParseEventuallyQueue getEventuallyQueue() {
        Object object = MUTEX;
        synchronized (object) {
            boolean isLocalDatastoreEnabled = Parse.isLocalDatastoreEnabled();
            if (eventuallyQueue == null || isLocalDatastoreEnabled && eventuallyQueue instanceof ParseCommandCache || !isLocalDatastoreEnabled && eventuallyQueue instanceof ParsePinningEventuallyQueue) {
                Parse.checkContext();
                ParseEventuallyQueue parseEventuallyQueue = eventuallyQueue = isLocalDatastoreEnabled ? new ParsePinningEventuallyQueue(applicationContext) : new ParseCommandCache(applicationContext);
                if (isLocalDatastoreEnabled && ParseCommandCache.getPendingCount() > 0) {
                    new ParseCommandCache(applicationContext);
                }
            }
            return eventuallyQueue;
        }
    }

    static void checkInit() {
        if (applicationId == null) {
            throw new RuntimeException("applicationId is null. You must call Parse.initialize(Context) before using the Parse library.");
        }
        if (clientKey == null) {
            throw new RuntimeException("clientKey is null. You must call Parse.initialize(Context) before using the Parse library.");
        }
    }

    static void checkContext() {
        if (applicationContext == null) {
            throw new RuntimeException("applicationContext is null. You must call Parse.initialize(Context) before using the Parse library.");
        }
    }

    static boolean hasPermission(String permission) {
        Parse.checkContext();
        return applicationContext.checkCallingOrSelfPermission(permission) == 0;
    }

    static void requirePermission(String permission) {
        if (!Parse.hasPermission(permission)) {
            throw new IllegalStateException("To use this functionality, add this to your AndroidManifest.xml:\n<uses-permission android:name=\"" + permission + "\" />");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerParseCallbacks(ParseCallbacks listener) {
        if (Parse.isInitialized()) {
            throw new IllegalStateException("You must register callbacks before Parse.initialize(Context)");
        }
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            if (callbacks == null) {
                return;
            }
            callbacks.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterParseCallbacks(ParseCallbacks listener) {
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            if (callbacks == null) {
                return;
            }
            callbacks.remove(listener);
        }
    }

    private static void dispatchOnParseInitialized() {
        ParseCallbacks[] callbacks = Parse.collectParseCallbacks();
        if (callbacks != null) {
            for (ParseCallbacks callback : callbacks) {
                callback.onParseInitialized();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseCallbacks[] collectParseCallbacks() {
        ParseCallbacks[] callbacks;
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            if (Parse.callbacks == null) {
                return null;
            }
            callbacks = new ParseCallbacks[Parse.callbacks.size()];
            if (Parse.callbacks.size() > 0) {
                callbacks = Parse.callbacks.toArray(callbacks);
            }
        }
        return callbacks;
    }

    public static void setLogLevel(int logLevel) {
        PLog.setLogLevel(logLevel);
    }

    public static int getLogLevel() {
        return PLog.getLogLevel();
    }

    static {
        MUTEX = new Object();
        eventuallyQueue = null;
        MUTEX_CALLBACKS = new Object();
        callbacks = new HashSet<ParseCallbacks>();
    }

    static interface ParseCallbacks {
        public void onParseInitialized();
    }
}

