/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.ParseCallback2;
import com.parse.ParseException;
import com.parse.ParseTaskUtils;
import com.parse.ProgressCallback;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.entity.ByteArrayEntity;

class CountingByteArrayEntity
extends ByteArrayEntity {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private final ParseCallback2<Integer, ParseException> progressCallback;

    public CountingByteArrayEntity(byte[] b, final ProgressCallback progressCallback) {
        super(b);
        this.progressCallback = progressCallback != null ? new ParseCallback2<Integer, ParseException>(){
            Integer maxProgressSoFar = 0;

            @Override
            public void done(Integer percentDone, ParseException e) {
                if (percentDone > this.maxProgressSoFar) {
                    this.maxProgressSoFar = percentDone;
                    progressCallback.done(percentDone);
                }
            }
        } : null;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        int position = 0;
        int totalLength = this.content.length;
        while (position < totalLength) {
            int length = totalLength - position;
            length = Math.min(length, 4096);
            outstream.write(this.content, position, length);
            outstream.flush();
            int progress = 100 * (position += length) / totalLength;
            this.reportProgressIfNeeded(progress);
        }
    }

    private void reportProgressIfNeeded(int progress) {
        ParseTaskUtils.callbackOnMainThreadAsync(Task.forResult((Object)progress), this.progressCallback);
    }
}

