/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.GetCallback;
import com.parse.Parse;
import com.parse.ParseClassName;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseRESTSessionCommand;
import com.parse.ParseUser;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

@ParseClassName(value="_Session")
public class ParseSession
extends ParseObject {
    private static final String KEY_SESSION_TOKEN = "sessionToken";
    private static final String KEY_CREATED_WITH = "createdWith";
    private static final String KEY_RESTRICTED = "restricted";
    private static final String KEY_USER = "user";
    private static final String KEY_EXPIRES_AT = "expiresAt";
    private static final String KEY_INSTALLATION_ID = "installationId";
    private static final List<String> READ_ONLY_KEYS = Collections.unmodifiableList(Arrays.asList("sessionToken", "createdWith", "restricted", "user", "expiresAt", "installationId"));

    public static Task<ParseSession> getCurrentSessionInBackground() {
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<JSONObject>>(){

            public Task<JSONObject> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                if (sessionToken == null) {
                    return Task.forResult(null);
                }
                return ParseRESTSessionCommand.getCurrentSessionCommand(sessionToken).executeAsync().cast();
            }
        }).onSuccess((Continuation)new Continuation<JSONObject, ParseSession>(){

            public ParseSession then(Task<JSONObject> task) throws Exception {
                JSONObject json = (JSONObject)task.getResult();
                if (json == null) {
                    return null;
                }
                return (ParseSession)ParseObject.fromJSON(json, "_Session", true);
            }
        });
    }

    public static void getCurrentSessionInBackground(GetCallback<ParseSession> callback) {
        Parse.callbackOnMainThreadAsync(ParseSession.getCurrentSessionInBackground(), callback);
    }

    public static ParseQuery<ParseSession> getQuery() {
        return ParseQuery.getQuery(ParseSession.class);
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }

    @Override
    boolean isKeyMutable(String key) {
        return !READ_ONLY_KEYS.contains(key);
    }

    public String getSessionToken() {
        return this.getString(KEY_SESSION_TOKEN);
    }
}

