/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.CountCallback;
import com.parse.FindCallback;
import com.parse.GetCallback;
import com.parse.OfflineStore;
import com.parse.Parse;
import com.parse.ParseCallback2;
import com.parse.ParseException;
import com.parse.ParseGeoPoint;
import com.parse.ParseKeyValueCache;
import com.parse.ParseObject;
import com.parse.ParseObjectEncodingStrategy;
import com.parse.ParsePin;
import com.parse.ParseRESTCommand;
import com.parse.ParseRESTQueryCommand;
import com.parse.ParseRelation;
import com.parse.ParseUser;
import com.parse.PointerEncodingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseQuery<T extends ParseObject> {
    private static final String TAG = "com.parse.ParseQuery";
    private String className;
    private QueryConstraints where;
    private ArrayList<String> include;
    private ArrayList<String> selectedKeys;
    private int limit;
    private boolean trace;
    private int skip;
    private String order;
    private HashMap<String, Object> extraOptions = null;
    private long queryStart;
    private long querySent;
    private long queryReceived;
    private long objectsParsed;
    private final Object isRunningLock = new Object();
    private boolean isRunning = false;
    private Task.TaskCompletionSource ct;
    private CachePolicy cachePolicy;
    private boolean isFromLocalDatastore;
    private long maxCacheAge;
    private String pinName;
    boolean ignoreACLs;
    boolean includeIsDeletingEventually;

    public static <T extends ParseObject> ParseQuery<T> or(List<ParseQuery<T>> queries) {
        ArrayList<ParseQuery<T>> localList = new ArrayList<ParseQuery<T>>();
        String className = null;
        for (int i = 0; i < queries.size(); ++i) {
            if (className != null && !queries.get((int)i).className.equals(className)) {
                throw new IllegalArgumentException("All of the queries in an or query must be on the same class ");
            }
            className = queries.get((int)i).className;
            localList.add(queries.get(i));
        }
        if (localList.size() == 0) {
            throw new IllegalArgumentException("Can't take an or of an empty list of queries");
        }
        ParseQuery<T> value = new ParseQuery<T>(className);
        return super.whereSatifiesAnyOf(localList);
    }

    public static <T extends ParseObject> ParseQuery<T> getQuery(Class<T> subclass) {
        return new ParseQuery<T>(subclass);
    }

    public static <T extends ParseObject> ParseQuery<T> getQuery(String className) {
        return new ParseQuery<T>(className);
    }

    @Deprecated
    public static ParseQuery<ParseUser> getUserQuery() {
        return ParseUser.getQuery();
    }

    public ParseQuery(Class<T> subclass) {
        this(ParseObject.getClassName(subclass));
    }

    public ParseQuery(String theClassName) {
        this.className = theClassName;
        this.limit = -1;
        this.skip = 0;
        this.where = new QueryConstraints();
        this.include = new ArrayList();
        this.cachePolicy = CachePolicy.IGNORE_CACHE;
        this.isFromLocalDatastore = false;
        this.maxCacheAge = Long.MAX_VALUE;
        this.trace = false;
        this.extraOptions = new HashMap();
    }

    private void checkIfRunning() {
        this.checkIfRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfRunning(boolean grabLock) {
        Object object = this.isRunningLock;
        synchronized (object) {
            if (this.isRunning) {
                throw new RuntimeException("This query has an outstanding network connection. You have to wait until it's done.");
            }
            if (grabLock) {
                this.isRunning = true;
                this.ct = Task.create();
            }
        }
    }

    QueryConstraints getConstraints() {
        return this.where;
    }

    private Task<ParseUser> getUserAsync() {
        return this.ignoreACLs ? Task.forResult(null) : ParseUser.getCurrentUserAsync();
    }

    JSONObject toREST() {
        JSONObject params = new JSONObject();
        try {
            params.put("className", (Object)this.className);
            params.put("where", Parse.encode(this.where, PointerEncodingStrategy.get()));
            if (this.limit >= 0) {
                params.put("limit", this.limit);
            }
            if (this.skip > 0) {
                params.put("skip", this.skip);
            }
            if (this.order != null) {
                params.put("order", (Object)this.order);
            }
            if (!this.include.isEmpty()) {
                params.put("include", (Object)Parse.join(",", this.include));
            }
            if (this.selectedKeys != null) {
                params.put("fields", (Object)Parse.join(",", this.selectedKeys));
            }
            if (this.trace) {
                params.put("trace", (Object)"1");
            }
            for (String key : this.extraOptions.keySet()) {
                params.put(key, Parse.encode(this.extraOptions.get(key), PointerEncodingStrategy.get()));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return params;
    }

    private ParseRESTQueryCommand currentFindCommand(ParseUser user) {
        String sessionToken = user != null ? user.getSessionToken() : null;
        return ParseRESTQueryCommand.findCommand(this.className, this.order, this.where, this.selectedKeys, this.include, this.limit, this.skip, this.extraOptions, this.trace, sessionToken);
    }

    private ParseRESTCommand currentCountCommand(ParseUser user) {
        return ParseRESTQueryCommand.countCommand(this.currentFindCommand(user));
    }

    private List<T> convertFindResponse(JSONObject response) throws JSONException {
        ArrayList answer = new ArrayList();
        JSONArray results = response.getJSONArray("results");
        if (results == null) {
            Parse.logD(TAG, "null results in find response");
        } else {
            String resultClassName = response.optString("className");
            if (resultClassName.equals("")) {
                resultClassName = this.className;
            }
            for (int i = 0; i < results.length(); ++i) {
                JSONObject data = results.getJSONObject(i);
                Object object = ParseObject.fromJSON(data, resultClassName, this.selectedKeys == null);
                answer.add(object);
                RelationConstraint relation = (RelationConstraint)this.where.get("$relatedTo");
                if (relation == null) continue;
                relation.getRelation().addKnownObject((ParseObject)object);
            }
        }
        this.objectsParsed = System.nanoTime();
        if (response.has("trace")) {
            Object serverTrace = response.get("trace");
            Parse.logD("ParseQuery", String.format("Query pre-processing took %f seconds\n%s\nClient side parsing took %f seconds\n", Float.valueOf((float)(this.querySent - this.queryStart) / 1000000.0f), serverTrace, Float.valueOf((float)(this.objectsParsed - this.queryReceived) / 1000000.0f)));
        }
        return answer;
    }

    private <TResult> Task<TResult> runCommandWithPolicyAsync(final CommandDelegate<TResult> c, CachePolicy policy) {
        switch (policy) {
            case IGNORE_CACHE: 
            case NETWORK_ONLY: {
                return c.runOnNetworkAsync(true);
            }
            case CACHE_ONLY: {
                return c.runFromCacheAsync();
            }
            case CACHE_ELSE_NETWORK: {
                return c.runFromCacheAsync().continueWithTask(new Continuation<TResult, Task<TResult>>(){

                    public Task<TResult> then(Task<TResult> task) throws Exception {
                        if (task.isFaulted() && task.getError() instanceof ParseException) {
                            return c.runOnNetworkAsync(true);
                        }
                        return task;
                    }
                });
            }
            case NETWORK_ELSE_CACHE: {
                return c.runOnNetworkAsync(false).continueWithTask(new Continuation<TResult, Task<TResult>>(){

                    public Task<TResult> then(Task<TResult> task) throws Exception {
                        if (task.isFaulted() && task.getError() instanceof ParseException && ((ParseException)task.getError()).getCode() == 100) {
                            return c.runFromCacheAsync();
                        }
                        return task;
                    }
                });
            }
            case CACHE_THEN_NETWORK: {
                throw new RuntimeException("You cannot use the cache policy CACHE_THEN_NETWORK with find()");
            }
        }
        throw new RuntimeException("Unknown cache policy: " + (Object)((Object)this.cachePolicy));
    }

    private Task<Integer> countWithCachePolicyAsync(CachePolicy policy, final ParseUser user) {
        CommandDelegate<Integer> callbacks = new CommandDelegate<Integer>(){

            @Override
            public Task<Integer> runOnNetworkAsync(boolean retry) {
                return ParseQuery.this.countFromNetworkAsync(user, retry);
            }

            @Override
            public Task<Integer> runFromCacheAsync() {
                return ParseQuery.this.countFromCacheAsync(user);
            }
        };
        return this.runCommandWithPolicyAsync(callbacks, policy);
    }

    Task<List<T>> findWithCachePolicyAsync(CachePolicy policy, final ParseUser user) {
        CommandDelegate callbacks = new CommandDelegate<List<T>>(){

            @Override
            public Task<List<T>> runOnNetworkAsync(boolean retry) {
                return ParseQuery.this.findFromNetworkAsync(user, retry);
            }

            @Override
            public Task<List<T>> runFromCacheAsync() {
                return ParseQuery.this.findFromCacheAsync(user);
            }
        };
        return this.runCommandWithPolicyAsync(callbacks, policy);
    }

    private Task<T> getFirstWithCachePolicyAsync(CachePolicy policy, ParseUser user) {
        this.limit = 1;
        return this.findWithCachePolicyAsync(policy, user).continueWith(new Continuation<List<T>, T>(){

            public T then(Task<List<T>> task) throws Exception {
                if (task.isFaulted()) {
                    throw task.getError();
                }
                if (task.getResult() != null && ((List)task.getResult()).size() > 0) {
                    return (ParseObject)((List)task.getResult()).get(0);
                }
                throw new ParseException(101, "no results found for query");
            }
        });
    }

    private Task<T> getFirstFromLocalDatastoreAsync(ParseUser user) {
        this.limit = 1;
        return this.findFromLocalDatastoreAsync(user).continueWith(new Continuation<List<T>, T>(){

            public T then(Task<List<T>> task) throws Exception {
                if (task.isFaulted()) {
                    throw task.getError();
                }
                if (task.getResult() != null && ((List)task.getResult()).size() > 0) {
                    return (ParseObject)((List)task.getResult()).get(0);
                }
                throw new ParseException(101, "no results found for query");
            }
        });
    }

    private Task<T> getWithCachePolicyAsync(String objectId, CachePolicy policy, ParseUser user) {
        this.skip = -1;
        this.where = new QueryConstraints();
        this.where.put("objectId", objectId);
        return this.getFirstWithCachePolicyAsync(policy, user);
    }

    private Task<T> getFromLocalDatastoreAsync(String objectId, ParseUser user) {
        this.skip = -1;
        this.where = new QueryConstraints();
        this.where.put("objectId", objectId);
        return this.getFirstFromLocalDatastoreAsync(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.isRunningLock;
        synchronized (object) {
            if (this.ct != null) {
                this.ct.trySetCancelled();
                this.ct = null;
            }
            this.isRunning = false;
        }
    }

    public List<T> find() throws ParseException {
        return Parse.waitForTask(this.findInBackground());
    }

    public T getFirst() throws ParseException {
        return (T)((ParseObject)Parse.waitForTask(this.getFirstInBackground()));
    }

    private Task<List<T>> findFromNetworkAsync(ParseUser user, boolean shouldRetry) {
        final ParseRESTQueryCommand command = this.currentFindCommand(user);
        if (shouldRetry) {
            command.enableRetrying();
        }
        if (this.ct == null) {
            command.cancel();
        } else {
            this.ct.getTask().continueWith((Continuation)new Continuation<Void, Void>(){

                public Void then(Task<Void> task) throws Exception {
                    if (task.isCancelled()) {
                        command.cancel();
                    }
                    return null;
                }
            });
        }
        final boolean caching = this.cachePolicy != CachePolicy.IGNORE_CACHE;
        this.querySent = System.nanoTime();
        return command.executeAsync().onSuccess(new Continuation<Object, List<T>>(){

            public List<T> then(Task<Object> task) throws Exception {
                if (caching) {
                    Object result = task.getResult();
                    ParseKeyValueCache.saveToKeyValueCache(command.getCacheKey(), result.toString());
                }
                ParseQuery.this.queryReceived = System.nanoTime();
                return ParseQuery.this.convertFindResponse((JSONObject)task.getResult());
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    private static void checkLDSEnabled(boolean enabled) {
        if (enabled && !OfflineStore.isEnabled()) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Parse#enableLocalDatastore(Context)`.");
        }
        if (!enabled && OfflineStore.isEnabled()) {
            throw new IllegalStateException("Unsupported method when Local Datastore is enabled.");
        }
    }

    public ParseQuery<T> setCachePolicy(CachePolicy newCachePolicy) {
        ParseQuery.checkLDSEnabled(false);
        this.checkIfRunning();
        this.cachePolicy = newCachePolicy;
        return this;
    }

    public CachePolicy getCachePolicy() {
        ParseQuery.checkLDSEnabled(false);
        return this.cachePolicy;
    }

    ParseQuery<T> fromNetwork() {
        ParseQuery.checkLDSEnabled(true);
        this.checkIfRunning();
        this.cachePolicy = CachePolicy.NETWORK_ONLY;
        this.isFromLocalDatastore = false;
        this.pinName = null;
        return this;
    }

    boolean isFromNetwork() {
        ParseQuery.checkLDSEnabled(true);
        return this.cachePolicy == CachePolicy.NETWORK_ONLY;
    }

    public ParseQuery<T> fromLocalDatastore() {
        return this.fromPin(null);
    }

    boolean isFromLocalDatastore() {
        ParseQuery.checkLDSEnabled(true);
        return this.isFromLocalDatastore;
    }

    public ParseQuery<T> fromPin() {
        return this.fromPin("_default");
    }

    public ParseQuery<T> fromPin(String name) {
        ParseQuery.checkLDSEnabled(true);
        this.checkIfRunning();
        this.isFromLocalDatastore = true;
        this.pinName = name;
        return this;
    }

    public ParseQuery<T> ignoreACLs() {
        ParseQuery.checkLDSEnabled(true);
        this.checkIfRunning();
        this.ignoreACLs = true;
        return this;
    }

    public ParseQuery<T> setMaxCacheAge(long maxAgeInMilliseconds) {
        ParseQuery.checkLDSEnabled(false);
        this.maxCacheAge = maxAgeInMilliseconds;
        return this;
    }

    public long getMaxCacheAge() {
        ParseQuery.checkLDSEnabled(false);
        return this.maxCacheAge;
    }

    private ParseQuery<T> build() {
        if (!this.isFromLocalDatastore && this.ignoreACLs) {
            throw new IllegalStateException("`ignoreACLs` cannot be combined with network queries");
        }
        return this;
    }

    private Task<List<T>> findFromCacheAsync(final ParseUser user) {
        return Task.call((Callable)new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                String cacheKey = ParseQuery.this.currentFindCommand(user).getCacheKey();
                Object cached = ParseKeyValueCache.jsonFromKeyValueCache(cacheKey, ParseQuery.this.maxCacheAge);
                if (cached == null) {
                    throw new ParseException(120, "results not cached");
                }
                if (!(cached instanceof JSONObject)) {
                    throw new ParseException(120, "the cache contains the wrong datatype");
                }
                JSONObject object = (JSONObject)cached;
                try {
                    return ParseQuery.this.convertFindResponse(object);
                }
                catch (JSONException e) {
                    throw new ParseException(120, "the cache contains corrupted json");
                }
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    private Task<Integer> countFromCacheAsync(final ParseUser user) {
        return Task.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                String cacheKey = ParseQuery.this.currentCountCommand(user).getCacheKey();
                Object cached = ParseKeyValueCache.jsonFromKeyValueCache(cacheKey, ParseQuery.this.maxCacheAge);
                if (cached == null) {
                    throw new ParseException(120, "results not cached");
                }
                if (!(cached instanceof JSONObject)) {
                    throw new ParseException(120, "the cache contains the wrong datatype");
                }
                JSONObject object = (JSONObject)cached;
                try {
                    return object.getInt("count");
                }
                catch (JSONException e) {
                    throw new ParseException(120, "the cache contains corrupted json");
                }
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    private Task<List<T>> findFromLocalDatastoreAsync(final ParseUser user) {
        final OfflineStore store = OfflineStore.getCurrent();
        Task<ParsePin> task = this.pinName != null ? ParsePin.getParsePin(this.pinName) : Task.forResult(null);
        return task.onSuccessTask(new Continuation<ParsePin, Task<List<T>>>(){

            public Task<List<T>> then(Task<ParsePin> task) throws Exception {
                ParsePin pin = (ParsePin)task.getResult();
                return store.findAsync(ParseQuery.this, user, pin);
            }
        });
    }

    private Task<Integer> countFromLocalDatastoreAsync(final ParseUser user) {
        final OfflineStore store = OfflineStore.getCurrent();
        Task<ParsePin> task = this.pinName != null ? ParsePin.getParsePin(this.pinName) : Task.forResult(null);
        return task.onSuccessTask((Continuation)new Continuation<ParsePin, Task<Integer>>(){

            public Task<Integer> then(Task<ParsePin> task) throws Exception {
                ParsePin pin = (ParsePin)task.getResult();
                return store.countAsync(ParseQuery.this, user, pin);
            }
        });
    }

    private <TResult> Task<TResult> doWithRunningCheck(Callable<Task<TResult>> runnable) {
        Task task;
        this.checkIfRunning(true);
        try {
            task = runnable.call();
        }
        catch (Exception e) {
            task = Task.forError((Exception)e);
        }
        return task.continueWithTask(new Continuation<TResult, Task<TResult>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<TResult> then(Task<TResult> task) throws Exception {
                Object object = ParseQuery.this.isRunningLock;
                synchronized (object) {
                    ParseQuery.this.isRunning = false;
                    if (ParseQuery.this.ct != null) {
                        ParseQuery.this.ct.trySetResult(null);
                    }
                    ParseQuery.this.ct = null;
                }
                return task;
            }
        });
    }

    private <TResult> void doInBackground(final CallableWithCachePolicy<Task<TResult>> callable, final ParseCallback2<TResult, ParseException> callback) {
        Parse.callbackOnMainThreadAsync(this.doWithRunningCheck(new Callable<Task<TResult>>(){

            @Override
            public Task<TResult> call() throws Exception {
                Task findTask;
                if (ParseQuery.this.cachePolicy == CachePolicy.CACHE_THEN_NETWORK) {
                    findTask = (Task)callable.call(CachePolicy.CACHE_ONLY);
                    findTask = Parse.callbackOnMainThreadAsync(findTask, callback);
                    findTask = findTask.continueWithTask(new Continuation<TResult, Task<TResult>>(){

                        public Task<TResult> then(Task<TResult> task) throws Exception {
                            if (task.isCancelled()) {
                                return task;
                            }
                            return (Task)callable.call(CachePolicy.NETWORK_ONLY);
                        }
                    });
                } else {
                    findTask = (Task)callable.call(ParseQuery.this.cachePolicy);
                }
                return findTask;
            }
        }), callback);
    }

    public Task<List<T>> findInBackground() {
        this.build();
        return this.doWithRunningCheck(new Callable<Task<List<T>>>(){

            @Override
            public Task<List<T>> call() throws Exception {
                return ParseQuery.this.getUserAsync().onSuccessTask(new Continuation<ParseUser, Task<List<T>>>(){

                    public Task<List<T>> then(Task<ParseUser> task) throws Exception {
                        ParseUser user = (ParseUser)task.getResult();
                        ParseQuery.this.queryStart = System.nanoTime();
                        if (ParseQuery.this.isFromLocalDatastore) {
                            return ParseQuery.this.findFromLocalDatastoreAsync(user);
                        }
                        return ParseQuery.this.findWithCachePolicyAsync(ParseQuery.this.cachePolicy, user);
                    }
                });
            }
        });
    }

    public void findInBackground(FindCallback<T> callback) {
        this.build();
        if (this.isFromLocalDatastore) {
            Parse.callbackOnMainThreadAsync(this.doWithRunningCheck(new Callable<Task<List<T>>>(){

                @Override
                public Task<List<T>> call() throws Exception {
                    return ParseQuery.this.getUserAsync().onSuccessTask(new Continuation<ParseUser, Task<List<T>>>(){

                        public Task<List<T>> then(Task<ParseUser> task) throws Exception {
                            ParseUser user = (ParseUser)task.getResult();
                            ParseQuery.this.queryStart = System.nanoTime();
                            return ParseQuery.this.findFromLocalDatastoreAsync(user);
                        }
                    });
                }
            }), callback);
        } else {
            this.doInBackground(new CallableWithCachePolicy<Task<List<T>>>(){

                @Override
                public Task<List<T>> call(final CachePolicy cachePolicy) {
                    return ParseQuery.this.getUserAsync().onSuccessTask(new Continuation<ParseUser, Task<List<T>>>(){

                        public Task<List<T>> then(Task<ParseUser> task) throws Exception {
                            ParseUser user = (ParseUser)task.getResult();
                            ParseQuery.this.queryStart = System.nanoTime();
                            return ParseQuery.this.findWithCachePolicyAsync(cachePolicy, user);
                        }
                    });
                }
            }, callback);
        }
    }

    public Task<T> getFirstInBackground() {
        this.build();
        return this.doWithRunningCheck(new Callable<Task<T>>(){

            @Override
            public Task<T> call() throws Exception {
                return ParseQuery.this.getUserAsync().onSuccessTask(new Continuation<ParseUser, Task<T>>(){

                    public Task<T> then(Task<ParseUser> task) throws Exception {
                        ParseUser user = (ParseUser)task.getResult();
                        ParseQuery.this.queryStart = System.nanoTime();
                        if (ParseQuery.this.isFromLocalDatastore) {
                            return ParseQuery.this.getFirstFromLocalDatastoreAsync(user);
                        }
                        return ParseQuery.this.getFirstWithCachePolicyAsync(ParseQuery.this.cachePolicy, user);
                    }
                });
            }
        });
    }

    public void getFirstInBackground(GetCallback<T> callback) {
        this.build();
        if (this.isFromLocalDatastore) {
            Parse.callbackOnMainThreadAsync(this.doWithRunningCheck(new Callable<Task<T>>(){

                @Override
                public Task<T> call() throws Exception {
                    return ParseQuery.this.getUserAsync().onSuccessTask(new Continuation<ParseUser, Task<T>>(){

                        public Task<T> then(Task<ParseUser> task) throws Exception {
                            ParseUser user = (ParseUser)task.getResult();
                            ParseQuery.this.queryStart = System.nanoTime();
                            return ParseQuery.this.getFirstFromLocalDatastoreAsync(user);
                        }
                    });
                }
            }), callback);
        } else {
            this.doInBackground(new CallableWithCachePolicy<Task<T>>(){

                @Override
                public Task<T> call(final CachePolicy cachePolicy) {
                    return ParseQuery.this.getUserAsync().onSuccessTask(new Continuation<ParseUser, Task<T>>(){

                        public Task<T> then(Task<ParseUser> task) throws Exception {
                            ParseUser user = (ParseUser)task.getResult();
                            ParseQuery.this.queryStart = System.nanoTime();
                            return ParseQuery.this.getFirstWithCachePolicyAsync(cachePolicy, user);
                        }
                    });
                }
            }, callback);
        }
    }

    public int count() throws ParseException {
        return Parse.waitForTask(this.countInBackground());
    }

    private Task<Integer> countFromNetworkAsync(ParseUser user, boolean shouldRetry) {
        final ParseRESTCommand command = this.currentCountCommand(user);
        if (shouldRetry) {
            command.enableRetrying();
        }
        if (this.ct == null) {
            command.cancel();
        } else {
            this.ct.getTask().continueWith((Continuation)new Continuation<Void, Void>(){

                public Void then(Task<Void> task) throws Exception {
                    if (task.isCancelled()) {
                        command.cancel();
                    }
                    return null;
                }
            });
        }
        final boolean caching = this.cachePolicy != CachePolicy.IGNORE_CACHE;
        return command.executeAsync().onSuccessTask((Continuation)new Continuation<Object, Task<Object>>(){

            public Task<Object> then(Task<Object> task) throws Exception {
                if (caching) {
                    Object result = task.getResult();
                    ParseKeyValueCache.saveToKeyValueCache(command.getCacheKey(), result.toString());
                }
                return task;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR).onSuccess((Continuation)new Continuation<Object, Integer>(){

            public Integer then(Task<Object> task) throws Exception {
                return ((JSONObject)task.getResult()).optInt("count");
            }
        });
    }

    public Task<Integer> countInBackground() {
        this.build();
        return this.doWithRunningCheck(new Callable<Task<Integer>>(){

            @Override
            public Task<Integer> call() throws Exception {
                return ParseQuery.this.getUserAsync().onSuccessTask((Continuation)new Continuation<ParseUser, Task<Integer>>(){

                    public Task<Integer> then(Task<ParseUser> task) throws Exception {
                        ParseUser user = (ParseUser)task.getResult();
                        ParseQuery.this.queryStart = System.nanoTime();
                        if (ParseQuery.this.isFromLocalDatastore) {
                            return ParseQuery.this.countFromLocalDatastoreAsync(user);
                        }
                        return ParseQuery.this.countWithCachePolicyAsync(ParseQuery.this.cachePolicy, user);
                    }
                });
            }
        });
    }

    public void countInBackground(final CountCallback callback) {
        this.build();
        ParseCallback2<Integer, ParseException> c = null;
        if (callback != null) {
            c = new ParseCallback2<Integer, ParseException>(){

                @Override
                public void done(Integer integer, ParseException e) {
                    callback.done(e == null ? integer : -1, e);
                }
            };
        }
        if (this.isFromLocalDatastore) {
            Parse.callbackOnMainThreadAsync(this.doWithRunningCheck(new Callable<Task<Integer>>(){

                @Override
                public Task<Integer> call() throws Exception {
                    return ParseQuery.this.getUserAsync().onSuccessTask((Continuation)new Continuation<ParseUser, Task<Integer>>(){

                        public Task<Integer> then(Task<ParseUser> task) throws Exception {
                            ParseUser user = (ParseUser)task.getResult();
                            ParseQuery.this.queryStart = System.nanoTime();
                            return ParseQuery.this.countFromLocalDatastoreAsync(user);
                        }
                    });
                }
            }), c);
        } else {
            this.doInBackground(new CallableWithCachePolicy<Task<Integer>>(){

                @Override
                public Task<Integer> call(final CachePolicy cachePolicy) {
                    return ParseQuery.this.getUserAsync().onSuccessTask((Continuation)new Continuation<ParseUser, Task<Integer>>(){

                        public Task<Integer> then(Task<ParseUser> task) throws Exception {
                            ParseUser user = (ParseUser)task.getResult();
                            ParseQuery.this.queryStart = System.nanoTime();
                            return ParseQuery.this.countWithCachePolicyAsync(cachePolicy, user);
                        }
                    });
                }
            }, c);
        }
    }

    public T get(String objectId) throws ParseException {
        return (T)((ParseObject)Parse.waitForTask(this.getInBackground(objectId)));
    }

    public boolean hasCachedResult() {
        ParseQuery.checkLDSEnabled(false);
        ParseUser user = null;
        try {
            user = Parse.waitForTask(this.getUserAsync());
        }
        catch (ParseException e) {
            // empty catch block
        }
        String raw = ParseKeyValueCache.loadFromKeyValueCache(this.currentFindCommand(user).getCacheKey(), this.maxCacheAge);
        return raw != null;
    }

    public void clearCachedResult() {
        ParseQuery.checkLDSEnabled(false);
        ParseUser user = null;
        try {
            user = Parse.waitForTask(this.getUserAsync());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        ParseKeyValueCache.clearFromKeyValueCache(this.currentFindCommand(user).getCacheKey());
    }

    public static void clearAllCachedResults() {
        ParseQuery.checkLDSEnabled(false);
        ParseKeyValueCache.clearKeyValueCacheDir();
    }

    public Task<T> getInBackground(final String objectId) {
        this.build();
        return this.doWithRunningCheck(new Callable<Task<T>>(){

            @Override
            public Task<T> call() throws Exception {
                return ParseQuery.this.getUserAsync().continueWithTask(new Continuation<ParseUser, Task<T>>(){

                    public Task<T> then(Task<ParseUser> task) throws Exception {
                        ParseUser user = (ParseUser)task.getResult();
                        ParseQuery.this.queryStart = System.nanoTime();
                        if (ParseQuery.this.isFromLocalDatastore) {
                            return ParseQuery.this.getFromLocalDatastoreAsync(objectId, user);
                        }
                        return ParseQuery.this.getWithCachePolicyAsync(objectId, ParseQuery.this.cachePolicy, user);
                    }
                });
            }
        });
    }

    public void getInBackground(final String objectId, GetCallback<T> callback) {
        this.build();
        if (this.isFromLocalDatastore) {
            Parse.callbackOnMainThreadAsync(this.doWithRunningCheck(new Callable<Task<T>>(){

                @Override
                public Task<T> call() throws Exception {
                    return ParseQuery.this.getUserAsync().onSuccessTask(new Continuation<ParseUser, Task<T>>(){

                        public Task<T> then(Task<ParseUser> task) throws Exception {
                            ParseUser user = (ParseUser)task.getResult();
                            ParseQuery.this.queryStart = System.nanoTime();
                            return ParseQuery.this.getFromLocalDatastoreAsync(objectId, user);
                        }
                    });
                }
            }), callback);
        } else {
            this.doInBackground(new CallableWithCachePolicy<Task<T>>(){

                @Override
                public Task<T> call(final CachePolicy cachePolicy) {
                    return ParseQuery.this.getUserAsync().onSuccessTask(new Continuation<ParseUser, Task<T>>(){

                        public Task<T> then(Task<ParseUser> task) throws Exception {
                            ParseUser user = (ParseUser)task.getResult();
                            ParseQuery.this.queryStart = System.nanoTime();
                            return ParseQuery.this.getWithCachePolicyAsync(objectId, cachePolicy, user);
                        }
                    });
                }
            }, callback);
        }
    }

    public ParseQuery<T> whereEqualTo(String key, Object value) {
        this.checkIfRunning();
        this.where.put(key, value);
        return this;
    }

    private ParseQuery<T> addCondition(String key, String condition, Object value) {
        Object existingValue;
        this.checkIfRunning();
        KeyConstraints whereValue = null;
        if (this.where.containsKey(key) && (existingValue = this.where.get(key)) instanceof KeyConstraints) {
            whereValue = (KeyConstraints)existingValue;
        }
        if (whereValue == null) {
            whereValue = new KeyConstraints();
        }
        whereValue.put(condition, value);
        this.where.put(key, whereValue);
        return this;
    }

    public ParseQuery<T> whereLessThan(String key, Object value) {
        return this.addCondition(key, "$lt", value);
    }

    public ParseQuery<T> whereNotEqualTo(String key, Object value) {
        return this.addCondition(key, "$ne", value);
    }

    public ParseQuery<T> whereGreaterThan(String key, Object value) {
        return this.addCondition(key, "$gt", value);
    }

    public ParseQuery<T> whereLessThanOrEqualTo(String key, Object value) {
        return this.addCondition(key, "$lte", value);
    }

    public ParseQuery<T> whereGreaterThanOrEqualTo(String key, Object value) {
        return this.addCondition(key, "$gte", value);
    }

    public ParseQuery<T> whereContainedIn(String key, Collection<? extends Object> values) {
        return this.addCondition(key, "$in", new ArrayList<Object>(values));
    }

    public ParseQuery<T> whereContainsAll(String key, Collection<?> values) {
        return this.addCondition(key, "$all", new ArrayList(values));
    }

    public ParseQuery<T> whereMatchesQuery(String key, ParseQuery<?> query) {
        return this.addCondition(key, "$inQuery", query);
    }

    public ParseQuery<T> whereDoesNotMatchQuery(String key, ParseQuery<?> query) {
        return this.addCondition(key, "$notInQuery", query);
    }

    public ParseQuery<T> whereMatchesKeyInQuery(String key, String keyInQuery, ParseQuery<?> query) {
        JSONObject condition = new JSONObject();
        try {
            condition.put("key", (Object)keyInQuery);
            condition.put("query", query);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return this.addCondition(key, "$select", condition);
    }

    public ParseQuery<T> whereDoesNotMatchKeyInQuery(String key, String keyInQuery, ParseQuery<?> query) {
        JSONObject condition = new JSONObject();
        try {
            condition.put("key", (Object)keyInQuery);
            condition.put("query", query);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return this.addCondition(key, "$dontSelect", condition);
    }

    private ParseQuery<T> whereSatifiesAnyOf(List<ParseQuery<? extends T>> queries) {
        ArrayList<QueryConstraints> constraints = new ArrayList<QueryConstraints>();
        for (ParseQuery<T> query : queries) {
            if (query.limit >= 0) {
                throw new IllegalArgumentException("Cannot have limits in sub queries of an 'OR' query");
            }
            if (query.skip > 0) {
                throw new IllegalArgumentException("Cannot have skips in sub queries of an 'OR' query");
            }
            if (query.order != null) {
                throw new IllegalArgumentException("Cannot have an order in sub queries of an 'OR' query");
            }
            if (!query.include.isEmpty()) {
                throw new IllegalArgumentException("Cannot have an include in sub queries of an 'OR' query");
            }
            if (query.selectedKeys != null) {
                throw new IllegalArgumentException("Cannot have an selectKeys in sub queries of an 'OR' query");
            }
            constraints.add(query.getConstraints());
        }
        this.where.put("$or", constraints);
        return this;
    }

    public ParseQuery<T> whereNotContainedIn(String key, Collection<? extends Object> values) {
        return this.addCondition(key, "$nin", new ArrayList<Object>(values));
    }

    public ParseQuery<T> whereNear(String key, ParseGeoPoint point) {
        return this.addCondition(key, "$nearSphere", point);
    }

    public ParseQuery<T> whereWithinMiles(String key, ParseGeoPoint point, double maxDistance) {
        return this.whereWithinRadians(key, point, maxDistance / ParseGeoPoint.EARTH_MEAN_RADIUS_MILE);
    }

    public ParseQuery<T> whereWithinKilometers(String key, ParseGeoPoint point, double maxDistance) {
        return this.whereWithinRadians(key, point, maxDistance / ParseGeoPoint.EARTH_MEAN_RADIUS_KM);
    }

    public ParseQuery<T> whereWithinRadians(String key, ParseGeoPoint point, double maxDistance) {
        this.addCondition(key, "$nearSphere", point);
        return this.addCondition(key, "$maxDistance", maxDistance);
    }

    public ParseQuery<T> whereWithinGeoBox(String key, ParseGeoPoint southwest, ParseGeoPoint northeast) {
        ArrayList<ParseGeoPoint> array = new ArrayList<ParseGeoPoint>();
        array.add(southwest);
        array.add(northeast);
        HashMap<String, ArrayList<ParseGeoPoint>> dictionary = new HashMap<String, ArrayList<ParseGeoPoint>>();
        dictionary.put("$box", array);
        return this.addCondition(key, "$within", dictionary);
    }

    public ParseQuery<T> whereMatches(String key, String regex) {
        return this.addCondition(key, "$regex", regex);
    }

    public ParseQuery<T> whereMatches(String key, String regex, String modifiers) {
        this.addCondition(key, "$regex", regex);
        if (modifiers.length() != 0) {
            this.addCondition(key, "$options", modifiers);
        }
        return this;
    }

    public ParseQuery<T> whereContains(String key, String substring) {
        String regex = Pattern.quote(substring);
        this.whereMatches(key, regex);
        return this;
    }

    public ParseQuery<T> whereStartsWith(String key, String prefix) {
        String regex = "^" + Pattern.quote(prefix);
        this.whereMatches(key, regex);
        return this;
    }

    public ParseQuery<T> whereEndsWith(String key, String suffix) {
        String regex = Pattern.quote(suffix) + "$";
        this.whereMatches(key, regex);
        return this;
    }

    public ParseQuery<T> include(String key) {
        this.checkIfRunning();
        this.include.add(key);
        return this;
    }

    List<String> getIncludes() {
        return Collections.unmodifiableList(this.include);
    }

    public ParseQuery<T> selectKeys(Collection<String> keys) {
        this.checkIfRunning();
        if (this.selectedKeys == null) {
            this.selectedKeys = new ArrayList();
        }
        this.selectedKeys.addAll(keys);
        return this;
    }

    public ParseQuery<T> whereExists(String key) {
        return this.addCondition(key, "$exists", true);
    }

    public ParseQuery<T> whereDoesNotExist(String key) {
        return this.addCondition(key, "$exists", false);
    }

    ParseQuery<T> whereRelatedTo(ParseObject parent, String key) {
        this.where.put("$relatedTo", new RelationConstraint(key, parent));
        return this;
    }

    ParseQuery<T> redirectClassNameForKey(String key) {
        this.extraOptions.put("redirectClassNameForKey", key);
        return this;
    }

    public ParseQuery<T> orderByAscending(String key) {
        this.checkIfRunning();
        this.order = key;
        return this;
    }

    public ParseQuery<T> addAscendingOrder(String key) {
        this.checkIfRunning();
        this.order = this.order == null ? key : this.order + "," + key;
        return this;
    }

    public ParseQuery<T> orderByDescending(String key) {
        this.checkIfRunning();
        this.order = "-" + key;
        return this;
    }

    public ParseQuery<T> addDescendingOrder(String key) {
        this.checkIfRunning();
        this.order = this.order == null ? "-" + key : this.order + ",-" + key;
        return this;
    }

    String[] sortKeys() {
        if (this.order == null) {
            return new String[0];
        }
        return this.order.split(",");
    }

    public ParseQuery<T> setLimit(int newLimit) {
        this.checkIfRunning();
        this.limit = newLimit;
        return this;
    }

    public ParseQuery<T> setTrace(boolean shouldTrace) {
        this.checkIfRunning();
        this.trace = shouldTrace;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public ParseQuery<T> setSkip(int newSkip) {
        this.checkIfRunning();
        this.skip = newSkip;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public String getClassName() {
        return this.className;
    }

    private static interface CommandDelegate<T> {
        public Task<T> runOnNetworkAsync(boolean var1);

        public Task<T> runFromCacheAsync();
    }

    private static interface CallableWithCachePolicy<TResult> {
        public TResult call(CachePolicy var1);
    }

    public static enum CachePolicy {
        IGNORE_CACHE,
        CACHE_ONLY,
        NETWORK_ONLY,
        CACHE_ELSE_NETWORK,
        NETWORK_ELSE_CACHE,
        CACHE_THEN_NETWORK;

    }

    static class RelationConstraint {
        private String key;
        private ParseObject object;

        public RelationConstraint(String key, ParseObject object) {
            if (key == null || object == null) {
                throw new IllegalArgumentException("Arguments must not be null.");
            }
            this.key = key;
            this.object = object;
        }

        public String getKey() {
            return this.key;
        }

        public ParseObject getObject() {
            return this.object;
        }

        public ParseRelation<ParseObject> getRelation() {
            return this.object.getRelation(this.key);
        }

        public JSONObject encode(ParseObjectEncodingStrategy objectEncoder) {
            JSONObject json = new JSONObject();
            try {
                json.put("key", (Object)this.key);
                json.put("object", (Object)objectEncoder.encodeRelatedObject(this.object));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return json;
        }
    }

    static class KeyConstraints
    extends HashMap<String, Object> {
        KeyConstraints() {
        }
    }

    static class QueryConstraints
    extends HashMap<String, Object> {
        QueryConstraints() {
        }
    }
}

