/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ParseUser;
import org.json.JSONObject;

abstract class ParseAuthenticationProvider {
    ParseAuthenticationProvider() {
    }

    public abstract String getAuthType();

    public abstract Task<JSONObject> authenticateAsync();

    public abstract void deauthenticate();

    public abstract boolean restoreAuthentication(JSONObject var1);

    public abstract void cancel();

    public Task<ParseUser> logInAsync() {
        return this.authenticateAsync().onSuccessTask((Continuation)new Continuation<JSONObject, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<JSONObject> task) throws Exception {
                return ParseAuthenticationProvider.this.logInAsync((JSONObject)task.getResult());
            }
        });
    }

    public Task<ParseUser> logInAsync(JSONObject authData) {
        return ParseUser.logInWithAsync(this.getAuthType(), authData);
    }

    public Task<Void> linkAsync(final ParseUser user) {
        return this.authenticateAsync().onSuccessTask((Continuation)new Continuation<JSONObject, Task<Void>>(){

            public Task<Void> then(Task<JSONObject> task) throws Exception {
                return ParseAuthenticationProvider.this.linkAsync(user, (JSONObject)task.getResult());
            }
        });
    }

    public Task<Void> linkAsync(ParseUser user, JSONObject authData) {
        return user.linkWithAsync(this.getAuthType(), authData);
    }

    public Task<Void> unlinkAsync(ParseUser user) {
        return user.unlinkFromAsync(this.getAuthType());
    }

    static interface ParseAuthenticationCallback {
        public void onSuccess(JSONObject var1);

        public void onCancel();

        public void onError(Throwable var1);
    }
}

