/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.os.Build;
import com.parse.ParseHttpClient;
import com.parse.ParseHttpResponse;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

class ParseApacheHttpClient
extends ParseHttpClient {
    private static final int SOCKET_OPERATION_TIMEOUT = 10000;
    private DefaultHttpClient httpClient;

    public ParseApacheHttpClient(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context passed to newHttpClient should not be null.");
        }
        context = context.getApplicationContext();
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)10000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)10000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        SSLSessionCache sessionCache = new SSLSessionCache(context);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)this.getUserAgent(context));
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLCertificateSocketFactory.getHttpSocketFactory((int)10000, (SSLSessionCache)sessionCache), 443));
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(20));
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)20);
        String host = System.getProperty("http.proxyHost");
        String portString = System.getProperty("http.proxyPort");
        if (host != null && host.length() != 0 && portString != null && portString.length() != 0) {
            int port = Integer.parseInt(portString);
            HttpHost proxy = new HttpHost(host, port, "http");
            params.setParameter("http.route.default-proxy", (Object)proxy);
        }
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)params);
    }

    private String getUserAgent(Context context) {
        String packageVersion = "unknown";
        try {
            String packageName = context.getPackageName();
            int versionCode = context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
            packageVersion = packageName + "/" + versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return "Parse Android SDK 1.9.1 (" + packageVersion + ") API Level " + Build.VERSION.SDK_INT;
    }

    @Override
    public ParseHttpResponse execute(HttpUriRequest request) throws IOException {
        HttpResponse response = this.httpClient.execute(request);
        return ParseHttpResponse.createParseApacheHttpResponse(response);
    }
}

