/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.CountingMultipartEntity;
import com.parse.Parse;
import com.parse.ParseCallback2;
import com.parse.ParseException;
import com.parse.ParseHttpResponse;
import com.parse.ParseIOUtils;
import com.parse.ParseRequest;
import com.parse.ProgressCallback;
import com.parse.entity.mime.HttpMultipartMode;
import com.parse.entity.mime.content.ByteArrayBody;
import com.parse.entity.mime.content.StringBody;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.json.JSONException;
import org.json.JSONObject;

class ParseAWSRequest
extends ParseRequest<byte[], byte[]> {
    private String mimeType;
    private JSONObject postParams;
    private byte[] data;

    public ParseAWSRequest(String url) {
        super(url);
    }

    public ParseAWSRequest(ParseRequest.Method method, String url) {
        super(method, url);
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setPostParams(JSONObject postParams) {
        this.postParams = postParams;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    protected HttpEntity newEntity(ProgressCallback uploadProgressCallback) {
        CountingMultipartEntity entity = new CountingMultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, uploadProgressCallback);
        try {
            entity.addPart("Content-Type", new StringBody(this.mimeType));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        Iterator keys = this.postParams.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                entity.addPart(key, new StringBody(this.postParams.getString(key)));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        entity.addPart("file", new ByteArrayBody(this.data, this.mimeType, "file"));
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Task<byte[]> onResponse(ParseHttpResponse response, final ProgressCallback downloadProgressCallback) {
        int statusCode = response.getStatusCode();
        if ((statusCode < 200 || statusCode >= 300) && statusCode != 304) {
            String action = this.method == ParseRequest.Method.GET ? "Download from" : "Upload to";
            return Task.forError((Exception)new ParseException(100, String.format("%s S3 failed. %s", action, statusCode)));
        }
        if (this.method != ParseRequest.Method.GET) {
            return null;
        }
        int totalSize = response.getTotalSize();
        int downloadedSize = 0;
        InputStream responseStream = null;
        try {
            int nRead;
            responseStream = response.getContent();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[32768];
            ParseCallback2<Integer, ParseException> c = null;
            if (downloadProgressCallback != null) {
                c = new ParseCallback2<Integer, ParseException>(){
                    Integer maxProgressSoFar = 0;

                    @Override
                    public void done(Integer percentDone, ParseException e) {
                        if (percentDone > this.maxProgressSoFar) {
                            this.maxProgressSoFar = percentDone;
                            downloadProgressCallback.done(percentDone);
                        }
                    }
                };
            }
            while ((nRead = responseStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
                downloadedSize += nRead;
                if (c == null || totalSize == -1) continue;
                int progressToReport = Math.round((float)downloadedSize / (float)totalSize * 100.0f);
                Parse.callbackOnMainThreadAsync(Task.forResult((Object)progressToReport), c);
            }
            Task task = Task.forResult((Object)buffer.toByteArray());
            return task;
        }
        catch (IOException e) {
            Task task = Task.forError((Exception)e);
            return task;
        }
        finally {
            ParseIOUtils.closeQuietly(responseStream);
        }
    }
}

