/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;

class NotificationCompat {
    public static final int FLAG_HIGH_PRIORITY = 128;
    public static final int PRIORITY_DEFAULT = 0;
    private static final NotificationCompatImpl IMPL = Build.VERSION.SDK_INT >= 16 ? new NotificationCompatPostJellyBean() : new NotificationCompatImplBase();

    NotificationCompat() {
    }

    public static class Builder {
        private static final int MAX_CHARSEQUENCE_LENGTH = 5120;
        Context mContext;
        CharSequence mContentTitle;
        CharSequence mContentText;
        PendingIntent mContentIntent;
        Bitmap mLargeIcon;
        int mPriority;
        Style mStyle;
        Notification mNotification = new Notification();

        public Builder(Context context) {
            this.mContext = context;
            this.mNotification.when = System.currentTimeMillis();
            this.mNotification.audioStreamType = -1;
            this.mPriority = 0;
        }

        public Builder setWhen(long when) {
            this.mNotification.when = when;
            return this;
        }

        public Builder setSmallIcon(int icon) {
            this.mNotification.icon = icon;
            return this;
        }

        public Builder setSmallIcon(int icon, int level) {
            this.mNotification.icon = icon;
            this.mNotification.iconLevel = level;
            return this;
        }

        public Builder setContentTitle(CharSequence title) {
            this.mContentTitle = Builder.limitCharSequenceLength(title);
            return this;
        }

        public Builder setContentText(CharSequence text) {
            this.mContentText = Builder.limitCharSequenceLength(text);
            return this;
        }

        public Builder setContentIntent(PendingIntent intent) {
            this.mContentIntent = intent;
            return this;
        }

        public Builder setDeleteIntent(PendingIntent intent) {
            this.mNotification.deleteIntent = intent;
            return this;
        }

        public Builder setTicker(CharSequence tickerText) {
            this.mNotification.tickerText = Builder.limitCharSequenceLength(tickerText);
            return this;
        }

        public Builder setLargeIcon(Bitmap icon) {
            this.mLargeIcon = icon;
            return this;
        }

        public Builder setAutoCancel(boolean autoCancel) {
            this.setFlag(16, autoCancel);
            return this;
        }

        public Builder setDefaults(int defaults) {
            this.mNotification.defaults = defaults;
            if ((defaults & 4) != 0) {
                this.mNotification.flags |= 1;
            }
            return this;
        }

        private void setFlag(int mask, boolean value) {
            this.mNotification.flags = value ? (this.mNotification.flags |= mask) : (this.mNotification.flags &= ~mask);
        }

        public Builder setPriority(int pri) {
            this.mPriority = pri;
            return this;
        }

        public Builder setStyle(Style style) {
            if (this.mStyle != style) {
                this.mStyle = style;
                if (this.mStyle != null) {
                    this.mStyle.setBuilder(this);
                }
            }
            return this;
        }

        @Deprecated
        public Notification getNotification() {
            return IMPL.build(this);
        }

        public Notification build() {
            return IMPL.build(this);
        }

        protected static CharSequence limitCharSequenceLength(CharSequence cs) {
            if (cs == null) {
                return cs;
            }
            if (cs.length() > 5120) {
                cs = cs.subSequence(0, 5120);
            }
            return cs;
        }

        public static class BigTextStyle
        extends Style {
            CharSequence mBigText;

            public BigTextStyle() {
            }

            public BigTextStyle(Builder builder) {
                this.setBuilder(builder);
            }

            public BigTextStyle setBigContentTitle(CharSequence title) {
                this.mBigContentTitle = title;
                return this;
            }

            public BigTextStyle setSummaryText(CharSequence cs) {
                this.mSummaryText = cs;
                this.mSummaryTextSet = true;
                return this;
            }

            public BigTextStyle bigText(CharSequence cs) {
                this.mBigText = cs;
                return this;
            }
        }

        public static abstract class Style {
            Builder mBuilder;
            CharSequence mBigContentTitle;
            CharSequence mSummaryText;
            boolean mSummaryTextSet = false;

            public void setBuilder(Builder builder) {
                if (this.mBuilder != builder) {
                    this.mBuilder = builder;
                    if (this.mBuilder != null) {
                        this.mBuilder.setStyle(this);
                    }
                }
            }

            public Notification build() {
                Notification notification = null;
                if (this.mBuilder != null) {
                    notification = this.mBuilder.build();
                }
                return notification;
            }
        }
    }

    @TargetApi(value=16)
    static class NotificationCompatPostJellyBean
    implements NotificationCompatImpl {
        private Notification.Builder postJellyBeanBuilder;

        NotificationCompatPostJellyBean() {
        }

        @Override
        public Notification build(Builder b) {
            this.postJellyBeanBuilder = new Notification.Builder(b.mContext);
            this.postJellyBeanBuilder.setContentTitle(b.mContentTitle).setContentText(b.mContentText).setTicker(b.mNotification.tickerText).setSmallIcon(b.mNotification.icon, b.mNotification.iconLevel).setContentIntent(b.mContentIntent).setDeleteIntent(b.mNotification.deleteIntent).setAutoCancel((b.mNotification.flags & 0x10) != 0).setLargeIcon(b.mLargeIcon).setDefaults(b.mNotification.defaults);
            if (b.mStyle != null && b.mStyle instanceof Builder.BigTextStyle) {
                Builder.BigTextStyle staticStyle = (Builder.BigTextStyle)b.mStyle;
                Notification.BigTextStyle style = new Notification.BigTextStyle(this.postJellyBeanBuilder).setBigContentTitle(staticStyle.mBigContentTitle).bigText(staticStyle.mBigText);
                if (staticStyle.mSummaryTextSet) {
                    style.setSummaryText(staticStyle.mSummaryText);
                }
            }
            return this.postJellyBeanBuilder.build();
        }
    }

    static class NotificationCompatImplBase
    implements NotificationCompatImpl {
        NotificationCompatImplBase() {
        }

        @Override
        public Notification build(Builder b) {
            Notification result = b.mNotification;
            result.setLatestEventInfo(b.mContext, b.mContentTitle, b.mContentText, b.mContentIntent);
            if (b.mPriority > 0) {
                result.flags |= 0x80;
            }
            return result;
        }
    }

    static interface NotificationCompatImpl {
        public Notification build(Builder var1);
    }
}

