/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.webkit.MimeTypeMap;
import bolts.Continuation;
import bolts.Task;
import com.parse.GetDataCallback;
import com.parse.Parse;
import com.parse.ParseAWSRequest;
import com.parse.ParseCallback1;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseFileUtils;
import com.parse.ParseRESTCommand;
import com.parse.ParseRESTFileCommand;
import com.parse.ParseUser;
import com.parse.ProgressCallback;
import com.parse.SaveCallback;
import com.parse.TaskQueue;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseFile {
    private boolean dirty = false;
    private String name = null;
    private String url = null;
    private String contentType = null;
    byte[] data;
    final TaskQueue taskQueue = new TaskQueue();
    private Set<Task.TaskCompletionSource> currentTasks = Collections.synchronizedSet(new HashSet());

    static File getCacheDir() {
        return Parse.getParseCacheDir("files");
    }

    static File getFilesDir() {
        return Parse.getParseFilesDir("files");
    }

    static void clearCache() {
        for (File file : ParseFile.getCacheDir().listFiles()) {
            ParseFileUtils.deleteQuietly(file);
        }
    }

    public ParseFile(String name, byte[] data, String contentType) {
        if (data.length > Parse.maxParseFileSize) {
            throw new IllegalArgumentException(String.format("ParseFile must be less than %d bytes", Parse.maxParseFileSize));
        }
        this.name = name;
        this.data = data;
        this.contentType = contentType;
        this.dirty = true;
    }

    public ParseFile(byte[] data) {
        this(null, data, null);
    }

    public ParseFile(String name, byte[] data) {
        this(name, data, null);
    }

    public ParseFile(byte[] data, String contentType) {
        this(null, data, contentType);
    }

    ParseFile(String name, String url) {
        this.name = name;
        this.url = url;
    }

    private String getFilename() {
        return this.name;
    }

    File getCacheFile() {
        String filename = this.getFilename();
        return filename != null ? new File(ParseFile.getCacheDir(), filename) : null;
    }

    File getFilesFile() {
        String filename = this.getFilename();
        return filename != null ? new File(ParseFile.getFilesDir(), filename) : null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDataAvailable() {
        return this.data != null || (!this.isPinned() ? this.getCacheFile().exists() : this.getFilesFile().exists());
    }

    public String getUrl() {
        return this.url;
    }

    private byte[] getCachedData() {
        File file;
        if (this.data != null) {
            return this.data;
        }
        try {
            file = this.getCacheFile();
            if (file != null) {
                return ParseFileUtils.readFileToByteArray(file);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            file = this.getFilesFile();
            if (file != null) {
                return ParseFileUtils.readFileToByteArray(file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    boolean isPinned() {
        File file = this.getFilesFile();
        return file != null && file.exists();
    }

    void pin() throws ParseException {
        this.setPinned(true);
    }

    void unpin() throws ParseException {
        this.setPinned(false);
    }

    Task<Void> pinInBackground() {
        return this.setPinnedInBackground(true);
    }

    Task<Void> unpinInBackground() {
        return this.setPinnedInBackground(false);
    }

    void pinInBackground(ParseCallback1<ParseException> callback) {
        this.setPinnedInBackground(true, callback);
    }

    void unpinInBackground(ParseCallback1<ParseException> callback) {
        this.setPinnedInBackground(false, callback);
    }

    private void setPinned(boolean pinned) throws ParseException {
        Parse.waitForTask(this.setPinnedInBackground(pinned));
    }

    private void setPinnedInBackground(boolean pinned, ParseCallback1<ParseException> callback) {
        Parse.callbackOnMainThreadAsync(this.setPinnedInBackground(pinned), callback);
    }

    private Task<Void> setPinnedInBackground(final boolean pinned) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return task;
            }
        }).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                File dest;
                File src;
                if (pinned && ParseFile.this.isPinned() || !pinned && !ParseFile.this.isPinned()) {
                    return null;
                }
                if (pinned) {
                    src = ParseFile.this.getCacheFile();
                    dest = ParseFile.this.getFilesFile();
                } else {
                    src = ParseFile.this.getFilesFile();
                    dest = ParseFile.this.getCacheFile();
                }
                if (dest == null) {
                    throw new IllegalStateException("Unable to pin file before saving");
                }
                if (dest.exists()) {
                    ParseFileUtils.deleteQuietly(dest);
                }
                if (pinned && ParseFile.this.data != null) {
                    ParseFileUtils.writeByteArrayToFile(dest, ParseFile.this.data);
                    if (src.exists()) {
                        ParseFileUtils.deleteQuietly(src);
                    }
                    return null;
                }
                if (src == null || !src.exists()) {
                    throw new IllegalStateException("Unable to pin file before retrieving");
                }
                ParseFileUtils.moveFile(src, dest);
                return null;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    public void save() throws ParseException {
        Parse.waitForTask(this.saveInBackground());
    }

    private void save(ProgressCallback progressCallback) throws ParseException {
        Parse.waitForTask(this.saveInBackground(progressCallback));
    }

    Task<Void> saveAsync(final ProgressCallback uploadProgressCallback, Task<Void> toAwait) {
        if (!this.isDirty()) {
            return Task.forResult(null);
        }
        final Task.TaskCompletionSource tcs = Task.create();
        this.currentTasks.add(tcs);
        toAwait.continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                if (!ParseFile.this.isDirty()) {
                    tcs.trySetResult(null);
                    return null;
                }
                final String sessionToken = ParseUser.getCurrentSessionToken();
                Task.call((Callable)new Callable<ParseRESTCommand>(){

                    @Override
                    public ParseRESTCommand call() throws Exception {
                        String fileName = ParseFile.this.name != null ? ParseFile.this.name : "file";
                        String mimeType = null;
                        if (ParseFile.this.contentType != null) {
                            mimeType = ParseFile.this.contentType;
                        } else if (fileName.lastIndexOf(".") != -1) {
                            String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
                            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
                        }
                        if (mimeType == null) {
                            mimeType = "application/octet-stream";
                        }
                        final ParseRESTFileCommand command = ParseRESTFileCommand.uploadFileCommand(fileName, ParseFile.this.data, mimeType, sessionToken);
                        command.enableRetrying();
                        tcs.getTask().continueWith((Continuation)new Continuation<Void, Void>(){

                            public Void then(Task<Void> task) throws Exception {
                                if (task.isCancelled()) {
                                    command.cancel();
                                }
                                return null;
                            }
                        });
                        return command;
                    }
                }).onSuccessTask((Continuation)new Continuation<ParseRESTCommand, Task<Object>>(){

                    public Task<Object> then(Task<ParseRESTCommand> task) throws Exception {
                        return ((ParseRESTCommand)task.getResult()).executeAsync(uploadProgressCallback, null);
                    }
                }).onSuccessTask((Continuation)new Continuation<Object, Task<Void>>(){

                    public Task<Void> then(Task<Object> task) throws Exception {
                        JSONObject result = (JSONObject)task.getResult();
                        ParseFile.this.name = result.getString("name");
                        ParseFile.this.url = result.getString("url");
                        try {
                            ParseFileUtils.writeByteArrayToFile(ParseFile.this.getCacheFile(), ParseFile.this.data);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ParseFile.this.dirty = false;
                        return task.makeVoid();
                    }
                }).continueWith((Continuation)new Continuation<Void, Void>(){

                    public Void then(Task<Void> task) throws Exception {
                        ParseFile.this.currentTasks.remove(tcs);
                        if (task.isCancelled()) {
                            tcs.trySetCancelled();
                        } else if (task.isFaulted()) {
                            tcs.trySetError(task.getError());
                        } else {
                            tcs.trySetResult(task.getResult());
                        }
                        return null;
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }

    public Task<Void> saveInBackground(final ProgressCallback uploadProgressCallback) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseFile.this.saveAsync(uploadProgressCallback, task);
            }
        });
    }

    public Task<Void> saveInBackground() {
        return this.saveInBackground((ProgressCallback)null);
    }

    public synchronized void saveInBackground(SaveCallback saveCallback, ProgressCallback progressCallback) {
        Parse.callbackOnMainThreadAsync(this.saveInBackground(progressCallback), saveCallback);
    }

    public void saveInBackground(SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(this.saveInBackground(), callback);
    }

    public byte[] getData() throws ParseException {
        return Parse.waitForTask(this.getDataInBackground());
    }

    private Task<byte[]> getDataAsync(final ProgressCallback progressCallback, Task<Void> toAwait) {
        if (this.data != null) {
            return Task.forResult((Object)this.data);
        }
        final Task.TaskCompletionSource tcs = Task.create();
        this.currentTasks.add(tcs);
        toAwait.continueWith((Continuation)new Continuation<Void, byte[]>(){

            public byte[] then(Task<Void> task) throws Exception {
                return ParseFile.this.getCachedData();
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR).continueWith((Continuation)new Continuation<byte[], Void>(){

            public Void then(Task<byte[]> task) throws Exception {
                byte[] result = (byte[])task.getResult();
                if (result != null) {
                    tcs.trySetResult((Object)result);
                    return null;
                }
                ParseAWSRequest request = new ParseAWSRequest(ParseFile.this.url);
                request.executeAsync(null, progressCallback).continueWithTask((Continuation)new Continuation<byte[], Task<byte[]>>(){

                    public Task<byte[]> then(Task<byte[]> task) throws Exception {
                        if (task.isFaulted() && task.getError() instanceof IllegalStateException) {
                            return Task.forError((Exception)new ParseException(100, task.getError().getMessage()));
                        }
                        if (tcs.getTask().isCancelled()) {
                            return tcs.getTask();
                        }
                        ParseFile.this.data = (byte[])task.getResult();
                        if (ParseFile.this.data != null) {
                            ParseFileUtils.writeByteArrayToFile(ParseFile.this.getCacheFile(), ParseFile.this.data);
                        }
                        return task;
                    }
                }).continueWith((Continuation)new Continuation<byte[], Void>(){

                    public Void then(Task<byte[]> task) throws Exception {
                        ParseFile.this.currentTasks.remove(tcs);
                        if (task.isCancelled()) {
                            tcs.trySetCancelled();
                        } else if (task.isFaulted()) {
                            tcs.trySetError(task.getError());
                        } else {
                            tcs.trySetResult(task.getResult());
                        }
                        return null;
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }

    public Task<byte[]> getDataInBackground(final ProgressCallback progressCallback) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<byte[]>>(){

            public Task<byte[]> then(Task<Void> task) throws Exception {
                return ParseFile.this.getDataAsync(progressCallback, (Task<Void>)task);
            }
        });
    }

    public Task<byte[]> getDataInBackground() {
        return this.getDataInBackground((ProgressCallback)null);
    }

    public void getDataInBackground(GetDataCallback dataCallback, ProgressCallback progressCallback) {
        Parse.callbackOnMainThreadAsync(this.getDataInBackground(progressCallback), dataCallback);
    }

    public void getDataInBackground(GetDataCallback dataCallback) {
        Parse.callbackOnMainThreadAsync(this.getDataInBackground(), dataCallback);
    }

    public void cancel() {
        HashSet<Task.TaskCompletionSource> tasks = new HashSet<Task.TaskCompletionSource>(this.currentTasks);
        for (Task.TaskCompletionSource tcs : tasks) {
            tcs.trySetCancelled();
        }
        this.currentTasks.removeAll(tasks);
    }

    ParseFile(JSONObject json, ParseDecoder decoder) {
        this(json.optString("name"), json.optString("url"));
    }

    JSONObject encode() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("__type", (Object)"File");
        json.put("name", (Object)this.getName());
        String url = this.getUrl();
        if (url == null) {
            throw new IllegalStateException("Unable to encode an unsaved ParseFile.");
        }
        json.put("url", (Object)this.getUrl());
        return json;
    }
}

