/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Parse;
import com.parse.ParseDecoder;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import com.parse.PointerEncodingStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

class ParseRESTQueryCommand
extends ParseRESTCommand {
    public ParseRESTQueryCommand(String httpPath, ParseRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    public static ParseRESTQueryCommand findCommand(String className, String order, Map<String, ?> conditions, List<String> selectedKeys, List<String> includedKeys, int limit, int skip, Map<String, ?> extraOptions, boolean tracingEnabled, String sessionToken) {
        String httpPath = String.format("classes/%s", className);
        Map<String, String> parameters = ParseRESTQueryCommand.findCommandParameters(order, conditions, selectedKeys, includedKeys, limit, skip, extraOptions, tracingEnabled);
        return new ParseRESTQueryCommand(httpPath, ParseRequest.Method.GET, parameters, sessionToken);
    }

    public static ParseRESTQueryCommand countCommand(ParseRESTQueryCommand findCommand) {
        ParseDecoder decoder = new ParseDecoder();
        Map<String, Object> parameters = decoder.convertJSONObjectToMap(findCommand.jsonParameters);
        parameters.put("count", Integer.toString(1));
        parameters.remove("limit");
        parameters.remove("skip");
        return new ParseRESTQueryCommand(findCommand.httpPath, findCommand.method, parameters, findCommand.sessionToken);
    }

    public static Map<String, String> findCommandParameters(String order, Map<String, ?> conditions, List<String> selectedKeys, List<String> includedKeys, int limit, int skip, Map<String, ?> extraOptions, boolean tracingEnabled) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (order != null) {
            parameters.put("order", order);
        }
        if (conditions != null && conditions.size() > 0) {
            JSONObject encodedConditions = (JSONObject)Parse.encode(conditions, PointerEncodingStrategy.get());
            parameters.put("where", encodedConditions.toString());
        }
        if (selectedKeys != null) {
            parameters.put("keys", Parse.join(",", selectedKeys));
        }
        if (includedKeys != null && includedKeys.size() > 0) {
            parameters.put("include", Parse.join(",", includedKeys));
        }
        if (limit >= 0) {
            parameters.put("limit", Integer.toString(limit));
        }
        if (skip > 0) {
            parameters.put("skip", Integer.toString(skip));
        }
        for (String key : extraOptions.keySet()) {
            JSONObject encodedExtraOptions = (JSONObject)Parse.encode(extraOptions.get(key), PointerEncodingStrategy.get());
            parameters.put(key, encodedExtraOptions.toString());
        }
        if (tracingEnabled) {
            parameters.put("trace", "1");
        }
        return parameters;
    }
}

