/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.Uri;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import org.json.JSONObject;

class ParseRESTObjectCommand
extends ParseRESTCommand {
    public ParseRESTObjectCommand(String httpPath, ParseRequest.Method httpMethod, JSONObject parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    public static ParseRESTObjectCommand getObjectCommand(String objectId, String className, String sessionToken) {
        String httpPath = String.format("classes/%s/%s", Uri.encode((String)className), Uri.encode((String)objectId));
        return new ParseRESTObjectCommand(httpPath, ParseRequest.Method.GET, null, sessionToken);
    }

    public static ParseRESTObjectCommand createObjectCommand(String className, JSONObject changes, String sessionToken) {
        String httpPath = String.format("classes/%s", Uri.encode((String)className));
        return new ParseRESTObjectCommand(httpPath, ParseRequest.Method.POST, changes, sessionToken);
    }

    public static ParseRESTObjectCommand updateObjectCommand(String objectId, String className, JSONObject changes, String sessionToken) {
        String httpPath = String.format("classes/%s/%s", Uri.encode((String)className), Uri.encode((String)objectId));
        return new ParseRESTObjectCommand(httpPath, ParseRequest.Method.PUT, changes, sessionToken);
    }

    public static ParseRESTObjectCommand deleteObjectCommand(String objectId, String className, String sessionToken) {
        String httpPath = String.format("classes/%s", Uri.encode((String)className));
        if (objectId != null) {
            httpPath = httpPath + String.format("/%s", Uri.encode((String)objectId));
        }
        return new ParseRESTObjectCommand(httpPath, ParseRequest.Method.DELETE, null, sessionToken);
    }
}

