/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.http.AndroidHttpClient;
import bolts.Task;
import com.parse.Parse;
import com.parse.ParseIOUtils;
import com.parse.ParseRESTCommand;
import com.parse.ParseRESTObjectCommand;
import com.parse.ParseRequest;
import com.parse.ProgressCallback;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ParseRESTObjectBatchCommand
extends ParseRESTCommand {
    public static final int COMMAND_OBJECT_BATCH_MAX_SIZE = 50;

    public ParseRESTObjectBatchCommand(String httpPath, ParseRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    public static List<ParseRESTObjectBatchCommand> batchCommands(List<ParseRESTObjectCommand> commands, String sessionToken) {
        List<List<ParseRESTObjectCommand>> batches = Parse.partitionList(commands, 50);
        ArrayList<ParseRESTObjectBatchCommand> batchCommands = new ArrayList<ParseRESTObjectBatchCommand>();
        for (List<ParseRESTObjectCommand> batch : batches) {
            ParseRESTObjectBatchCommand multiCommand = ParseRESTObjectBatchCommand.batchCommand(batch, sessionToken);
            batchCommands.add(multiCommand);
        }
        return batchCommands;
    }

    public static ParseRESTObjectBatchCommand batchCommand(List<ParseRESTObjectCommand> commands, String sessionToken) {
        ArrayList<JSONObject> requests = new ArrayList<JSONObject>();
        try {
            for (ParseRESTObjectCommand command : commands) {
                JSONObject requestParameters = new JSONObject();
                requestParameters.put("method", (Object)command.method.toString());
                requestParameters.put("path", (Object)String.format("/1/%s", command.httpPath));
                JSONObject body = command.jsonParameters;
                if (body != null) {
                    requestParameters.put("body", (Object)body);
                }
                requests.add(requestParameters);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, ArrayList<JSONObject>> parameters = new HashMap<String, ArrayList<JSONObject>>();
        parameters.put("requests", requests);
        return new ParseRESTObjectBatchCommand("batch", ParseRequest.Method.POST, parameters, sessionToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Task<JSONObject> onResponse(HttpResponse response, ProgressCallback downloadProgressCallback) {
        JSONObject json;
        InputStream inputStream = null;
        String content = null;
        try {
            inputStream = AndroidHttpClient.getUngzippedContent((HttpEntity)response.getEntity());
            content = new String(ParseIOUtils.toByteArray(inputStream));
        }
        catch (IOException e) {
            Task task = Task.forError((Exception)e);
            return task;
        }
        finally {
            ParseIOUtils.closeQuietly(inputStream);
        }
        try {
            JSONArray results = new JSONArray(content);
            json = new JSONObject();
            json.put("results", (Object)results);
        }
        catch (JSONException e) {
            return Task.forError((Exception)this.connectionFailed("bad json response", (Exception)((Object)e)));
        }
        return Task.forResult((Object)json);
    }

    @Override
    protected Task<Object> onPostExecute(Task<JSONObject> task) {
        JSONArray results;
        JSONObject json = (JSONObject)task.getResult();
        try {
            results = json.getJSONArray("results");
        }
        catch (JSONException e) {
            return Task.forError((Exception)this.connectionFailed("corrupted json", (Exception)((Object)e)));
        }
        return Task.forResult((Object)results);
    }
}

