/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Capture;
import bolts.Continuation;
import bolts.Task;
import com.parse.LogInCallback;
import com.parse.OfflineStore;
import com.parse.Parse;
import com.parse.ParseAnonymousUtils;
import com.parse.ParseAuthenticationProvider;
import com.parse.ParseClassName;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseFileUtils;
import com.parse.ParseObject;
import com.parse.ParseObjectEncodingStrategy;
import com.parse.ParseOperationSet;
import com.parse.ParseQuery;
import com.parse.ParseRESTObjectCommand;
import com.parse.ParseRESTUserCommand;
import com.parse.PointerEncodingStrategy;
import com.parse.RequestPasswordResetCallback;
import com.parse.SignUpCallback;
import com.parse.TaskQueue;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

@ParseClassName(value="_User")
public class ParseUser
extends ParseObject {
    static final String FILENAME_CURRENT_USER = "currentUser";
    private static final String PIN_CURRENT_USER = "_currentUser";
    private static final Object MUTEX_CURRENT_USER = new Object();
    private static ParseUser currentUser;
    private static Map<String, ParseAuthenticationProvider> authenticationProviders;
    private static boolean autoUserEnabled;
    private static boolean currentUserMatchesDisk;
    private String password;
    private String sessionToken;
    private final JSONObject authData = new JSONObject();
    private final Set<String> linkedServiceNames = new HashSet<String>();
    private final Set<String> readOnlyLinkedServiceNames = Collections.unmodifiableSet(this.linkedServiceNames);
    private boolean isNew;
    private boolean isLazy = false;
    private boolean dirty;
    private boolean isCurrentUser = false;

    public static ParseQuery<ParseUser> getQuery() {
        return ParseQuery.getQuery(ParseUser.class);
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParseUser logInLazyUser(String authType, JSONObject authData) {
        ParseUser user = ParseObject.create(ParseUser.class);
        Object object = user.mutex;
        synchronized (object) {
            user.isCurrentUser = true;
            user.isLazy = true;
            try {
                user.authData.put(authType, (Object)authData);
                user.linkedServiceNames.add(authType);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        boolean matchesDisk = false;
        if (OfflineStore.isEnabled()) {
            try {
                Parse.waitForTask(ParseUser.saveCurrentUserAsync(user));
                matchesDisk = true;
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        Object object2 = MUTEX_CURRENT_USER;
        synchronized (object2) {
            currentUserMatchesDisk = matchesDisk;
            currentUser = user;
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLazy() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isLazy;
        }
    }

    @Override
    boolean isDirty(boolean considerChildren) {
        return this.dirty || super.isDirty(considerChildren);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthenticated() {
        Object object = this.mutex;
        synchronized (object) {
            ParseUser current = ParseUser.getCurrentUser();
            return this.isLazy() || this.sessionToken != null && current != null && this.getObjectId().equals(current.getObjectId());
        }
    }

    @Override
    public void remove(String key) {
        if ("username".equals(key)) {
            throw new IllegalArgumentException("Can't remove the username key.");
        }
        super.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    JSONObject toJSONObjectForSaving(ParseOperationSet operations, ParseObjectEncodingStrategy objectEncoder) {
        Object object = this.mutex;
        synchronized (object) {
            JSONObject objectJSON = super.toJSONObjectForSaving(operations, objectEncoder);
            if (this.authData.length() > 0) {
                try {
                    objectJSON.put("authData", (Object)this.authData);
                }
                catch (JSONException e) {
                    throw new RuntimeException("could not attach key: authData");
                }
            }
            if (this.password != null) {
                try {
                    objectJSON.put("password", (Object)this.password);
                }
                catch (JSONException e) {
                    throw new RuntimeException("could not attach key: password");
                }
            }
            return objectJSON;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    JSONObject toJSONObjectForDataFile(boolean includeOperations, ParseObjectEncodingStrategy objectEncoder) {
        Object object = this.mutex;
        synchronized (object) {
            JSONObject objectJSON = super.toJSONObjectForDataFile(includeOperations, objectEncoder);
            if (this.sessionToken != null) {
                try {
                    objectJSON.put("session_token", (Object)this.sessionToken);
                }
                catch (JSONException e) {
                    throw new RuntimeException("could not encode value for key: session_token");
                }
            }
            if (this.authData.length() > 0) {
                try {
                    objectJSON.put("auth_data", (Object)this.authData);
                }
                catch (JSONException e) {
                    throw new RuntimeException("could not attach key: auth_data");
                }
            }
            return objectJSON;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mergeFromDiskJSON(JSONObject object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            JSONObject newAuthData;
            String newSessionToken = object.optString("session_token", null);
            if (newSessionToken != null) {
                this.sessionToken = newSessionToken;
                object.remove("session_token");
            }
            if ((newAuthData = object.optJSONObject("auth_data")) != null) {
                try {
                    Iterator i = newAuthData.keys();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        if (!newAuthData.isNull(key)) {
                            this.authData.put(key, newAuthData.get(key));
                            this.linkedServiceNames.add(key);
                        }
                        this.synchronizeAuthData(key);
                    }
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                object.remove("auth_data");
            }
            super.mergeFromDiskJSON(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mergeFromObject(ParseObject other) {
        Object object = this.mutex;
        synchronized (object) {
            super.mergeFromObject(other);
            if (this == other) {
                return;
            }
            if (other instanceof ParseUser) {
                this.sessionToken = ((ParseUser)other).sessionToken;
                this.isNew = ((ParseUser)other).isNew();
                Iterator key = this.authData.keys();
                while (key.hasNext()) {
                    key.next();
                    key.remove();
                }
                key = ((ParseUser)other).authData.keys();
                while (key.hasNext()) {
                    String k = (String)key.next();
                    try {
                        Object v = ((ParseUser)other).authData.get(k);
                        this.authData.put(k, v);
                    }
                    catch (JSONException e) {
                        throw new RuntimeException("A JSONException occurred where one was not possible.");
                    }
                }
                this.linkedServiceNames.clear();
                this.linkedServiceNames.addAll(((ParseUser)other).linkedServiceNames);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mergeFromServer(JSONObject object, ParseDecoder decoder, boolean completeData) {
        Object object2 = this.mutex;
        synchronized (object2) {
            String newSessionToken = object.optString("sessionToken", null);
            if (newSessionToken != null) {
                this.sessionToken = newSessionToken;
            }
            JSONObject newAuthData = object.optJSONObject("authData");
            try {
                if (newAuthData != null) {
                    Iterator i = newAuthData.keys();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        if (!newAuthData.isNull(key)) {
                            this.authData.put(key, newAuthData.get(key));
                            this.linkedServiceNames.add(key);
                        }
                        this.synchronizeAuthData(key);
                    }
                }
                if (object.has("is_new")) {
                    this.isNew = object.optBoolean("is_new");
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            object.remove("session_token");
            object.remove("sessionToken");
            super.mergeFromServer(object, decoder, completeData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    JSONObject toRest(ParseObjectEncodingStrategy objectEncoder) {
        Object object = this.mutex;
        synchronized (object) {
            JSONObject objectJSON = super.toRest(objectEncoder);
            if (this.sessionToken != null) {
                try {
                    objectJSON.put("sessionToken", (Object)this.sessionToken);
                }
                catch (JSONException e) {
                    throw new RuntimeException("could not encode value for key: sessionToken");
                }
            }
            if (this.authData.length() > 0) {
                try {
                    objectJSON.put("authData", (Object)this.authData);
                }
                catch (JSONException e) {
                    throw new RuntimeException("could not attach key: authData");
                }
            }
            return objectJSON;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mergeREST(JSONObject object, ParseDecoder decoder) {
        Object object2 = this.mutex;
        synchronized (object2) {
            super.mergeREST(object, decoder);
            if (object.has("sessionToken")) {
                try {
                    this.sessionToken = object.getString("sessionToken");
                }
                catch (JSONException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (object.has("authData")) {
                try {
                    JSONObject newData = object.getJSONObject("authData");
                    Iterator i = newData.keys();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        this.authData.put(key, newData.get(key));
                        if (!newData.isNull(key)) {
                            this.linkedServiceNames.add(key);
                        }
                        this.synchronizeAuthData(key);
                    }
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            if (object.has("isNew")) {
                try {
                    this.isNew = object.getBoolean("isNew");
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCurrentUser() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isCurrentUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpAuthData() {
        Object object = this.mutex;
        synchronized (object) {
            Iterator i = this.authData.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (!this.authData.isNull(key)) continue;
                i.remove();
                this.linkedServiceNames.remove(key);
                if (!authenticationProviders.containsKey(key)) continue;
                authenticationProviders.get(key).restoreAuthentication(null);
            }
        }
    }

    public void setUsername(String username) {
        this.put("username", username);
    }

    public String getUsername() {
        return this.getString("username");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String password) {
        Object object = this.mutex;
        synchronized (object) {
            this.password = password;
            this.dirty = true;
        }
    }

    public void setEmail(String email) {
        this.put("email", email);
    }

    public String getEmail() {
        return this.getString("email");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object value) {
        Object object = this.mutex;
        synchronized (object) {
            if ("username".equals(key)) {
                this.stripAnonymity();
            }
            if ("password".equals(key)) {
                this.setPassword((String)value);
                return;
            }
            super.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stripAnonymity() {
        Object object = this.mutex;
        synchronized (object) {
            if (ParseAnonymousUtils.isLinked(this)) {
                this.linkedServiceNames.remove("anonymous");
                try {
                    if (this.getObjectId() != null) {
                        this.authData.put("anonymous", JSONObject.NULL);
                    } else {
                        this.authData.remove("anonymous");
                    }
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                this.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreAnonymity(JSONObject anonymousData) {
        Object object = this.mutex;
        synchronized (object) {
            if (anonymousData != null) {
                this.linkedServiceNames.add("anonymous");
                try {
                    this.authData.put("anonymous", (Object)anonymousData);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionToken() {
        Object object = this.mutex;
        synchronized (object) {
            return this.sessionToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateSave() {
        ParseUser user = ParseUser.getCurrentUser();
        Object object = this.mutex;
        synchronized (object) {
            if (this.getObjectId() == null) {
                throw new IllegalArgumentException("Cannot save a ParseUser until it has been signed up. Call signUp first.");
            }
            if (!this.isAuthenticated() && this.isDirty() && !this.getObjectId().equals(user.getObjectId())) {
                throw new IllegalArgumentException("Cannot save a ParseUser that is not authenticated.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Task<Void> saveAsync(Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            Task task = this.isLazy() ? this.resolveLazinessAsync(toAwait).makeVoid() : super.saveAsync(toAwait);
            return task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    if (ParseUser.this.isCurrentUser()) {
                        ParseUser.this.cleanUpAuthData();
                        return ParseUser.saveCurrentUserAsync(ParseUser.this).makeVoid();
                    }
                    return Task.forResult(null);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateDelete() {
        Object object = this.mutex;
        synchronized (object) {
            super.validateDelete();
            if (!this.isAuthenticated() && this.isDirty()) {
                throw new IllegalArgumentException("Cannot delete a ParseUser that is not authenticated.");
            }
        }
    }

    public ParseUser fetch() throws ParseException {
        return (ParseUser)super.fetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends ParseObject> Task<T> fetchAsync(Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isLazy()) {
                return Task.forResult((Object)this);
            }
            return super.fetchAsync(toAwait).onSuccessTask(new Continuation<T, Task<T>>(){

                public Task<T> then(final Task<T> fetchAsyncTask) throws Exception {
                    if (ParseUser.this.isCurrentUser()) {
                        ParseUser.this.cleanUpAuthData();
                        return ParseUser.saveCurrentUserAsync(ParseUser.this).continueWithTask(new Continuation<ParseUser, Task<T>>(){

                            public Task<T> then(Task<ParseUser> task) throws Exception {
                                return fetchAsyncTask;
                            }
                        });
                    }
                    return fetchAsyncTask;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseRESTUserCommand currentServiceLogInCommand(ParseOperationSet operations) throws ParseException {
        ParseRESTUserCommand command;
        JSONObject authData;
        JSONObject params;
        Object object = this.mutex;
        synchronized (object) {
            params = this.toJSONObjectForSaving(operations, PointerEncodingStrategy.get());
            authData = this.authData;
        }
        try {
            params.put("authData", (Object)authData);
            command = ParseRESTUserCommand.serviceLogInUserCommand(params, this.sessionToken);
        }
        catch (JSONException e) {
            throw new ParseException(e);
        }
        return command;
    }

    public Task<Void> signUpInBackground() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseUser.this.signUpAsync((Task<Void>)task);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> signUpAsync(Task<Void> toAwait) {
        final ParseUser user = ParseUser.getCurrentUser();
        Object object = this.mutex;
        synchronized (object) {
            final String sessionToken = ParseUser.getCurrentSessionToken();
            if (this.getUsername() == null || this.getUsername().length() == 0) {
                throw new IllegalArgumentException("Username cannot be missing or blank");
            }
            if (this.password == null) {
                throw new IllegalArgumentException("Password cannot be missing or blank");
            }
            if (this.getObjectId() != null) {
                try {
                    if (this.authData.has("anonymous") && this.authData.get("anonymous") == JSONObject.NULL) {
                        return this.saveAsync(toAwait);
                    }
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                throw new IllegalArgumentException("Cannot sign up a user that has already signed up.");
            }
            if (this.operationSetQueue.size() > 1) {
                throw new IllegalArgumentException("Cannot sign up a user that is already signing up.");
            }
            if (user != null && ParseAnonymousUtils.isLinked(user)) {
                JSONObject anonymousData;
                if (this == user) {
                    throw new IllegalArgumentException("Attempt to merge currentUser with itself.");
                }
                this.checkForChangesToMutableContainers();
                user.checkForChangesToMutableContainers();
                final String oldUsername = user.getUsername();
                final String oldPassword = user.password;
                try {
                    anonymousData = user.authData.getJSONObject("anonymous");
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                user.copyChangesFrom(this);
                user.dirty = true;
                user.setPassword(this.password);
                user.setUsername(this.getUsername());
                this.revert();
                return user.saveAsync(toAwait).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Task<Void> then(Task<Void> task) throws Exception {
                        if (task.isCancelled() || task.isFaulted()) {
                            Object object = user.mutex;
                            synchronized (object) {
                                if (oldUsername != null) {
                                    user.setUsername(oldUsername);
                                }
                                user.password = oldPassword;
                                user.restoreAnonymity(anonymousData);
                            }
                            return task;
                        }
                        ParseUser.this.mergeFromObject(user);
                        return ParseUser.saveCurrentUserAsync(ParseUser.this).makeVoid();
                    }
                });
            }
            return Task.call((Callable)new Callable<ParseOperationSet>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ParseOperationSet call() throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        return ParseUser.this.startSave();
                    }
                }
            }).continueWithTask(TaskQueue.waitFor(toAwait)).onSuccessTask((Continuation)new Continuation<ParseOperationSet, Task<Void>>(){

                public Task<Void> then(Task<ParseOperationSet> task) throws Exception {
                    final ParseOperationSet operations = (ParseOperationSet)task.getResult();
                    ParseRESTObjectCommand command = ParseUser.this.currentSaveCommand(operations, PointerEncodingStrategy.get(), sessionToken);
                    if (command == null) {
                        return Task.forResult(null);
                    }
                    return command.executeAsync().continueWithTask((Continuation)new Continuation<Object, Task<Void>>(){

                        public Task<Void> then(final Task<Object> signUpTask) throws Exception {
                            return ParseUser.this.handleSaveResultAsync((JSONObject)signUpTask.getResult(), operations).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public Task<Void> then(Task<Void> task) throws Exception {
                                    if (!signUpTask.isCancelled() && !signUpTask.isFaulted()) {
                                        Object object = ParseUser.this.mutex;
                                        synchronized (object) {
                                            ParseUser.this.isNew = true;
                                            ParseUser.this.dirty = false;
                                            ParseUser.this.isLazy = false;
                                        }
                                        return ParseUser.saveCurrentUserAsync(ParseUser.this).makeVoid();
                                    }
                                    return signUpTask.makeVoid();
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    public void signUp() throws ParseException {
        Parse.waitForTask(this.signUpInBackground());
    }

    public void signUpInBackground(SignUpCallback callback) {
        Parse.callbackOnMainThreadAsync(this.signUpInBackground(), callback);
    }

    public static Task<ParseUser> logInInBackground(String username, String password) {
        if (username == null) {
            throw new IllegalArgumentException("Must specify a username for the user to log in with");
        }
        if (password == null) {
            throw new IllegalArgumentException("Must specify a password for the user to log in with");
        }
        ParseRESTUserCommand command = ParseRESTUserCommand.logInUserCommand(username, password);
        return command.executeAsync().onSuccessTask((Continuation)new Continuation<Object, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<Object> task) throws Exception {
                JSONObject json = (JSONObject)task.getResult();
                if (json == JSONObject.NULL) {
                    throw new ParseException(101, "invalid login credentials");
                }
                ParseUser user = (ParseUser)ParseObject.fromJSON(json, "_User", true);
                return ParseUser.saveCurrentUserAsync(user);
            }
        });
    }

    public static ParseUser logIn(String username, String password) throws ParseException {
        return Parse.waitForTask(ParseUser.logInInBackground(username, password));
    }

    public static void logInInBackground(String username, String password, LogInCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseUser.logInInBackground(username, password), callback);
    }

    public static Task<ParseUser> becomeInBackground(String sessionToken) {
        if (sessionToken == null) {
            throw new IllegalArgumentException("Must specify a sessionToken for the user to log in with");
        }
        ParseRESTUserCommand command = ParseRESTUserCommand.getCurrentUserCommand(sessionToken);
        return command.executeAsync().onSuccessTask((Continuation)new Continuation<Object, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<Object> task) throws Exception {
                JSONObject json = (JSONObject)task.getResult();
                if (json == JSONObject.NULL) {
                    throw new ParseException(101, "invalid login credentials");
                }
                ParseUser user = (ParseUser)ParseObject.fromJSON(json, "_User", true);
                return ParseUser.saveCurrentUserAsync(user);
            }
        });
    }

    public static ParseUser become(String sessionToken) throws ParseException {
        return Parse.waitForTask(ParseUser.becomeInBackground(sessionToken));
    }

    public static void becomeInBackground(String sessionToken, LogInCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseUser.becomeInBackground(sessionToken), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseUser getCurrentUser() {
        boolean matchesDisk;
        ParseUser current;
        ParseUser.checkApplicationContext();
        Object object = MUTEX_CURRENT_USER;
        synchronized (object) {
            current = currentUser;
            matchesDisk = currentUserMatchesDisk;
        }
        if (current != null) {
            return current;
        }
        if (matchesDisk) {
            if (ParseUser.isAutomaticUserEnabled()) {
                return ParseAnonymousUtils.lazyLogIn();
            }
            return null;
        }
        if (OfflineStore.isEnabled()) {
            try {
                ParseQuery<ParseUser> query = ParseQuery.getQuery(ParseUser.class).fromPin(PIN_CURRENT_USER).ignoreACLs();
                Task task = query.findInBackground().onSuccessTask((Continuation)new Continuation<List<ParseUser>, Task<ParseUser>>(){

                    public Task<ParseUser> then(Task<List<ParseUser>> task) throws Exception {
                        List results = (List)task.getResult();
                        if (results != null) {
                            if (results.size() == 1) {
                                return Task.forResult(results.get(0));
                            }
                            return ParseObject.unpinAllInBackground(ParseUser.PIN_CURRENT_USER).cast();
                        }
                        return Task.forResult(null);
                    }
                }).onSuccessTask((Continuation)new Continuation<ParseUser, Task<ParseUser>>(){

                    public Task<ParseUser> then(Task<ParseUser> task) throws Exception {
                        ParseUser ldsUser = (ParseUser)task.getResult();
                        if (ldsUser != null) {
                            return task;
                        }
                        return ParseObject.migrateFromDiskToLDS(ParseUser.FILENAME_CURRENT_USER, ParseUser.PIN_CURRENT_USER).cast();
                    }
                });
                current = (ParseUser)Parse.waitForTask(task);
                matchesDisk = true;
            }
            catch (ParseException parseException) {}
        } else {
            current = (ParseUser)ParseUser.getFromDisk(Parse.applicationContext, FILENAME_CURRENT_USER);
            matchesDisk = true;
        }
        object = MUTEX_CURRENT_USER;
        synchronized (object) {
            currentUser = current;
            currentUserMatchesDisk = matchesDisk;
        }
        if (current != null) {
            object = current.mutex;
            synchronized (object) {
                current.isCurrentUser = true;
            }
            return current;
        }
        if (ParseUser.isAutomaticUserEnabled()) {
            return ParseAnonymousUtils.lazyLogIn();
        }
        return null;
    }

    static String getCurrentSessionToken() {
        ParseUser current = ParseUser.getCurrentUser();
        return current != null ? current.getSessionToken() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Task<ParseUser> saveCurrentUserAsync(final ParseUser user) {
        ParseUser current;
        ParseUser.checkApplicationContext();
        Object object = MUTEX_CURRENT_USER;
        synchronized (object) {
            current = currentUser;
        }
        Task task = Task.forResult(null);
        if (current != user) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return ParseUser.logOutInBackground();
                }
            });
        }
        Object object2 = user.mutex;
        synchronized (object2) {
            user.isCurrentUser = true;
            user.synchronizeAllAuthData();
        }
        task = OfflineStore.isEnabled() ? task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return user.pinInBackground(ParseUser.PIN_CURRENT_USER);
            }
        }) : task.onSuccess((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                user.saveToDisk(Parse.applicationContext, ParseUser.FILENAME_CURRENT_USER);
                return null;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
        return task.continueWith((Continuation)new Continuation<Void, ParseUser>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ParseUser then(Task task) throws Exception {
                Object object = MUTEX_CURRENT_USER;
                synchronized (object) {
                    currentUserMatchesDisk = !task.isFaulted();
                    currentUser = user;
                }
                return user;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Task<Void> logOutInBackground() {
        ParseUser current;
        ParseUser.checkApplicationContext();
        Object object = MUTEX_CURRENT_USER;
        synchronized (object) {
            current = currentUser;
        }
        if (current != null) {
            object = current.mutex;
            synchronized (object) {
                for (String authType : current.getLinkedServiceNames()) {
                    current.logOutWith(authType);
                }
                current.isCurrentUser = false;
                current.isNew = false;
                current.sessionToken = null;
            }
        }
        return Task.call((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ParseFileUtils.deleteQuietly(new File(Parse.getParseDir(), ParseUser.FILENAME_CURRENT_USER));
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR).continueWithTask((Continuation)new Continuation<Boolean, Task<Boolean>>(){

            public Task<Boolean> then(Task<Boolean> task) throws Exception {
                if (OfflineStore.isEnabled()) {
                    return ParseObject.unpinAllInBackground(ParseUser.PIN_CURRENT_USER).continueWith((Continuation)new Continuation<Void, Boolean>(){

                        public Boolean then(Task<Void> task) throws Exception {
                            return !task.isFaulted();
                        }
                    });
                }
                return task;
            }
        }).onSuccess((Continuation)new Continuation<Boolean, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void then(Task<Boolean> task) throws Exception {
                boolean deleted = (Boolean)task.getResult();
                Object object = MUTEX_CURRENT_USER;
                synchronized (object) {
                    currentUserMatchesDisk = deleted;
                    currentUser = null;
                }
                return null;
            }
        });
    }

    public static void logOut() {
        try {
            Parse.waitForTask(ParseUser.logOutInBackground());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public static Task<Void> requestPasswordResetInBackground(String email) {
        ParseRESTUserCommand command = ParseRESTUserCommand.resetUserPasswordCommand(email);
        return command.executeAsync().makeVoid();
    }

    public static void requestPasswordReset(String email) throws ParseException {
        Parse.waitForTask(ParseUser.requestPasswordResetInBackground(email));
    }

    public static void requestPasswordResetInBackground(String email, RequestPasswordResetCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseUser.requestPasswordResetInBackground(email), callback);
    }

    private static void checkApplicationContext() {
        if (Parse.applicationContext == null) {
            throw new RuntimeException("You must call Parse.initialize(context, oauthKey, oauthSecret) before using the Parse library.");
        }
    }

    public ParseUser fetchIfNeeded() throws ParseException {
        return (ParseUser)super.fetchIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getLinkedServiceNames() {
        Object object = this.mutex;
        synchronized (object) {
            return this.readOnlyLinkedServiceNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeAuthData(String authType) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isCurrentUser()) {
                return;
            }
            if (!authenticationProviders.containsKey(authType)) {
                return;
            }
            ParseAuthenticationProvider provider = authenticationProviders.get(authType);
            boolean success = provider.restoreAuthentication(this.authData.optJSONObject(provider.getAuthType()));
            if (!success) {
                this.unlinkFromAsync(authType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeAllAuthData() {
        Object object = this.mutex;
        synchronized (object) {
            Iterator authTypes = this.authData.keys();
            while (authTypes.hasNext()) {
                this.synchronizeAuthData((String)authTypes.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> unlinkFromAsync(final String authType) {
        Object object = this.mutex;
        synchronized (object) {
            if (authType == null) {
                return Task.forResult(null);
            }
            return Task.forResult(null).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Task<Void> then(Task<Void> task) throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        if (ParseUser.this.authData.has(authType)) {
                            ParseUser.this.authData.put(authType, JSONObject.NULL);
                            ParseUser.this.dirty = true;
                            return ParseUser.this.saveInBackground();
                        }
                        return Task.forResult(null);
                    }
                }
            });
        }
    }

    static void registerAuthenticationProvider(ParseAuthenticationProvider provider) {
        authenticationProviders.put(provider.getAuthType(), provider);
        ParseUser user = ParseUser.getCurrentUser();
        if (user != null) {
            user.synchronizeAuthData(provider.getAuthType());
        }
    }

    static Task<ParseUser> logInWithAsync(String authType) {
        if (!authenticationProviders.containsKey(authType)) {
            throw new IllegalArgumentException("No authentication provider could be found for the provided authType");
        }
        return ParseUser.logInWithAsync(authenticationProviders.get(authType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Task<ParseUser> logInWithAsync(final String authType, final JSONObject authData) {
        Continuation<Void, Task<ParseUser>> logInWithTask = new Continuation<Void, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<Void> task) throws Exception {
                final ParseRESTUserCommand command = ParseRESTUserCommand.serviceLogInUserCommand(authType, authData);
                return command.executeAsync().onSuccessTask((Continuation)new Continuation<Object, Task<ParseUser>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Task<ParseUser> then(Task<Object> task) throws Exception {
                        JSONObject result = (JSONObject)task.getResult();
                        ParseUser user = (ParseUser)ParseObject.fromJSON(result, "_User", true);
                        Object object = user.mutex;
                        synchronized (object) {
                            try {
                                user.authData.put(authType, (Object)authData);
                                user.linkedServiceNames.add(authType);
                            }
                            catch (JSONException e) {
                                throw new ParseException(e);
                            }
                            user.isNew = command.getStatusCode() == 201;
                        }
                        return ParseUser.saveCurrentUserAsync(user);
                    }
                });
            }
        };
        final ParseUser user = ParseUser.getCurrentUser();
        if (user != null) {
            Object object = user.mutex;
            synchronized (object) {
                if (ParseAnonymousUtils.isLinked(user)) {
                    if (user.isLazy()) {
                        final JSONObject oldAnonymousData = user.authData.optJSONObject("anonymous");
                        return user.taskQueue.enqueue(new Continuation<Void, Task<ParseUser>>(){

                            public Task<ParseUser> then(Task<Void> toAwait) throws Exception {
                                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public Task<Void> then(Task<Void> task) throws Exception {
                                        Object object = user.mutex;
                                        synchronized (object) {
                                            user.stripAnonymity();
                                            user.authData.put(authType, (Object)authData);
                                            user.linkedServiceNames.add(authType);
                                            return user.resolveLazinessAsync((Task<Void>)task).makeVoid();
                                        }
                                    }
                                }).continueWithTask((Continuation)new Continuation<Void, Task<ParseUser>>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public Task<ParseUser> then(Task<Void> task) throws Exception {
                                        Object object = user.mutex;
                                        synchronized (object) {
                                            if (task.isFaulted()) {
                                                user.authData.remove(authType);
                                                user.linkedServiceNames.remove(authType);
                                                user.restoreAnonymity(oldAnonymousData);
                                                return Task.forError((Exception)task.getError());
                                            }
                                            if (task.isCancelled()) {
                                                return Task.cancelled();
                                            }
                                            return Task.forResult((Object)user);
                                        }
                                    }
                                });
                            }
                        });
                    }
                    return user.linkWithAsync(authType, authData).continueWithTask((Continuation)new Continuation<Void, Task<ParseUser>>((Continuation)logInWithTask, user){
                        final /* synthetic */ Continuation val$logInWithTask;
                        final /* synthetic */ ParseUser val$user;
                        {
                            this.val$logInWithTask = continuation;
                            this.val$user = parseUser;
                        }

                        public Task<ParseUser> then(Task<Void> task) throws Exception {
                            Exception error;
                            if (task.isFaulted() && (error = task.getError()) instanceof ParseException && ((ParseException)error).getCode() == 208) {
                                return Task.forResult(null).continueWithTask(this.val$logInWithTask);
                            }
                            if (task.isCancelled()) {
                                return Task.cancelled();
                            }
                            return Task.forResult((Object)this.val$user);
                        }
                    });
                }
            }
        }
        return Task.forResult(null).continueWithTask((Continuation)logInWithTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<ParseUser> resolveLazinessAsync(Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isLazy()) {
                return Task.forResult(null);
            }
            if (this.linkedServiceNames.size() == 0) {
                return this.signUpAsync(toAwait).onSuccess((Continuation)new Continuation<Void, ParseUser>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public ParseUser then(Task<Void> task) throws Exception {
                        Object object = ParseUser.this.mutex;
                        synchronized (object) {
                            ParseUser.this.isLazy = false;
                            return ParseUser.this;
                        }
                    }
                });
            }
            final Capture operations = new Capture();
            return Task.call((Callable)new Callable<ParseOperationSet>(){

                @Override
                public ParseOperationSet call() throws Exception {
                    return ParseUser.this.startSave();
                }
            }).onSuccessTask(TaskQueue.waitFor(toAwait)).onSuccessTask((Continuation)new Continuation<ParseOperationSet, Task<ParseUser>>(){

                public Task<ParseUser> then(Task<ParseOperationSet> task) throws Exception {
                    operations.set(task.getResult());
                    final ParseRESTUserCommand command = ParseUser.this.currentServiceLogInCommand((ParseOperationSet)operations.get());
                    return command.executeAsync().onSuccessTask((Continuation)new Continuation<Object, Task<ParseUser>>(){

                        public Task<ParseUser> then(Task<Object> task) throws Exception {
                            final JSONObject commandResult = (JSONObject)task.getResult();
                            final boolean isNew = command.getStatusCode() == 201;
                            Task resultTask = OfflineStore.isEnabled() && !isNew ? Task.forResult((Object)commandResult) : ParseUser.this.handleSaveResultAsync(commandResult, (ParseOperationSet)operations.get()).onSuccess((Continuation)new Continuation<Void, JSONObject>(){

                                public JSONObject then(Task<Void> task) throws Exception {
                                    return commandResult;
                                }
                            });
                            return resultTask.onSuccessTask((Continuation)new Continuation<JSONObject, Task<ParseUser>>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public Task<ParseUser> then(Task<JSONObject> task) throws Exception {
                                    JSONObject commandResult = (JSONObject)task.getResult();
                                    Object object = ParseUser.this.mutex;
                                    synchronized (object) {
                                        ParseUser.this.dirty = false;
                                        if (isNew) {
                                            ParseUser.this.isLazy = false;
                                            return Task.forResult((Object)ParseUser.this);
                                        }
                                    }
                                    ParseUser newUser = (ParseUser)ParseObject.fromJSON(commandResult, "_User", true);
                                    return ParseUser.saveCurrentUserAsync(newUser);
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    private static Task<JSONObject> authenticateAsync(ParseAuthenticationProvider authenticator) {
        final Task.TaskCompletionSource tcs = Task.create();
        authenticator.authenticate(new ParseAuthenticationProvider.ParseAuthenticationCallback(){

            @Override
            public void onSuccess(JSONObject authData) {
                tcs.setResult((Object)authData);
            }

            @Override
            public void onCancel() {
                tcs.setCancelled();
            }

            @Override
            public void onError(Throwable error) {
                tcs.setError((Exception)new ParseException(error));
            }
        });
        return tcs.getTask();
    }

    private static Task<ParseUser> logInWithAsync(final ParseAuthenticationProvider authenticator) {
        return ParseUser.authenticateAsync(authenticator).onSuccessTask((Continuation)new Continuation<JSONObject, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<JSONObject> task) throws Exception {
                return ParseUser.logInWithAsync(authenticator.getAuthType(), (JSONObject)task.getResult());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> linkWithAsync(final String authType, final JSONObject authData, final Task<Void> toAwait) {
        final JSONObject oldAnonymousData = authData.optJSONObject("anonymous");
        Object object = this.mutex;
        synchronized (object) {
            return Task.call((Callable)new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        ParseUser.this.authData.put(authType, (Object)authData);
                        ParseUser.this.linkedServiceNames.add(authType);
                        ParseUser.this.stripAnonymity();
                        ParseUser.this.dirty = true;
                        return null;
                    }
                }
            }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return ParseUser.this.saveAsync((Task<Void>)toAwait);
                }
            }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Task<Void> then(Task<Void> task) throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        if (task.isFaulted() || task.isCancelled()) {
                            ParseUser.this.restoreAnonymity(oldAnonymousData);
                            return task;
                        }
                        ParseUser.this.synchronizeAuthData(authType);
                        return task;
                    }
                }
            });
        }
    }

    Task<Void> linkWithAsync(final String authType, final JSONObject authData) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseUser.this.linkWithAsync(authType, authData, (Task<Void>)task);
            }
        });
    }

    Task<Void> linkWithAsync(String authType) {
        if (!authenticationProviders.containsKey(authType)) {
            throw new IllegalArgumentException("No authentication provider could be found for the provided authType");
        }
        return this.linkWithAsync(authenticationProviders.get(authType));
    }

    private Task<Void> linkWithAsync(final ParseAuthenticationProvider authenticator) {
        return ParseUser.authenticateAsync(authenticator).onSuccessTask((Continuation)new Continuation<JSONObject, Task<Void>>(){

            public Task<Void> then(Task<JSONObject> task) throws Exception {
                return ParseUser.this.linkWithAsync(authenticator.getAuthType(), (JSONObject)task.getResult());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logOutWith(String authType) {
        Object object = this.mutex;
        synchronized (object) {
            if (authenticationProviders.containsKey(authType) && this.linkedServiceNames.contains(authType)) {
                this.logOutWith(authenticationProviders.get(authType));
            }
        }
    }

    private void logOutWith(ParseAuthenticationProvider provider) {
        provider.deauthenticate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNew() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isNew;
        }
    }

    static void disableAutomaticUser() {
        autoUserEnabled = false;
    }

    public static void enableAutomaticUser() {
        autoUserEnabled = true;
    }

    static boolean isAutomaticUserEnabled() {
        return autoUserEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCurrentUserFromMemory() {
        Object object = MUTEX_CURRENT_USER;
        synchronized (object) {
            currentUser = null;
            currentUserMatchesDisk = false;
        }
    }

    static {
        authenticationProviders = new HashMap<String, ParseAuthenticationProvider>();
        currentUserMatchesDisk = false;
    }
}

