/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import bolts.Task;
import com.parse.LogInCallback;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ParseUser;
import com.parse.SaveCallback;
import com.parse.TwitterAuthenticationProvider;
import com.parse.twitter.Twitter;
import org.json.JSONException;

public final class ParseTwitterUtils {
    private static Twitter twitter;
    private static TwitterAuthenticationProvider provider;
    private static boolean isInitialized;

    private static TwitterAuthenticationProvider getAuthenticationProvider() {
        if (provider == null) {
            provider = new TwitterAuthenticationProvider(ParseTwitterUtils.getTwitter());
        }
        return provider;
    }

    public static Twitter getTwitter() {
        if (twitter == null) {
            twitter = new Twitter("", "");
        }
        return twitter;
    }

    public static void initialize(String consumerKey, String consumerSecret) {
        ParseTwitterUtils.getTwitter().setConsumerKey(consumerKey);
        ParseTwitterUtils.getTwitter().setConsumerSecret(consumerSecret);
        ParseUser.registerAuthenticationProvider(ParseTwitterUtils.getAuthenticationProvider());
        isInitialized = true;
    }

    private static void checkInitialization() {
        if (!isInitialized) {
            throw new IllegalStateException("You must call ParseTwitterUtils.initialize() before using ParseTwitterUtils");
        }
    }

    public static boolean isLinked(ParseUser user) {
        return user.getLinkedServiceNames().contains(ParseTwitterUtils.getAuthenticationProvider().getAuthType());
    }

    public static Task<Void> linkInBackground(Context context, ParseUser user) {
        ParseTwitterUtils.checkInitialization();
        ParseTwitterUtils.getAuthenticationProvider().setContext(context);
        return user.linkWithAsync(ParseTwitterUtils.getAuthenticationProvider().getAuthType());
    }

    @Deprecated
    public static void link(ParseUser user, Context context) {
        ParseTwitterUtils.link(user, context, null);
    }

    public static void link(ParseUser user, Context context, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseTwitterUtils.linkInBackground(context, user), callback, true);
    }

    public static Task<Void> linkInBackground(ParseUser user, String twitterId, String screenName, String authToken, String authTokenSecret) {
        ParseTwitterUtils.checkInitialization();
        try {
            return user.linkWithAsync(ParseTwitterUtils.getAuthenticationProvider().getAuthType(), ParseTwitterUtils.getAuthenticationProvider().getAuthData(twitterId, screenName, authToken, authTokenSecret));
        }
        catch (JSONException e) {
            return Task.forError((Exception)new ParseException(e));
        }
    }

    @Deprecated
    public static void link(ParseUser user, String twitterId, String screenName, String authToken, String authTokenSecret) {
        ParseTwitterUtils.link(user, twitterId, screenName, authToken, authTokenSecret, null);
    }

    public static void link(ParseUser user, String twitterId, String screenName, String authToken, String authTokenSecret, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseTwitterUtils.linkInBackground(user, twitterId, screenName, authToken, authTokenSecret), callback);
    }

    public static Task<ParseUser> logInInBackground(String twitterId, String screenName, String authToken, String authTokenSecret) {
        ParseTwitterUtils.checkInitialization();
        try {
            return ParseUser.logInWithAsync(ParseTwitterUtils.getAuthenticationProvider().getAuthType(), ParseTwitterUtils.getAuthenticationProvider().getAuthData(twitterId, screenName, authToken, authTokenSecret));
        }
        catch (JSONException e) {
            return Task.forError((Exception)new ParseException(e));
        }
    }

    public static void logIn(String twitterId, String screenName, String authToken, String authTokenSecret, LogInCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseTwitterUtils.logInInBackground(twitterId, screenName, authToken, authTokenSecret), callback);
    }

    public static Task<ParseUser> logInInBackground(Context context) {
        ParseTwitterUtils.checkInitialization();
        ParseTwitterUtils.getAuthenticationProvider().setContext(context);
        return ParseUser.logInWithAsync(ParseTwitterUtils.getAuthenticationProvider().getAuthType());
    }

    public static void logIn(Context context, LogInCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseTwitterUtils.logInInBackground(context), callback, true);
    }

    public static void unlink(ParseUser user) throws ParseException {
        Parse.waitForTask(ParseTwitterUtils.unlinkInBackground(user));
    }

    public static Task<Void> unlinkInBackground(ParseUser user) {
        ParseTwitterUtils.checkInitialization();
        return user.unlinkFromAsync(ParseTwitterUtils.getAuthenticationProvider().getAuthType());
    }

    public static void unlinkInBackground(ParseUser user, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParseTwitterUtils.unlinkInBackground(user), callback);
    }

    private ParseTwitterUtils() {
    }
}

