/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Parse;
import com.parse.ParseFieldOperations;
import com.parse.ParseFile;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseRelation;
import com.parse.codec.binary.Base64;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ParseDecoder {
    ParseDecoder() {
    }

    List<Object> convertJSONArrayToList(JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(this.decode(array.opt(i)));
        }
        return list;
    }

    Map<String, Object> convertJSONObjectToMap(JSONObject object) {
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        Iterator it = object.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = object.opt(key);
            outputMap.put(key, this.decode(value));
        }
        return outputMap;
    }

    protected ParseObject decodePointer(String className, String objectId) {
        return ParseObject.createWithoutData(className, objectId);
    }

    public Object decode(Object object) {
        if (object instanceof JSONArray) {
            return this.convertJSONArrayToList((JSONArray)object);
        }
        if (!(object instanceof JSONObject)) {
            return object;
        }
        JSONObject jsonObject = (JSONObject)object;
        String opString = jsonObject.optString("__op", null);
        if (opString != null) {
            try {
                return ParseFieldOperations.decode(jsonObject, this);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        String typeString = jsonObject.optString("__type", null);
        if (typeString == null) {
            return this.convertJSONObjectToMap(jsonObject);
        }
        if (typeString.equals("Date")) {
            String iso = jsonObject.optString("iso");
            return Parse.stringToDate(iso);
        }
        if (typeString.equals("Bytes")) {
            String base64 = jsonObject.optString("base64");
            return Base64.decodeBase64(base64);
        }
        if (typeString.equals("Pointer")) {
            return this.decodePointer(jsonObject.optString("className"), jsonObject.optString("objectId"));
        }
        if (typeString.equals("File")) {
            return new ParseFile(jsonObject, this);
        }
        if (typeString.equals("GeoPoint")) {
            double longitude;
            double latitude;
            try {
                latitude = jsonObject.getDouble("latitude");
                longitude = jsonObject.getDouble("longitude");
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return new ParseGeoPoint(latitude, longitude);
        }
        if (typeString.equals("Object")) {
            String className = jsonObject.optString("className", null);
            String objectId = jsonObject.optString("objectId", null);
            ParseObject output = ParseObject.createWithoutData(className, objectId);
            output.mergeAfterFetch(jsonObject, this, true);
            return output;
        }
        if (typeString.equals("Relation")) {
            return new ParseRelation(jsonObject, this);
        }
        if (typeString.equals("OfflineObject")) {
            throw new RuntimeException("An unexpected offline pointer was encountered.");
        }
        return null;
    }
}

