/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ReceiverCallNotAllowedException;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.parse.Parse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

class ConnectivityNotifier
extends BroadcastReceiver {
    private static final String TAG = "com.parse.ConnectivityNotifier";
    private static final ConnectivityNotifier singleton = new ConnectivityNotifier();
    private Set<ConnectivityListener> listeners = new HashSet<ConnectivityListener>();
    private boolean hasRegisteredReceiver = false;
    private final Object lock = new Object();

    ConnectivityNotifier() {
    }

    public static ConnectivityNotifier getNotifier(Context context) {
        singleton.tryToRegisterForNetworkStatusNotifications(context);
        return singleton;
    }

    public static boolean isConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo network = connectivityManager.getActiveNetworkInfo();
        return network != null && network.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConnectivityListener delegate) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConnectivityListener delegate) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryToRegisterForNetworkStatusNotifications(Context context) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasRegisteredReceiver) {
                return true;
            }
            try {
                if (context == null) {
                    return false;
                }
                context = context.getApplicationContext();
                context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                this.hasRegisteredReceiver = true;
                return true;
            }
            catch (ReceiverCallNotAllowedException e) {
                Parse.logV(TAG, "Cannot register a broadcast receiver because the executing thread is currently in a broadcast receiver. Will try again later.");
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        ArrayList<ConnectivityListener> listenersCopy;
        Object object = this.lock;
        synchronized (object) {
            listenersCopy = new ArrayList<ConnectivityListener>(this.listeners);
        }
        for (ConnectivityListener delegate : listenersCopy) {
            delegate.networkConnectivityStatusChanged(context, intent);
        }
    }

    public static interface ConnectivityListener {
        public void networkConnectivityStatusChanged(Context var1, Intent var2);
    }
}

