/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ParseClassName;
import com.parse.ParseCommand;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

@ParseClassName(value="_EventuallyPin")
class EventuallyPin
extends ParseObject {
    public static final String PIN_NAME = "_eventuallyPin";
    public static final int TYPE_SAVE = 1;
    public static final int TYPE_DELETE = 2;
    public static final int TYPE_COMMAND = 3;

    public EventuallyPin() {
        super("_EventuallyPin");
    }

    public String getUUID() {
        return this.getString("uuid");
    }

    public int getType() {
        return this.getInt("type");
    }

    public ParseObject getObject() {
        return this.getParseObject("object");
    }

    public String getOperationSetUUID() {
        return this.getString("operationSetUUID");
    }

    public String getSessionToken() {
        return this.getString("sessionToken");
    }

    public ParseCommand getCommand() throws JSONException {
        return new ParseCommand(this.getJSONObject("command"));
    }

    public static Task<EventuallyPin> pinEventuallyCommand(ParseObject object, ParseCommand command) {
        int type;
        String op = command.getOp();
        JSONObject json = null;
        if (op.equals("create") || op.equals("update")) {
            type = 1;
        } else if (op.equals("delete")) {
            type = 2;
        } else {
            type = 3;
            json = command.toJSONObject();
        }
        return EventuallyPin.pinEventuallyCommand(type, object, command.getOperationSetUUID(), command.getSessionToken(), json);
    }

    private static Task<EventuallyPin> pinEventuallyCommand(int type, ParseObject obj, String operationSetUUID, String sessionToken, JSONObject command) {
        final EventuallyPin pin = new EventuallyPin();
        pin.put("uuid", UUID.randomUUID().toString());
        pin.put("time", new Date());
        pin.put("type", type);
        if (obj != null) {
            pin.put("object", obj);
        }
        if (operationSetUUID != null) {
            pin.put("operationSetUUID", operationSetUUID);
        }
        if (sessionToken != null) {
            pin.put("sessionToken", sessionToken);
        }
        if (command != null) {
            pin.put("command", command);
        }
        return pin.pinInBackground(PIN_NAME).continueWith((Continuation)new Continuation<Void, EventuallyPin>(){

            public EventuallyPin then(Task<Void> task) throws Exception {
                return pin;
            }
        });
    }

    public static Task<List<EventuallyPin>> findAllPinned() {
        return EventuallyPin.findAllPinned(null);
    }

    public static Task<List<EventuallyPin>> findAllPinned(Collection<String> excludeUUIDs) {
        ParseQuery<EventuallyPin> query = new ParseQuery<EventuallyPin>(EventuallyPin.class).fromPin(PIN_NAME, true).orderByAscending("time");
        if (excludeUUIDs != null) {
            query.whereNotContainedIn("uuid", excludeUUIDs);
        }
        return query.findInBackground().continueWithTask((Continuation)new Continuation<List<EventuallyPin>, Task<List<EventuallyPin>>>(){

            public Task<List<EventuallyPin>> then(Task<List<EventuallyPin>> task) throws Exception {
                final List pins = (List)task.getResult();
                ArrayList<Task> tasks = new ArrayList<Task>();
                for (EventuallyPin pin : pins) {
                    ParseObject object = pin.getObject();
                    if (object == null) continue;
                    tasks.add(object.fetchFromLocalDatastoreAsync().makeVoid());
                }
                return Task.whenAll(tasks).continueWithTask((Continuation)new Continuation<Void, Task<List<EventuallyPin>>>(){

                    public Task<List<EventuallyPin>> then(Task<Void> task) throws Exception {
                        return Task.forResult((Object)pins);
                    }
                });
            }
        });
    }
}

