/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.ResolveInfo;
import android.util.Log;
import bolts.AggregateException;
import bolts.Continuation;
import bolts.Task;
import com.parse.GcmRegistrar;
import com.parse.ManifestInfo;
import com.parse.OfflineStore;
import com.parse.ParseACL;
import com.parse.ParseAnonymousUtils;
import com.parse.ParseCallback;
import com.parse.ParseCommandCache;
import com.parse.ParseConfig;
import com.parse.ParseEventuallyQueue;
import com.parse.ParseException;
import com.parse.ParseFieldOperation;
import com.parse.ParseFieldOperations;
import com.parse.ParseFile;
import com.parse.ParseFileUtils;
import com.parse.ParseGeoPoint;
import com.parse.ParseInstallation;
import com.parse.ParseObject;
import com.parse.ParseObjectEncodingStrategy;
import com.parse.ParsePinningEventuallyQueue;
import com.parse.ParseQuery;
import com.parse.ParseRelation;
import com.parse.ParseRequest;
import com.parse.ParseUser;
import com.parse.codec.binary.Base64;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Parse {
    private static final String TAG = "com.parse.Parse";
    static Context applicationContext;
    static String applicationId;
    static String clientKey;
    public static final int LOG_LEVEL_VERBOSE = 2;
    public static final int LOG_LEVEL_DEBUG = 3;
    public static final int LOG_LEVEL_INFO = 4;
    public static final int LOG_LEVEL_WARNING = 5;
    public static final int LOG_LEVEL_ERROR = 6;
    public static final int LOG_LEVEL_NONE = Integer.MAX_VALUE;
    private static int logLevel;
    static int maxParseFileSize;
    static int maxKeyValueCacheBytes;
    static int maxKeyValueCacheFiles;
    private static final Object MUTEX;
    static ParseEventuallyQueue eventuallyQueue;
    private static final Object MUTEX_CALLBACKS;
    private static Set<ParseCallbacks> callbacks;
    private static final DateFormat dateFormat;
    private static ScheduledExecutorService scheduledExecutor;
    private static final Object SCHEDULED_EXECUTOR_LOCK;

    private Parse() {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Context context, String applicationId, String clientKey) {
        ParseRequest.initialize(context);
        ParseObject.registerParseSubclasses();
        Parse.applicationId = applicationId;
        Parse.clientKey = clientKey;
        if (context != null) {
            applicationContext = context.getApplicationContext();
            Parse.checkCacheApplicationId();
            new Thread("Parse.initialize Disk Check & Starting Command Cache"){

                @Override
                public void run() {
                    Parse.getEventuallyQueue();
                }
            }.start();
        }
        ParseFieldOperations.registerDefaultDecoders();
        if (!Parse.allParsePushIntentReceiversInternal()) {
            throw new SecurityException("To prevent external tampering to your app's notifications, all receivers registered to handle the following actions must have their exported attributes set to false: com.parse.push.intent.RECEIVE, com.parse.push.intent.OPEN, com.parse.push.intent.DELETE");
        }
        GcmRegistrar.updateAsync();
        ParseUser.getCurrentUser();
        ParseAnonymousUtils.initialize();
        Task.forResult(null).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                ParseInstallation.getCurrentInstallation();
                ParseConfig.getCurrentConfig();
                return null;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
        ParseCallbacks[] callbacks = Parse.collectParseCallbacks();
        if (callbacks != null) {
            for (ParseCallbacks callback : callbacks) {
                callback.onParseInitialized();
            }
        }
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            Parse.callbacks = null;
        }
    }

    private static boolean isInitialized() {
        return applicationId != null || clientKey != null;
    }

    public static void enableLocalDatastore(Context context) {
        OfflineStore.enableOfflineStore(context);
    }

    private static boolean allParsePushIntentReceiversInternal() {
        List<ResolveInfo> intentReceivers = ManifestInfo.getIntentReceivers("com.parse.push.intent.RECEIVE", "com.parse.push.intent.DELETE", "com.parse.push.intent.OPEN");
        for (ResolveInfo resolveInfo : intentReceivers) {
            if (!resolveInfo.activityInfo.exported) continue;
            return false;
        }
        return true;
    }

    static Context getApplicationContext() {
        Parse.checkContext();
        return applicationContext;
    }

    public static void setLogLevel(int logLevel) {
        Parse.logLevel = logLevel;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    private static void log(int messageLogLevel, String tag, String message, Throwable tr) {
        if (messageLogLevel >= logLevel) {
            if (tr == null) {
                Log.println((int)logLevel, (String)tag, (String)message);
            } else {
                Log.println((int)logLevel, (String)tag, (String)(message + '\n' + Log.getStackTraceString((Throwable)tr)));
            }
        }
    }

    static void logV(String tag, String message, Throwable tr) {
        Parse.log(2, tag, message, tr);
    }

    static void logV(String tag, String message) {
        Parse.logV(tag, message, null);
    }

    static void logD(String tag, String message, Throwable tr) {
        Parse.log(3, tag, message, tr);
    }

    static void logD(String tag, String message) {
        Parse.logD(tag, message, null);
    }

    static void logI(String tag, String message, Throwable tr) {
        Parse.log(4, tag, message, tr);
    }

    static void logI(String tag, String message) {
        Parse.logI(tag, message, null);
    }

    static void logW(String tag, String message, Throwable tr) {
        Parse.log(5, tag, message, tr);
    }

    static void logW(String tag, String message) {
        Parse.logW(tag, message, null);
    }

    static void logE(String tag, String message, Throwable tr) {
        Parse.log(6, tag, message, tr);
    }

    static void logE(String tag, String message) {
        Parse.logE(tag, message, null);
    }

    static void setContextIfNeeded(Context context) {
        if (applicationContext == null) {
            applicationContext = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    static File getParseDir() {
        Object object = MUTEX;
        synchronized (object) {
            Parse.checkContext();
            return applicationContext.getDir("Parse", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getParseCacheDir(String subDir) {
        Object object = MUTEX;
        synchronized (object) {
            Parse.checkContext();
            File cacheDir = new File(applicationContext.getCacheDir(), "com.parse");
            File dir = new File(cacheDir, subDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getParseFilesDir(String subDir) {
        Object object = MUTEX;
        synchronized (object) {
            Parse.checkContext();
            File cacheDir = new File(applicationContext.getFilesDir(), "com.parse");
            File dir = new File(cacheDir, subDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void recursiveDelete(File file) {
        Object object = MUTEX;
        synchronized (object) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    Parse.recursiveDelete(f);
                }
            }
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkCacheApplicationId() {
        Object object = MUTEX;
        synchronized (object) {
            if (applicationId != null) {
                File applicationIdFile = new File(Parse.getParseDir(), "applicationId");
                if (applicationIdFile.exists()) {
                    boolean matches = false;
                    try {
                        RandomAccessFile f = new RandomAccessFile(applicationIdFile, "r");
                        byte[] bytes = new byte[(int)f.length()];
                        f.readFully(bytes);
                        f.close();
                        String diskApplicationId = new String(bytes, "UTF-8");
                        matches = diskApplicationId.equals(applicationId);
                    }
                    catch (FileNotFoundException e) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!matches) {
                        Parse.recursiveDelete(Parse.getParseDir());
                    }
                }
                applicationIdFile = new File(Parse.getParseDir(), "applicationId");
                try {
                    FileOutputStream out = new FileOutputStream(applicationIdFile);
                    out.write(applicationId.getBytes("UTF-8"));
                    out.close();
                }
                catch (FileNotFoundException e) {
                }
                catch (UnsupportedEncodingException e) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static File getKeyValueCacheDir() {
        Object object = MUTEX;
        synchronized (object) {
            Parse.checkContext();
            File appCacheDir = applicationContext.getCacheDir();
            File parseCacheDir = new File(appCacheDir, "ParseKeyValueCache");
            if (parseCacheDir.isDirectory() || parseCacheDir.mkdir()) {
                return parseCacheDir;
            }
            throw new RuntimeException("could not create Parse cache directory");
        }
    }

    static File getKeyValueCacheFile(String key) {
        final String suffix = '.' + key;
        File[] matches = Parse.getKeyValueCacheDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(suffix);
            }
        });
        return matches == null || matches.length == 0 ? null : matches[0];
    }

    static long getKeyValueCacheAge(File cacheFile) {
        String name = cacheFile.getName();
        try {
            return Long.parseLong(name.substring(0, name.indexOf(46)));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    static File createKeyValueCacheFile(String key) {
        String filename = String.valueOf(new Date().getTime()) + '.' + key;
        return new File(Parse.getKeyValueCacheDir(), filename);
    }

    static void clearCacheDir() {
        File dir = Parse.getKeyValueCacheDir();
        File[] entries = dir.listFiles();
        if (entries == null) {
            return;
        }
        for (File entry : entries) {
            entry.delete();
        }
    }

    static void saveToKeyValueCache(String key, String value) {
        File prior = Parse.getKeyValueCacheFile(key);
        if (prior != null) {
            prior.delete();
        }
        File f = Parse.createKeyValueCacheFile(key);
        try {
            FileOutputStream out = new FileOutputStream(f);
            out.write(value.getBytes("UTF-8"));
            out.close();
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        File[] files = Parse.getKeyValueCacheDir().listFiles();
        int numFiles = files.length;
        int numBytes = 0;
        for (File file : files) {
            numBytes = (int)((long)numBytes + file.length());
        }
        if (numFiles > maxKeyValueCacheFiles || numBytes > maxKeyValueCacheBytes) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    int dateCompare = Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                    if (dateCompare != 0) {
                        return dateCompare;
                    }
                    return f1.getName().compareTo(f2.getName());
                }
            });
            for (File file : files) {
                numBytes = (int)((long)numBytes - file.length());
                file.delete();
                if (--numFiles <= maxKeyValueCacheFiles && numBytes <= maxKeyValueCacheBytes) break;
            }
        }
    }

    static void clearFromKeyValueCache(String key) {
        File file = Parse.getKeyValueCacheFile(key);
        if (file != null) {
            file.delete();
        }
    }

    static String loadFromKeyValueCache(String key, long maxAgeMilliseconds) {
        File file = Parse.getKeyValueCacheFile(key);
        if (file == null) {
            return null;
        }
        Date now = new Date();
        long oldestAcceptableAge = Math.max(0L, now.getTime() - maxAgeMilliseconds);
        if (Parse.getKeyValueCacheAge(file) < oldestAcceptableAge) {
            return null;
        }
        file.setLastModified(now.getTime());
        try {
            RandomAccessFile f = new RandomAccessFile(file, "r");
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            f.close();
            return new String(bytes, "UTF-8");
        }
        catch (IOException e) {
            Parse.logE(TAG, "error reading from cache", e);
            return null;
        }
    }

    static Object jsonFromKeyValueCache(String key, long maxAgeMilliseconds) {
        String raw = Parse.loadFromKeyValueCache(key, maxAgeMilliseconds);
        if (raw == null) {
            return null;
        }
        JSONTokener tokener = new JSONTokener(raw);
        try {
            Object o = tokener.nextValue();
            return o;
        }
        catch (JSONException e) {
            Parse.logE(TAG, "corrupted cache for " + key, e);
            Parse.clearFromKeyValueCache(key);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParseEventuallyQueue getEventuallyQueue() {
        Object object = MUTEX;
        synchronized (object) {
            boolean isLocalDatastoreEnabled = OfflineStore.isEnabled();
            if (eventuallyQueue == null || isLocalDatastoreEnabled && eventuallyQueue instanceof ParseCommandCache || !isLocalDatastoreEnabled && eventuallyQueue instanceof ParsePinningEventuallyQueue) {
                Parse.checkContext();
                ParseEventuallyQueue parseEventuallyQueue = eventuallyQueue = isLocalDatastoreEnabled ? new ParsePinningEventuallyQueue(applicationContext) : new ParseCommandCache(applicationContext);
                if (isLocalDatastoreEnabled && ParseCommandCache.getPendingCount() > 0) {
                    new ParseCommandCache(applicationContext);
                }
            }
            return eventuallyQueue;
        }
    }

    static void checkInit() {
        if (applicationId == null) {
            throw new RuntimeException("applicationId is null. You must call Parse.initialize(context, applicationId, clientKey) before using the Parse library.");
        }
        if (clientKey == null) {
            throw new RuntimeException("clientKey is null. You must call Parse.initialize(context, applicationId, clientKey) before using the Parse library.");
        }
    }

    static void checkContext() {
        if (applicationContext == null) {
            throw new RuntimeException("applicationContext is null. You must call Parse.initialize(context, applicationId, clientKey) before using the Parse library.");
        }
    }

    static boolean hasPermission(String permission) {
        Parse.checkContext();
        return applicationContext.checkCallingOrSelfPermission(permission) == 0;
    }

    static void requirePermission(String permission) {
        if (!Parse.hasPermission(permission)) {
            throw new IllegalStateException("To use this functionality, add this to your AndroidManifest.xml:\n<uses-permission android:name=\"" + permission + "\" />");
        }
    }

    static boolean isValidType(Object value) {
        return value instanceof JSONObject || value instanceof JSONArray || value instanceof String || value instanceof Number || value instanceof Boolean || value == JSONObject.NULL || value instanceof ParseObject || value instanceof ParseACL || value instanceof ParseFile || value instanceof ParseGeoPoint || value instanceof Date || value instanceof byte[] || value instanceof List || value instanceof Map || value instanceof ParseRelation;
    }

    static Object encode(Object object, ParseObjectEncodingStrategy objectEncoder) {
        try {
            if (object instanceof ParseObject) {
                return objectEncoder.encodeRelatedObject((ParseObject)object);
            }
            if (object instanceof ParseQuery) {
                ParseQuery query = (ParseQuery)object;
                return query.toREST();
            }
            if (object instanceof Date) {
                return Parse.encodeDate((Date)object);
            }
            if (object instanceof byte[]) {
                JSONObject json = new JSONObject();
                json.put("__type", (Object)"Bytes");
                json.put("base64", (Object)Base64.encodeBase64String((byte[])object));
                return json;
            }
            if (object instanceof ParseFile) {
                return ((ParseFile)object).encode();
            }
            if (object instanceof ParseGeoPoint) {
                ParseGeoPoint point = (ParseGeoPoint)object;
                JSONObject json = new JSONObject();
                json.put("__type", (Object)"GeoPoint");
                json.put("latitude", point.getLatitude());
                json.put("longitude", point.getLongitude());
                return json;
            }
            if (object instanceof ParseACL) {
                ParseACL acl = (ParseACL)object;
                return acl.toJSONObject(objectEncoder);
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONObject json = new JSONObject();
                for (Map.Entry pair : map.entrySet()) {
                    json.put((String)pair.getKey(), Parse.encode(pair.getValue(), objectEncoder));
                }
                return json;
            }
            if (object instanceof JSONObject) {
                JSONObject map = (JSONObject)object;
                JSONObject json = new JSONObject();
                Iterator keys = map.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    json.put(key, Parse.encode(map.opt(key), objectEncoder));
                }
                return json;
            }
            if (object instanceof List) {
                JSONArray array = new JSONArray();
                for (Object item : (List)object) {
                    array.put(Parse.encode(item, objectEncoder));
                }
                return array;
            }
            if (object instanceof JSONArray) {
                JSONArray array = (JSONArray)object;
                JSONArray json = new JSONArray();
                for (int i = 0; i < array.length(); ++i) {
                    json.put(Parse.encode(array.opt(i), objectEncoder));
                }
                return json;
            }
            if (object instanceof ParseRelation) {
                ParseRelation relation = (ParseRelation)object;
                return relation.encodeToJSON(objectEncoder);
            }
            if (object instanceof ParseFieldOperation) {
                return ((ParseFieldOperation)object).encode(objectEncoder);
            }
            if (object instanceof ParseQuery.RelationConstraint) {
                return ((ParseQuery.RelationConstraint)object).encode(objectEncoder);
            }
            if (object == null) {
                return JSONObject.NULL;
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        if (Parse.isValidType(object)) {
            return object;
        }
        throw new IllegalArgumentException("invalid type for ParseObject: " + object.getClass().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Date stringToDate(String dateString) {
        Object object = MUTEX;
        synchronized (object) {
            try {
                return dateFormat.parse(dateString);
            }
            catch (java.text.ParseException e) {
                Parse.logE(TAG, "could not parse date: " + dateString, e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String dateToString(Date date) {
        Object object = MUTEX;
        synchronized (object) {
            return dateFormat.format(date);
        }
    }

    static JSONObject encodeDate(Date date) {
        JSONObject object = new JSONObject();
        String iso = Parse.dateToString(date);
        try {
            object.put("__type", (Object)"Date");
            object.put("iso", (Object)iso);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return object;
    }

    static Iterable<String> keys(JSONObject object) {
        final JSONObject finalObject = object;
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return finalObject.keys();
            }
        };
    }

    static boolean isContainerObject(Object object) {
        return object instanceof JSONObject || object instanceof JSONArray || object instanceof ParseACL || object instanceof ParseGeoPoint || object instanceof List || object instanceof Map;
    }

    static Number addNumbers(Number first, Number second) {
        if (first instanceof Double || second instanceof Double) {
            return first.doubleValue() + second.doubleValue();
        }
        if (first instanceof Float || second instanceof Float) {
            return Float.valueOf(first.floatValue() + second.floatValue());
        }
        if (first instanceof Long || second instanceof Long) {
            return first.longValue() + second.longValue();
        }
        if (first instanceof Integer || second instanceof Integer) {
            return first.intValue() + second.intValue();
        }
        if (first instanceof Short || second instanceof Short) {
            return first.shortValue() + second.shortValue();
        }
        if (first instanceof Byte || second instanceof Byte) {
            return first.byteValue() + second.byteValue();
        }
        throw new RuntimeException("Unknown number type.");
    }

    static Number subtractNumbers(Number first, Number second) {
        if (first instanceof Double || second instanceof Double) {
            return first.doubleValue() - second.doubleValue();
        }
        if (first instanceof Float || second instanceof Float) {
            return Float.valueOf(first.floatValue() - second.floatValue());
        }
        if (first instanceof Long || second instanceof Long) {
            return first.longValue() - second.longValue();
        }
        if (first instanceof Integer || second instanceof Integer) {
            return first.intValue() - second.intValue();
        }
        if (first instanceof Short || second instanceof Short) {
            return first.shortValue() - second.shortValue();
        }
        if (first instanceof Byte || second instanceof Byte) {
            return first.byteValue() - second.byteValue();
        }
        throw new RuntimeException("Unknown number type.");
    }

    static int compareNumbers(Number first, Number second) {
        if (first instanceof Double || second instanceof Double) {
            return (int)Math.signum(first.doubleValue() - second.doubleValue());
        }
        if (first instanceof Float || second instanceof Float) {
            return (int)Math.signum(first.floatValue() - second.floatValue());
        }
        if (first instanceof Long || second instanceof Long) {
            long diff = first.longValue() - second.longValue();
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }
        if (first instanceof Integer || second instanceof Integer) {
            return first.intValue() - second.intValue();
        }
        if (first instanceof Short || second instanceof Short) {
            return first.shortValue() - second.shortValue();
        }
        if (first instanceof Byte || second instanceof Byte) {
            return first.byteValue() - second.byteValue();
        }
        throw new RuntimeException("Unknown number type.");
    }

    static String join(CharSequence delimiter, Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object item : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    static <T> T waitForTask(Task<T> task) throws ParseException {
        try {
            task.waitForCompletion();
            if (task.isFaulted()) {
                Exception error = task.getError();
                if (error instanceof ParseException) {
                    throw (ParseException)error;
                }
                if (error instanceof AggregateException) {
                    throw new ParseException(error);
                }
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new RuntimeException(error);
            }
            if (task.isCancelled()) {
                throw new RuntimeException(new CancellationException());
            }
            return (T)task.getResult();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScheduledExecutorService getScheduledExecutor() {
        Object object = SCHEDULED_EXECUTOR_LOCK;
        synchronized (object) {
            if (scheduledExecutor == null) {
                scheduledExecutor = Executors.newScheduledThreadPool(1);
            }
        }
        return scheduledExecutor;
    }

    static <T> Task<T> callbackOnMainThreadAsync(Task<T> task, ParseCallback<T> callback) {
        return Parse.callbackOnMainThreadAsync(task, callback, false);
    }

    static <T> Task<T> callbackOnMainThreadAsync(Task<T> task, final ParseCallback<T> callback, final boolean reportCancellation) {
        if (callback == null) {
            return task;
        }
        final Task.TaskCompletionSource tcs = Task.create();
        task.continueWith(new Continuation<T, Void>(){

            public Void then(final Task<T> task) throws Exception {
                if (task.isCancelled() && !reportCancellation) {
                    tcs.setCancelled();
                    return null;
                }
                Task.UI_THREAD_EXECUTOR.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Exception error = task.getError();
                            if (error != null && !(error instanceof ParseException)) {
                                error = new ParseException(error);
                            }
                            callback.internalDone(task.getResult(), (ParseException)error);
                        }
                        finally {
                            if (task.isCancelled()) {
                                tcs.setCancelled();
                            } else if (task.isFaulted()) {
                                tcs.setError(task.getError());
                            } else {
                                tcs.setResult(task.getResult());
                            }
                        }
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }

    static synchronized void saveDiskObject(File file, JSONObject object) {
        try {
            ParseFileUtils.writeByteArrayToFile(file, object.toString().getBytes(Charset.forName("UTF-8")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static synchronized JSONObject getDiskObject(File file) {
        try {
            String fileContent = new String(ParseFileUtils.readFileToByteArray(file), "UTF-8");
            JSONTokener tokener = new JSONTokener(fileContent);
            return new JSONObject(tokener);
        }
        catch (IOException e) {
            return null;
        }
        catch (JSONException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerParseCallbacks(ParseCallbacks listener) {
        if (Parse.isInitialized()) {
            throw new IllegalStateException("You must register callbacks before Parse.initialize(Context, String, String).");
        }
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            if (callbacks == null) {
                return;
            }
            callbacks.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterParseCallbacks(ParseCallbacks listener) {
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            if (callbacks == null) {
                return;
            }
            callbacks.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseCallbacks[] collectParseCallbacks() {
        ParseCallbacks[] callbacks;
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            if (Parse.callbacks == null) {
                return null;
            }
            callbacks = new ParseCallbacks[Parse.callbacks.size()];
            if (Parse.callbacks.size() > 0) {
                callbacks = Parse.callbacks.toArray(callbacks);
            }
        }
        return callbacks;
    }

    @Deprecated
    static synchronized void saveDiskObject(Context context, String filename, JSONObject object) {
        Parse.setContextIfNeeded(context);
        File file = new File(Parse.getParseDir(), filename);
        Parse.saveDiskObject(file, object);
    }

    @Deprecated
    static synchronized JSONObject getDiskObject(Context context, String filename) {
        Parse.setContextIfNeeded(context);
        File file = new File(Parse.getParseDir(), filename);
        return Parse.getDiskObject(file);
    }

    @Deprecated
    static synchronized boolean deleteDiskObject(Context context, String filename) {
        Parse.setContextIfNeeded(context);
        return ParseFileUtils.deleteQuietly(new File(Parse.getParseDir(), filename));
    }

    static {
        logLevel = 6;
        maxParseFileSize = 0xA00000;
        maxKeyValueCacheBytes = 0x200000;
        maxKeyValueCacheFiles = 1000;
        MUTEX = new Object();
        eventuallyQueue = null;
        MUTEX_CALLBACKS = new Object();
        callbacks = new HashSet<ParseCallbacks>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        format.setTimeZone(new SimpleTimeZone(0, "GMT"));
        dateFormat = format;
        SCHEDULED_EXECUTOR_LOCK = new Object();
    }

    static interface ParseCallbacks {
        public void onParseInitialized();
    }
}

