/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import android.util.Pair;
import bolts.Capture;
import bolts.Continuation;
import bolts.Task;
import com.parse.OfflineQueryLogic;
import com.parse.OfflineSQLiteOpenHelper;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseObjectEncodingStrategy;
import com.parse.ParsePin;
import com.parse.ParseQuery;
import com.parse.ParseSQLiteDatabase;
import com.parse.ParseTraverser;
import com.parse.ParseUser;
import com.parse.WeakValueHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.json.JSONException;
import org.json.JSONObject;

class OfflineStore {
    private static final int MAX_SQL_VARIABLES = 999;
    private static final Object defaultInstanceLock = new Object();
    private static OfflineStore defaultInstance = null;
    private final Object lock = new Object();
    private final OfflineSQLiteOpenHelper helper;
    private final WeakValueHashMap<String, ParseObject> uuidToObjectMap = new WeakValueHashMap();
    private final WeakValueHashMap<Pair<String, String>, ParseObject> classNameAndObjectIdToObjectMap = new WeakValueHashMap();
    private final WeakHashMap<ParseObject, Task<String>> objectToUuidMap = new WeakHashMap();
    private final WeakHashMap<ParseObject, Task<ParseObject>> fetchedObjects = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableOfflineStore(Context context) {
        Object object = defaultInstanceLock;
        synchronized (object) {
            if (defaultInstance != null) {
                throw new RuntimeException("enableOfflineStore() called multiple times.");
            }
            defaultInstance = new OfflineStore(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled() {
        Object object = defaultInstanceLock;
        synchronized (object) {
            return defaultInstance != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableOfflineStore() {
        Object object = defaultInstanceLock;
        synchronized (object) {
            defaultInstance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OfflineStore getCurrent() {
        Object object = defaultInstanceLock;
        synchronized (object) {
            return defaultInstance;
        }
    }

    private OfflineStore(Context context) {
        this.helper = new OfflineSQLiteOpenHelper(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<String> getOrCreateUUIDAsync(final ParseObject object, ParseSQLiteDatabase db) {
        final String newUUID = UUID.randomUUID().toString();
        final Task.TaskCompletionSource tcs = Task.create();
        Object object2 = this.lock;
        synchronized (object2) {
            Task<String> uuidTask = this.objectToUuidMap.get(object);
            if (uuidTask != null) {
                return uuidTask;
            }
            this.objectToUuidMap.put(object, (Task<String>)tcs.getTask());
            this.uuidToObjectMap.put(newUUID, object);
            this.fetchedObjects.put(object, (Task<ParseObject>)tcs.getTask().onSuccess((Continuation)new Continuation<String, ParseObject>(){

                public ParseObject then(Task<String> task) throws Exception {
                    return object;
                }
            }));
        }
        ContentValues values = new ContentValues();
        values.put("uuid", newUUID);
        values.put("className", object.getClassName());
        db.insertOrThrowAsync("ParseObjects", values).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                tcs.setResult((Object)newUUID);
                return null;
            }
        });
        return tcs.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ParseObject> Task<T> getPointerAsync(final String uuid, ParseSQLiteDatabase db) {
        Object object = this.lock;
        synchronized (object) {
            ParseObject existing = this.uuidToObjectMap.get(uuid);
            if (existing != null) {
                return Task.forResult((Object)existing);
            }
        }
        String[] select = new String[]{"className", "objectId"};
        String where = "uuid = ?";
        String[] args = new String[]{uuid};
        return db.queryAsync("ParseObjects", select, where, args).onSuccess(new Continuation<Cursor, T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T then(Task<Cursor> task) throws Exception {
                Cursor cursor = (Cursor)task.getResult();
                cursor.moveToFirst();
                if (cursor.isAfterLast()) {
                    throw new IllegalStateException("Attempted to find non-existent uuid " + uuid);
                }
                Object object = OfflineStore.this.lock;
                synchronized (object) {
                    ParseObject existing = (ParseObject)OfflineStore.this.uuidToObjectMap.get(uuid);
                    if (existing != null) {
                        return existing;
                    }
                    String className = cursor.getString(0);
                    String objectId = cursor.getString(1);
                    ParseObject pointer = ParseObject.createWithoutData(className, objectId);
                    if (objectId == null) {
                        OfflineStore.this.uuidToObjectMap.put(uuid, pointer);
                        OfflineStore.this.objectToUuidMap.put(pointer, Task.forResult((Object)uuid));
                    }
                    return pointer;
                }
            }
        });
    }

    <T extends ParseObject> Task<List<T>> findAsync(ParseQuery<T> query, ParseUser user, ParsePin pin, boolean includeIsDeletingEventually, boolean ignoreACLs) {
        return this.findAsync(query, user, pin, false, includeIsDeletingEventually, ignoreACLs);
    }

    <T extends ParseObject> Task<Integer> countAsync(ParseQuery<T> query, ParseUser user, ParsePin pin, boolean includeIsDeletingEventually, boolean ignoreACLS) {
        return this.findAsync(query, user, pin, true, includeIsDeletingEventually, ignoreACLS).onSuccess(new Continuation<List<T>, Integer>(){

            public Integer then(Task<List<T>> task) throws Exception {
                return ((List)task.getResult()).size();
            }
        });
    }

    <T extends ParseObject> Task<List<T>> findAsync(final ParseQuery<T> query, final ParseUser user, final ParsePin pin, final boolean isCount, final boolean includeIsDeletingEventually, final boolean ignoreACLs) {
        return this.helper.getWritableDatabaseAsync().continueWithTask(new Continuation<ParseSQLiteDatabase, Task<List<T>>>(){

            public Task<List<T>> then(Task<ParseSQLiteDatabase> task) throws Exception {
                final ParseSQLiteDatabase db = (ParseSQLiteDatabase)task.getResult();
                return OfflineStore.this.findAsync(query, user, pin, isCount, includeIsDeletingEventually, ignoreACLs, db).continueWithTask(new Continuation<List<T>, Task<List<T>>>(){

                    public Task<List<T>> then(Task<List<T>> task) throws Exception {
                        db.close();
                        return task;
                    }
                });
            }
        });
    }

    <T extends ParseObject> Task<List<T>> findAsync(final ParseQuery<T> query, final ParseUser user, ParsePin pin, final boolean isCount, final boolean includeIsDeletingEventually, final boolean ignoreACLs, final ParseSQLiteDatabase db) {
        Task<Cursor> queryTask;
        final OfflineQueryLogic queryLogic = new OfflineQueryLogic(this);
        final ArrayList results = new ArrayList();
        if (pin == null) {
            String table = "ParseObjects";
            String[] select = new String[]{"uuid"};
            String where = "className=?";
            if (!includeIsDeletingEventually) {
                where = where + " AND isDeletingEventually=0";
            }
            String[] args = new String[]{query.getClassName()};
            queryTask = db.queryAsync(table, select, where, args);
        } else {
            Task<String> uuidTask = this.objectToUuidMap.get(pin);
            if (uuidTask == null) {
                return Task.forResult(results);
            }
            queryTask = uuidTask.onSuccessTask((Continuation)new Continuation<String, Task<Cursor>>(){

                public Task<Cursor> then(Task<String> task) throws Exception {
                    String uuid = (String)task.getResult();
                    String table = "ParseObjects A  INNER JOIN Dependencies B  ON A.uuid=B.uuid";
                    String[] select = new String[]{"A.uuid"};
                    String where = "className=? AND key=?";
                    if (!includeIsDeletingEventually) {
                        where = where + " AND isDeletingEventually=0";
                    }
                    String[] args = new String[]{query.getClassName(), uuid};
                    return db.queryAsync(table, select, where, args);
                }
            });
        }
        return queryTask.onSuccessTask((Continuation)new Continuation<Cursor, Task<Void>>(){

            public Task<Void> then(Task<Cursor> task) throws Exception {
                Cursor cursor = (Cursor)task.getResult();
                final OfflineQueryLogic.ConstraintMatcher matcher = queryLogic.createMatcher(query, user, ignoreACLs);
                Task checkedAllObjects = Task.forResult(null);
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    final String uuid = cursor.getString(0);
                    final Capture object = new Capture();
                    checkedAllObjects = checkedAllObjects.onSuccessTask(new Continuation<Void, Task<T>>(){

                        public Task<T> then(Task<Void> task) throws Exception {
                            return OfflineStore.this.getPointerAsync(uuid, db);
                        }
                    }).onSuccessTask(new Continuation<T, Task<T>>(){

                        public Task<T> then(Task<T> task) throws Exception {
                            object.set(task.getResult());
                            return OfflineStore.this.fetchLocallyAsync((ParseObject)object.get(), db);
                        }
                    }).onSuccessTask(new Continuation<T, Task<Boolean>>(){

                        public Task<Boolean> then(Task<T> task) throws Exception {
                            if (!((ParseObject)object.get()).isDataAvailable()) {
                                return Task.forResult((Object)false);
                            }
                            return matcher.matchesAsync((ParseObject)object.get(), db);
                        }
                    }).onSuccess((Continuation)new Continuation<Boolean, Void>(){

                        public Void then(Task<Boolean> task) {
                            if (((Boolean)task.getResult()).booleanValue()) {
                                results.add(object.get());
                            }
                            return null;
                        }
                    });
                    cursor.moveToNext();
                }
                return checkedAllObjects;
            }
        }).onSuccessTask(new Continuation<Void, Task<List<T>>>(){

            public Task<List<T>> then(Task<Void> task) throws Exception {
                queryLogic.sort(results, query);
                List trimmedResults = results;
                int skip = query.getSkip();
                if (!isCount && skip >= 0) {
                    skip = Math.min(query.getSkip(), trimmedResults.size());
                    trimmedResults = trimmedResults.subList(skip, trimmedResults.size());
                }
                int limit = query.getLimit();
                if (!isCount && limit >= 0 && trimmedResults.size() > limit) {
                    trimmedResults = trimmedResults.subList(0, limit);
                }
                Task fetchedIncludes = Task.forResult(null);
                for (final ParseObject object : trimmedResults) {
                    fetchedIncludes = fetchedIncludes.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                        public Task<Void> then(Task<Void> task) throws Exception {
                            return queryLogic.fetchIncludes(object, query, db);
                        }
                    });
                }
                final List finalTrimmedResults = trimmedResults;
                return fetchedIncludes.onSuccess(new Continuation<Void, List<T>>(){

                    public List<T> then(Task<Void> task) throws Exception {
                        return finalTrimmedResults;
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<ParseObject, Boolean> getOrCreateObjectWithoutData(String className, String objectId) {
        if (objectId == null) {
            throw new IllegalStateException("objectId cannot be null.");
        }
        Pair classNameAndObjectId = Pair.create((Object)className, (Object)objectId);
        Object object = this.lock;
        synchronized (object) {
            ParseObject object2 = this.classNameAndObjectIdToObjectMap.get((Pair<String, String>)classNameAndObjectId);
            if (object2 != null) {
                return Pair.create((Object)object2, (Object)false);
            }
            return Pair.create((Object)ParseObject.create(className), (Object)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateObjectId(ParseObject object, String oldObjectId, String newObjectId) {
        if (oldObjectId != null) {
            if (oldObjectId.equals(newObjectId)) {
                return;
            }
            throw new RuntimeException("objectIds cannot be changed in offline mode.");
        }
        String className = object.getClassName();
        Pair classNameAndNewObjectId = Pair.create((Object)className, (Object)newObjectId);
        Object object2 = this.lock;
        synchronized (object2) {
            ParseObject existing = this.classNameAndObjectIdToObjectMap.get((Pair<String, String>)classNameAndNewObjectId);
            if (existing != null && existing != object) {
                throw new RuntimeException("Attempted to change an objectId to one that's already known to the Offline Store.");
            }
            this.classNameAndObjectIdToObjectMap.put((Pair<String, String>)classNameAndNewObjectId, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends ParseObject> Task<T> fetchLocallyAsync(final T object, final ParseSQLiteDatabase db) {
        Task<String> uuidTask;
        final Task.TaskCompletionSource tcs = Task.create();
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.fetchedObjects.containsKey(object)) {
                return this.fetchedObjects.get(object);
            }
            this.fetchedObjects.put(object, (Task<ParseObject>)tcs.getTask());
            uuidTask = this.objectToUuidMap.get(object);
        }
        String className = object.getClassName();
        String objectId = object.getObjectId();
        Task jsonStringTask = Task.forResult(null);
        if (objectId == null) {
            if (uuidTask != null) {
                final String[] select = new String[]{"json"};
                String where = "uuid = ?";
                final Capture uuid = new Capture();
                jsonStringTask = uuidTask.onSuccessTask((Continuation)new Continuation<String, Task<Cursor>>(){

                    public Task<Cursor> then(Task<String> task) throws Exception {
                        uuid.set(task.getResult());
                        String[] args = new String[]{(String)uuid.get()};
                        return db.queryAsync("ParseObjects", select, "uuid = ?", args);
                    }
                }).onSuccess((Continuation)new Continuation<Cursor, String>(){

                    public String then(Task<Cursor> task) throws Exception {
                        Cursor cursor = (Cursor)task.getResult();
                        cursor.moveToFirst();
                        if (cursor.isAfterLast()) {
                            throw new IllegalStateException("Attempted to find non-existent uuid " + (String)uuid.get());
                        }
                        return cursor.getString(0);
                    }
                });
            }
        } else {
            if (uuidTask != null) {
                tcs.setError((Exception)new IllegalStateException("This object must have already been fetched from the local datastore, but isn't marked as fetched."));
                Object select = this.lock;
                synchronized (select) {
                    this.fetchedObjects.remove(object);
                }
                return tcs.getTask();
            }
            String[] select = new String[]{"json", "uuid"};
            String where = String.format("%s = ? AND %s = ?", "className", "objectId");
            String[] args = new String[]{className, objectId};
            jsonStringTask = db.queryAsync("ParseObjects", select, where, args).onSuccess((Continuation)new Continuation<Cursor, String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public String then(Task<Cursor> task) throws Exception {
                    Cursor cursor = (Cursor)task.getResult();
                    cursor.moveToFirst();
                    if (cursor.isAfterLast()) {
                        throw new ParseException(120, "This object is not available in the offline cache.");
                    }
                    String jsonString = cursor.getString(0);
                    String newUUID = cursor.getString(1);
                    Object object2 = OfflineStore.this.lock;
                    synchronized (object2) {
                        OfflineStore.this.objectToUuidMap.put(object, Task.forResult((Object)newUUID));
                        OfflineStore.this.uuidToObjectMap.put(newUUID, object);
                    }
                    return jsonString;
                }
            });
        }
        return jsonStringTask.onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                JSONObject json;
                String jsonString = (String)task.getResult();
                if (jsonString == null) {
                    return Task.forError((Exception)new ParseException(120, "Attempted to fetch an object offline which was never saved to the offline cache."));
                }
                try {
                    json = new JSONObject(jsonString);
                }
                catch (JSONException e) {
                    return Task.forError((Exception)((Object)e));
                }
                final HashMap offlineObjects = new HashMap();
                new ParseTraverser(){

                    @Override
                    protected boolean visit(Object object) {
                        if (object instanceof JSONObject && ((JSONObject)object).optString("__type").equals("OfflineObject")) {
                            String uuid = ((JSONObject)object).optString("uuid");
                            offlineObjects.put(uuid, OfflineStore.this.getPointerAsync(uuid, db));
                        }
                        return true;
                    }
                }.setTraverseParseObjects(false).setYieldRoot(false).traverse(json);
                return Task.whenAll(offlineObjects.values()).onSuccess((Continuation)new Continuation<Void, Void>(){

                    public Void then(Task<Void> task) throws Exception {
                        object.mergeREST(json, new OfflineDecoder(offlineObjects));
                        return null;
                    }
                });
            }
        }).continueWithTask(new Continuation<Void, Task<T>>(){

            public Task<T> then(Task<Void> task) throws Exception {
                if (task.isCancelled()) {
                    tcs.setCancelled();
                } else if (task.isFaulted()) {
                    tcs.setError(task.getError());
                } else {
                    tcs.setResult((Object)object);
                }
                return tcs.getTask();
            }
        });
    }

    <T extends ParseObject> Task<T> fetchLocallyAsync(final T object) {
        return this.helper.getWritableDatabaseAsync().continueWithTask(new Continuation<ParseSQLiteDatabase, Task<T>>(){

            public Task<T> then(Task<ParseSQLiteDatabase> task) throws Exception {
                final ParseSQLiteDatabase db = (ParseSQLiteDatabase)task.getResult();
                return OfflineStore.this.fetchLocallyAsync(object, db).continueWithTask(new Continuation<T, Task<T>>(){

                    public Task<T> then(Task<T> task) throws Exception {
                        db.close();
                        return task;
                    }
                });
            }
        });
    }

    private Task<Void> saveLocallyAsync(final String key, final ParseObject object, final ParseSQLiteDatabase db) {
        if (!(object.getObjectId() == null || object.isDataAvailable() || object.hasChanges() || object.hasOutstandingOperations())) {
            return Task.forResult(null);
        }
        final Capture uuid = new Capture();
        final Capture encoded = new Capture();
        return this.fetchLocallyAsync(object, db).continueWithTask((Continuation)new Continuation<ParseObject, Task<ParseObject>>(){

            public Task<ParseObject> then(Task<ParseObject> task) throws Exception {
                if (task.isFaulted() && task.getError() instanceof ParseException && ((ParseException)task.getError()).getCode() == 120) {
                    return Task.forResult(null);
                }
                return task;
            }
        }).onSuccessTask((Continuation)new Continuation<ParseObject, Task<String>>(){

            public Task<String> then(Task<ParseObject> task) throws Exception {
                return OfflineStore.this.getOrCreateUUIDAsync(object, db);
            }
        }).onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                uuid.set(task.getResult());
                OfflineEncodingStrategy encoder = new OfflineEncodingStrategy(db);
                encoded.set((Object)object.toRest(encoder));
                return encoder.whenFinished();
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                String className = object.getClassName();
                String objectId = object.getObjectId();
                String json = encoded.get().toString();
                ContentValues values = new ContentValues();
                values.put("className", className);
                values.put("json", json);
                if (objectId != null) {
                    values.put("objectId", objectId);
                }
                String where = "uuid = ?";
                String[] args = new String[]{(String)uuid.get()};
                return db.updateAsync("ParseObjects", values, where, args).makeVoid();
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                ContentValues values = new ContentValues();
                values.put("key", key);
                values.put("uuid", (String)uuid.get());
                return db.insertWithOnConflict("Dependencies", values, 4);
            }
        });
    }

    Task<Void> saveLocallyAsync(final ParseObject object, final boolean includeAllChildren) {
        return this.helper.getWritableDatabaseAsync().continueWithTask((Continuation)new Continuation<ParseSQLiteDatabase, Task<Void>>(){

            public Task<Void> then(Task<ParseSQLiteDatabase> task) throws Exception {
                final ParseSQLiteDatabase db = (ParseSQLiteDatabase)task.getResult();
                return db.beginTransactionAsync().onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        return OfflineStore.this.saveLocallyAsync(object, includeAllChildren, db);
                    }
                }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        return db.setTransactionSuccessfulAsync();
                    }
                }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        db.endTransactionAsync();
                        db.close();
                        return task;
                    }
                });
            }
        });
    }

    Task<Void> saveLocallyAsync(final ParseObject object, boolean includeAllChildren, final ParseSQLiteDatabase db) {
        final ArrayList<ParseObject> objectsInTree = new ArrayList<ParseObject>();
        if (!includeAllChildren) {
            objectsInTree.add(object);
            return this.fetchLocallyAsync(object, db).makeVoid();
        }
        new ParseTraverser(){

            @Override
            protected boolean visit(Object object) {
                if (object instanceof ParseObject) {
                    objectsInTree.add((ParseObject)object);
                }
                return true;
            }
        }.setYieldRoot(true).setTraverseParseObjects(true).traverse(object);
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (ParseObject obj : objectsInTree) {
            tasks.add(this.fetchLocallyAsync(obj, db).makeVoid());
        }
        return Task.whenAll(tasks).continueWithTask((Continuation)new Continuation<Void, Task<String>>(){

            public Task<String> then(Task<Void> task) throws Exception {
                return (Task)OfflineStore.this.objectToUuidMap.get(object);
            }
        }).onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String uuid = (String)task.getResult();
                if (uuid == null) {
                    return null;
                }
                return OfflineStore.this.unpinAsync(uuid, db);
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<String>>(){

            public Task<String> then(Task<Void> task) throws Exception {
                return OfflineStore.this.getOrCreateUUIDAsync(object, db);
            }
        }).onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String uuid = (String)task.getResult();
                ArrayList<Task> tasks = new ArrayList<Task>();
                for (ParseObject obj : objectsInTree) {
                    tasks.add(OfflineStore.this.saveLocallyAsync(uuid, obj, db));
                }
                return Task.whenAll(tasks);
            }
        });
    }

    Task<Void> unpinAsync(final ParseObject object) {
        return Task.forResult(null).continueWithTask((Continuation)new Continuation<Void, Task<String>>(){

            public Task<String> then(Task<Void> task) throws Exception {
                return (Task)OfflineStore.this.objectToUuidMap.get(object);
            }
        }).continueWithTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String uuid = (String)task.getResult();
                if (uuid == null) {
                    return Task.forResult(null);
                }
                return OfflineStore.this.unpinAsync(uuid);
            }
        });
    }

    private Task<Void> unpinAsync(final String key) {
        return this.helper.getWritableDatabaseAsync().onSuccessTask((Continuation)new Continuation<ParseSQLiteDatabase, Task<Void>>(){

            public Task<Void> then(Task<ParseSQLiteDatabase> task) throws Exception {
                final ParseSQLiteDatabase db = (ParseSQLiteDatabase)task.getResult();
                return db.beginTransactionAsync().onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        return OfflineStore.this.unpinAsync(key, db).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                            public Task<Void> then(Task<Void> task) throws Exception {
                                return db.setTransactionSuccessfulAsync();
                            }
                        }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                            public Task<Void> then(Task<Void> task) throws Exception {
                                db.endTransactionAsync();
                                db.close();
                                return task;
                            }
                        });
                    }
                });
            }
        });
    }

    private Task<Void> unpinAsync(final String key, final ParseSQLiteDatabase db) {
        final LinkedList uuidsToDelete = new LinkedList();
        return Task.forResult((Object)null).continueWithTask((Continuation)new Continuation<Void, Task<Cursor>>(){

            public Task<Cursor> then(Task<Void> task) throws Exception {
                String sql = "SELECT uuid FROM Dependencies WHERE key=? AND uuid IN ( SELECT uuid FROM Dependencies GROUP BY uuid HAVING COUNT(uuid)=1)";
                String[] args = new String[]{key};
                return db.rawQueryAsync(sql, args);
            }
        }).onSuccessTask((Continuation)new Continuation<Cursor, Task<Void>>(){

            public Task<Void> then(Task<Cursor> task) throws Exception {
                Cursor cursor = (Cursor)task.getResult();
                while (cursor.moveToNext()) {
                    uuidsToDelete.add(cursor.getString(0));
                }
                return OfflineStore.this.deleteObjects(uuidsToDelete, db);
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                String where = "key=?";
                String[] args = new String[]{key};
                return db.deleteAsync("Dependencies", where, args);
            }
        }).onSuccess((Continuation)new Continuation<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void then(Task<Void> task) throws Exception {
                Object object = OfflineStore.this.lock;
                synchronized (object) {
                    for (String uuid : uuidsToDelete) {
                        ParseObject object2 = (ParseObject)OfflineStore.this.uuidToObjectMap.get(uuid);
                        if (object2 == null) continue;
                        OfflineStore.this.objectToUuidMap.remove(object2);
                        OfflineStore.this.uuidToObjectMap.remove(uuid);
                    }
                }
                return null;
            }
        });
    }

    private Task<Void> deleteObjects(final List<String> uuids, final ParseSQLiteDatabase db) {
        if (uuids.size() <= 0) {
            return Task.forResult(null);
        }
        if (uuids.size() > 999) {
            return this.deleteObjects(uuids.subList(0, 999), db).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return OfflineStore.this.deleteObjects(uuids.subList(999, uuids.size()), db);
                }
            });
        }
        Object[] placeholders = new String[uuids.size()];
        for (int i = 0; i < placeholders.length; ++i) {
            placeholders[i] = "?";
        }
        String where = "uuid IN (" + TextUtils.join((CharSequence)",", (Object[])placeholders) + ")";
        String[] args = uuids.toArray(new String[uuids.size()]);
        return db.deleteAsync("ParseObjects", where, args);
    }

    void registerNewObject(ParseObject object) {
        String objectId = object.getObjectId();
        if (objectId != null) {
            String className = object.getClassName();
            Pair classNameAndObjectId = Pair.create((Object)className, (Object)objectId);
            this.classNameAndObjectIdToObjectMap.put((Pair<String, String>)classNameAndObjectId, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> updateDataForObjectAsync(final ParseObject object) {
        Task<ParseObject> fetched;
        Object object2 = this.lock;
        synchronized (object2) {
            fetched = this.fetchedObjects.get(object);
            if (fetched == null) {
                return Task.forError((Exception)new IllegalStateException("An object cannot be updated if it wasn't fetched."));
            }
        }
        return fetched.continueWithTask((Continuation)new Continuation<ParseObject, Task<Void>>(){

            public Task<Void> then(Task<ParseObject> task) throws Exception {
                if (task.isFaulted()) {
                    if (task.getError() instanceof ParseException && ((ParseException)task.getError()).getCode() == 120) {
                        return Task.forResult(null);
                    }
                    return task.makeVoid();
                }
                return OfflineStore.this.helper.getWritableDatabaseAsync().continueWithTask((Continuation)new Continuation<ParseSQLiteDatabase, Task<Void>>(){

                    public Task<Void> then(Task<ParseSQLiteDatabase> task) throws Exception {
                        final ParseSQLiteDatabase db = (ParseSQLiteDatabase)task.getResult();
                        return db.beginTransactionAsync().onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                            public Task<Void> then(Task<Void> task) throws Exception {
                                return OfflineStore.this.updateDataForObjectAsync(object, db).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                                    public Task<Void> then(Task<Void> task) throws Exception {
                                        return db.setTransactionSuccessfulAsync();
                                    }
                                }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                    public Task<Void> then(Task<Void> task) throws Exception {
                                        db.endTransactionAsync();
                                        db.close();
                                        return task;
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> updateDataForObjectAsync(final ParseObject object, final ParseSQLiteDatabase db) {
        Task<String> uuidTask;
        final Capture uuid = new Capture();
        final Capture jsonObject = new Capture();
        Object object2 = this.lock;
        synchronized (object2) {
            uuidTask = this.objectToUuidMap.get(object);
            if (uuidTask == null) {
                return Task.forResult(null);
            }
        }
        return uuidTask.onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                uuid.set(task.getResult());
                OfflineEncodingStrategy encoder = new OfflineEncodingStrategy(db);
                jsonObject.set((Object)object.toRest(encoder));
                return encoder.whenFinished();
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                String className = object.getClassName();
                String objectId = object.getObjectId();
                String json = ((JSONObject)jsonObject.get()).toString();
                int isDeletingEventually = ((JSONObject)jsonObject.get()).getInt("isDeletingEventually");
                ContentValues values = new ContentValues();
                values.put("className", className);
                values.put("json", json);
                if (objectId != null) {
                    values.put("objectId", objectId);
                }
                values.put("isDeletingEventually", Integer.valueOf(isDeletingEventually));
                String where = "uuid = ?";
                String[] args = new String[]{(String)uuid.get()};
                return db.updateAsync("ParseObjects", values, where, args).makeVoid();
            }
        });
    }

    Task<Void> deleteDataForObjectAsync(final ParseObject object) {
        return this.helper.getWritableDatabaseAsync().continueWithTask((Continuation)new Continuation<ParseSQLiteDatabase, Task<Void>>(){

            public Task<Void> then(Task<ParseSQLiteDatabase> task) throws Exception {
                final ParseSQLiteDatabase db = (ParseSQLiteDatabase)task.getResult();
                return db.beginTransactionAsync().onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        return OfflineStore.this.deleteDataForObjectAsync(object, db).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                            public Task<Void> then(Task<Void> task) throws Exception {
                                return db.setTransactionSuccessfulAsync();
                            }
                        }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                            public Task<Void> then(Task<Void> task) throws Exception {
                                db.endTransactionAsync();
                                db.close();
                                return task;
                            }
                        });
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> deleteDataForObjectAsync(final ParseObject object, final ParseSQLiteDatabase db) {
        Task uuidTask;
        final Capture uuid = new Capture();
        Object object2 = this.lock;
        synchronized (object2) {
            uuidTask = this.objectToUuidMap.get(object);
            if (uuidTask == null) {
                return Task.forResult(null);
            }
        }
        uuidTask = uuidTask.onSuccessTask((Continuation)new Continuation<String, Task<String>>(){

            public Task<String> then(Task<String> task) throws Exception {
                uuid.set(task.getResult());
                return task;
            }
        });
        Task unpinTask = uuidTask.onSuccessTask((Continuation)new Continuation<String, Task<Cursor>>(){

            public Task<Cursor> then(Task<String> task) throws Exception {
                String[] select = new String[]{"key"};
                String where = "uuid=?";
                String[] args = new String[]{(String)uuid.get()};
                return db.queryAsync("Dependencies", select, where, args);
            }
        }).onSuccessTask((Continuation)new Continuation<Cursor, Task<Void>>(){

            public Task<Void> then(Task<Cursor> task) throws Exception {
                Cursor cursor = (Cursor)task.getResult();
                ArrayList<Task> tasks = new ArrayList<Task>();
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    final String uuid = cursor.getString(0);
                    Task unpinTask = OfflineStore.this.getPointerAsync(uuid, db).onSuccessTask((Continuation)new Continuation<ParseObject, Task<ParsePin>>(){

                        public Task<ParsePin> then(Task<ParseObject> task) throws Exception {
                            ParsePin pin = (ParsePin)task.getResult();
                            return OfflineStore.this.fetchLocallyAsync(pin, db);
                        }
                    }).continueWithTask((Continuation)new Continuation<ParsePin, Task<Void>>(){

                        public Task<Void> then(Task<ParsePin> task) throws Exception {
                            ParsePin pin = (ParsePin)task.getResult();
                            List<ParseObject> modified = pin.getObjects();
                            if (modified == null || !modified.contains(object)) {
                                return task.makeVoid();
                            }
                            modified.remove(object);
                            if (modified.size() == 0) {
                                return OfflineStore.this.unpinAsync(uuid, db);
                            }
                            pin.setObjects(modified);
                            return OfflineStore.this.saveLocallyAsync(pin, true, db);
                        }
                    });
                    tasks.add(unpinTask);
                    cursor.moveToNext();
                }
                return Task.whenAll(tasks);
            }
        });
        return unpinTask.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                String where = "uuid=?";
                String[] args = new String[]{(String)uuid.get()};
                return db.deleteAsync("Dependencies", where, args);
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                String where = "uuid=?";
                String[] args = new String[]{(String)uuid.get()};
                return db.deleteAsync("ParseObjects", where, args);
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<Void> then(Task<Void> task) throws Exception {
                Object object2 = OfflineStore.this.lock;
                synchronized (object2) {
                    String objectId = object.getObjectId();
                    if (objectId != null) {
                        OfflineStore.this.classNameAndObjectIdToObjectMap.remove(Pair.create((Object)object.getClassName(), (Object)objectId));
                    }
                    OfflineStore.this.fetchedObjects.remove(object);
                }
                return task;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void simulateReboot() {
        Object object = this.lock;
        synchronized (object) {
            this.uuidToObjectMap.clear();
            this.objectToUuidMap.clear();
            this.classNameAndObjectIdToObjectMap.clear();
            this.fetchedObjects.clear();
        }
    }

    void clearDatabase(Context context) {
        this.helper.clearDatabase(context);
    }

    private class OfflineEncodingStrategy
    implements ParseObjectEncodingStrategy {
        private ParseSQLiteDatabase db;
        private ArrayList<Task<Void>> tasks = new ArrayList();
        private final Object tasksLock = new Object();

        public OfflineEncodingStrategy(ParseSQLiteDatabase db) {
            this.db = db;
        }

        public Task<Void> whenFinished() {
            return Task.whenAll(this.tasks).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Task<Void> then(Task<Void> ignore) throws Exception {
                    Object object = OfflineEncodingStrategy.this.tasksLock;
                    synchronized (object) {
                        for (Task task : OfflineEncodingStrategy.this.tasks) {
                            if (!task.isFaulted() && !task.isCancelled()) continue;
                            return task;
                        }
                        OfflineEncodingStrategy.this.tasks.clear();
                        return Task.forResult((Object)null);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JSONObject encodeRelatedObject(ParseObject object) {
            try {
                if (object.getObjectId() != null) {
                    JSONObject result = new JSONObject();
                    result.put("__type", (Object)"Pointer");
                    result.put("objectId", (Object)object.getObjectId());
                    result.put("className", (Object)object.getClassName());
                    return result;
                }
                final JSONObject result = new JSONObject();
                result.put("__type", (Object)"OfflineObject");
                Object object2 = this.tasksLock;
                synchronized (object2) {
                    this.tasks.add((Task<Void>)OfflineStore.this.getOrCreateUUIDAsync(object, this.db).onSuccess((Continuation)new Continuation<String, Void>(){

                        public Void then(Task<String> task) throws Exception {
                            result.put("uuid", task.getResult());
                            return null;
                        }
                    }));
                }
                return result;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class OfflineDecoder
    extends ParseDecoder {
        private Map<String, Task<ParseObject>> offlineObjects;

        private OfflineDecoder(Map<String, Task<ParseObject>> offlineObjects) {
            this.offlineObjects = offlineObjects;
        }

        @Override
        public Object decode(Object object) {
            if (object instanceof JSONObject && ((JSONObject)object).optString("__type").equals("OfflineObject")) {
                String uuid = ((JSONObject)object).optString("uuid");
                return this.offlineObjects.get(uuid).getResult();
            }
            return super.decode(object);
        }
    }
}

