/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.net.http.AndroidHttpClient;
import android.os.Build;
import bolts.Continuation;
import bolts.Task;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ProgressCallback;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

abstract class ParseRequest<Response, Result> {
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ParseRequest.NETWORK_EXECUTOR-thread-" + this.mCount.getAndIncrement());
        }
    };
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int MAX_POOL_SIZE = CPU_COUNT * 2 * 2 + 1;
    private static final long KEEP_ALIVE_TIME = 1L;
    private static final int MAX_QUEUE_SIZE = 128;
    static final ExecutorService NETWORK_EXECUTOR = ParseRequest.newThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), sThreadFactory);
    private static final int SOCKET_OPERATION_TIMEOUT = 10000;
    protected static final int DEFAULT_MAX_RETRIES = 4;
    private static HttpClient defaultClient = null;
    private static long defaultInitialRetryDelay = 1000L;
    private static volatile String UserAgent;
    private HttpClient client;
    private HttpUriRequest request;
    protected int maxRetries = 4;
    protected int method;
    protected String url;
    private AtomicReference<Task.TaskCompletionSource> currentTask = new AtomicReference();

    private static ThreadPoolExecutor newThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, workQueue, threadFactory);
        if (Build.VERSION.SDK_INT >= 9) {
            executor.allowCoreThreadTimeOut(true);
        }
        return executor;
    }

    public static void setDefaultClient(HttpClient client) {
        defaultClient = client;
    }

    public static HttpClient getDefaultClient() {
        if (defaultClient == null) {
            throw new IllegalStateException("Can't send Parse HTTPS request before Parse.initialize()");
        }
        return defaultClient;
    }

    public static void setDefaultInitialRetryDelay(long delay) {
        defaultInitialRetryDelay = delay;
    }

    public static long getDefaultInitialRetryDelay() {
        return defaultInitialRetryDelay;
    }

    public static void initialize(Context context) {
        if (defaultClient == null) {
            defaultClient = ParseRequest.newHttpClient(context);
        }
    }

    private static String getUserAgent(Context context) {
        if (UserAgent == null) {
            String packageVersion = "unknown";
            try {
                String packageName = context.getPackageName();
                int versionCode = context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
                packageVersion = packageName + "/" + versionCode;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            UserAgent = "Parse Android SDK 1.7.1 (" + packageVersion + ") API Level " + Build.VERSION.SDK_INT;
        }
        return UserAgent;
    }

    private static HttpClient newHttpClient(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context passed to newHttpClient should not be null.");
        }
        context = context.getApplicationContext();
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)10000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)10000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        SSLSessionCache sessionCache = new SSLSessionCache(context);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)ParseRequest.getUserAgent(context));
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLCertificateSocketFactory.getHttpSocketFactory((int)10000, (SSLSessionCache)sessionCache), 443));
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(20));
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)20);
        String host = System.getProperty("http.proxyHost");
        String portString = System.getProperty("http.proxyPort");
        if (host != null && host.length() != 0 && portString != null && portString.length() != 0) {
            int port = Integer.parseInt(portString);
            HttpHost proxy = new HttpHost(host, port, "http");
            params.setParameter("http.route.default-proxy", (Object)proxy);
        }
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        return new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)params);
    }

    public ParseRequest(String url) {
        this(0, url);
    }

    public ParseRequest(int method, String url) {
        this.client = defaultClient;
        this.method = method;
        this.url = url;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMaxRetries(int max) {
        this.maxRetries = max;
    }

    protected Task<Void> onPreExecute(Task<Void> task) {
        return null;
    }

    protected HttpEntity newEntity() {
        return null;
    }

    protected HttpUriRequest newRequest() throws ParseException {
        HttpGet request;
        if (this.method == 0) {
            request = new HttpGet(this.url);
        } else if (this.method == 1) {
            Pattern s3UrlPattern;
            Matcher s3UrlMatcher;
            String hostHeader = null;
            if (this.url.contains(".s3.amazonaws.com") && (s3UrlMatcher = (s3UrlPattern = Pattern.compile("^https://([a-zA-Z0-9.]*\\.s3\\.amazonaws\\.com)/?.*")).matcher(this.url)).matches()) {
                String hostname = s3UrlMatcher.group(1);
                this.url = this.url.replace(hostname, "s3.amazonaws.com");
                hostHeader = hostname;
            }
            HttpPost post = new HttpPost(this.url);
            post.setEntity(this.newEntity());
            if (hostHeader != null) {
                post.addHeader("Host", hostHeader);
            }
            request = post;
        } else {
            throw new IllegalStateException("Invalid method " + this.method);
        }
        AndroidHttpClient.modifyRequestToAcceptGzipResponse((HttpRequest)request);
        return request;
    }

    protected Task<Result> onPostExecute(Task<Response> task) throws ParseException {
        return task.cast();
    }

    private Task<Response> sendOneRequestAsync(final ProgressCallback progressCallback) {
        if (this.currentTask.get().getTask().isCancelled()) {
            return Task.cancelled();
        }
        return Task.call((Callable)new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                try {
                    HttpResponse response = ParseRequest.this.client.execute(ParseRequest.this.request);
                    return ParseRequest.this.onResponse(response, progressCallback);
                }
                catch (ClientProtocolException e) {
                    throw ParseRequest.this.connectionFailed("bad protocol", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw ParseRequest.this.connectionFailed("i/o failure", e);
                }
            }
        }, (Executor)NETWORK_EXECUTOR).continueWithTask(new Continuation<Response, Task<Response>>(){

            public Task<Response> then(Task<Response> task) throws Exception {
                return task;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    protected abstract Response onResponse(HttpResponse var1, ProgressCallback var2) throws IOException, ParseException;

    public Task<Result> executeAsync() {
        return this.executeAsync(null);
    }

    public Task<Result> executeAsync(final ProgressCallback progressCallback) {
        final Task.TaskCompletionSource tcs = Task.create();
        this.currentTask.set(tcs);
        Task.forResult(null).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseRequest.this.onPreExecute(task);
            }
        }).onSuccessTask(new Continuation<Void, Task<Response>>(){

            public Task<Response> then(Task<Void> task) throws Exception {
                long delay = defaultInitialRetryDelay + (long)((double)defaultInitialRetryDelay * Math.random());
                if (ParseRequest.this.request == null) {
                    ParseRequest.this.request = ParseRequest.this.newRequest();
                }
                return ParseRequest.this.executeAsync(0, delay, progressCallback);
            }
        }).onSuccessTask(new Continuation<Response, Task<Result>>(){

            public Task<Result> then(Task<Response> task) throws Exception {
                return ParseRequest.this.onPostExecute(task);
            }
        }).continueWithTask(new Continuation<Result, Task<Void>>(){

            public Task<Void> then(Task<Result> task) throws Exception {
                if (task.isCancelled()) {
                    tcs.trySetCancelled();
                } else if (task.isFaulted()) {
                    tcs.trySetError(task.getError());
                } else {
                    tcs.trySetResult(task.getResult());
                }
                return null;
            }
        });
        return tcs.getTask();
    }

    private Task<Response> executeAsync(final int attemptsMade, final long delay, final ProgressCallback progressCallback) {
        return this.sendOneRequestAsync(progressCallback).continueWithTask(new Continuation<Response, Task<Response>>(){

            public Task<Response> then(Task<Response> task) throws Exception {
                if (task.isFaulted() && task.getError() instanceof ParseException) {
                    if (((Task.TaskCompletionSource)ParseRequest.this.currentTask.get()).getTask().isCancelled()) {
                        return Task.cancelled();
                    }
                    if (attemptsMade < ParseRequest.this.maxRetries) {
                        Parse.logI("com.parse.ParseRequest", "Request failed. Waiting " + delay + " milliseconds before attempt #" + (attemptsMade + 1));
                        final Task.TaskCompletionSource retryTask = Task.create();
                        Parse.getScheduledExecutor().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ParseRequest.this.executeAsync(attemptsMade + 1, delay * 2L, progressCallback).continueWithTask(new Continuation<Response, Task<Void>>(){

                                    public Task<Void> then(Task<Response> task) throws Exception {
                                        if (task.isCancelled()) {
                                            retryTask.setCancelled();
                                        } else if (task.isFaulted()) {
                                            retryTask.setError(task.getError());
                                        } else {
                                            retryTask.setResult(task.getResult());
                                        }
                                        return null;
                                    }
                                });
                            }
                        }, delay, TimeUnit.MILLISECONDS);
                        return retryTask.getTask();
                    }
                    if (!ParseRequest.this.request.isAborted()) {
                        Parse.logI("com.parse.ParseRequest", "Request failed. Giving up.");
                    }
                }
                return task;
            }
        });
    }

    public void cancel() {
        Task.TaskCompletionSource curr = this.currentTask.get();
        if (curr != null) {
            curr.trySetCancelled();
        }
        if (this.request != null) {
            this.request.abort();
        }
    }

    protected ParseException connectionFailed(String message, Exception e) {
        return new ParseException(100, message + ": " + e.getClass().getName() + ": " + e.getMessage());
    }

    public static interface Method {
        public static final int GET = 0;
        public static final int POST = 1;
    }
}

