/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.util.SparseArray;
import com.parse.Parse;
import com.parse.ParseWakeLock;

class ServiceUtils {
    private static final String TAG = "com.parse.ServiceUtils";
    private static final String WAKE_LOCK_EXTRA = "parseWakeLockId";
    private static final SparseArray<ParseWakeLock> wakeLocks = new SparseArray();
    private static int wakeLockId = 0;

    ServiceUtils() {
    }

    public static boolean runIntentInService(Context context, Intent intent, Class<? extends Service> clazz) {
        boolean startedService = false;
        if (intent != null) {
            ComponentName name;
            if (clazz != null) {
                intent.setClass(context, clazz);
            }
            boolean bl = startedService = (name = context.startService(intent)) != null;
            if (!startedService) {
                Parse.logE(TAG, "Could not start the service. Make sure that the XML tag <service android:name=\"" + clazz.toString() + "\" /> is in your " + "AndroidManifest.xml as a child of the <application> element.");
            }
        }
        return startedService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runWakefulIntentInService(Context context, Intent intent, Class<? extends Service> clazz, long wakeLockTimeout) {
        boolean startedService = false;
        if (intent != null) {
            String reason = intent.toString();
            ParseWakeLock wl = ParseWakeLock.acquireNewWakeLock(context, 1, reason, 0L);
            SparseArray<ParseWakeLock> sparseArray = wakeLocks;
            synchronized (sparseArray) {
                intent.putExtra(WAKE_LOCK_EXTRA, wakeLockId);
                wakeLocks.append(wakeLockId, (Object)wl);
                ++wakeLockId;
            }
            startedService = ServiceUtils.runIntentInService(context, intent, clazz);
            if (!startedService) {
                ServiceUtils.completeWakefulIntent(intent);
            }
        }
        return startedService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void completeWakefulIntent(Intent intent) {
        if (intent != null && intent.hasExtra(WAKE_LOCK_EXTRA)) {
            int id = intent.getIntExtra(WAKE_LOCK_EXTRA, -1);
            ParseWakeLock wakeLock = null;
            SparseArray<ParseWakeLock> sparseArray = wakeLocks;
            synchronized (sparseArray) {
                wakeLock = (ParseWakeLock)wakeLocks.get(id);
                wakeLocks.remove(id);
            }
            if (wakeLock == null) {
                Parse.logE(TAG, "Got wake lock id of " + id + " in intent, but no such lock found in " + "global map. Was completeWakefulIntent called twice for the same intent?");
            } else {
                wakeLock.release();
            }
        }
    }
}

