/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.parse.Continuation;
import com.parse.Task;
import com.parse.TaskQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class ParseSQLiteDatabase {
    private static final ExecutorService dbExecutor = Executors.newSingleThreadExecutor();
    private static final TaskQueue taskQueue = new TaskQueue();
    private SQLiteDatabase db;
    private Task<Void> current = null;
    private final Object currentLock = new Object();
    private final Task.TaskCompletionSource tcs = Task.create();
    private boolean writable;

    ParseSQLiteDatabase(boolean writable) {
        this.writable = writable;
        taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                Object object = ParseSQLiteDatabase.this.currentLock;
                synchronized (object) {
                    ParseSQLiteDatabase.this.current = task;
                }
                return ParseSQLiteDatabase.this.tcs.getTask();
            }
        });
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isOpen() {
        return this.db.isOpen();
    }

    public boolean inTransaction() {
        return this.db.inTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> open(final SQLiteOpenHelper helper) {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.continueWithTask(new Continuation<Void, Task<SQLiteDatabase>>(){

                @Override
                public Task<SQLiteDatabase> then(Task<Void> task) throws Exception {
                    return Task.forResult(ParseSQLiteDatabase.this.writable ? helper.getWritableDatabase() : helper.getReadableDatabase());
                }
            }, dbExecutor).continueWithTask(new Continuation<SQLiteDatabase, Task<Void>>(){

                @Override
                public Task<Void> then(Task<SQLiteDatabase> task) throws Exception {
                    ParseSQLiteDatabase.this.db = task.getResult();
                    return task.makeVoid();
                }
            }, Task.BACKGROUND_EXECUTOR);
            return this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> beginTransactionAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.continueWithTask(new Continuation<Void, Task<Void>>(){

                @Override
                public Task<Void> then(Task<Void> task) throws Exception {
                    ParseSQLiteDatabase.this.db.beginTransaction();
                    return task;
                }
            }, dbExecutor);
            return this.current.continueWithTask(new Continuation<Void, Task<Void>>(){

                @Override
                public Task<Void> then(Task<Void> task) throws Exception {
                    return task;
                }
            }, Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> setTransactionSuccessfulAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.onSuccessTask(new Continuation<Void, Task<Void>>(){

                @Override
                public Task<Void> then(Task<Void> task) throws Exception {
                    ParseSQLiteDatabase.this.db.setTransactionSuccessful();
                    return task;
                }
            }, dbExecutor);
            return this.current.continueWithTask(new Continuation<Void, Task<Void>>(){

                @Override
                public Task<Void> then(Task<Void> task) throws Exception {
                    return task;
                }
            }, Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> endTransactionAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.continueWithTask(new Continuation<Void, Task<Void>>(){

                @Override
                public Task<Void> then(Task<Void> task) throws Exception {
                    ParseSQLiteDatabase.this.db.endTransaction();
                    return Task.forResult(null);
                }
            }, dbExecutor);
            return this.current.continueWithTask(new Continuation<Void, Task<Void>>(){

                @Override
                public Task<Void> then(Task<Void> task) throws Exception {
                    return task;
                }
            }, Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> close() {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.continueWithTask(new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Task<Void> then(Task<Void> task) throws Exception {
                    try {
                        ParseSQLiteDatabase.this.db.close();
                    }
                    finally {
                        ParseSQLiteDatabase.this.tcs.setResult(null);
                    }
                    return ParseSQLiteDatabase.this.tcs.getTask();
                }
            }, dbExecutor);
            return this.current.continueWithTask(new Continuation<Void, Task<Void>>(){

                @Override
                public Task<Void> then(Task<Void> task) throws Exception {
                    return task;
                }
            }, Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Cursor> queryAsync(final String table, final String[] select, final String where, final String[] args) {
        Object object = this.currentLock;
        synchronized (object) {
            Task<Cursor> task = this.current.onSuccessTask(new Continuation<Void, Task<Cursor>>(){

                @Override
                public Task<Cursor> then(Task<Void> task) throws Exception {
                    return Task.forResult(ParseSQLiteDatabase.this.db.query(table, select, where, args, null, null, null));
                }
            }, dbExecutor).onSuccessTask(new Continuation<Cursor, Task<Cursor>>(){

                @Override
                public Task<Cursor> then(Task<Cursor> task) throws Exception {
                    final Cursor cursor = task.getResult();
                    return Task.forResult(cursor.getCount()).continueWithTask(new Continuation<Integer, Task<Cursor>>(){

                        @Override
                        public Task<Cursor> then(Task<Integer> task) throws Exception {
                            return Task.forResult(cursor);
                        }
                    });
                }
            }, dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask(new Continuation<Cursor, Task<Cursor>>(){

                @Override
                public Task<Cursor> then(Task<Cursor> task) throws Exception {
                    return task;
                }
            }, Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> insertWithOnConflict(final String table, final ContentValues values, final int conflictAlgorithm) {
        Object object = this.currentLock;
        synchronized (object) {
            Task<Long> task = this.current.onSuccessTask(new Continuation<Void, Task<Long>>(){

                @Override
                public Task<Long> then(Task<Void> task) throws Exception {
                    return Task.forResult(ParseSQLiteDatabase.this.db.insertWithOnConflict(table, null, values, conflictAlgorithm));
                }
            }, dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask(new Continuation<Long, Task<Long>>(){

                @Override
                public Task<Long> then(Task<Long> task) throws Exception {
                    return task;
                }
            }, Task.BACKGROUND_EXECUTOR).makeVoid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> insertOrThrowAsync(final String table, final ContentValues values) {
        Object object = this.currentLock;
        synchronized (object) {
            Task<Long> task = this.current.onSuccessTask(new Continuation<Void, Task<Long>>(){

                @Override
                public Task<Long> then(Task<Void> task) throws Exception {
                    return Task.forResult(ParseSQLiteDatabase.this.db.insertOrThrow(table, null, values));
                }
            }, dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask(new Continuation<Long, Task<Long>>(){

                @Override
                public Task<Long> then(Task<Long> task) throws Exception {
                    return task;
                }
            }, Task.BACKGROUND_EXECUTOR).makeVoid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Integer> updateAsync(final String table, final ContentValues values, final String where, final String[] args) {
        Object object = this.currentLock;
        synchronized (object) {
            Task<Integer> task = this.current.onSuccessTask(new Continuation<Void, Task<Integer>>(){

                @Override
                public Task<Integer> then(Task<Void> task) throws Exception {
                    return Task.forResult(ParseSQLiteDatabase.this.db.update(table, values, where, args));
                }
            }, dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask(new Continuation<Integer, Task<Integer>>(){

                @Override
                public Task<Integer> then(Task<Integer> task) throws Exception {
                    return task;
                }
            }, Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> deleteAsync(final String table, final String where, final String[] args) {
        Object object = this.currentLock;
        synchronized (object) {
            Task<Integer> task = this.current.onSuccessTask(new Continuation<Void, Task<Integer>>(){

                @Override
                public Task<Integer> then(Task<Void> task) throws Exception {
                    return Task.forResult(ParseSQLiteDatabase.this.db.delete(table, where, args));
                }
            }, dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask(new Continuation<Integer, Task<Integer>>(){

                @Override
                public Task<Integer> then(Task<Integer> task) throws Exception {
                    return task;
                }
            }, Task.BACKGROUND_EXECUTOR).makeVoid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Cursor> rawQueryAsync(final String sql, final String[] args) {
        Object object = this.currentLock;
        synchronized (object) {
            Task<Cursor> task = this.current.onSuccessTask(new Continuation<Void, Task<Cursor>>(){

                @Override
                public Task<Cursor> then(Task<Void> task) throws Exception {
                    return Task.forResult(ParseSQLiteDatabase.this.db.rawQuery(sql, args));
                }
            }, dbExecutor).onSuccessTask(new Continuation<Cursor, Task<Cursor>>(){

                @Override
                public Task<Cursor> then(Task<Cursor> task) throws Exception {
                    final Cursor cursor = task.getResult();
                    return Task.forResult(cursor.getCount()).continueWithTask(new Continuation<Integer, Task<Cursor>>(){

                        @Override
                        public Task<Cursor> then(Task<Integer> task) throws Exception {
                            return Task.forResult(cursor);
                        }
                    });
                }
            }, dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask(new Continuation<Cursor, Task<Cursor>>(){

                @Override
                public Task<Cursor> then(Task<Cursor> task) throws Exception {
                    return task;
                }
            }, Task.BACKGROUND_EXECUTOR);
        }
    }
}

