/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Continuation;
import com.parse.ManifestInfo;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseException;
import com.parse.ParseInstallation;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseUser;
import com.parse.PointerEncodingStrategy;
import com.parse.PushRouter;
import com.parse.PushService;
import com.parse.SaveCallback;
import com.parse.SendCallback;
import com.parse.Task;
import com.parse.gdata.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ParsePush {
    private static final String TAG = "com.parse.ParsePush";
    private static final String START_IF_REQUIRED_ACTION = "com.parse.PushService.startIfRequired";
    private Set<String> channelSet = null;
    private ParseQuery<ParseInstallation> query = null;
    private Long expirationTime = null;
    private Long expirationTimeInterval = null;
    private Boolean pushToIOS = null;
    private Boolean pushToAndroid = null;
    private JSONObject data;
    static final String V2_PUSH_NOT_CONFIGURED = "In order to use the ParsePush.subscribe or ParsePush.unsubscribe methods you must add the following to your AndroidManifest.xml: \n<receiver android:name=\"com.parse.ParsePushBroadcastReceiver\"\n  android:exported=\"false\">\n  <intent-filter>\n    <action android:name=\"com.parse.push.intent.RECEIVE\" />\n    <action android:name=\"com.parse.push.intent.OPEN\" />\n    <action android:name=\"com.parse.push.intent.DELETE\" />\n  </intent-filter>\n</receiver>\n(Replace \"com.parse.ParsePushBroadcastReceiver\" with your own implementation if you choose to extend ParsePushBroadcastReceiver)";

    static void setEnabled(final boolean enabled) {
        ParsePush.checkForManifestAndThrowExceptionIfNeeded();
        PushRouter.setForceEnabledAsync(enabled).onSuccess(new Continuation<Void, Void>(){

            @Override
            public Void then(Task<Void> task) throws Exception {
                if (!enabled) {
                    PushService.stopPpnsService(Parse.applicationContext);
                } else {
                    PushService.startServiceIfRequired(Parse.applicationContext);
                }
                return null;
            }
        });
    }

    static Task<Void> subscribeAsync(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Can't subscribe to null channel.");
        }
        ParsePush.checkForManifestAndThrowExceptionIfNeeded();
        ParseInstallation installation = ParseInstallation.getCurrentInstallation();
        installation.addUnique("channels", channel);
        return installation.saveAsync();
    }

    public static void subscribeInBackground(String channel, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParsePush.subscribeAsync(channel), callback);
    }

    public static void subscribeInBackground(String channel) {
        ParsePush.subscribeInBackground(channel, null);
    }

    static Task<Void> unsubscribeAsync(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Can't unsubscribe from null channel.");
        }
        ParsePush.checkForManifestAndThrowExceptionIfNeeded();
        ParseInstallation installation = ParseInstallation.getCurrentInstallation();
        installation.removeAll("channels", Arrays.asList(channel));
        return installation.saveAsync();
    }

    public static void unsubscribeInBackground(String channel, SaveCallback callback) {
        Parse.callbackOnMainThreadAsync(ParsePush.unsubscribeAsync(channel), callback);
    }

    public static void unsubscribeInBackground(String channel) {
        ParsePush.unsubscribeInBackground(channel, null);
    }

    private static void checkForManifestAndThrowExceptionIfNeeded() {
        if (!ManifestInfo.getPushUsesBroadcastReceivers()) {
            throw new IllegalStateException(V2_PUSH_NOT_CONFIGURED);
        }
    }

    public static void sendMessageInBackground(String message, ParseQuery<ParseInstallation> query) {
        ParsePush.sendMessageInBackground(message, query, null);
    }

    public static void sendMessageInBackground(String message, ParseQuery<ParseInstallation> query, SendCallback callback) {
        ParsePush push = new ParsePush();
        push.setQuery(query);
        push.setMessage(message);
        push.sendInBackground(callback);
    }

    public static void sendDataInBackground(JSONObject data, ParseQuery<ParseInstallation> query) {
        ParsePush.sendDataInBackground(data, query, null);
    }

    public static void sendDataInBackground(JSONObject data, ParseQuery<ParseInstallation> query, SendCallback callback) {
        ParsePush push = new ParsePush();
        push.setQuery(query);
        push.setData(data);
        push.sendInBackground(callback);
    }

    public void setChannel(String channel) {
        Preconditions.checkArgument(channel != null, "channel cannot be null");
        this.channelSet = new HashSet<String>();
        this.channelSet.add(channel);
        this.query = null;
    }

    public void setChannels(Collection<String> channels) {
        Preconditions.checkArgument(channels != null, "channels collection cannot be null");
        for (String channel : channels) {
            Preconditions.checkArgument(channel != null, "channel cannot be null");
        }
        this.channelSet = new HashSet<String>();
        this.channelSet.addAll(channels);
        this.query = null;
    }

    public void setQuery(ParseQuery<ParseInstallation> query) {
        Preconditions.checkArgument(query != null, "Cannot target a null query");
        Preconditions.checkArgument(this.pushToIOS == null && this.pushToAndroid == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
        Preconditions.checkArgument(query.getClassName().equals(ParseObject.getClassName(ParseInstallation.class)), "Can only push to a query for Installations");
        this.channelSet = null;
        this.query = query;
    }

    public void setExpirationTime(long time) {
        this.expirationTime = time;
        this.expirationTimeInterval = null;
    }

    public void setExpirationTimeInterval(long timeInterval) {
        this.expirationTime = null;
        this.expirationTimeInterval = timeInterval;
    }

    public void clearExpiration() {
        this.expirationTime = null;
        this.expirationTimeInterval = null;
    }

    @Deprecated
    public void setPushToIOS(boolean pushToIOS) {
        Preconditions.checkArgument(this.query == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
        this.pushToIOS = pushToIOS;
    }

    @Deprecated
    public void setPushToAndroid(boolean pushToAndroid) {
        Preconditions.checkArgument(this.query == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
        this.pushToAndroid = pushToAndroid;
    }

    public void setData(JSONObject data) {
        this.data = data;
    }

    public void setMessage(String message) {
        JSONObject data = new JSONObject();
        try {
            data.put("alert", (Object)message);
        }
        catch (JSONException e) {
            Parse.logE(TAG, "JSONException in setMessage", e);
        }
        this.setData(data);
    }

    private Task<Void> sendAsync() {
        return this.buildCommand(ParseUser.getCurrentSessionToken()).executeAsync().continueWith(new Continuation<Object, Void>(){

            @Override
            public Void then(Task<Object> task) throws Exception {
                return null;
            }
        });
    }

    public void send() throws ParseException {
        Parse.waitForTask(this.sendAsync());
    }

    public void sendInBackground(SendCallback callback) {
        Parse.callbackOnMainThreadAsync(this.sendAsync(), callback);
    }

    public void sendInBackground() {
        this.sendInBackground(null);
    }

    ParseCommand buildCommand(String sessionToken) {
        ParseCommand command = new ParseCommand("client_push", sessionToken);
        if (this.data == null) {
            throw new IllegalArgumentException("Cannot send a push without calling either setMessage or setData");
        }
        command.put("data", this.data);
        if (this.query != null) {
            ParseQuery.QueryConstraints where = this.query.getConstraints();
            JSONObject whereJSON = (JSONObject)Parse.encode(where, PointerEncodingStrategy.get());
            command.put("where", whereJSON);
        } else if (this.channelSet == null) {
            command.put("channel", "");
        } else {
            command.put("channels", new JSONArray(this.channelSet));
        }
        if (this.expirationTime != null) {
            command.put("expiration_time", this.expirationTime);
        } else if (this.expirationTimeInterval != null) {
            command.put("expiration_time_interval", this.expirationTimeInterval);
        }
        if (this.query == null && (this.pushToAndroid != null || this.pushToIOS != null)) {
            boolean willPushToIOS;
            boolean willPushToAndroid = this.pushToAndroid == null || this.pushToAndroid != false;
            boolean bl = willPushToIOS = this.pushToIOS != null && this.pushToIOS != false;
            if (!willPushToIOS || !willPushToAndroid) {
                if (willPushToIOS) {
                    command.put("type", "ios");
                } else if (willPushToAndroid) {
                    command.put("type", "android");
                } else {
                    throw new IllegalArgumentException("Cannot push if both pushToIOS and pushToAndroid are false");
                }
            }
        }
        return command;
    }
}

