/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.http.AndroidHttpClient;
import android.os.Build;
import com.parse.LocalIdManager;
import com.parse.ManifestInfo;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ParseIOUtils;
import com.parse.ParseInstallation;
import com.parse.ParseObject;
import com.parse.ParseRequest;
import com.parse.ParseUser;
import com.parse.ProgressCallback;
import com.parse.Task;
import com.parse.codec.digest.DigestUtils;
import com.parse.signpost.commonshttp.CommonsHttpOAuthConsumer;
import com.parse.signpost.exception.OAuthCommunicationException;
import com.parse.signpost.exception.OAuthExpectationFailedException;
import com.parse.signpost.exception.OAuthMessageSignerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

class ParseCommand
extends ParseRequest<JSONObject, Object> {
    private static final String COMMAND_UUID = "uuid";
    private static final String SESSION_TOKEN = "session_token";
    private static final String OS_VERSION = "osVersion";
    private static final String APP_BUILD_VERSION = "appBuildVersion";
    private static final String APP_DISPLAY_VERSION = "appDisplayVersion";
    private static final String INSTALLATION_ID = "iid";
    private static final String DEVICE_TYPE_AND_SDK_VERSION = "v";
    private String op;
    JSONObject params;
    private String localId;
    private String operationSetUUID;
    private final String sessionToken;

    private static String generateUrl(String op) {
        return String.format("%s/%s/%s", ParseObject.server, "2", op);
    }

    ParseCommand(String op, String sessionToken) {
        this(op, new JSONObject(), null, null, sessionToken);
    }

    ParseCommand(JSONObject json) throws JSONException {
        this(json.getString("op"), json.getJSONObject("params"), json.optString("localId", null), json.optString("operationSetUUID", null), json.optString(SESSION_TOKEN, ParseUser.getCurrentSessionToken()));
    }

    private ParseCommand(String op, JSONObject params, String localId, String operationSetUUID, String sessionToken) {
        super(1, ParseCommand.generateUrl(op));
        this.op = op;
        this.params = params;
        this.localId = localId;
        this.operationSetUUID = operationSetUUID;
        this.sessionToken = sessionToken;
        this.maxRetries = 0;
    }

    void put(String key, String value) {
        try {
            this.params.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void put(String key, int value) {
        try {
            this.params.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void put(String key, long value) {
        try {
            this.params.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void put(String key, JSONArray value) {
        try {
            this.params.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void put(String key, JSONObject value) {
        try {
            this.params.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    String getOp() {
        return this.op;
    }

    void setOp(String op) {
        this.op = op;
        this.setUrl(ParseCommand.generateUrl(op));
    }

    String getSessionToken() {
        return this.sessionToken;
    }

    String getOperationSetUUID() {
        return this.operationSetUUID;
    }

    void setOperationSetUUID(String uuid) {
        this.operationSetUUID = uuid;
    }

    String getLocalId() {
        return this.localId;
    }

    void setLocalId(String theLocalId) {
        this.localId = theLocalId;
    }

    void enableRetrying() {
        this.maxRetries = 4;
    }

    JSONObject toJSONObject() {
        try {
            JSONObject answer = new JSONObject();
            answer.put("op", (Object)this.op);
            answer.put("params", (Object)this.params);
            if (this.localId != null) {
                answer.put("localId", (Object)this.localId);
            }
            if (this.operationSetUUID != null) {
                answer.put("operationSetUUID", (Object)this.operationSetUUID);
            }
            answer.put(SESSION_TOKEN, this.sessionToken != null ? this.sessionToken : JSONObject.NULL);
            return answer;
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    String getCacheKey() {
        String json;
        try {
            json = ParseCommand.toDeterministicString(this.params);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (this.sessionToken != null) {
            json = json + this.sessionToken;
        }
        return "ParseCommand." + this.op + "." + "2" + "." + DigestUtils.md5Hex(json);
    }

    static String toDeterministicString(Object o) throws JSONException {
        JSONStringer stringer = new JSONStringer();
        ParseCommand.addToStringer(stringer, o);
        return stringer.toString();
    }

    static void addToStringer(JSONStringer stringer, Object o) throws JSONException {
        if (o instanceof JSONObject) {
            stringer.object();
            JSONObject object = (JSONObject)o;
            Iterator keyIterator = object.keys();
            ArrayList keys = new ArrayList();
            while (keyIterator.hasNext()) {
                keys.add(keyIterator.next());
            }
            Collections.sort(keys);
            for (String key : keys) {
                stringer.key(key);
                ParseCommand.addToStringer(stringer, object.opt(key));
            }
            stringer.endObject();
            return;
        }
        if (o instanceof JSONArray) {
            JSONArray array = (JSONArray)o;
            stringer.array();
            for (int i = 0; i < array.length(); ++i) {
                ParseCommand.addToStringer(stringer, array.get(i));
            }
            stringer.endArray();
            return;
        }
        stringer.value(o);
    }

    static void addDefaultParameters(JSONObject params, String sessionToken) throws JSONException {
        params.put(OS_VERSION, (Object)Build.VERSION.RELEASE);
        params.put(APP_BUILD_VERSION, (Object)Integer.toString(ManifestInfo.getVersionCode()));
        params.put(APP_DISPLAY_VERSION, (Object)ManifestInfo.getVersionName());
        params.put(DEVICE_TYPE_AND_SDK_VERSION, (Object)"a1.6.0");
        params.put(INSTALLATION_ID, (Object)ParseInstallation.getOrCreateCurrentInstallationId());
        params.put(COMMAND_UUID, (Object)UUID.randomUUID().toString());
        if (sessionToken != null) {
            params.put(SESSION_TOKEN, (Object)sessionToken);
        }
    }

    @Override
    protected HttpEntity newEntity() {
        Iterator keys = this.params.keys();
        JSONObject fullParams = new JSONObject();
        try {
            while (keys.hasNext()) {
                String key = (String)keys.next();
                fullParams.put(key, this.params.get(key));
            }
            ParseCommand.addDefaultParameters(fullParams, this.sessionToken);
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        try {
            StringEntity entity = new StringEntity(fullParams.toString(), "UTF8");
            entity.setContentType("application/json");
            return entity;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    protected HttpUriRequest newRequest() throws ParseException {
        HttpUriRequest request = super.newRequest();
        try {
            CommonsHttpOAuthConsumer consumer = new CommonsHttpOAuthConsumer(Parse.applicationId, Parse.clientKey);
            consumer.setTokenWithSecret(null, "");
            consumer.sign(request);
        }
        catch (OAuthMessageSignerException e) {
            throw new ParseException(109, e.getMessage());
        }
        catch (OAuthExpectationFailedException e) {
            throw new ParseException(109, e.getMessage());
        }
        catch (OAuthCommunicationException e) {
            throw new ParseException(109, e.getMessage());
        }
        return request;
    }

    @Override
    protected Task<Void> onPreExecute(Task<Void> task) {
        Parse.checkInit();
        this.resolveLocalIds();
        return task;
    }

    @Override
    protected JSONObject onResponse(HttpResponse response, ProgressCallback progressCallback) throws IOException, ParseException {
        JSONObject json;
        try {
            InputStream is = AndroidHttpClient.getUngzippedContent((HttpEntity)response.getEntity());
            String content = new String(ParseIOUtils.toByteArray(is));
            JSONTokener tokener = new JSONTokener(content);
            json = new JSONObject(tokener);
        }
        catch (JSONException e) {
            throw this.connectionFailed("bad json response", (Exception)((Object)e));
        }
        return json;
    }

    @Override
    protected Task<Object> onPostExecute(Task<JSONObject> task) throws ParseException {
        Object result;
        JSONObject json = task.getResult();
        try {
            if (json.has("error")) {
                throw new ParseException(json.getInt("code"), json.getString("error"));
            }
            result = json.get("result");
        }
        catch (JSONException e) {
            throw this.connectionFailed("corrupted json", (Exception)((Object)e));
        }
        return Task.forResult(result);
    }

    private static void getLocalPointersIn(Object container, ArrayList<JSONObject> localPointers) throws JSONException {
        if (container instanceof JSONObject) {
            JSONObject object = (JSONObject)container;
            if ("Pointer".equals(object.opt("__type")) && object.has("localId")) {
                localPointers.add((JSONObject)container);
                return;
            }
            Iterator keyIterator = object.keys();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                ParseCommand.getLocalPointersIn(object.get(key), localPointers);
            }
        }
        if (container instanceof JSONArray) {
            JSONArray array = (JSONArray)container;
            for (int i = 0; i < array.length(); ++i) {
                ParseCommand.getLocalPointersIn(array.get(i), localPointers);
            }
        }
    }

    public void maybeChangeServerOperation() throws JSONException {
        String objectId;
        if (this.localId != null && (objectId = LocalIdManager.getDefaultInstance().getObjectId(this.localId)) != null) {
            this.localId = null;
            JSONObject data = this.params.optJSONObject("data");
            if (data != null) {
                data.put("objectId", (Object)objectId);
            }
            if (this.op.equals("create")) {
                this.setOp("update");
            }
        }
    }

    public void resolveLocalIds() {
        try {
            Object data = this.params.get("data");
            ArrayList<JSONObject> localPointers = new ArrayList<JSONObject>();
            ParseCommand.getLocalPointersIn(data, localPointers);
            for (JSONObject pointer : localPointers) {
                String localId = (String)pointer.get("localId");
                String objectId = LocalIdManager.getDefaultInstance().getObjectId(localId);
                if (objectId == null) {
                    throw new IllegalStateException("Tried to serialize a command referencing a new, unsaved object.");
                }
                pointer.put("objectId", (Object)objectId);
                pointer.remove("localId");
            }
            this.maybeChangeServerOperation();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void retainLocalIds() {
        if (this.localId != null) {
            LocalIdManager.getDefaultInstance().retainLocalIdOnDisk(this.localId);
        }
        try {
            Object data = this.params.get("data");
            ArrayList<JSONObject> localPointers = new ArrayList<JSONObject>();
            ParseCommand.getLocalPointersIn(data, localPointers);
            for (JSONObject pointer : localPointers) {
                String localId = (String)pointer.get("localId");
                LocalIdManager.getDefaultInstance().retainLocalIdOnDisk(localId);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void releaseLocalIds() {
        if (this.localId != null) {
            LocalIdManager.getDefaultInstance().releaseLocalIdOnDisk(this.localId);
        }
        try {
            Object data = this.params.get("data");
            ArrayList<JSONObject> localPointers = new ArrayList<JSONObject>();
            ParseCommand.getLocalPointersIn(data, localPointers);
            for (JSONObject pointer : localPointers) {
                String localId = (String)pointer.get("localId");
                LocalIdManager.getDefaultInstance().releaseLocalIdOnDisk(localId);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

