/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Intent;
import com.parse.NoObjectsEncodingStrategy;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseUser;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseAnalytics {
    private static final String TAG = "com.parse.ParseAnalytics";
    private static final String OP = "client_events";
    static final String APP_OPENED = "AppOpened";

    public static void trackAppOpened(Intent intent) {
        String parseData = null;
        if (intent != null && intent.getExtras() != null) {
            parseData = intent.getExtras().getString("com.parse.Data");
        }
        ParseAnalytics.trackAppOpened(parseData);
    }

    public static void trackEvent(String name) {
        ParseAnalytics.trackEvent(name, null);
    }

    public static void trackEvent(String name, Map<String, String> dimensions) {
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeException("A name for the custom event must be provided.");
        }
        ParseCommand command = ParseAnalytics.createCommand(name);
        if (dimensions != null) {
            JSONObject jsonDimensions = (JSONObject)Parse.encode(dimensions, NoObjectsEncodingStrategy.get());
            command.put("dimensions", jsonDimensions);
        }
        Parse.getEventuallyQueue().enqueueEventuallyAsync(command, null);
    }

    private static void trackAppOpened(String pushData) {
        ParseCommand command = ParseAnalytics.createCommand(APP_OPENED);
        if (pushData != null) {
            try {
                JSONObject payload = new JSONObject(pushData);
                String pushHash = payload.optString("push_hash");
                if (pushHash.length() > 0) {
                    command.put("push_hash", pushHash);
                }
            }
            catch (JSONException e) {
                Parse.logE(TAG, "Failed to parse push data: " + e.getMessage());
            }
        }
        Parse.getEventuallyQueue().enqueueEventuallyAsync(command, null);
    }

    private static ParseCommand createCommand(String eventName) {
        ParseCommand command = new ParseCommand(OP, ParseUser.getCurrentSessionToken());
        command.put("at", Parse.encodeDate(new Date()));
        command.put("name", eventName);
        return command;
    }
}

