/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import com.parse.Capture;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ParseGeoPoint;
import com.parse.Task;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class LocationNotifier {
    public static final String testProviderName = "Test";
    private static Location fakeLocation = null;

    LocationNotifier() {
    }

    static Task<ParseGeoPoint> getCurrentLocationAsync(long timeout, Criteria criteria) {
        Parse.checkContext();
        final Task.TaskCompletionSource tcs = Task.create();
        final Capture timeoutFuture = new Capture();
        final LocationManager manager = (LocationManager)Parse.applicationContext.getSystemService("location");
        final LocationListener listener = new LocationListener(){

            public void onLocationChanged(Location location) {
                ((ScheduledFuture)timeoutFuture.get()).cancel(true);
                ParseGeoPoint geoPoint = null;
                if (location != null) {
                    geoPoint = new ParseGeoPoint(location.getLatitude(), location.getLongitude());
                }
                tcs.trySetResult(geoPoint);
                manager.removeUpdates((LocationListener)this);
            }

            public void onProviderDisabled(String provider) {
            }

            public void onProviderEnabled(String provider) {
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }
        };
        timeoutFuture.set(Parse.getScheduledExecutor().schedule(new Runnable(){

            @Override
            public void run() {
                tcs.trySetError(new ParseException(124, "location fetch timed out"));
                manager.removeUpdates(listener);
            }
        }, timeout, TimeUnit.MILLISECONDS));
        String providerName = manager.getBestProvider(criteria, true);
        if (providerName != null) {
            manager.requestLocationUpdates(providerName, 0L, 0.0f, listener);
        }
        if (fakeLocation != null) {
            listener.onLocationChanged(fakeLocation);
        }
        return tcs.getTask();
    }

    static void setFakeLocation(Location location) {
        fakeLocation = location;
    }
}

