/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Parcelable;
import android.os.SystemClock;
import com.parse.Continuation;
import com.parse.ManifestInfo;
import com.parse.Parse;
import com.parse.ParseInstallation;
import com.parse.PushType;
import com.parse.Task;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

class GcmRegistrar {
    private static final String TAG = "com.parse.GcmRegistrar";
    private static final String REGISTRATION_ID_EXTRA = "registration_id";
    private static final String ERROR_EXTRA = "error";
    private static final String SENDER_ID = "1076345567071";
    public static final String REGISTER_ACTION = "com.google.android.c2dm.intent.REGISTER";
    public static final String REGISTER_RESPONSE_ACTION = "com.google.android.c2dm.intent.REGISTRATION";
    private Object lock = new Object();
    private Request request = null;
    private Context context = null;

    public static GcmRegistrar getInstance() {
        return Singleton.INSTANCE;
    }

    public static void updateAsync() {
        Task.callInBackground(new Callable<Void>(){

            @Override
            public Void call() {
                GcmRegistrar.getInstance().update();
                return null;
            }
        });
    }

    GcmRegistrar(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        if (ManifestInfo.getPushType() == PushType.GCM) {
            Object object = this.lock;
            synchronized (object) {
                ParseInstallation installation = ParseInstallation.getCurrentInstallation();
                if (installation.getDeviceToken() == null || installation.isDeviceTokenStale()) {
                    if (installation.getPushType() != PushType.GCM) {
                        installation.setPushType(PushType.GCM);
                        installation.saveEventually();
                    }
                    this.sendRegistrationRequest();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (ParseInstallation.hasCurrentInstallation() && ManifestInfo.getPushType() == PushType.GCM) {
            Object object = this.lock;
            synchronized (object) {
                ParseInstallation installation = ParseInstallation.getCurrentInstallation();
                if (installation.getPushType() == PushType.GCM && (installation.getDeviceToken() == null || installation.isDeviceTokenStale())) {
                    this.sendRegistrationRequest();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRegistrationRequest() {
        Object object = this.lock;
        synchronized (object) {
            if (this.request == null) {
                this.request = Request.createAndSend(this.context, SENDER_ID);
                this.request.getTask().continueWith(new Continuation<String, Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void then(Task<String> task) {
                        Exception e = task.getError();
                        if (e != null) {
                            Parse.logE(GcmRegistrar.TAG, "Got error when trying to register for GCM push", e);
                        }
                        Object object = GcmRegistrar.this.lock;
                        synchronized (object) {
                            GcmRegistrar.this.request = null;
                        }
                        return null;
                    }
                });
            }
        }
    }

    public boolean isRegistrationIntent(Intent intent) {
        return intent != null && REGISTER_RESPONSE_ACTION.equals(intent.getAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRegistrationIntent(Intent intent) {
        if (this.isRegistrationIntent(intent)) {
            String registrationId = intent.getStringExtra(REGISTRATION_ID_EXTRA);
            if (registrationId != null && registrationId.length() > 0) {
                ParseInstallation installation = ParseInstallation.getCurrentInstallation();
                installation.setPushType(PushType.GCM);
                installation.setDeviceToken(registrationId);
                installation.saveEventually();
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.request != null) {
                    this.request.onReceiveResponseIntent(intent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRequestIdentifier() {
        Object object = this.lock;
        synchronized (object) {
            return this.request != null ? this.request.identifier : 0;
        }
    }

    private static class Request {
        private static final String RETRY_ACTION = "com.parse.RetryGcmRegistration";
        private static final int MAX_RETRIES = 5;
        private static final int BACKOFF_INTERVAL_MS = 3000;
        private final Context context;
        private final String senderId;
        private final Random random;
        private final int identifier;
        private final Task.TaskCompletionSource tcs;
        private final PendingIntent appIntent;
        private final AtomicInteger tries;
        private final PendingIntent retryIntent;
        private final BroadcastReceiver retryReceiver;

        public static Request createAndSend(Context context, String senderId) {
            Request request = new Request(context, senderId);
            request.send();
            return request;
        }

        private Request(Context context, String senderId) {
            this.context = context;
            this.senderId = senderId;
            this.random = new Random();
            this.identifier = this.random.nextInt();
            this.tcs = Task.create();
            this.appIntent = PendingIntent.getBroadcast((Context)this.context, (int)this.identifier, (Intent)new Intent(), (int)0);
            this.tries = new AtomicInteger(0);
            String packageName = this.context.getPackageName();
            Intent intent = new Intent(RETRY_ACTION).setPackage(packageName);
            intent.addCategory(packageName);
            intent.putExtra("random", this.identifier);
            this.retryIntent = PendingIntent.getBroadcast((Context)this.context, (int)this.identifier, (Intent)intent, (int)0);
            this.retryReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if (intent != null && intent.getIntExtra("random", 0) == Request.this.identifier) {
                        Request.this.send();
                    }
                }
            };
            IntentFilter filter = new IntentFilter();
            filter.addAction(RETRY_ACTION);
            filter.addCategory(packageName);
            context.registerReceiver(this.retryReceiver, filter);
        }

        public Task<String> getTask() {
            return this.tcs.getTask();
        }

        private void send() {
            Intent intent = new Intent(GcmRegistrar.REGISTER_ACTION);
            intent.setPackage("com.google.android.gsf");
            intent.putExtra("sender", this.senderId);
            intent.putExtra("app", (Parcelable)this.appIntent);
            ComponentName name = null;
            try {
                name = this.context.startService(intent);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (name == null) {
                this.finish(null, "GSF_PACKAGE_NOT_AVAILABLE");
            }
            this.tries.incrementAndGet();
            Parse.logV(GcmRegistrar.TAG, "Sending GCM registration intent");
        }

        public void onReceiveResponseIntent(Intent intent) {
            String registrationId = intent.getStringExtra(GcmRegistrar.REGISTRATION_ID_EXTRA);
            String error = intent.getStringExtra(GcmRegistrar.ERROR_EXTRA);
            if (registrationId == null && error == null) {
                Parse.logE(GcmRegistrar.TAG, "Got no registration info in GCM onReceiveResponseIntent");
                return;
            }
            if ("SERVICE_NOT_AVAILABLE".equals(error) && this.tries.get() < 5) {
                AlarmManager manager = (AlarmManager)this.context.getSystemService("alarm");
                int alarmType = 2;
                long delay = (1 << this.tries.get()) * 3000 + this.random.nextInt(3000);
                long start = SystemClock.elapsedRealtime() + delay;
                manager.set(alarmType, start, this.retryIntent);
            } else {
                this.finish(registrationId, error);
            }
        }

        private void finish(String registrationId, String error) {
            boolean didSetResult = false;
            didSetResult = registrationId != null ? this.tcs.trySetResult(registrationId) : this.tcs.trySetError(new Exception("GCM registration error: " + error));
            if (didSetResult) {
                this.appIntent.cancel();
                this.retryIntent.cancel();
                this.context.unregisterReceiver(this.retryReceiver);
            }
        }
    }

    private static class Singleton {
        public static final GcmRegistrar INSTANCE = new GcmRegistrar(Parse.getApplicationContext());

        private Singleton() {
        }
    }
}

