/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.parse.Continuation;
import com.parse.ManifestInfo;
import com.parse.OfflineStore;
import com.parse.Parse;
import com.parse.ParseClassName;
import com.parse.ParseException;
import com.parse.ParseFileUtils;
import com.parse.ParseObject;
import com.parse.ParseOperationSet;
import com.parse.ParseQuery;
import com.parse.PushType;
import com.parse.Task;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ParseClassName(value="_Installation")
public class ParseInstallation
extends ParseObject {
    private static final String TAG = "com.parse.ParseInstallation";
    private static final Object installationLock = new Object();
    static ParseInstallation currentInstallation = null;
    static String installationId = null;
    static final String INSTALLATION_ID_LOCATION = "installationId";
    private static final String STORAGE_LOCATION = "currentInstallation";
    private static final String PIN_CURRENT_INSTALLATION = "_currentInstallation";
    private static final List<String> readonlyFields = Arrays.asList("deviceType", "installationId", "deviceToken", "pushType", "timeZone", "appVersion", "appName", "parseVersion", "deviceTokenLastModified", "appIdentifier");

    @Override
    void setDefaultValues() {
        super.setDefaultValues();
        super.put("deviceType", "android");
        super.put(INSTALLATION_ID_LOCATION, ParseInstallation.getOrCreateCurrentInstallationId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasCurrentInstallation() {
        boolean hasCurrentInstallation;
        Object object = installationLock;
        synchronized (object) {
            hasCurrentInstallation = currentInstallation != null || new File(Parse.getParseDir(), STORAGE_LOCATION).exists();
        }
        return hasCurrentInstallation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseInstallation getCurrentInstallation() {
        boolean deserializedInstallationFromDisk = false;
        Object object = installationLock;
        synchronized (object) {
            if (currentInstallation == null) {
                ParseObject installation = null;
                if (OfflineStore.isEnabled()) {
                    try {
                        ParseQuery<ParseInstallation> query = ParseQuery.getQuery(ParseInstallation.class).fromPin(PIN_CURRENT_INSTALLATION);
                        Task<ParseInstallation> task = query.findFromCacheAsync(null, false).onSuccessTask(new Continuation<List<ParseInstallation>, Task<ParseInstallation>>(){

                            @Override
                            public Task<ParseInstallation> then(Task<List<ParseInstallation>> task) throws Exception {
                                List<ParseInstallation> results = task.getResult();
                                if (results != null) {
                                    if (results.size() == 1) {
                                        return Task.forResult(results.get(0));
                                    }
                                    return ParseObject.unpinAllAsync(ParseInstallation.PIN_CURRENT_INSTALLATION).cast();
                                }
                                return Task.forResult(null);
                            }
                        });
                        installation = Parse.waitForTask(task);
                    }
                    catch (ParseException parseException) {}
                } else {
                    installation = ParseInstallation.getFromDisk(Parse.applicationContext, STORAGE_LOCATION);
                }
                if (installation == null) {
                    currentInstallation = ParseObject.create(ParseInstallation.class);
                } else {
                    deserializedInstallationFromDisk = true;
                    currentInstallation = (ParseInstallation)installation;
                    Parse.logV(TAG, "Successfully deserialized Installation object");
                }
            }
        }
        if (deserializedInstallationFromDisk) {
            currentInstallation.maybeUpdateInstallationIdOnDisk();
        }
        return currentInstallation;
    }

    public static ParseQuery<ParseInstallation> getQuery() {
        return ParseQuery.getQuery(ParseInstallation.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getOrCreateCurrentInstallationId() {
        Object object = installationLock;
        synchronized (object) {
            if (installationId == null) {
                try {
                    File installationIdFile = new File(Parse.getParseDir(), INSTALLATION_ID_LOCATION);
                    installationId = new String(ParseFileUtils.readFileToByteArray(installationIdFile));
                }
                catch (FileNotFoundException e) {
                    Parse.logI(TAG, "Couldn't find existing installationId file. Creating one instead.");
                }
                catch (IOException e) {
                    Parse.logE(TAG, "Unexpected exception reading installation id from disk", e);
                }
            }
            if (installationId == null) {
                installationId = UUID.randomUUID().toString();
                ParseInstallation.setCurrentInstallationId(installationId);
            }
        }
        return installationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCurrentInstallationId(String newInstallationId) {
        Object object = installationLock;
        synchronized (object) {
            File installationIdFile = new File(Parse.getParseDir(), INSTALLATION_ID_LOCATION);
            try {
                ParseFileUtils.writeByteArrayToFile(installationIdFile, newInstallationId.getBytes());
            }
            catch (IOException e) {
                Parse.logE(TAG, "Unexpected exception writing installation id to disk", e);
            }
            installationId = newInstallationId;
        }
    }

    public String getInstallationId() {
        return this.getString(INSTALLATION_ID_LOCATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkKeyIsMutable(String key) throws IllegalArgumentException {
        Object object = this.mutex;
        synchronized (object) {
            if (readonlyFields.contains(key)) {
                throw new IllegalArgumentException("Cannot change " + key + " property of an installation object.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object value) throws IllegalArgumentException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkKeyIsMutable(key);
            super.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkKeyIsMutable(key);
            super.remove(key);
        }
    }

    @Override
    void updateBeforeSave() {
        super.updateBeforeSave();
        this.updateTimezone();
        this.updateVersionInfo();
        this.updateDeviceInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends ParseObject> Task<T> fetchAsync(final Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            Task<Object> result = this.getObjectId() == null ? this.saveAsync(toAwait) : Task.forResult(null);
            return result.onSuccessTask(new Continuation<Void, Task<T>>(){

                @Override
                public Task<T> then(Task<Void> task) throws Exception {
                    return ParseInstallation.super.fetchAsync(toAwait);
                }
            });
        }
    }

    @Override
    Task<Void> handleSaveResultAsync(JSONObject result, ParseOperationSet operationsBeforeSave) {
        Task<Void> task = super.handleSaveResultAsync(result, operationsBeforeSave);
        return task.onSuccessTask(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseInstallation.maybeFlushToDiskAsync(ParseInstallation.this);
            }
        });
    }

    @Override
    Task<Void> handleFetchResultAsync(JSONObject result) {
        return super.handleFetchResultAsync(result).onSuccessTask(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseInstallation.maybeFlushToDiskAsync(ParseInstallation.this);
            }
        });
    }

    private void maybeUpdateInstallationIdOnDisk() {
        boolean installationIdIsEmpty;
        String installationIdInObject = this.getInstallationId();
        String installationIdOnDisk = ParseInstallation.getOrCreateCurrentInstallationId();
        boolean bl = installationIdIsEmpty = installationIdInObject == null || installationIdInObject.length() == 0;
        if (!installationIdIsEmpty && !installationIdInObject.equals(installationIdOnDisk)) {
            Parse.logW(TAG, "Will update installation id on disk: " + installationIdOnDisk + " because it does not match installation id in ParseInstallation: " + installationIdInObject);
            ParseInstallation.setCurrentInstallationId(installationIdInObject);
        }
    }

    private void updateTimezone() {
        String zone = TimeZone.getDefault().getID();
        if ((zone.indexOf(47) > 0 || zone.equals("GMT")) && !zone.equals(this.get("timeZone"))) {
            super.put("timeZone", zone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersionInfo() {
        Object object = this.mutex;
        synchronized (object) {
            try {
                String packageName = Parse.applicationContext.getPackageName();
                PackageManager pm = Parse.applicationContext.getPackageManager();
                PackageInfo pkgInfo = pm.getPackageInfo(packageName, 0);
                String appVersion = pkgInfo.versionName;
                String appName = pm.getApplicationLabel(pm.getApplicationInfo(packageName, 0)).toString();
                if (packageName != null && !packageName.equals(this.get("appIdentifier"))) {
                    super.put("appIdentifier", packageName);
                }
                if (appName != null && !appName.equals(this.get("appName"))) {
                    super.put("appName", appName);
                }
                if (appVersion != null & !appVersion.equals(this.get("appVersion"))) {
                    super.put("appVersion", appVersion);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Parse.logW(TAG, "Cannot load package info; will not be saved to installation");
            }
            if (!"1.5.1".equals(this.get("parseVersion"))) {
                super.put("parseVersion", "1.5.1");
            }
        }
    }

    private void updateDeviceInfo() {
        String deviceType;
        if (!this.has(INSTALLATION_ID_LOCATION)) {
            super.put(INSTALLATION_ID_LOCATION, ParseInstallation.getOrCreateCurrentInstallationId());
        }
        if (!(deviceType = "android").equals(this.get("deviceType"))) {
            super.put("deviceType", deviceType);
        }
    }

    PushType getPushType() {
        return PushType.fromString(super.getString("pushType"));
    }

    void setPushType(PushType pushType) {
        if (pushType != null) {
            super.put("pushType", pushType.toString());
        }
    }

    void removePushType() {
        super.remove("pushType");
    }

    String getDeviceToken() {
        return super.getString("deviceToken");
    }

    boolean isDeviceTokenStale() {
        return super.getLong("deviceTokenLastModified") != ManifestInfo.getLastModified();
    }

    void setDeviceTokenLastModified(long lastModified) {
        super.put("deviceTokenLastModified", lastModified);
    }

    void setDeviceToken(String deviceToken) {
        if (deviceToken != null && deviceToken.length() > 0) {
            super.put("deviceToken", deviceToken);
            super.put("deviceTokenLastModified", ManifestInfo.getLastModified());
        }
    }

    void removeDeviceToken() {
        super.remove("deviceToken");
        super.remove("deviceTokenLastModified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Task<Void> maybeFlushToDiskAsync(final ParseInstallation installation) {
        boolean isCurrentInstallation;
        Object object = installationLock;
        synchronized (object) {
            isCurrentInstallation = installation == currentInstallation;
        }
        if (!isCurrentInstallation) {
            return Task.forResult(null);
        }
        Task<Void> task = OfflineStore.isEnabled() ? ParseObject.unpinAllAsync(PIN_CURRENT_INSTALLATION).continueWithTask(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                return installation.pinAsync(ParseInstallation.PIN_CURRENT_INSTALLATION);
            }
        }) : Task.forResult(null).continueWithTask(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                installation.saveToDisk(Parse.applicationContext, ParseInstallation.STORAGE_LOCATION);
                return task;
            }
        });
        task = task.continueWithTask(new Continuation<Void, Task<Void>>(){

            @Override
            public Task<Void> then(Task<Void> task) throws Exception {
                installation.maybeUpdateInstallationIdOnDisk();
                return task;
            }
        });
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCurrentInstallationFromMemory() {
        Object object = installationLock;
        synchronized (object) {
            currentInstallation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCurrentInstallationFromDisk(Context context) {
        Object object = installationLock;
        synchronized (object) {
            currentInstallation = null;
            installationId = null;
            if (OfflineStore.isEnabled()) {
                ParseObject.unpinAllAsync(PIN_CURRENT_INSTALLATION);
            }
            ParseObject.deleteDiskObject(context, STORAGE_LOCATION);
            ParseObject.deleteDiskObject(context, INSTALLATION_ID_LOCATION);
        }
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }
}

