/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseACL;
import com.parse.ParseObject;
import com.parse.ParseUser;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ParseTraverser {
    private boolean traverseParseObjects = false;
    private boolean yieldRoot = false;

    protected abstract boolean visit(Object var1);

    private void traverseInternal(Object root, boolean yieldRoot, IdentityHashMap<Object, Object> seen) {
        ParseACL acl;
        if (root == null || seen.containsKey(root)) {
            return;
        }
        if (yieldRoot && !this.visit(root)) {
            return;
        }
        seen.put(root, root);
        if (root instanceof JSONObject) {
            JSONObject json = (JSONObject)root;
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    this.traverseInternal(json.get(key), true, seen);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (root instanceof JSONArray) {
            JSONArray array = (JSONArray)root;
            for (int i = 0; i < array.length(); ++i) {
                try {
                    this.traverseInternal(array.get(i), true, seen);
                    continue;
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (root instanceof Map) {
            Map map = (Map)root;
            for (Object value : map.values()) {
                this.traverseInternal(value, true, seen);
            }
        } else if (root instanceof List) {
            List list = (List)root;
            for (Object value : list) {
                this.traverseInternal(value, true, seen);
            }
        } else if (root instanceof ParseObject) {
            if (this.traverseParseObjects) {
                ParseObject object = (ParseObject)root;
                for (String key : object.keySet()) {
                    this.traverseInternal(object.get(key), true, seen);
                }
            }
        } else if (root instanceof ParseACL && (acl = (ParseACL)root).hasUnresolvedUser()) {
            this.traverseInternal(ParseUser.getCurrentUser(), true, seen);
        }
    }

    public ParseTraverser setTraverseParseObjects(boolean newValue) {
        this.traverseParseObjects = newValue;
        return this;
    }

    public ParseTraverser setYieldRoot(boolean newValue) {
        this.yieldRoot = newValue;
        return this;
    }

    public void traverse(Object root) {
        IdentityHashMap<Object, Object> seen = new IdentityHashMap<Object, Object>();
        this.traverseInternal(root, this.yieldRoot, seen);
    }
}

