/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.parse.ManifestInfo;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseCommandCache;
import com.parse.ParseException;
import com.parse.ParseInstallation;
import com.parse.ParseNotificationManager;
import com.parse.ParseObject;
import com.parse.ParseUser;
import com.parse.PushConnection;
import com.parse.PushRouter;
import com.parse.PushService;
import com.parse.PushType;
import com.parse.Synchronizer;
import com.parse.Task;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParseTestUtils {
    private static final String TAG = "com.parse.ParseTestUtils";
    private static final Object TEST_SERVER_LOCK = new Object();
    private static String testServer;
    private static Synchronizer synchronizer;
    static int totalNotifications;
    private static volatile Semaphore awaitStartSemaphore;
    private static volatile Semaphore awaitStopSemaphore;
    private static StateTransitionListener listener;
    private static PushRoutedListener globalListener;
    static final AtomicBoolean strictModeEnabled;

    ParseTestUtils() {
    }

    public static String useServer(String theServer) {
        String oldServer = ParseObject.server;
        ParseObject.server = theServer;
        return oldServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTestServer(String server) {
        Object object = TEST_SERVER_LOCK;
        synchronized (object) {
            testServer = server;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTestServer(Context context) {
        if (testServer == null) {
            Object object = TEST_SERVER_LOCK;
            synchronized (object) {
                if (testServer == null) {
                    try {
                        BufferedReader br = new BufferedReader(new InputStreamReader(context.getAssets().open("server.config")));
                        testServer = br.readLine();
                    }
                    catch (Exception e) {
                        testServer = Build.PRODUCT.contains("vbox") ? "http://192.168.56.1:3000" : (Build.PRODUCT.contains("sdk") ? "http://10.0.2.2:3000" : "http://localhost:3000");
                    }
                }
            }
        }
        return testServer;
    }

    public static String useTestServer(Context context) {
        return ParseTestUtils.useServer(ParseTestUtils.getTestServer(context));
    }

    public static String useBadServerPort() {
        return ParseTestUtils.useBadServerPort(ParseObject.server);
    }

    public static String useInvalidServer() {
        return ParseTestUtils.useServer("http://invalid.server:3000");
    }

    public static String useBadServerPort(String baseUrl) {
        String newUrl = "http://10.0.2.2:6000";
        try {
            URL base = new URL(baseUrl);
            newUrl = base.getProtocol() + "://" + base.getHost() + ":" + (base.getPort() + 999);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return ParseTestUtils.useServer(newUrl);
    }

    public static void clearApp() {
        ParseCommand command = new ParseCommand("clear_app", null);
        try {
            Parse.waitForTask(command.executeAsync());
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void mockV8Client() {
        ParseCommand command = new ParseCommand("mock_v8_client", null);
        try {
            Parse.waitForTask(command.executeAsync());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unmockV8Client() {
        ParseCommand command = new ParseCommand("unmock_v8_client", null);
        try {
            Parse.waitForTask(command.executeAsync());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void useDevPushServer() {
        PushService.useServer("10.0.2.2", 8253);
    }

    public static void saveObjectToDisk(ParseObject object, Context context, String filename) {
        object.saveToDisk(context, filename);
    }

    public static ParseObject getObjectFromDisk(Context context, String filename) {
        return ParseObject.getFromDisk(context, filename);
    }

    public static ParseUser getUserObjectFromDisk(Context context, String filename) {
        return (ParseUser)ParseObject.getFromDisk(context, filename);
    }

    public static void saveStringToDisk(String string2, Context context, String filename) {
        File file = new File(ParseTestUtils.getParseDir(context), filename);
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write(string2.getBytes("UTF-8"));
            out.close();
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    static File getParseDir(Context context) {
        return context.getDir("Parse", 0);
    }

    public static void initSynchronizer() {
        synchronizer = new Synchronizer();
    }

    public static Set<String> keySet(ParseObject object) {
        return object.keySet();
    }

    public static void start(int count) {
        synchronizer.start(count);
    }

    public static void assertFinishes() {
        synchronizer.assertFinishes();
    }

    public static void finish() {
        synchronizer.finish();
    }

    public static void setCommandInitialDelay(long milliSeconds) {
        ParseCommand.setDefaultInitialRetryDelay(milliSeconds);
    }

    public static void recursiveDelete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                ParseTestUtils.recursiveDelete(child);
            }
        }
        file.delete();
    }

    public static void clearFiles() {
        ParseTestUtils.recursiveDelete(Parse.getParseDir());
        ParseTestUtils.recursiveDelete(Parse.getKeyValueCacheDir());
        if (Parse.commandCache != null) {
            Parse.commandCache.pause();
            Parse.commandCache = null;
        }
    }

    public static void reloadPushRouter() {
        PushRouter.reloadFromDiskAsync(false);
    }

    public static void clearCurrentInstallationFromMemory() {
        ParseInstallation.currentInstallation = null;
    }

    public static Set<String> pushRoutes(Context context) {
        Task<Set<String>> subscriptionsTask = PushRouter.getSubscriptionsAsync(false);
        try {
            subscriptionsTask.waitForCompletion();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return subscriptionsTask.getResult();
    }

    public static int totalNotifications() {
        return totalNotifications;
    }

    public static String getInstallationId(Context context) {
        return ParseInstallation.getCurrentInstallation().getInstallationId();
    }

    public static JSONObject getPushRequestJSON() {
        Task<JSONObject> task = PushRouter.getPushRequestJSONAsync();
        try {
            task.waitForCompletion();
        }
        catch (InterruptedException e) {
            return null;
        }
        return task.getResult();
    }

    public static JSONObject getSerializedPushStateJSON() {
        return ParseObject.getDiskObject(Parse.applicationContext, "pushState");
    }

    public static void resetAwaitConnectionStarted() {
        awaitStartSemaphore = new Semaphore(0);
    }

    public static void resetAwaitConnectionStopped() {
        awaitStopSemaphore = new Semaphore(0);
    }

    public static boolean awaitConnectionStarted() throws Exception {
        return awaitStartSemaphore.tryAcquire(5L, TimeUnit.SECONDS);
    }

    public static boolean awaitConnectionStopped() throws Exception {
        if (awaitStopSemaphore == null) {
            awaitStopSemaphore = new Semaphore(0);
        }
        return awaitStopSemaphore.tryAcquire(5L, TimeUnit.SECONDS);
    }

    public static List<StateTransition> getPushConnectionStateTransitions() {
        return listener.getTransitions();
    }

    public static List<Long> getPushConnectionRetryDelays() {
        ArrayList<Long> delays = new ArrayList<Long>();
        for (StateTransition transition : ParseTestUtils.getPushConnectionStateTransitions()) {
            if (!(transition.fromState instanceof PushConnection.WaitRetryState)) continue;
            PushConnection.WaitRetryState state = (PushConnection.WaitRetryState)transition.fromState;
            delays.add(state.getDelay());
        }
        return delays;
    }

    public static void tearDownPushTest(Context context) {
        PushConnection.setStateTransitionListener(null);
        PushConnection.KEEP_ALIVE_INTERVAL = 900000L;
        PushConnection.ENABLE_RETRY_DELAY = true;
        ParseNotificationManager.getInstance().setShouldShowNotifications(true);
        ParseTestUtils.clearFiles();
        ParseInstallation.clearCurrentInstallationFromDisk(context);
        PushRouter.reloadFromDiskAsync(true);
        ParseTestUtils.setPushRoutedListener(null);
        awaitStartSemaphore = null;
        awaitStopSemaphore = null;
    }

    public static synchronized void setPushRoutedListener(PushRoutedListener listener) {
        globalListener = listener;
    }

    public static void setUpPushTest(Context context) {
        ManifestInfo.setPushType(PushType.PPNS);
        awaitStartSemaphore = null;
        awaitStopSemaphore = null;
        listener = new StateTransitionListener();
        PushConnection.setStateTransitionListener(listener);
        ParseNotificationManager.getInstance().setShouldShowNotifications(false);
        ParseTestUtils.useTestServer(context);
        ParseInstallation.clearCurrentInstallationFromDisk(context);
        PushRouter.reloadFromDiskAsync(true);
        ParseTestUtils.initSynchronizer();
        totalNotifications = 0;
        PushRouter.setGlobalPushListener(new PushRouter.PushListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onPushHandled(JSONObject pushData, PushRouter.HandlePushResult result) {
                if (result != PushRouter.HandlePushResult.SHOW_NOTIFICATION) return;
                ++totalNotifications;
                PushRoutedListener listener = null;
                Class<ParseTestUtils> clazz = ParseTestUtils.class;
                synchronized (ParseTestUtils.class) {
                    listener = globalListener;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    if (listener == null) return;
                    listener.onPushRouted(pushData);
                    return;
                }
            }
        });
    }

    public static void startServiceIfRequired(Context context) {
        PushService.startServiceIfRequired(context);
    }

    public static void setRetryDelayEnabled(boolean enable) {
        PushConnection.ENABLE_RETRY_DELAY = enable;
    }

    public static ServerSocket mockPushServer() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        InetSocketAddress address = (InetSocketAddress)socket.getLocalSocketAddress();
        PushService.useServer(address.getHostName(), address.getPort());
        Parse.logI(TAG, "running mockPushServer on port " + address);
        return socket;
    }

    public static int numKeyValueCacheFiles() {
        return Parse.getKeyValueCacheDir().listFiles().length;
    }

    public static void setMaxKeyValueCacheFiles(int max) {
        Parse.maxKeyValueCacheFiles = max;
    }

    public static void setMaxKeyValueCacheBytes(int max) {
        Parse.maxKeyValueCacheBytes = max;
    }

    public static void resetCommandCache() {
        ParseCommandCache cache = Parse.getCommandCache();
        ParseCommandCache.TestHelper helper = cache.getTestHelper();
        cache.clear();
        helper.clear();
    }

    public static void disconnectCommandCache() {
        Parse.getCommandCache().setConnected(false);
    }

    public static void reconnectCommandCache() {
        Parse.getCommandCache().setConnected(true);
    }

    public static boolean waitForCommandCacheEnqueue() {
        return Parse.getCommandCache().getTestHelper().waitFor(3);
    }

    public static boolean waitForCommandCacheSuccess() {
        return Parse.getCommandCache().getTestHelper().waitFor(1) && Parse.getCommandCache().getTestHelper().waitFor(5);
    }

    public static boolean waitForCommandCacheFailure() {
        return Parse.getCommandCache().getTestHelper().waitFor(2);
    }

    public static int commandCacheUnexpectedEvents() {
        return Parse.getCommandCache().getTestHelper().unexpectedEvents();
    }

    public static int setPushHistoryLength(int length) {
        int oldLength = PushRouter.MAX_HISTORY_LENGTH;
        PushRouter.MAX_HISTORY_LENGTH = length;
        return oldLength;
    }

    public static void setStrictModeEnabledForMainThread(final boolean enabled) {
        if (strictModeEnabled.compareAndSet(!enabled, enabled)) {
            final Semaphore done = new Semaphore(0);
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                public void run() {
                    ParseTestUtils.setStrictModeEnabledForThisThread(enabled);
                    done.release();
                }
            });
            done.acquireUninterruptibly();
        }
    }

    public static void setStrictModeEnabledForThisThread(boolean enabled) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> strictModeClass = Class.forName("android.os.StrictMode", true, loader);
            if (enabled) {
                Class<?> threadPolicyClass = Class.forName("android.os.StrictMode$ThreadPolicy", true, loader);
                Class<?> threadPolicyBuilderClass = Class.forName("android.os.StrictMode$ThreadPolicy$Builder", true, loader);
                Object threadPolicyBuilder = threadPolicyBuilderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                threadPolicyBuilder = threadPolicyBuilderClass.getMethod("detectNetwork", new Class[0]).invoke(threadPolicyBuilder, new Object[0]);
                threadPolicyBuilder = threadPolicyBuilderClass.getMethod("penaltyDeath", new Class[0]).invoke(threadPolicyBuilder, new Object[0]);
                Object threadPolicy = threadPolicyBuilderClass.getMethod("build", new Class[0]).invoke(threadPolicyBuilder, new Object[0]);
                strictModeClass.getMethod("setThreadPolicy", threadPolicyClass).invoke(strictModeClass, threadPolicy);
            } else {
                strictModeClass.getMethod("enableDefaults", new Class[0]).invoke(strictModeClass, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        totalNotifications = 0;
        strictModeEnabled = new AtomicBoolean(false);
    }

    public static interface PushRoutedListener {
        public void onPushRouted(JSONObject var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StateTransitionListener
    implements PushConnection.StateTransitionListener {
        private ArrayList<StateTransition> transitions = new ArrayList();

        StateTransitionListener() {
        }

        @Override
        public synchronized void onStateChange(PushConnection connection, PushConnection.State fromState, PushConnection.State toState) {
            this.transitions.add(new StateTransition(SystemClock.elapsedRealtime(), connection, fromState, toState));
            if (toState != null && awaitStartSemaphore != null && toState instanceof PushConnection.ConnectState) {
                awaitStartSemaphore.release();
            } else if (toState != null && awaitStopSemaphore != null && toState instanceof PushConnection.StoppedState) {
                awaitStopSemaphore.release();
            }
        }

        public synchronized List<StateTransition> getTransitions() {
            return Collections.unmodifiableList(this.transitions);
        }
    }

    static class StateTransition {
        public final long timestamp;
        public final PushConnection connection;
        public final PushConnection.State fromState;
        public final PushConnection.State toState;

        StateTransition(long timestamp, PushConnection connection, PushConnection.State fromState, PushConnection.State toState) {
            this.timestamp = timestamp;
            this.connection = connection;
            this.fromState = fromState;
            this.toState = toState;
        }

        public String toString() {
            return this.timestamp + " ms: " + this.fromState + " to " + this.toState;
        }
    }
}

