/*
 * Decompiled with CFR 0.152.
 */
package com.parse.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.SessionDefaultAudience;
import com.facebook.SessionState;
import com.facebook.SharedPreferencesTokenCachingStrategy;
import com.facebook.TokenCachingStrategy;
import com.facebook.android.Facebook;
import com.facebook.android.FacebookError;
import com.parse.ParseException;
import com.parse.auth.ParseAuthenticationProvider;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class FacebookAuthenticationProvider
implements ParseAuthenticationProvider {
    private final DateFormat preciseDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
    public static final int DEFAULT_AUTH_ACTIVITY_CODE = 32665;
    private static final String AUTH_TYPE_NAME = "facebook";
    private Facebook facebook;
    private Session session;
    private SessionDefaultAudience defaultAudience;
    private String applicationId;
    private int activityCode;
    private WeakReference<Activity> baseActivity;
    private Context applicationContext;
    private Collection<String> permissions;
    private ParseAuthenticationProvider.ParseAuthenticationCallback currentOperationCallback;
    private String userId;

    public FacebookAuthenticationProvider(Context context, String applicationId) {
        this.preciseDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.activityCode = 32665;
        this.applicationId = applicationId;
        if (context != null) {
            this.applicationContext = context.getApplicationContext();
        }
        if (applicationId != null) {
            this.facebook = new Facebook(applicationId);
        }
    }

    @Deprecated
    public synchronized void extendAccessToken(Context context, ParseAuthenticationProvider.ParseAuthenticationCallback callback) {
        if (this.currentOperationCallback != null) {
            this.cancel();
        }
        this.currentOperationCallback = callback;
        boolean result = this.facebook.extendAccessToken(context, new Facebook.ServiceListener(){

            public void onComplete(Bundle values) {
                FacebookAuthenticationProvider.this.handleSuccess(FacebookAuthenticationProvider.this.userId);
            }

            public void onFacebookError(FacebookError e) {
                FacebookAuthenticationProvider.this.handleError((Throwable)e);
            }

            public void onError(Error e) {
                FacebookAuthenticationProvider.this.handleError(e);
            }
        });
        if (!result) {
            this.handleCancel();
        }
    }

    @Override
    public synchronized void authenticate(ParseAuthenticationProvider.ParseAuthenticationCallback callback) {
        Activity activity;
        if (this.currentOperationCallback != null) {
            this.cancel();
        }
        this.currentOperationCallback = callback;
        Activity activity2 = activity = this.baseActivity == null ? null : (Activity)this.baseActivity.get();
        if (activity == null) {
            throw new IllegalStateException("Activity must be non-null for Facebook authentication to proceed.");
        }
        int activityCode = this.activityCode;
        this.session = new Session.Builder((Context)activity).setApplicationId(this.applicationId).setTokenCachingStrategy((TokenCachingStrategy)new SharedPreferencesTokenCachingStrategy((Context)activity)).build();
        Session.OpenRequest openRequest = new Session.OpenRequest(activity);
        openRequest.setRequestCode(activityCode);
        if (this.defaultAudience != null) {
            openRequest.setDefaultAudience(this.defaultAudience);
        }
        if (this.permissions != null) {
            openRequest.setPermissions(new ArrayList<String>(this.permissions));
        }
        openRequest.setCallback(new Session.StatusCallback(){

            public void call(Session session, SessionState state, Exception exception) {
                if (state == SessionState.OPENING) {
                    return;
                }
                if (state.isOpened()) {
                    if (FacebookAuthenticationProvider.this.currentOperationCallback == null) {
                        return;
                    }
                    Request meRequest = Request.newGraphPathRequest((Session)session, (String)"me", (Request.Callback)new Request.Callback(){

                        public void onCompleted(Response response) {
                            if (response.getError() != null) {
                                if (response.getError().getException() != null) {
                                    FacebookAuthenticationProvider.this.handleError((Throwable)response.getError().getException());
                                } else {
                                    FacebookAuthenticationProvider.this.handleError(new ParseException(-1, "An error occurred while fetching the Facebook user's identity."));
                                }
                            } else {
                                FacebookAuthenticationProvider.this.handleSuccess((String)response.getGraphObject().getProperty("id"));
                            }
                        }
                    });
                    meRequest.getParameters().putString("fields", "id");
                    meRequest.executeAsync();
                } else if (exception != null) {
                    FacebookAuthenticationProvider.this.handleError(exception);
                } else {
                    FacebookAuthenticationProvider.this.handleCancel();
                }
            }
        });
        this.session.openForRead(openRequest);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Activity activity = (Activity)this.baseActivity.get();
        if (activity != null) {
            this.session.onActivityResult(activity, requestCode, resultCode, data);
        }
    }

    @Override
    public synchronized void cancel() {
        this.handleCancel();
    }

    public int getActivityCode() {
        return this.activityCode;
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE_NAME;
    }

    public Facebook getFacebook() {
        return this.facebook;
    }

    public Session getSession() {
        return this.session;
    }

    private void handleCancel() {
        if (this.currentOperationCallback == null) {
            return;
        }
        try {
            this.currentOperationCallback.onCancel();
        }
        finally {
            this.currentOperationCallback = null;
        }
    }

    private void handleError(Throwable error) {
        if (this.currentOperationCallback == null) {
            return;
        }
        try {
            this.currentOperationCallback.onError(error);
        }
        finally {
            this.currentOperationCallback = null;
        }
    }

    public JSONObject getAuthData(String id2, String accessToken, Date expiration) throws JSONException {
        JSONObject authData = new JSONObject();
        authData.put("id", (Object)id2);
        authData.put("access_token", (Object)accessToken);
        authData.put("expiration_date", (Object)this.preciseDateFormat.format(expiration));
        return authData;
    }

    private void handleSuccess(String userId) {
        if (this.currentOperationCallback == null) {
            return;
        }
        this.userId = userId;
        JSONObject authData = null;
        try {
            authData = this.getAuthData(userId, this.session.getAccessToken(), this.session.getExpirationDate());
        }
        catch (JSONException e) {
            this.handleError(e);
            return;
        }
        try {
            this.currentOperationCallback.onSuccess(authData);
        }
        finally {
            this.currentOperationCallback = null;
        }
    }

    public synchronized void setActivity(Activity activity) {
        this.baseActivity = new WeakReference<Activity>(activity);
    }

    public synchronized void setActivityCode(int activityCode) {
        this.activityCode = activityCode;
    }

    public synchronized void setPermissions(Collection<String> permissions) {
        this.permissions = permissions;
    }

    @Override
    public boolean restoreAuthentication(JSONObject authData) {
        if (authData == null) {
            if (this.facebook != null) {
                this.facebook.setAccessExpires(0L);
                this.facebook.setAccessToken(null);
            }
            this.session = null;
            return true;
        }
        try {
            String accessToken = authData.getString("access_token");
            Date expirationDate = this.preciseDateFormat.parse(authData.getString("expiration_date"));
            if (this.facebook != null) {
                this.facebook.setAccessToken(accessToken);
                this.facebook.setAccessExpires(expirationDate.getTime());
            }
            SharedPreferencesTokenCachingStrategy tcs = new SharedPreferencesTokenCachingStrategy(this.applicationContext);
            Bundle data = tcs.load();
            TokenCachingStrategy.putToken((Bundle)data, (String)authData.getString("access_token"));
            TokenCachingStrategy.putExpirationDate((Bundle)data, (Date)expirationDate);
            tcs.save(data);
            Session newSession = new Session.Builder(this.applicationContext).setApplicationId(this.applicationId).setTokenCachingStrategy((TokenCachingStrategy)tcs).build();
            if (newSession.getState() == SessionState.CREATED_TOKEN_LOADED) {
                newSession.openForRead(null);
                this.session = newSession;
                Session.setActiveSession((Session)this.session);
            } else {
                this.session = null;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void deauthenticate() {
        this.restoreAuthentication(null);
    }

    public String getUserId() {
        return this.userId;
    }
}

