/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import com.parse.GcmBroadcastReceiver;
import com.parse.Parse;
import com.parse.ParseBroadcastReceiver;
import com.parse.PushService;
import com.parse.PushType;
import java.io.File;
import java.util.List;

class ManifestInfo {
    private static final String TAG = "com.parse.ManifestInfo";
    private static Object lock = new Object();
    private static long lastModified = -1L;
    private static int versionCode = -1;
    private static int iconId = 0;
    private static String displayName = null;
    private static PushType pushType;

    ManifestInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified() {
        Object object = lock;
        synchronized (object) {
            if (lastModified == -1L) {
                File apkPath = new File(ManifestInfo.getApplicationInfo().sourceDir);
                lastModified = apkPath.lastModified();
            }
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVersionCode() {
        Object object = lock;
        synchronized (object) {
            if (versionCode == -1) {
                try {
                    versionCode = ManifestInfo.getPackageManager().getPackageInfo((String)ManifestInfo.getPackageName(), (int)0).versionCode;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Parse.logE(TAG, "Couldn't find info about own package", e);
                }
            }
        }
        return versionCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDisplayName() {
        Object object = lock;
        synchronized (object) {
            if (displayName == null) {
                displayName = ManifestInfo.getPackageManager().getApplicationLabel(ManifestInfo.getApplicationInfo()).toString();
            }
        }
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIconId() {
        Object object = lock;
        synchronized (object) {
            if (iconId == 0) {
                iconId = ManifestInfo.getApplicationInfo().icon;
            }
        }
        return iconId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setPushType(PushType newPushType) {
        Object object = lock;
        synchronized (object) {
            pushType = newPushType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PushType getPushType() {
        Object object = lock;
        synchronized (object) {
            if (pushType == null) {
                boolean deviceSupportsGcm = ManifestInfo.deviceSupportsGcm();
                boolean hasAnyGcmSpecificDeclaration = ManifestInfo.hasAnyGcmSpecificDeclaration();
                ManifestCheckResult gcmSupportLevel = ManifestInfo.gcmSupportLevel();
                ManifestCheckResult ppnsSupportLevel = ManifestInfo.ppnsSupportLevel();
                pushType = deviceSupportsGcm && gcmSupportLevel != ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS ? PushType.GCM : ((!hasAnyGcmSpecificDeclaration || !deviceSupportsGcm) && ppnsSupportLevel != ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS ? PushType.PPNS : PushType.NONE);
                if (Parse.getLogLevel() <= 5) {
                    if (pushType == PushType.GCM && gcmSupportLevel == ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS) {
                        Parse.logW(TAG, "Using GCM for push, but the app manifest is missing some optional declarations that should be added for maximum reliability. Please " + ManifestInfo.getGcmManifestMessage());
                    } else if (pushType == PushType.PPNS && ppnsSupportLevel == ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS) {
                        Parse.logW(TAG, "Using PPNS for push, but the app manifest is missing some optional declarations that should be added for maximum reliability. Please " + ManifestInfo.getPpnsManifestMessage());
                    }
                }
                if (Parse.getLogLevel() <= 6 && pushType == PushType.NONE && hasAnyGcmSpecificDeclaration) {
                    if (!deviceSupportsGcm) {
                        Parse.logE(TAG, "Cannot use GCM for push on this device because Google Play Services is not installed. Install Google Play Service from the Play Store, or enable PPNS as a fallback push service. To enable PPNS as a fallback push service on devices without Google Play support, please " + ManifestInfo.getPpnsManifestMessage());
                    }
                    if (gcmSupportLevel != ManifestCheckResult.HAS_ALL_DECLARATIONS) {
                        Parse.logE(TAG, "Cannot use GCM for push because the app manifest is missing some required declarations. Please " + ManifestInfo.getGcmManifestMessage());
                    }
                }
                if (Parse.getLogLevel() <= 2) {
                    Parse.logV(TAG, "Using " + (Object)((Object)pushType) + " for push.");
                }
            }
        }
        return pushType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNonePushTypeLogMessage() {
        Object object = lock;
        synchronized (object) {
            if (pushType == PushType.NONE) {
                return "Push is not configured for this app because the app manifest is missing required declarations. Please add the following declarations to your app manifest to support either GCM or PPNS for push (or both). To enable GCM support, please " + ManifestInfo.getGcmManifestMessage() + "To enable PPNS support, please " + ManifestInfo.getPpnsManifestMessage();
            }
            return "";
        }
    }

    private static Context getContext() {
        return Parse.getApplicationContext();
    }

    private static String getPackageName() {
        return ManifestInfo.getContext().getPackageName();
    }

    private static PackageManager getPackageManager() {
        return ManifestInfo.getContext().getPackageManager();
    }

    private static ApplicationInfo getApplicationInfo() {
        return ManifestInfo.getContext().getApplicationInfo();
    }

    private static PackageInfo getPackageInfo(String name) {
        PackageInfo info = null;
        try {
            info = ManifestInfo.getPackageManager().getPackageInfo(name, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info;
    }

    private static ServiceInfo getServiceInfo(Class<? extends Service> clazz) {
        ServiceInfo info = null;
        try {
            info = ManifestInfo.getPackageManager().getServiceInfo(new ComponentName(ManifestInfo.getContext(), clazz), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info;
    }

    private static ActivityInfo getReceiverInfo(Class<? extends BroadcastReceiver> clazz) {
        ActivityInfo info = null;
        try {
            info = ManifestInfo.getPackageManager().getReceiverInfo(new ComponentName(ManifestInfo.getContext(), clazz), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info;
    }

    private static boolean hasPermissions(String ... permissions) {
        String[] stringArray = permissions;
        int n = permissions.length;
        int n2 = 0;
        while (n2 < n) {
            String permission = stringArray[n2];
            if (ManifestInfo.getPackageManager().checkPermission(permission, ManifestInfo.getPackageName()) != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean checkResolveInfo(Class<? extends BroadcastReceiver> clazz, List<ResolveInfo> infoList) {
        for (ResolveInfo info : infoList) {
            if (info.activityInfo == null || !clazz.getCanonicalName().equals(info.activityInfo.name)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkReceiver(Class<? extends BroadcastReceiver> clazz, String permission, Intent[] intents) {
        ActivityInfo receiver = ManifestInfo.getReceiverInfo(clazz);
        if (receiver == null) {
            return false;
        }
        if (permission != null && !permission.equals(receiver.permission)) {
            return false;
        }
        Intent[] intentArray = intents;
        int n = intents.length;
        int n2 = 0;
        while (n2 < n) {
            Intent intent = intentArray[n2];
            List receivers = ManifestInfo.getPackageManager().queryBroadcastReceivers(intent, 0);
            if (receivers.isEmpty()) {
                return false;
            }
            if (!ManifestInfo.checkResolveInfo(clazz, receivers)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean hasAnyGcmSpecificDeclaration() {
        return ManifestInfo.hasPermissions("com.google.android.c2dm.permission.RECEIVE") || ManifestInfo.hasPermissions(String.valueOf(ManifestInfo.getPackageName()) + ".permission.C2D_MESSAGE") || ManifestInfo.getReceiverInfo(GcmBroadcastReceiver.class) != null;
    }

    private static boolean deviceSupportsGcm() {
        return Build.VERSION.SDK_INT >= 8 && ManifestInfo.getPackageInfo("com.google.android.gsf") != null;
    }

    private static ManifestCheckResult gcmSupportLevel() {
        if (ManifestInfo.getServiceInfo(PushService.class) == null) {
            return ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
        }
        String[] requiredPermissions = new String[]{"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK", "android.permission.GET_ACCOUNTS", "com.google.android.c2dm.permission.RECEIVE", String.valueOf(ManifestInfo.getPackageName()) + ".permission.C2D_MESSAGE"};
        if (!ManifestInfo.hasPermissions(requiredPermissions)) {
            return ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
        }
        String packageName = ManifestInfo.getPackageName();
        String rcvrPermission = "com.google.android.c2dm.permission.SEND";
        Intent[] intents = new Intent[]{new Intent("com.google.android.c2dm.intent.RECEIVE").setPackage(packageName).addCategory(packageName), new Intent("com.google.android.c2dm.intent.REGISTRATION").setPackage(packageName).addCategory(packageName)};
        if (!ManifestInfo.checkReceiver(GcmBroadcastReceiver.class, rcvrPermission, intents)) {
            return ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
        }
        String[] optionalPermissions = new String[]{"android.permission.VIBRATE"};
        if (!ManifestInfo.hasPermissions(optionalPermissions)) {
            return ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS;
        }
        return ManifestCheckResult.HAS_ALL_DECLARATIONS;
    }

    private static ManifestCheckResult ppnsSupportLevel() {
        if (ManifestInfo.getServiceInfo(PushService.class) == null) {
            return ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
        }
        String[] optionalPermissions = new String[]{"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.VIBRATE", "android.permission.WAKE_LOCK", "android.permission.RECEIVE_BOOT_COMPLETED"};
        if (!ManifestInfo.hasPermissions(optionalPermissions)) {
            return ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS;
        }
        Intent[] intents = new Intent[]{new Intent("android.intent.action.BOOT_COMPLETED").setPackage(ManifestInfo.getPackageName()), new Intent("android.intent.action.USER_PRESENT").setPackage(ManifestInfo.getPackageName())};
        if (!ManifestInfo.checkReceiver(ParseBroadcastReceiver.class, null, intents)) {
            return ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS;
        }
        return ManifestCheckResult.HAS_ALL_DECLARATIONS;
    }

    private static String getGcmManifestMessage() {
        String gcmPackagePermission = String.valueOf(ManifestInfo.getPackageName()) + ".permission.C2D_MESSAGE";
        return "make sure that these permissions are declared as children of the root <manifest> element:\n\n<uses-permission android:name=\"android.permission.INTERNET\" />\n<uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />\n<uses-permission android:name=\"android.permission.VIBRATE\" />\n<uses-permission android:name=\"android.permission.WAKE_LOCK\" />\n<uses-permission android:name=\"android.permission.GET_ACCOUNTS\" />\n<uses-permission android:name=\"com.google.android.c2dm.permission.RECEIVE\" />\n<permission android:name=\"" + gcmPackagePermission + "\" " + "android:protectionLevel=\"signature\" />\n" + "<uses-permission android:name=\"" + gcmPackagePermission + "\" />\n" + "\n" + "Also, please make sure that these services and broadcast receivers are declared as " + "children of the <application> element:\n" + "\n" + "<service android:name=\"com.parse.PushService\" />\n" + "<receiver android:name=\"com.parse.GcmBroadcastReceiver\" " + "android:permission=\"com.google.android.c2dm.permission.SEND\">\n" + "  <intent-filter>\n" + "    <action android:name=\"com.google.android.c2dm.intent.RECEIVE\" />\n" + "    <action android:name=\"com.google.android.c2dm.intent.REGISTRATION\" />\n" + "    <category android:name=\"" + ManifestInfo.getPackageName() + "\" />\n" + "  </intent-filter>\n" + "</receiver>\n";
    }

    private static String getPpnsManifestMessage() {
        return "make sure that these permissions are declared as children of the root <manifest> element:\n\n<uses-permission android:name=\"android.permission.INTERNET\" />\n<uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />\n<uses-permission android:name=\"android.permission.RECEIVE_BOOT_COMPLETED\" />\n<uses-permission android:name=\"android.permission.VIBRATE\" />\n<uses-permission android:name=\"android.permission.WAKE_LOCK\" />\n\nAlso, please make sure that these services and broadcast receivers are declared as children of the <application> element:\n\n<service android:name=\"com.parse.PushService\" />\n<receiver android:name=\"com.parse.ParseBroadcastReceiver\">\n  <intent-filter>\n    <action android:name=\"android.intent.action.BOOT_COMPLETED\" />\n    <action android:name=\"android.intent.action.USER_PRESENT\" />\n  </intent-filter>\n</receiver>\n";
    }

    static enum ManifestCheckResult {
        HAS_ALL_DECLARATIONS,
        MISSING_OPTIONAL_DECLARATIONS,
        MISSING_REQUIRED_DECLARATIONS;

    }
}

