/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.PowerManager;
import com.parse.Parse;
import com.parse.ParsePushRouter;
import com.parse.PushConnection;
import com.parse.Task;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PushService
extends Service {
    private static final String TAG = "com.parse.PushService";
    private static final String START_ACTION = "com.parse.PushService.start";
    private static final String START_IF_REQUIRED_ACTION = "com.parse.PushService.startIfRequired";
    private static String host = "push.parse.com";
    private static int port = 8253;
    private static AtomicBoolean hasWakeLockPermission = new AtomicBoolean(true);
    private PushConnection connection;

    @SuppressLint(value={"Wakelock"})
    static PowerManager.WakeLock acquireNewWakeLock(Context context, int type, String reason, long timeout) {
        PowerManager.WakeLock wl = null;
        if (hasWakeLockPermission.get()) {
            try {
                PowerManager pm = (PowerManager)context.getApplicationContext().getSystemService("power");
                if (pm != null && (wl = pm.newWakeLock(type, reason)) != null) {
                    wl.setReferenceCounted(false);
                    if (timeout == 0L) {
                        wl.acquire();
                    } else {
                        wl.acquire(timeout);
                    }
                }
            }
            catch (SecurityException e) {
                if (hasWakeLockPermission.compareAndSet(true, false)) {
                    Parse.logE(TAG, "Failed to acquire a PowerManager.WakeLock. This isnecessary for reliable handling of pushes. Please add this to your Manifest.xml: <uses-permission android:name=\"android.permission.WAKE_LOCK\" /> ");
                }
                wl = null;
            }
        }
        return wl;
    }

    private static synchronized void startService(Context context, boolean force) {
        Parse.logD(TAG, "ensuring push service is started");
        Intent intent = new Intent(force ? START_ACTION : START_IF_REQUIRED_ACTION);
        intent.setClass(context, PushService.class);
        ComponentName name = context.startService(intent);
        if (name == null) {
            Parse.logE(TAG, "Could not start the push service. Make sure that the XML tag <service android:name=\"com.parse.PushService\" /> is in your AndroidManifest.xml as a child of the <application> element.");
        }
    }

    public static void startServiceIfRequired(Context context) {
        PushService.startService(context, false);
    }

    public static void subscribe(Context context, String channel, Class<? extends Activity> cls) {
        ApplicationInfo info;
        String packageName = context.getPackageName();
        PackageManager pm = context.getPackageManager();
        try {
            info = pm.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Parse.logE(TAG, "missing package " + packageName, e);
            return;
        }
        PushService.subscribe(context, channel, cls, info.icon);
    }

    public static synchronized void subscribe(Context context, String channel, Class<? extends Activity> cls, int icon) {
        PushService.startService(context, true);
        ParsePushRouter.addChannelRoute(context, channel, cls, icon);
    }

    public static synchronized void unsubscribe(Context context, String channel) {
        ParsePushRouter.removeChannelRoute(context, channel);
    }

    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls) {
        ApplicationInfo info;
        String packageName = context.getPackageName();
        PackageManager pm = context.getPackageManager();
        try {
            info = pm.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Parse.logE(TAG, "missing package " + packageName, e);
            return;
        }
        PushService.setDefaultPushCallback(context, cls, info.icon);
    }

    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls, int icon) {
        ParsePushRouter.setDefaultRoute(context, cls, icon);
        if (cls != null) {
            PushService.startService(context, true);
        } else if (!ParsePushRouter.hasRoutes(context)) {
            Parse.logD(TAG, "Shutting down push service. No remaining channels");
            context.stopService(new Intent(context, PushService.class));
        }
    }

    public static synchronized Set<String> getSubscriptions(Context context) {
        return ParsePushRouter.getSubscriptions(context);
    }

    static void useServer(String theHost, int thePort) {
        host = theHost;
        port = thePort;
    }

    public void onCreate() {
        super.onCreate();
        if (Parse.applicationContext == null) {
            Parse.logE(TAG, "The Parse push service cannot start because Parse.initialize has not yet been called. If you call Parse.initialize from an Activity's onCreate, that call should instead be in the Application.onCreate. Be sure your Application class is registered in your AndroidManifest.xml with the android:name property of your <application> tag.");
            this.stopSelf();
            return;
        }
        this.connection = new PushConnection(this, host, port);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null || intent.getAction() == null || intent.getAction().equals(START_IF_REQUIRED_ACTION)) {
            Parse.logI(TAG, "Received request to start service if required");
            PushService context = this;
            PushConnection conn = this.connection;
            Task.callInBackground(new Callable<Void>((Context)context, conn){
                private final /* synthetic */ Context val$context;
                private final /* synthetic */ PushConnection val$conn;
                {
                    this.val$context = context;
                    this.val$conn = pushConnection;
                }

                @Override
                public Void call() {
                    if (ParsePushRouter.hasRoutes(this.val$context)) {
                        this.val$conn.start();
                    } else {
                        this.val$conn.stop();
                        PushService.this.stopSelf();
                    }
                    return null;
                }
            });
        } else if (intent.getAction().equals(START_ACTION)) {
            Parse.logI(TAG, "Received request to start service unconditionally");
            this.connection.start();
        }
        return 1;
    }

    public IBinder onBind(Intent intent) {
        throw new IllegalArgumentException("You cannot bind directly to the PushService. Use PushService.subscribe instead.");
    }

    public void onDestroy() {
        if (this.connection != null) {
            this.connection.stop();
        }
        super.onDestroy();
    }
}

