/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import com.parse.ConnectivityNotifier;
import com.parse.Continuation;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParsePushRouter;
import com.parse.PushService;
import com.parse.Task;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

class PushConnection {
    private static final String TAG = "com.parse.PushConnection";
    private static final int CONNECT_TIMEOUT_MS = 40000;
    static long KEEP_ALIVE_INTERVAL = 900000L;
    static boolean ENABLE_RETRY_DELAY = true;
    private static final long MIN_RETRY_DELAY_MS = 15000L;
    private static final long MAX_RETRY_DELAY_MS = 300000L;
    private static final double RETRY_MULT_FACTOR_MIN = 1.5;
    private static final double RETRY_MULT_FACTOR_MAX = 2.0;
    private final Service service;
    private final String host;
    private final int port;
    private final ExecutorService executor;
    private final EventSet eventSet;
    private static StateTransitionListener stateTransitionListener;

    public PushConnection(Service service, String host, int port) {
        this.service = service;
        this.host = host;
        this.port = port;
        this.executor = Executors.newSingleThreadExecutor();
        this.eventSet = new EventSet();
        this.executor.execute(new WaitStartState());
    }

    public synchronized void start() {
        this.eventSet.signalEvent(Event.START);
    }

    public synchronized void stop() {
        this.eventSet.signalEvent(Event.STOP);
    }

    private static boolean writeLine(Socket socket, String string2) {
        boolean sent = false;
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            throw new Error("Wrote to push socket on main thread.");
        }
        try {
            OutputStream stream = socket.getOutputStream();
            stream.write((String.valueOf(string2) + "\n").getBytes("UTF-8"));
            stream.flush();
            sent = true;
        }
        catch (IOException e) {
            Parse.logV(TAG, "PushConnection write failed: " + string2 + " due to exception: " + e);
        }
        return sent;
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.shutdownInput();
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStateTransitionListener(StateTransitionListener listener) {
        Class<PushConnection> clazz = PushConnection.class;
        synchronized (PushConnection.class) {
            stateTransitionListener = listener;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public class ConnectState
    extends State {
        private long lastDelay;

        public ConnectState(long lastDelay) {
            this.lastDelay = lastDelay;
        }

        public State runState() {
            boolean connectedAndSentHandshake = false;
            Socket socket = new Socket();
            Exception t = null;
            try {
                InetSocketAddress address = new InetSocketAddress(PushConnection.this.host, PushConnection.this.port);
                if (address != null) {
                    socket.connect(address, 40000);
                    socket.setKeepAlive(true);
                    socket.setTcpNoDelay(true);
                    connectedAndSentHandshake = this.sendHandshake(socket);
                }
            }
            catch (IOException e) {
                t = e;
            }
            catch (SecurityException e) {
                t = e;
            }
            if (t != null) {
                Parse.logI(PushConnection.TAG, "Failed to connect to push server due to " + t);
            }
            if (!connectedAndSentHandshake) {
                PushConnection.closeSocket(socket);
                return new WaitRetryState(this.nextDelay());
            }
            return new ConnectedState(socket);
        }

        private boolean sendHandshake(Socket socket) {
            return PushConnection.writeLine(socket, ParsePushRouter.getPushRequestJSON((Context)PushConnection.this.service).toString());
        }

        private long nextDelay() {
            long delay = (long)((double)this.lastDelay * (1.5 + Math.random() * 0.5));
            delay = Math.min(Math.max(15000L, delay), 300000L);
            return delay;
        }
    }

    public class ConnectedState
    extends State {
        private Socket socket;

        public ConnectedState(Socket socket) {
            this.socket = socket;
        }

        public State runState() {
            State nextState = null;
            ReachabilityMonitor reachabilityMonitor = new ReachabilityMonitor();
            KeepAliveMonitor keepAliveMonitor = new KeepAliveMonitor(this.socket, KEEP_ALIVE_INTERVAL);
            ReaderThread readerThread = new ReaderThread(this.socket);
            reachabilityMonitor.register();
            keepAliveMonitor.register();
            readerThread.start();
            while (nextState == null) {
                Set<Event> e = PushConnection.this.eventSet.await(Event.STOP, Event.CONNECTIVITY_CHANGED, Event.KEEP_ALIVE_ERROR, Event.READ_ERROR);
                if (e.contains((Object)Event.STOP)) {
                    nextState = new StoppedState();
                    continue;
                }
                if (!e.contains((Object)Event.READ_ERROR) && !e.contains((Object)Event.KEEP_ALIVE_ERROR) && !e.contains((Object)Event.CONNECTIVITY_CHANGED)) continue;
                nextState = new WaitRetryState(0L);
            }
            reachabilityMonitor.unregister();
            keepAliveMonitor.unregister();
            readerThread.stopReading();
            PushConnection.closeSocket(this.socket);
            PushConnection.this.eventSet.removeEvents(Event.CONNECTIVITY_CHANGED, Event.KEEP_ALIVE_ERROR, Event.READ_ERROR);
            return nextState;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Event {
        START,
        STOP,
        CONNECTIVITY_CHANGED,
        KEEP_ALIVE_ERROR,
        READ_ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventSet {
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private final HashSet<Event> signaledEvents = new HashSet();

        private EventSet() {
        }

        public void signalEvent(Event event) {
            this.lock.lock();
            try {
                this.signaledEvents.add(event);
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void removeEvents(Event ... eventsToRemove) {
            this.lock.lock();
            try {
                Event[] eventArray = eventsToRemove;
                int n = eventsToRemove.length;
                int n2 = 0;
                while (n2 < n) {
                    Event e = eventArray[n2];
                    this.signaledEvents.remove((Object)e);
                    ++n2;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public Set<Event> await(Event ... eventsToAwait) {
            return this.timedAwait(Long.MAX_VALUE, eventsToAwait);
        }

        /*
         * Exception decompiling
         */
        public Set<Event> timedAwait(long timeoutMs, Event ... eventsToAwait) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class KeepAliveMonitor {
        private final Socket socket;
        private final long interval;
        private BroadcastReceiver receiver;
        private AlarmManager manager;
        private PendingIntent broadcast;
        private Task<Void> keepAliveTask;
        private boolean unregistered;

        public KeepAliveMonitor(Socket socket, long interval) {
            this.socket = socket;
            this.interval = interval;
        }

        public void register() {
            this.receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    final PowerManager.WakeLock wl = PushService.acquireNewWakeLock((Context)PushConnection.this.service, 1, "push-keep-alive", 10000L);
                    if (KeepAliveMonitor.this.keepAliveTask == null) {
                        KeepAliveMonitor.this.keepAliveTask = Task.forResult(null).makeVoid();
                    }
                    KeepAliveMonitor.this.keepAliveTask = KeepAliveMonitor.this.keepAliveTask.continueWith(new Continuation<Void, Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Void then(Task<Void> task) {
                            if (!PushConnection.writeLine(KeepAliveMonitor.this.socket, "{}")) {
                                KeepAliveMonitor keepAliveMonitor = KeepAliveMonitor.this;
                                synchronized (keepAliveMonitor) {
                                    if (!KeepAliveMonitor.this.unregistered) {
                                        PushConnection.this.eventSet.signalEvent(Event.KEEP_ALIVE_ERROR);
                                    }
                                }
                            }
                            if (wl != null) {
                                wl.release();
                            }
                            return null;
                        }
                    }, ParseCommand.networkThreadPool);
                }
            };
            Context appContext = Parse.applicationContext;
            String action = "com.parse.PushConnection.keepAlive";
            Intent intent = new Intent(action).setPackage(appContext.getPackageName());
            appContext.registerReceiver(this.receiver, new IntentFilter(action));
            this.broadcast = PendingIntent.getBroadcast((Context)appContext, (int)System.identityHashCode(this), (Intent)intent, (int)0);
            this.manager = (AlarmManager)appContext.getSystemService("alarm");
            int alarmType = 2;
            long start = SystemClock.elapsedRealtime() + this.interval;
            this.manager.setInexactRepeating(alarmType, start, this.interval, this.broadcast);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            Parse.applicationContext.unregisterReceiver(this.receiver);
            this.manager.cancel(this.broadcast);
            this.broadcast.cancel();
            KeepAliveMonitor keepAliveMonitor = this;
            synchronized (keepAliveMonitor) {
                this.unregistered = true;
            }
        }
    }

    private class ReachabilityMonitor {
        private ConnectivityNotifier.ConnectivityListener listener;
        private boolean unregistered;

        private ReachabilityMonitor() {
        }

        public void register() {
            this.listener = new ConnectivityNotifier.ConnectivityListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void networkConnectivityStatusChanged(Intent intent) {
                    ReachabilityMonitor reachabilityMonitor = ReachabilityMonitor.this;
                    synchronized (reachabilityMonitor) {
                        if (!ReachabilityMonitor.this.unregistered) {
                            PushConnection.this.eventSet.signalEvent(Event.CONNECTIVITY_CHANGED);
                        }
                    }
                }
            };
            ConnectivityNotifier.getNotifier().addListener(this.listener, (Context)PushConnection.this.service);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            ConnectivityNotifier.getNotifier().removeListener(this.listener);
            ReachabilityMonitor reachabilityMonitor = this;
            synchronized (reachabilityMonitor) {
                this.unregistered = true;
            }
        }
    }

    private class ReaderThread
    extends Thread {
        private Socket socket;
        private Handler handler;
        private boolean stopped;

        public ReaderThread(Socket socket) {
            this.socket = socket;
            this.handler = new Handler(Looper.getMainLooper());
            this.stopped = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (reader != null) {
                this.runReaderLoop(reader);
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ReaderThread readerThread = this;
            synchronized (readerThread) {
                if (!this.stopped) {
                    PushConnection.this.eventSet.signalEvent(Event.READ_ERROR);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runReaderLoop(BufferedReader reader) {
            while (true) {
                String line = null;
                try {
                    line = reader.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (line == null) break;
                JSONTokener tokener = new JSONTokener(line);
                JSONObject message = null;
                try {
                    message = new JSONObject(tokener);
                }
                catch (JSONException e) {
                    Parse.logE(PushConnection.TAG, "bad json: " + line, e);
                }
                if (message != null) {
                    final JSONObject push = message;
                    this.handler.post(new Runnable(){

                        public void run() {
                            ParsePushRouter.routePush(PushConnection.this.service, push);
                        }
                    });
                }
                ReaderThread readerThread = this;
                synchronized (readerThread) {
                    if (this.stopped) {
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopReading() {
            ReaderThread readerThread = this;
            synchronized (readerThread) {
                this.stopped = true;
            }
        }
    }

    public abstract class State
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            State nextState = this.runState();
            Class<PushConnection> clazz = PushConnection.class;
            synchronized (PushConnection.class) {
                if (stateTransitionListener != null) {
                    stateTransitionListener.onStateChange(PushConnection.this, this, nextState);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                if (this.isTerminal()) {
                    Parse.logI(PushConnection.TAG, this + " finished and is the terminal state. Thread exiting.");
                    PushConnection.this.executor.shutdown();
                } else if (nextState != null) {
                    Parse.logI(PushConnection.TAG, "PushConnection transitioning from " + this + " to " + nextState);
                    PushConnection.this.executor.execute(nextState);
                } else {
                    throw new NullPointerException(this + " tried to transition to null state.");
                }
                return;
            }
        }

        public abstract State runState();

        public boolean isTerminal() {
            return false;
        }
    }

    public static interface StateTransitionListener {
        public void onStateChange(PushConnection var1, State var2, State var3);
    }

    public class StoppedState
    extends State {
        public State runState() {
            return null;
        }

        public boolean isTerminal() {
            return true;
        }
    }

    public class WaitRetryState
    extends State {
        private long delay;

        public WaitRetryState(long delay) {
            this.delay = delay;
        }

        public long getDelay() {
            return this.delay;
        }

        public State runState() {
            Set<Event> e;
            State nextState = null;
            PushConnection.this.eventSet.removeEvents(Event.START);
            long actualDelay = this.delay;
            if (!ENABLE_RETRY_DELAY) {
                actualDelay = 0L;
            }
            nextState = (e = PushConnection.this.eventSet.timedAwait(actualDelay, Event.STOP, Event.START)).contains((Object)Event.STOP) ? new StoppedState() : (e.contains((Object)Event.START) ? new ConnectState(0L) : new ConnectState(this.delay));
            return nextState;
        }
    }

    public class WaitStartState
    extends State {
        public State runState() {
            State nextState = null;
            Set<Event> e = PushConnection.this.eventSet.await(Event.START, Event.STOP);
            if (e.contains((Object)Event.STOP)) {
                nextState = new StoppedState();
            } else if (e.contains((Object)Event.START)) {
                nextState = new ConnectState(0L);
            }
            return nextState;
        }
    }
}

