/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.os.Build;
import android.os.SystemClock;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseCommandCache;
import com.parse.ParseException;
import com.parse.ParseInstallation;
import com.parse.ParseObject;
import com.parse.ParsePushRouter;
import com.parse.ParseUser;
import com.parse.PushCallback;
import com.parse.PushConnection;
import com.parse.PushService;
import com.parse.StandardPushCallback;
import com.parse.Synchronizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseTestUtils {
    private static final String TAG = "com.parse.ParseTestUtils";
    private static Synchronizer synchronizer;
    private static StateTransitionListener listener;

    public static String useServer(String theServer) {
        String oldServer = ParseObject.server;
        ParseObject.server = theServer;
        return oldServer;
    }

    public static String getTestServer(Context context) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(context.getAssets().open("server.config")));
            return br.readLine();
        }
        catch (Exception e) {
            if (Build.PRODUCT.contains("vbox")) {
                return "http://192.168.56.1:3000";
            }
            if (Build.PRODUCT.contains("sdk")) {
                return "http://10.0.2.2:3000";
            }
            return "http://localhost:3000";
        }
    }

    public static String useTestServer(Context context) {
        return ParseTestUtils.useServer(ParseTestUtils.getTestServer(context));
    }

    public static String useInvalidServer() {
        return ParseTestUtils.useServer("http://invalid.server:3000");
    }

    public static String useBadServerPort(String baseUrl) {
        String newUrl = "http://10.0.2.2:6000";
        try {
            URL base = new URL(baseUrl);
            newUrl = base.getProtocol() + "://" + base.getHost() + ":" + (base.getPort() + 999);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return ParseTestUtils.useServer(newUrl);
    }

    public static void clearApp() {
        ParseCommand command = new ParseCommand("clear_app", null);
        try {
            Parse.waitForTask(command.performAsync());
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void mockV8Client() {
        ParseCommand command = new ParseCommand("mock_v8_client", null);
        try {
            Parse.waitForTask(command.performAsync());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unmockV8Client() {
        ParseCommand command = new ParseCommand("unmock_v8_client", null);
        try {
            Parse.waitForTask(command.performAsync());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void useDevPushServer() {
        PushService.useServer("10.0.2.2", 8253);
    }

    public static void saveObjectToDisk(ParseObject object, Context context, String filename) {
        object.saveToDisk(context, filename);
    }

    public static ParseObject getObjectFromDisk(Context context, String filename) {
        return ParseObject.getFromDisk(context, filename);
    }

    public static ParseUser getUserObjectFromDisk(Context context, String filename) {
        return (ParseUser)ParseObject.getFromDisk(context, filename);
    }

    public static void saveStringToDisk(String string2, Context context, String filename) {
        File file = new File(ParseTestUtils.getParseDir(context), filename);
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write(string2.getBytes("UTF-8"));
            out.close();
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    static File getParseDir(Context context) {
        return context.getDir("Parse", 0);
    }

    public static void initSynchronizer() {
        synchronizer = new Synchronizer();
    }

    public static Set<String> keySet(ParseObject object) {
        return object.keySet();
    }

    public static void start(int count) {
        synchronizer.start(count);
    }

    public static void assertFinishes() {
        synchronizer.assertFinishes();
    }

    public static void finish() {
        synchronizer.finish();
    }

    public static void setCommandInitialDelay(double seconds) {
        ParseCommand.setInitialDelay(seconds);
    }

    public static void recursiveDelete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                ParseTestUtils.recursiveDelete(child);
            }
        }
        file.delete();
    }

    public static void clearFiles() {
        ParseTestUtils.recursiveDelete(Parse.getParseDir());
        ParseTestUtils.recursiveDelete(Parse.getKeyValueCacheDir());
        if (Parse.commandCache != null) {
            Parse.commandCache.pause();
            Parse.commandCache = null;
        }
    }

    public static void clearPushRouterStateFromMemory() {
        ParsePushRouter.clearStateFromMemory();
    }

    public static void clearCurrentInstallationFromMemory() {
        ParseInstallation.currentInstallation = null;
    }

    public static Set<String> pushRoutes(Context context) {
        ParsePushRouter.ensureStateIsLoaded(context);
        return ParsePushRouter.channelRoutes.keySet();
    }

    public static void onPush(Context context, String channel, PushCallback callback) {
        ParsePushRouter.addSingletonRoute(context, channel, callback);
        PushService.startServiceIfRequired(context);
    }

    public static int totalNotifications() {
        return StandardPushCallback.totalNotifications;
    }

    public static int setPushHistoryLength(int length) {
        int old = ParsePushRouter.maxHistory;
        ParsePushRouter.maxHistory = length;
        return old;
    }

    public static String getInstallationId(Context context) {
        return ParseInstallation.getCurrentInstallation().getInstallationId();
    }

    public static String getLastTime() {
        return ParsePushRouter.lastTime;
    }

    public static String getIgnoreAfterTime() {
        return ParsePushRouter.ignoreAfter;
    }

    public static JSONObject getPushRequestJSON(Context context) {
        return ParsePushRouter.getPushRequestJSON(context);
    }

    public static List<StateTransition> getPushConnectionStateTransitions() {
        return listener.getTransitions();
    }

    public static List<Long> getPushConnectionRetryDelays() {
        ArrayList<Long> delays = new ArrayList<Long>();
        for (StateTransition transition : ParseTestUtils.getPushConnectionStateTransitions()) {
            if (!(transition.fromState instanceof PushConnection.WaitRetryState)) continue;
            PushConnection.WaitRetryState state = (PushConnection.WaitRetryState)transition.fromState;
            delays.add(state.getDelay());
        }
        return delays;
    }

    public static void tearDownPushTest(Context context) {
        PushConnection.setStateTransitionListener(null);
        PushConnection.KEEP_ALIVE_INTERVAL = 900000L;
        PushConnection.ENABLE_RETRY_DELAY = true;
        ParseTestUtils.clearFiles();
        ParseInstallation.clearCurrentInstallationFromDisk(context);
        ParsePushRouter.clearStateFromDisk(context);
    }

    public static void setUpPushTest(Context context) {
        listener = new StateTransitionListener();
        PushConnection.setStateTransitionListener(listener);
        StandardPushCallback.disableNotifications = true;
        StandardPushCallback.totalNotifications = 0;
        ParseTestUtils.useTestServer(context);
        ParsePushRouter.clearStateFromDisk(context);
        ParseInstallation.clearCurrentInstallationFromDisk(context);
        ParseTestUtils.initSynchronizer();
    }

    public static void startServiceIfRequired(Context context) {
        PushService.startServiceIfRequired(context);
    }

    public static void setKeepAliveInterval(long interval) {
        PushConnection.KEEP_ALIVE_INTERVAL = interval;
    }

    public static void setRetryDelayEnabled(boolean enable) {
        PushConnection.ENABLE_RETRY_DELAY = enable;
    }

    public static ServerSocket mockPushServer() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        InetSocketAddress address = (InetSocketAddress)socket.getLocalSocketAddress();
        PushService.useServer(address.getHostName(), address.getPort());
        Parse.logI(TAG, "running mockPushServer on port " + address);
        return socket;
    }

    public static int numKeyValueCacheFiles() {
        return Parse.getKeyValueCacheDir().listFiles().length;
    }

    public static void setMaxKeyValueCacheFiles(int max) {
        Parse.maxKeyValueCacheFiles = max;
    }

    public static void setMaxKeyValueCacheBytes(int max) {
        Parse.maxKeyValueCacheBytes = max;
    }

    public static void resetCommandCache() {
        ParseCommandCache cache = Parse.getCommandCache();
        ParseCommandCache.TestHelper helper = cache.getTestHelper();
        cache.clear();
        helper.clear();
    }

    public static void disconnectCommandCache() {
        Parse.getCommandCache().setConnected(false);
    }

    public static void reconnectCommandCache() {
        Parse.getCommandCache().setConnected(true);
    }

    public static boolean waitForCommandCacheEnqueue() {
        return Parse.getCommandCache().getTestHelper().waitFor(3);
    }

    public static boolean waitForCommandCacheSuccess() {
        return Parse.getCommandCache().getTestHelper().waitFor(1) && Parse.getCommandCache().getTestHelper().waitFor(5);
    }

    public static boolean waitForCommandCacheFailure() {
        return Parse.getCommandCache().getTestHelper().waitFor(2);
    }

    public static int commandCacheUnexpectedEvents() {
        return Parse.getCommandCache().getTestHelper().unexpectedEvents();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StateTransitionListener
    implements PushConnection.StateTransitionListener {
        private ArrayList<StateTransition> transitions = new ArrayList();

        @Override
        public synchronized void onStateChange(PushConnection connection, PushConnection.State fromState, PushConnection.State toState) {
            this.transitions.add(new StateTransition(SystemClock.elapsedRealtime(), connection, fromState, toState));
        }

        public synchronized List<StateTransition> getTransitions() {
            return Collections.unmodifiableList(this.transitions);
        }
    }

    public static class StateTransition {
        public final long timestamp;
        public final PushConnection connection;
        public final PushConnection.State fromState;
        public final PushConnection.State toState;

        StateTransition(long timestamp, PushConnection connection, PushConnection.State fromState, PushConnection.State toState) {
            this.timestamp = timestamp;
            this.connection = connection;
            this.fromState = fromState;
            this.toState = toState;
        }

        public String toString() {
            return this.timestamp + " ms: " + this.fromState + " to " + this.toState;
        }
    }
}

