/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import com.parse.Capture;
import com.parse.ConnectivityNotifier;
import com.parse.Continuation;
import com.parse.LocalIdManager;
import com.parse.Parse;
import com.parse.ParseCommand;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.Task;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParseCommandCache {
    private static final String TAG = "com.parse.ParseCommandCache";
    private File cachePath;
    private int timeoutMaxRetries = 5;
    private double timeoutRetryWaitSeconds = 600.0;
    private int maxCacheSizeBytes = 0xA00000;
    private static int filenameCounter = 0;
    private boolean shouldStop = false;
    private boolean connected = false;
    private HashMap<File, Task.TaskCompletionSource> pendingTasks = new HashMap();
    private static Object lock = new Object();
    private boolean running = false;
    private Object runningLock;
    private Logger log;
    private TestHelper testHelper = null;
    private ConnectivityNotifier.ConnectivityListener connectivityListener = new ConnectivityNotifier.ConnectivityListener(){

        public void networkConnectivityStatusChanged(Intent intent) {
            boolean connectionLost = intent.getBooleanExtra("noConnectivity", false);
            if (connectionLost) {
                ParseCommandCache.this.setConnected(false);
            } else {
                ParseCommandCache.this.setConnected(ConnectivityNotifier.getNotifier().isConnected());
            }
        }
    };

    public ParseCommandCache(Context context) {
        lock = new Object();
        this.runningLock = new Object();
        this.log = Logger.getLogger(TAG);
        File parseDir = Parse.getParseDir();
        this.cachePath = new File(parseDir, "CommandCache");
        this.cachePath.mkdirs();
        if (!Parse.hasPermission("android.permission.ACCESS_NETWORK_STATE")) {
            return;
        }
        this.setConnected(ConnectivityNotifier.getNotifier().isConnected());
        ConnectivityNotifier.getNotifier().addListener(this.connectivityListener, context);
        this.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeoutMaxRetries(int tries) {
        Object object = lock;
        synchronized (object) {
            this.timeoutMaxRetries = tries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeoutRetryWaitSeconds(double seconds) {
        Object object = lock;
        synchronized (object) {
            this.timeoutRetryWaitSeconds = seconds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxCacheSizeBytes(int bytes) {
        Object object = lock;
        synchronized (object) {
            this.maxCacheSizeBytes = bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.runningLock;
        synchronized (object) {
            if (!this.running) {
                new Thread("ParseCommandCache.runLoop()"){

                    public void run() {
                        ParseCommandCache.this.runLoop();
                    }
                }.start();
                try {
                    this.runningLock.wait();
                }
                catch (InterruptedException e) {
                    Object object2 = lock;
                    synchronized (object2) {
                        this.shouldStop = true;
                        lock.notify();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.runningLock;
        synchronized (object) {
            if (this.running) {
                Object object2 = lock;
                synchronized (object2) {
                    this.shouldStop = true;
                    lock.notify();
                }
            }
            while (this.running) {
                try {
                    this.runningLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFile(File file) {
        Object object = lock;
        synchronized (object) {
            this.pendingTasks.remove(file);
            JSONObject json = null;
            InputStream input = null;
            try {
                int read;
                input = new BufferedInputStream(new FileInputStream(file));
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] temp = new byte[1024];
                while ((read = input.read(temp)) > 0) {
                    buffer.write(temp, 0, read);
                }
                json = new JSONObject(buffer.toString("UTF-8"));
                ParseCommand command = new ParseCommand(json);
                command.releaseLocalIds();
            }
            catch (Exception e) {
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void simulateReboot() {
        Object object = lock;
        synchronized (object) {
            this.pendingTasks.clear();
        }
    }

    public Task<Object> runEventuallyAsync(ParseCommand command, ParseObject object) {
        Parse.requirePermission("android.permission.ACCESS_NETWORK_STATE");
        return this.runEventuallyInternalAsync(command, false, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Task<Object> runEventuallyInternalAsync(ParseCommand command, boolean preferOldest, ParseObject object) {
        byte[] json;
        Task.TaskCompletionSource tcs = Task.create();
        try {
            if (object != null && object.getObjectId() == null) {
                command.setLocalId(object.getOrCreateLocalId());
            }
            JSONObject jsonObject = command.toJSONObject();
            json = jsonObject.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (5 >= Parse.getLogLevel()) {
                this.log.log(Level.WARNING, "UTF-8 isn't supported.  This shouldn't happen.", e);
            }
            if (this.testHelper == null) return Task.forResult(null);
            this.testHelper.notify(4);
            return Task.forResult(null);
        }
        if (json.length > this.maxCacheSizeBytes) {
            if (5 >= Parse.getLogLevel()) {
                this.log.warning("Unable to save command for later because it's too big.");
            }
            if (this.testHelper == null) return Task.forResult(null);
            this.testHelper.notify(4);
            return Task.forResult(null);
        }
        Object object2 = lock;
        synchronized (object2) {
            try {
                void var9_20;
                String string2;
                String prefix1;
                Object[] fileNames = this.cachePath.list();
                if (fileNames != null) {
                    File file;
                    Arrays.sort(fileNames);
                    int size = 0;
                    Object[] objectArray = fileNames;
                    int len$ = objectArray.length;
                    for (int i$ = 0; i$ < len$; size += (int)file.length(), ++i$) {
                        Object fileName = objectArray[i$];
                        file = new File(this.cachePath, (String)fileName);
                    }
                    if ((size += json.length) > this.maxCacheSizeBytes) {
                        void var9_15;
                        if (preferOldest) {
                            if (5 >= Parse.getLogLevel()) {
                                this.log.warning("Unable to save command for later because storage is full.");
                            }
                            Task<Object> task = Task.forResult(null);
                            return task;
                        }
                        if (5 >= Parse.getLogLevel()) {
                            this.log.warning("Deleting old commands to make room in command cache.");
                        }
                        boolean bl = false;
                        while (size > this.maxCacheSizeBytes && var9_15 < fileNames.length) {
                            File file2 = new File(this.cachePath, (String)fileNames[++var9_15]);
                            size -= (int)file2.length();
                            this.removeFile(file2);
                        }
                    }
                }
                if ((prefix1 = Long.toHexString(System.currentTimeMillis())).length() < 16) {
                    char[] cArray = new char[16 - prefix1.length()];
                    Arrays.fill(cArray, '0');
                    prefix1 = new String(cArray) + prefix1;
                }
                if ((string2 = Integer.toHexString(filenameCounter++)).length() < 8) {
                    char[] zeroes = new char[8 - string2.length()];
                    Arrays.fill(zeroes, '0');
                    String string3 = new String(zeroes) + string2;
                }
                String prefix = "CachedCommand_" + prefix1 + "_" + (String)var9_20 + "_";
                File path = File.createTempFile(prefix, "", this.cachePath);
                this.pendingTasks.put(path, tcs);
                command.retainLocalIds();
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path));
                ((OutputStream)output).write(json);
                ((OutputStream)output).close();
                if (this.testHelper == null) return tcs.getTask();
                this.testHelper.notify(3);
            }
            catch (IOException e) {
                if (5 < Parse.getLogLevel()) return tcs.getTask();
                this.log.log(Level.WARNING, "Unable to save command for later.", e);
            }
            finally {
                lock.notify();
            }
            return tcs.getTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pendingCount() {
        Object object = lock;
        synchronized (object) {
            String[] files = this.cachePath.list();
            return files == null ? 0 : files.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = lock;
        synchronized (object) {
            File[] files = this.cachePath.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                this.removeFile(file);
            }
            this.pendingTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnected(boolean connected) {
        Object object = lock;
        synchronized (object) {
            if (this.connected != connected) {
                this.connected = connected;
                if (connected) {
                    lock.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T waitForTaskWithoutLock(Task<T> task) throws ParseException {
        Object object = lock;
        synchronized (object) {
            final Capture<Boolean> finished = new Capture<Boolean>(false);
            task.continueWith(new Continuation<T, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void then(Task<T> task) throws Exception {
                    finished.set(true);
                    Object object = lock;
                    synchronized (object) {
                        lock.notifyAll();
                    }
                    return null;
                }
            }, ParseCommand.networkThreadPool);
            while (!finished.get().booleanValue()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException ie) {
                    this.shouldStop = true;
                }
            }
            return Parse.waitForTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeRunAllCommandsNow(int retriesRemaining) {
        Object object = lock;
        synchronized (object) {
            if (!this.connected) {
                return;
            }
            Object[] fileNames = this.cachePath.list();
            if (fileNames == null || fileNames.length == 0) {
                return;
            }
            Arrays.sort(fileNames);
            for (Object fileName : fileNames) {
                File file = new File(this.cachePath, (String)fileName);
                JSONObject json = null;
                InputStream input = null;
                try {
                    int read;
                    input = new BufferedInputStream(new FileInputStream(file));
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    byte[] temp = new byte[1024];
                    while ((read = input.read(temp)) > 0) {
                        buffer.write(temp, 0, read);
                    }
                    json = new JSONObject(buffer.toString("UTF-8"));
                }
                catch (FileNotFoundException e) {
                    if (6 < Parse.getLogLevel()) continue;
                    this.log.log(Level.SEVERE, "File disappeared from cache while being read.", e);
                    continue;
                }
                catch (IOException e) {
                    if (6 >= Parse.getLogLevel()) {
                        this.log.log(Level.SEVERE, "Unable to read contents of file in cache.", e);
                    }
                    this.removeFile(file);
                    continue;
                }
                catch (JSONException e) {
                    if (6 >= Parse.getLogLevel()) {
                        this.log.log(Level.SEVERE, "Error parsing JSON found in cache.", e);
                    }
                    this.removeFile(file);
                    continue;
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                ParseCommand command = null;
                final Task.TaskCompletionSource tcs = this.pendingTasks.containsKey(file) ? this.pendingTasks.get(file) : null;
                try {
                    command = new ParseCommand(json);
                }
                catch (JSONException e) {
                    if (6 >= Parse.getLogLevel()) {
                        this.log.log(Level.SEVERE, "Unable to create ParseCommand from JSON.", e);
                    }
                    this.removeFile(file);
                    continue;
                }
                try {
                    final String localId = command.getLocalId();
                    Task<Void> commandTask = command.performAsync().onSuccess(new Continuation<Object, Void>(){

                        @Override
                        public Void then(Task<Object> task) throws Exception {
                            if (tcs != null) {
                                tcs.setResult(task.getResult());
                            } else if (localId != null && task.getResult() instanceof JSONObject && ((JSONObject)task.getResult()).has("data") && ((JSONObject)task.getResult()).getJSONObject("data").has("objectId")) {
                                String objectId = ((JSONObject)task.getResult()).getJSONObject("data").getString("objectId");
                                LocalIdManager.getDefaultInstance().setObjectId(localId, objectId);
                            }
                            return null;
                        }
                    });
                    this.waitForTaskWithoutLock(commandTask);
                    if (tcs != null) {
                        this.waitForTaskWithoutLock(tcs.getTask());
                    }
                    this.removeFile(file);
                    if (this.testHelper == null) continue;
                    this.testHelper.notify(1);
                }
                catch (ParseException e) {
                    if (e.getCode() == 100) {
                        if (retriesRemaining <= 0) continue;
                        if (4 >= Parse.getLogLevel()) {
                            this.log.info("Network timeout in command cache. Waiting for " + this.timeoutRetryWaitSeconds + " seconds and then retrying " + retriesRemaining + " times.");
                        }
                        long currentTime = System.currentTimeMillis();
                        long waitUntil = currentTime + (long)(this.timeoutRetryWaitSeconds * 1000.0);
                        while (currentTime < waitUntil) {
                            if (!this.connected || this.shouldStop) {
                                if (4 >= Parse.getLogLevel()) {
                                    this.log.info("Aborting wait because runEventually thread should stop.");
                                }
                                return;
                            }
                            try {
                                lock.wait(waitUntil - currentTime);
                            }
                            catch (InterruptedException ie) {
                                this.shouldStop = true;
                            }
                            if ((currentTime = System.currentTimeMillis()) >= waitUntil - (long)(this.timeoutRetryWaitSeconds * 1000.0)) continue;
                            currentTime = waitUntil - (long)(this.timeoutRetryWaitSeconds * 1000.0);
                        }
                        this.maybeRunAllCommandsNow(retriesRemaining - 1);
                        continue;
                    }
                    if (6 >= Parse.getLogLevel()) {
                        this.log.log(Level.SEVERE, "Failed to run command.", e);
                    }
                    this.removeFile(file);
                    if (this.testHelper == null) continue;
                    this.testHelper.notify(2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void runLoop() {
        if (4 >= Parse.getLogLevel()) {
            this.log.info("Parse command cache has started processing queued commands.");
        }
        Object object = this.runningLock;
        // MONITORENTER : object
        if (this.running) {
            // MONITOREXIT : object
            return;
        }
        this.running = true;
        this.runningLock.notifyAll();
        // MONITOREXIT : object
        boolean shouldRun = false;
        Object object2 = lock;
        // MONITORENTER : object2
        shouldRun = !this.shouldStop && !Thread.interrupted();
        // MONITOREXIT : object2
        while (true) {
            if (!shouldRun) {
                object2 = this.runningLock;
                // MONITORENTER : object2
                this.running = false;
                this.runningLock.notifyAll();
                // MONITOREXIT : object2
                if (4 < Parse.getLogLevel()) return;
                this.log.info("saveEventually thread has stopped processing commands.");
                return;
            }
            object2 = lock;
            // MONITORENTER : object2
            try {
                this.maybeRunAllCommandsNow(this.timeoutMaxRetries);
                if (!this.shouldStop) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        this.shouldStop = true;
                    }
                }
                shouldRun = !this.shouldStop;
            }
            catch (Exception e) {
                try {
                    if (6 >= Parse.getLogLevel()) {
                        this.log.log(Level.SEVERE, "saveEventually thread had an error.", e);
                    }
                    shouldRun = !this.shouldStop;
                }
                catch (Throwable throwable) {
                    shouldRun = !this.shouldStop;
                    throw throwable;
                }
            }
            // MONITOREXIT : object2
        }
    }

    public TestHelper getTestHelper() {
        if (this.testHelper == null) {
            this.testHelper = new TestHelper();
        }
        return this.testHelper;
    }

    public class TestHelper {
        private static final int MAX_EVENTS = 1000;
        public static final int COMMAND_SUCCESSFUL = 1;
        public static final int COMMAND_FAILED = 2;
        public static final int COMMAND_ENQUEUED = 3;
        public static final int COMMAND_NOT_ENQUEUED = 4;
        public static final int OBJECT_UPDATED = 5;
        public static final int OBJECT_REMOVED = 6;
        @SuppressLint(value={"UseSparseArrays"})
        private HashMap<Integer, Semaphore> events = new HashMap();

        private TestHelper() {
            this.clear();
        }

        public void clear() {
            this.events.clear();
            this.events.put(1, new Semaphore(1000));
            this.events.put(2, new Semaphore(1000));
            this.events.put(3, new Semaphore(1000));
            this.events.put(4, new Semaphore(1000));
            this.events.put(5, new Semaphore(1000));
            this.events.put(6, new Semaphore(1000));
            for (int event : this.events.keySet()) {
                this.events.get(event).acquireUninterruptibly(1000);
            }
        }

        public int unexpectedEvents() {
            int sum = 0;
            for (int event : this.events.keySet()) {
                sum += this.events.get(event).availablePermits();
            }
            return sum;
        }

        public void notify(int event) {
            this.events.get(event).release();
        }

        public boolean waitFor(int event) {
            try {
                return this.events.get(event).tryAcquire(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

